LOCAL INCLUDE 'TSTERR.INC'
      INTEGER   NERRS, ILIST(3,1000), NLIST
      CHARACTER ERRNAM(4,1000)*10, ADVLIS(1000)*10
      COMMON /ERRINT/ NERRS, NLIST, ILIST
      COMMON /ERRCHR/ ERRNAM, ADVLIS
LOCAL END
      PROGRAM ADVTST
C-----------------------------------------------------------------------
C! Extracts adverbs from help files
C# Utility
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Program to extract the adverb list from all task, verb, proc, etc
C   help files.  It writes a text file of the task name and the adverb
C   in 2 columns.
C      A logical or enviroment variable named MYDIR must be defined
C   before running ADVTST.
C      The output will be written to a file named ADVTST.OUT.
C-----------------------------------------------------------------------
      CHARACTER INLINE*100, LFIL*48, SUBNAM*12, ADVNAM*10,
     *   SUBS(1000)*12, LNAME*10
      INTEGER   IOERR, BUFFER(512), LUNL, FINDL, NCHK, I, LUNO, FINDO,
     *   IRET, J, LMAX, LJ
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'TSTERR.INC'
      DATA LUNL, LUNO /18,11/
C-----------------------------------------------------------------------
C                                       AIPS system start up stuff
      TSKNAM ='ADVTST'
      NPOPS = 1
      MSGKIL = 32000
      MSGSUP = 32000
      CALL ZDCHIN (.FALSE., BUFFER)
      MSGKIL = 32000
      MSGSUP = 32000
      DEVTAB(LUNL) = 3
      NLUSER = 1
      NERRS = 0
      NLIST = 0
      CALL FILL (3000, 0, ILIST)
C                                       Get list of routines
      LFIL = 'MYDIR:ADVHLP.SRT'
      CALL ZTXOPN ('READ', LUNL, FINDL, LFIL, .FALSE., IOERR)
      IF (IOERR.NE.0) GO TO 999
      LFIL = 'MYDIR:ADVTST.chk'
      CALL ZTXOPN ('WRIT', LUNO, FINDO, LFIL, .TRUE., IOERR)
      IF (IOERR.NE.0) GO TO 999
      NCHK = 0
      LNAME = ' '
C                                       Begin looping over files
 100     CALL ZTXIO ('READ', LUNL, FINDL, INLINE, IOERR)
         IF ((IOERR.NE.0) .AND. (IOERR.NE.2)) GO TO 890
         IF (INLINE.EQ.' ') GO TO 100
         SUBNAM = INLINE(:12)
         ADVNAM = INLINE(15:24)
         IF (IOERR.EQ.2) ADVNAM = ' '
         IF ((NCHK.GT.0) .AND. (ADVNAM.EQ.LNAME) .AND.
     *      (SUBNAM.EQ.SUBS(NCHK))) GO TO 100
         IF ((ADVNAM.NE.LNAME) .AND. (NCHK.GT.0)) THEN
            CALL CHKIT (LNAME, NCHK, SUBS, LUNO, FINDO, IRET)
            NCHK = 0
            END IF
         IF (IOERR.EQ.2) GO TO 900
         NCHK = NCHK + 1
         LNAME = ADVNAM
         SUBS(NCHK) = SUBNAM
         GO TO 100
C
 890  WRITE (6,1890) IOERR
C                                       Done - close files
 900  CALL ZTXCLS (LUNL, FINDL, IOERR)
      CALL ZTXCLS (LUNO, FINDO, IOERR)
      DO 910 I = 1,NERRS
         WRITE (MSGTXT,1900) ERRNAM(1,I), ERRNAM(2,I), ERRNAM(3,I),
     *      ERRNAM(4,I)
         CALL MSGWRT (5)
 910     CONTINUE
      DO 930 J = 1,NLIST
         LMAX = 0
         DO 920 I = 1,NLIST
            IF (ILIST(3,I).GT.LMAX) THEN
               LMAX = ILIST(3,I)
               LJ = I
               END IF
 920        CONTINUE
         WRITE (MSGTXT,1920) J, (ILIST(I,LJ), I = 1,3)
         CALL MSGWRT (5)
         ILIST(3,LJ) = -1
 930     CONTINUE
C
 999  STOP
C-----------------------------------------------------------------------
 1890 FORMAT (' ERROR READING FILE ',A)
 1900 FORMAT ('MISSING FILE ',A,' FROM',3(1X,A))
 1920 FORMAT ('Nmost',I4,' at',3I4)
      END
      SUBROUTINE CHKIT (ADVNAM, NCHK, TASKS, LUNO, FINDO, IRET)
C-----------------------------------------------------------------------
C   check adverb help file ADVNAM for all tasks (verbs, procs,...)
C   in list
C   Inputs
C      ADVNAM   C*(*)      Adverb name
C      NCHK     I          Number of tasks
C      TASKS    C(*)*(*)   Task list
C-----------------------------------------------------------------------
      INTEGER   NCHK, LUNO, FINDO, IRET
      CHARACTER ADVNAM*(*), TASKS(*)*(*)
C
      INCLUDE 'INCS:DMSG.INC'
      INTEGER   LUNI, FINDI, J, JTRIM, IERR, K, I, IL(2), LIL(2)
      CHARACTER INLINE*100, LFIL*48, SYM*10, OUTLIN*512
      INCLUDE 'TSTERR.INC'
C-----------------------------------------------------------------------
      LUNI = 3
      J = JTRIM (ADVNAM)
      LFIL = 'HLPFIL:' // ADVNAM(:J) // '.HLP'
      CALL ZTXOPN ('QRED', LUNI, FINDI, LFIL, .FALSE., IERR)
      IF (IERR.NE.0) THEN
         NERRS = NERRS + 1
         ERRNAM(1,NERRS) = ADVNAM
         ERRNAM(2,NERRS) = TASKS(1)
         ERRNAM(3,NERRS) = TASKS(2)
         ERRNAM(4,NERRS) = TASKS(3)
         GO TO 999
         END IF
 10   CALL ZTXIO ('READ', LUNI, FINDI, INLINE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING ' // ADVNAM(:J)
         GO TO 990
         END IF
      IF (INLINE(:1).EQ.';') GO TO 10
      CALL GETADV (INLINE, SYM, IL)
      IF ((SYM.NE.' ') .AND. (IL(1).NE.0)) THEN
         DO 20 I = 1,NLIST
            IF ((IL(1).EQ.ILIST(1,I)) .AND. (IL(2).EQ.ILIST(2,I))) THEN
               ILIST(3,I) = ILIST(3,I) + 1
               GO TO 30
               END IF
 20         CONTINUE
         NLIST = NLIST + 1
         CALL COPY (2, IL, ILIST(1,NLIST))
         ADVLIS(NLIST) = ADVNAM
         ILIST(3,NLIST) = 1
         GO TO 30
         END IF
      GO TO 10
C                                       are they all the same
 30   CALL COPY (2, IL, LIL)
 50   CALL ZTXIO ('READ', LUNI, FINDI, INLINE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING ' // ADVNAM(:J)
         GO TO 990
         END IF
      IF (INLINE(:1).EQ.';') GO TO 10
      CALL GETADV (INLINE, SYM, IL)
      IF ((SYM.NE.' ') .AND. (IL(1).NE.0)) THEN
         IF ((IL(1).NE.LIL(1)) .OR. (IL(2).NE.LIL(2))) THEN
            K = JTRIM (ADVNAM)
            WRITE (OUTLIN,1050) IL, LIL, ADVNAM(:K)
            K = JTRIM (OUTLIN)
            CALL ZTXIO ('WRIT', LUNO, FINDO, OUTLIN(:K), IRET)
            GO TO 995
            END IF
         END IF
      GO TO 50
C
 990  IF ((IERR.NE.2) .AND. (IERR.GT.0)) THEN
         CALL MSGWRT (8)
      ELSE IF ((ILIST(1,I).NE.4) .OR. (ILIST(2,I).NE.17)) THEN
         K = JTRIM (ADVNAM)
         WRITE (OUTLIN,1990) ILIST(1,I), ILIST(2,I), ADVNAM(:K)
c         WRITE (OUTLIN,1990) ADVNAM, (ILIST(J,I), J = 1,3)
         K = JTRIM (OUTLIN)
         CALL ZTXIO ('WRIT', LUNO, FINDO, OUTLIN(:K), IRET)
         END IF
 995  CALL ZTXCLS (LUNI, FINDI, I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('CHKIT ERROR',I4,' ON ',A)
 1050 FORMAT ('echo ''tasks at',4I4,''' | chkout $HLPFIL/',A,'.HLP')
 1990 FORMAT ('echo ''tasks at',2I4,''' | chkout $HLPFIL/',A,'.HLP')
      END
      SUBROUTINE GETADV (INLINE, SYM, IL)
C-----------------------------------------------------------------------
C   Looks for listing if task et al in adverb help file
C   Input
C      INLINE   C*(*)   line from help file
C   Output
C      SYM      C(*)   the task
C-----------------------------------------------------------------------
      CHARACTER INLINE*(*), SYM*(*)
      INTEGER   IL(2)
C
      INTEGER   I, I1, IC, I2, I3
      CHARACTER LCH*1
C-----------------------------------------------------------------------
      SYM = ' '
      IL(1) = 0
      IL(2) = 0
C                                       find first non-blank
      DO 10 I = 1,2
         IF (INLINE(I:I).NE.' ') GO TO 999
 10      CONTINUE
      DO 15 I = 3,6
         IF (INLINE(I:I).NE.' ') GO TO 20
 15      CONTINUE
      GO TO 999
 20   I1 = I
      DO 30 I = I1,I1+9
         LCH = INLINE(I:I)
         IF (LCH.EQ.'.') THEN
            IF (I.GT.I1) SYM = INLINE(I1:I-1)
            END IF
         IC = ICHAR(LCH)
         IF ((IC.GE.ICHAR('A')) .AND. (IC.LE.ICHAR('Z'))) GO TO 30
         IF ((IC.GE.ICHAR('0')) .AND. (IC.LE.ICHAR('9'))) GO TO 30
         I2 = I
         GO TO 40
 30      CONTINUE
      GO TO 999
 40   IF (SYM.NE.' ') THEN
         DO 50 I = I2,I2+10
            LCH = INLINE(I:I)
            IF (LCH.NE.'.') THEN
               I3 = I - 1
               GO TO 900
               END IF
 50         CONTINUE
         END IF
C
 900  IC = ICHAR(SYM(1:1))
      IF ((IC.GE.ICHAR('0')) .AND. (IC.LE.ICHAR('9'))) THEN
         SYM = ' '
      ELSE
         IL(1) = I1
         IL(2) = I3
         END IF
C
 999  RETURN
      END
