      SUBROUTINE AU6B (BRANCH)
C-----------------------------------------------------------------------
C! verb to display image value at pixel indicated by TV cursor (CURVAL)
C# POPS-appl TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 1995, 2014, 2021, 2024-2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   AU6B performs interactive displays of map image values:
C   BRANCH = 1  CURVALUE  display X, Y, B; get B from map file
C   BRANCH = 2  TVDATA/TVFACTS  display info about the Tv display
C   BRANCH = 3  OFMCOL or OFMs gone wild
C-----------------------------------------------------------------------
      INTEGER   BRANCH
C
      INCLUDE 'INCS:PTVC.INC'
      CHARACTER PRGNAM*6, CDUM*1, CCROS(15)*8
      INTEGER   MLUN, IG1, POTERR, IERR, BUFFER(3072), ICHAN, I, ZAND,
     *   PRTLEV, BITS(16,4), J, NCHNS(4), CHANS(16,4), K, ZEOR, NLEVS,
     *   ICROS(4)
      REAL      RBUFF(3072), RDUM, GRPHX(3,8), CROS(3,15),
     *   OFM(TVMOFM,3), IOFM(TVMOFM,3)
      INCLUDE 'INCS:DERR.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DMSG.INC'
      COMMON /AIPSCR/ OFM, IOFM
      EQUIVALENCE (RBUFF, BUFFER, OFM)
      DATA PRGNAM /'AU6B '/
      DATA MLUN /17/
      DATA CCROS /'1', '2', '1 2', '3', '1 3', '2 3', '1 2 3', '4',
     *   '1 4', '2 4', '1 2 4', '3 4', '1 3 4', '2 3 4', '1 2 3 4'/
C-----------------------------------------------------------------------
      IF ((BRANCH.LT.1) .OR. (BRANCH.GT.3)) GO TO 999
C                                       Open TV
      POTERR = 49
      CALL TVOPEN (BUFFER, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       Branch to OP
      GO TO (100, 200, 300), BRANCH
C-----------------------------------------------------------------------
C                                       CURVALUE (from disk file)
C                                       display value under cursor
C-----------------------------------------------------------------------
C                                       no image yet
 100  CALL ADVERB ('GRCHAN', 'I', 1, 0, IG1, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 975
      IG1 = MOD (IG1, 10)
      IF ((IG1.LT.1) .OR. (IG1.GT.NGRAPH)) IG1 = MIN (2, NGRAPH)
      CALL ADVERB ('NCHAN', 'I', 1, 0, ICHAN, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 975
C                                       is this channel on?
      IF (ICHAN.GT.0) THEN
         I = 2 ** (ICHAN-1)
         IF ((ZAND(TVLIMG(1),I).EQ.0) .AND. (ZAND(TVLIMG(2),I).EQ.0)
     *      .AND. (ZAND(TVLIMG(3),I).EQ.0) .AND.
     *      (ZAND(TVLIMG(4),I).EQ.0)) ICHAN = 0
         END IF
      CALL TVALUE (MLUN, IG1, ICHAN, BUFFER, RBUFF, POTERR, IERR)
      GO TO 975
C-----------------------------------------------------------------------
C                                       TVDATA or TVFACTS
C                                       info about TV display
C-----------------------------------------------------------------------
 200  CALL ADVERB ('PRTLEV', 'I', 1, 0, PRTLEV, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 975
      WRITE (MSGTXT,1200) MAXXTV
      CALL MSGWRT (4)
      WRITE (MSGTXT,1201) NGRAY, NGRAPH
      CALL MSGWRT (4)
      WRITE (MSGTXT,1202) NIMAGE
      CALL MSGWRT (4)
      WRITE (MSGTXT,1203) CSIZTV
      CALL MSGWRT (4)
      WRITE (MSGTXT,1204) WINDTV
      CALL MSGWRT (4)
      DO 210 I = 1,4
         CALL ZGTBIT (16, TVLIMG(I), BITS(1,I))
         NCHNS(I) = 0
         CALL FILL (16, 0, CHANS(1,I))
         DO 205 J = 1,16
            IF (BITS(J,I).GT.0) THEN
               NCHNS(I) = NCHNS(I) + 1
               CHANS(NCHNS(I),I) = J
               END IF
 205        CONTINUE
 210     CONTINUE
C                                       all 1
      IF ((TVLIMG(1).EQ.TVLIMG(2)) .AND. (TVLIMG(1).EQ.TVLIMG(3)) .AND.
     *   (TVLIMG(1).EQ.TVLIMG(4))) THEN
         WRITE (MSGTXT,1205) (CHANS(J,1), J = 1,NCHNS(1))
         CALL MSGWRT (4)
      ELSE
         DO 215 I = 1,4
            WRITE (MSGTXT,1206) I, (CHANS(J,I), J = 1,NCHNS(I))
            CALL MSGWRT (4)
 215        CONTINUE
         WRITE (MSGTXT,1207) TVSPLT
         CALL MSGWRT (4)
         END IF
C                                       extra info: scaling
      IF (PRTLEV.GT.0) THEN
         WRITE (MSGTXT,1210) MAXINT
         CALL MSGWRT (4)
         WRITE (MSGTXT,1211) LUTOUT
         CALL MSGWRT (4)
         WRITE (MSGTXT,1212) OFMINP, NGRAY, LUTOUT
         CALL MSGWRT (4)
         WRITE (MSGTXT,1213) OFMOUT
         CALL MSGWRT (4)
         END IF
C                                       extra info graphics colors
      IF (PRTLEV.GT.1) THEN
         DO 220 I = 1,MIN(8,NGRAPH)
            CALL YGRAFX ('READ', I, GRPHX(1,I), GRPHX(2,I), GRPHX(3,I),
     *         IERR)
            IF (IERR.NE.0) GO TO 975
            WRITE (MSGTXT,1220) I, (GRPHX(J,I), J = 1,3)
            IF ((PRTLEV.EQ.2) .OR. (I.GT.4)) CALL MSGWRT (4)
 220        CONTINUE
         END IF
C                                       extra info overlap colors
      IF (PRTLEV.GT.2) THEN
         DO 222 K = 1,3
            DO 221 I = 1,4
               ICROS(I) = GRPHX(K,I) * 255.0 + 0.5
 221           CONTINUE
            CROS(K,1) = GRPHX(K,1)
            CROS(K,2) = GRPHX(K,2)
            CROS(K,4) = GRPHX(K,3)
            CROS(K,8) = GRPHX(K,4)
            CROS(K,3) = ZEOR (ICROS(1), ICROS(2)) / 255.0
            CROS(K,5) = ZEOR (ICROS(1), ICROS(3)) / 255.0
            CROS(K,6) = ZEOR (ICROS(2), ICROS(3)) / 255.0
            CROS(K,7) = ZEOR (ICROS(1), ZEOR (ICROS(2),ICROS(3))) / 255.
            CROS(K,9) = ZEOR (ICROS(1), ICROS(4)) / 255.0
            CROS(K,10) = ZEOR (ICROS(2), ICROS(4)) / 255.0
            CROS(K,11) = ZEOR (ICROS(1), ZEOR (ICROS(2),ICROS(4)))/255.0
            CROS(K,12) = ZEOR (ICROS(3), ICROS(4)) / 255.0
            CROS(K,13) = ZEOR (ICROS(1), ZEOR (ICROS(3),ICROS(4)))/255.0
            CROS(K,14) = ZEOR (ICROS(2), ZEOR (ICROS(3),ICROS(4)))/255.0
            CROS(K,15) = ZEOR (ZEOR (ICROS(1), ICROS(2)),
     *         ZEOR (ICROS(3), ICROS(4))) / 255.0
 222        CONTINUE
         DO 225 I = 1,15
            WRITE (MSGTXT,1222) CCROS(I), (CROS(J,I), J = 1,3)
            CALL MSGWRT (4)
 225        CONTINUE
         END IF
      POTERR = 0
      GO TO 975
C-----------------------------------------------------------------------
C                                       OFMCOLOR
C                                       OFMs gone wild
C-----------------------------------------------------------------------
 300  NLEVS = LUTOUT + 1
      CALL OFMCOL (NLEVS, OFM, IOFM, IERR)
      IF (IERR.EQ.0) POTERR = 0
C-----------------------------------------------------------------------
 975  CALL YHOLD ('OFFF', IERR)
      CALL TVCLOS (BUFFER, IERR)
C                                       POPS error management
 980  IF (ERRNUM.EQ.0) ERRNUM = POTERR
      IF (ERRNUM.NE.0) THEN
         ERRLEV = ERRLEV + 1
         IF (ERRLEV.LE.5) PNAME(ERRLEV) = PRGNAM
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1200 FORMAT ('TV dimensions: X',I6,'   Y',I5)
 1201 FORMAT ('Number of grey-scale channels',I3,
     *   '  Number praphics planes',I2)
 1202 FORMAT ('Maximum number of images per grey-scale channel',I5)
 1203 FORMAT ('Character size in X',I3,'  in Y',I3)
 1204 FORMAT ('TV window BLC',2I5,'   TRC',2I5)
 1205 FORMAT ('Channels on:',16I3)
 1206 FORMAT ('Quadrant',I2,' chans',16I3)
 1207 FORMAT ('Split screen point',2I5)
 1210 FORMAT ('Images scaled from 0 -',I5,' into the LUTs')
 1211 FORMAT ('Output range from LUTs: 0 -',I5)
 1212 FORMAT ('Input range to OFMs 0 -',I6,' usually',I3,' times 0 -',
     *   I5)
 1213 FORMAT ('Output from OFMs 0 -',I4)
 1220 FORMAT ('Graphics plane',I2,'  R =',F6.3,'  G =',F6.3,'  B =',
     *   F6.3)
 1222 FORMAT ('Graphics planes ',A8,'  R =',F6.3,'  G =',F6.3,'  B =',
     *   F6.3)
      END
