      SUBROUTINE AU7C (BRANCH)
C-----------------------------------------------------------------------
C! verbs to access UV data
C# POPS-appl UV
C-----------------------------------------------------------------------
C;  Copyright (C) 2019, 2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   AU7B verbs:
C   1. GETITIME get the integration time - return INTTIME
C   Inputs:   (though adverbs in common)
C      INNAME   H*12  input file name.  If blank the first match
C                     consistent with the other parameters is used.
C      INCLASS  H*6   input file class.  If blank the first match is
C                     used.
C      INSEQ    R     the old entry's sequence number. If zero the first
C                     match consistent with the other parameters is used
C      INDISK   R     the catalog resides on this disk.  If zero, all
C                     disk volumes are searched until a match is found.
C-----------------------------------------------------------------------
      INTEGER   BRANCH
C
      INCLUDE 'INCS:ZPBUFSZ.INC'
      REAL      BUFF1(UVBFSS)
      INTEGER   LUNI, INDI, IREC, JBUFSZ, IRET,
     *   IVOL, LOCSEQ, IUSER, ISLOT, IBUFF(256), POTERR,
     *   IDUM, JREC
      CHARACTER PRGNAM*6, LOCNAM*12, LOCCLS*6, LOCTYP*2, STATUS*4,
     *   CDUM*1, CLSTAT*4, PHNAME*48
      REAL      RDUM, ITIME
      LOGICAL   T, F
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DERR.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      COMMON /AIPSCR/ BUFF1
      DATA LUNI /16/
      DATA T, F /.TRUE.,.FALSE./
      DATA PRGNAM /'AU7C  '/
C-----------------------------------------------------------------------
      IF ((BRANCH.LT.1) .OR. (BRANCH.GT.1)) GO TO 999
C                                       Set initial values.
      POTERR = 0
      CALL ADVERB ('INDISK', 'I', 1, 0, IVOL, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 980
      CALL ADVERB ('INSEQ', 'I', 1, 0, LOCSEQ, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 980
      CALL ADVERB ('INNAME', 'C', 1, 12, IDUM, RDUM, LOCNAM)
      IF (ERRNUM.NE.0) GO TO 980
      CALL ADVERB ('INCLASS', 'C', 1, 6, IDUM, RDUM, LOCCLS)
      IF (ERRNUM.NE.0) GO TO 980
      IUSER = NLUSER
      LOCTYP = 'UV'
      ISLOT = 1
      CLSTAT = '  '
      CALL CATDIR ('SRCH', IVOL, ISLOT, LOCNAM, LOCCLS, LOCSEQ,
     *   LOCTYP, IUSER, STATUS, IBUFF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING CATALOG ENTRY'
         CALL MSGWRT (8)
         POTERR = 101
         GO TO 980
         END IF
C                                       Choose function.
      GO TO (100), BRANCH
C-----------------------------------------------------------------------
C                                       GETITIME
C                                       get integration time
C-----------------------------------------------------------------------
 100  CALL CATIO ('READ', IVOL, ISLOT, CATBLK, 'READ', IBUFF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING CATALOG HEADER'
         IF (IRET.EQ.5) MSGTXT = 'CATALOG FILE TOO BUSY'
         POTERR = 33
         GO TO 970
         END IF
      CLSTAT = 'CLRD'
      CALL UVPGET (IRET)
      IF (IRET.NE.0) GO TO 975
      CALL ADVERB ('BPRINT', 'I', 1, 0, IREC, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 980
      CALL ADVERB ('EPRINT', 'I', 1, 0, JREC, RDUM, CDUM)
      IF (ERRNUM.NE.0) GO TO 980
      IREC = MAX(1, MIN (IREC, NVIS))
      IF (JREC.LT.IREC) JREC = NVIS
      CALL ZPHFIL ('UV', IVOL, ISLOT, 1, PHNAME, IRET)
      CALL ZOPEN (LUNI, INDI, IVOL, PHNAME, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN INPUT UV DATA SET'
         CALL MSGWRT (8)
         POTERR = 101
         GO TO 975
         END IF
      JBUFSZ = UVBFSS * 2
      CALL FINDIT (LUNI, INDI, IREC, JREC, JBUFSZ, BUFF1, ITIME, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING INTEGRATION TIME'
         GO TO 180
         END IF
      CALL ZCLOSE (LUNI, INDI, IRET)
      CALL ADVRBS ('INTTIME','R', 1, 0, IDUM, ITIME, CDUM)
      GO TO 975
C                                       error file open
 180  CALL MSGWRT (8)
      POTERR = 101
      CALL ZCLOSE (LUNI, INDI, IRET)
      GO TO 975
C-----------------------------------------------------------------------
C                                       Print error, clear catalog.
 970  CALL MSGWRT (6)
 975  IF (CLSTAT.NE.' ') CALL CATDIR ('CSTA', IVOL, ISLOT, LOCNAM,
     *   LOCCLS, LOCSEQ, LOCTYP, IUSER, CLSTAT, IBUFF, IRET)
C                                       AIPS error management.
 980  IF (ERRNUM.EQ.0) ERRNUM = POTERR
      IF (ERRNUM.EQ.0) GO TO 999
         ERRLEV = ERRLEV + 1
         IF (ERRLEV.LE.5) PNAME(ERRLEV) = PRGNAM
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('AU7C ERROR',I4,' ON ',A)
      END
