LOCAL INCLUDE 'CLNUP.INC'
      HOLLERITH XOPCOD(1), XINEXT(1)
      REAL      XINDSK, DETIME
      COMMON /INPARM/ XOPCOD, XINDSK, XINEXT, DETIME
LOCAL END
      PROGRAM CLNUP
C-----------------------------------------------------------------------
C! Reports/delets AIPS left over files
C# Service System Utility
C-----------------------------------------------------------------------
C;  Copyright (C) 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   DISKU reports AIPS left over files: MS, RL, TG, SG.  Other also
C   Input adverbs:
C      OPTYPE   C   'LIST', 'DELE'
C      INEXT    C   file type ' ' => all
C      DETIME   R   list only files older than DETIME days
C-----------------------------------------------------------------------
C
      INTEGER   ISCR(256), NPARMS, IERR, ITYP, IBTYP, IETYP, I, CLEN,
     *   LLEN, IRETCD, XLNB, JTRIM, INDISK
      CHARACTER PRGNAM*6, EXTYPS(5)*2, INEXT*2, OPCODE*4, CNAME*4,
     *   XLATED*128
      LOGICAL   QUICK
      INCLUDE 'CLNUP.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA PRGNAM /'CLNUP '/
      DATA EXTYPS /'MS', 'RL', 'SG', 'TG', '??'/
C-----------------------------------------------------------------------
C                                       AIPS inits
      CALL ZDCHIN (.TRUE.)
      NPARMS = 4
      CALL GTPARM (PRGNAM, NPARMS, QUICK, XOPCOD, ISCR, IERR)
      IRETCD = 0
      IF (IERR.NE.0) IRETCD = 8
      IF (QUICK) CALL RELPOP (IRETCD, ISCR, IERR)
      IF (IRETCD.NE.0) GO TO 990
C                                       Sort order as char.
      CALL H2CHR (2, 1, XINEXT, INEXT)
      CALL H2CHR (4, 1, XOPCOD, OPCODE)
      INDISK = XINDSK + 0.1
      INDISK = MAX (1, INDISK)
C                                       which types
      ITYP = 0
      DO 10 I = 1,5
         IF (INEXT.EQ.EXTYPS(I)) ITYP = I
 10      CONTINUE
      IF (ITYP.GT.0) THEN
         IBTYP = ITYP
         IETYP = ITYP
      ELSE
         IBTYP = 1
         IETYP = 4
         END IF
C                                       where are they
      CNAME = 'DA01'
      CALL ZEHEX (INDISK, 1, CNAME(4:4))
      CLEN = 4
      LLEN = 128
      CALL ZTRLOG (CLEN, CNAME, LLEN, XLATED, XLNB, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'TRANSLATING DA0n'
         GO TO 980
         END IF
      I = JTRIM (XLATED)
      IF (XLATED(I:I).NE.'//') THEN
         XLATED(I+1:I+1) = '//'
         END IF
C                                       loop over type
      IF (OPCODE.EQ.'COUN') THEN
         DO 20 ITYP = IBTYP,IETYP
            CALL COUNT (OPCODE, EXTYPS(ITYP), INDISK, XLATED, DETIME,
     *         IERR)
            IF (IERR.NE.0) THEN
                WRITE (MSGTXT,1000) IERR, 'PROCESSING ' // EXTYPS(ITYP)
                GO TO 980
                END IF
 20         CONTINUE
      ELSE
         DO 30 ITYP = IBTYP,IETYP
            CALL DOIT (OPCODE, EXTYPS(ITYP), INDISK, XLATED, DETIME,
     *         IERR)
            IF (IERR.NE.0) THEN
                WRITE (MSGTXT,1000) IERR, 'PROCESSING ' // EXTYPS(ITYP)
                GO TO 980
                END IF
 30         CONTINUE
         END IF
      GO TO 990
C
 980  CALL MSGWRT (8)
C
 990  CALL DIETSK (IRETCD, QUICK, ISCR)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I4,' ON ',A)
      END
      SUBROUTINE DOIT (OPCODE, INEXT, INDISK, XLATED, DETIME, IERR)
C-----------------------------------------------------------------------
C   DOIT does the ls -lt to a /tmp file, then reads it finding the time
C   of each matching file, and reporting those that are old enough
C   Inputs:
C      OPCODE   C*4     'LIST', 'DELE'
C      INEXT    C*2     'MS', 'RL', 'SG', 'TG'
C      INDISK   I       AIPS disk number
C      XLATED   C*(*)   Address of $DA0n
C      DETTIME  R       Age cutoff
C   Output
C      IERR     I       error code
C-----------------------------------------------------------------------
      CHARACTER OPCODE*4, INEXT*2, XLATED*(*)
      REAL      DETIME
      INTEGER   INDISK, IERR
C
      INTEGER   I, J, JTRIM, LUN, FIND, TYPE, IDATE(3), DAY, YEAR, JT,
     *   CURENT, FSIZE, KBPTR, CDAY, TDAY, TCOUNT, IPOS, IMONTH, LPOS
      REAL      DIFF
      CHARACTER COMAND*256, TFILE*12, INLINE*256, FNAME*14, STRNG*128,
     *   MONTH*3, MONTHS(12)*3, MM*2, EXTYPS(4)*2, PHNAME*48, CNAME*5,
     *   OPER*8
      DOUBLE PRECISION XX, TSPACE
      INCLUDE 'INCS:DMSG.INC'
      DATA LUN /3/
      DATA MONTHS /'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG',
     *   'SEP','OCT','NOV','DEC'/
      DATA EXTYPS /'MS', 'RL', 'SG', 'TG'/
C-----------------------------------------------------------------------
      CALL ZDATE (IDATE)
      CURENT = IDATE(1)
      CALL DAYNUM (IDATE(1), IDATE(3), IDATE(2), CDAY)
      CNAME = 'DA01:'
      CALL ZEHEX (INDISK, 1, CNAME(4:4))
      OPER = 'Listed'
      IF ((OPCODE.EQ.'DELE') .AND. (INEXT.NE.'??')) OPER = 'Deleted'
C                                       build ls command
      J = JTRIM (XLATED)
      IF (INEXT.EQ.'??') THEN
         TFILE = '/tmp/QQ.list'
      ELSE
         TFILE = '/tmp/' // INEXT // '.list'
         end if
      COMAND = 'ls -lt ' // XLATED(:J) // INEXT // '* > ' // TFILE
      I = JTRIM (COMAND)
      J = 0
      CALL ZSHCMD (I, COMAND, J, TFILE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'DOING ls -lt TO FILE', INEXT
         GO TO 980
         END IF
C                                       open the file
      CALL ZTXOPN ('READ', LUN, FIND, TFILE, .TRUE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TEXT FILE', INEXT
         GO TO 980
         END IF
      TSPACE = 0.0D0
      TCOUNT = 0
C                                       read the file
 20   CALL ZTXIO ('READ', LUN, FIND, INLINE, IERR)
      IF (IERR.EQ.2) THEN
         IERR = 0
         GO TO 900
      ELSE IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE', INEXT
         GO TO 980
      ELSE
         JT = JTRIM (INLINE)
         FNAME = INLINE(JT-13:JT)
         J = JT
C                                       need to parse time
         KBPTR = 1
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         IPOS = KBPTR
C                                       File size
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         FSIZE = XX
C                                       date
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         MONTH = STRNG
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         DAY = XX + 0.01
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.EQ.1) THEN
            YEAR = XX + 0.01
         ELSE IF (TYPE.EQ.2) THEN
            YEAR = CURENT
         ELSE
            GO TO 970
            END IF
         LPOS = KBPTR
C                                       exclude standard on ??
         IF (INEXT.EQ.'??') THEN
            MM = FNAME(:2)
            DO 25 I = 1,4
               IF (MM.EQ.EXTYPS(I)) GO TO 20
 25            CONTINUE
            END IF
         CALL CHLTOU (3, MONTH)
         IMONTH = 0
         DO 30 I = 1,12
            IF (MONTH.EQ.MONTHS(I)) IMONTH = I
 30         CONTINUE
         IF (IMONTH.EQ.0) THEN
            DIFF = 2 * DETIME
            FSIZE = 0
         ELSE
            CALL DAYNUM (YEAR, DAY, IMONTH, TDAY)
            DIFF = CDAY - TDAY + 365.25 * (CURENT - YEAR)
            END IF
         IF (DIFF.GT.DETIME) THEN
            TSPACE = TSPACE + FSIZE
            WRITE (MSGTXT,1030)
            IF (TCOUNT.EQ.0) CALL MSGWRT (5)
            TCOUNT = TCOUNT + 1
            IF (INEXT.EQ.'??') THEN
               IF (FNAME(14:).EQ.';') THEN
                  MSGTXT = INLINE (IPOS:LPOS) // FNAME
               ELSE
                  I = 63 - (LPOS - IPOS + 1)
                  MSGTXT = INLINE (IPOS:LPOS) // INLINE(JT-I:JT)
                  END IF
            ELSE
               MSGTXT = INLINE (IPOS:LPOS) // FNAME
               END IF
            CALL MSGWRT (5)
C                                       delete
            IF ((INEXT.NE.'??') .AND. (OPCODE.EQ.'DELE')) THEN
               PHNAME = CNAME // FNAME
               CALL ZDESTR (INDISK, PHNAME, IERR)
               IF (IERR.NE.0) THEN
                  WRITE (MSGTXT,1000) IERR, 'DELETING', INEXT
                  CALL MSGWRT (8)
                  MSGTXT = PHNAME
                  CALL MSGWRT (8)
                  END IF
               END IF
            END IF
         GO TO 20
         END IF
C                                       close
 900  J = JTRIM (OPER)
      WRITE (MSGTXT,1900) OPER(:J), TCOUNT, INEXT, TSPACE/(1024.D0**2)
      CALL MSGWRT (5)
      CALL ZTXCLS (LUN, FIND, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'CLOSING TEXT FILE', INEXT
         GO TO 980
         END IF
      CALL ZTXZAP (LUN, TFILE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'DELETING TEXT FILE', INEXT
         GO TO 980
         END IF
      GO TO 999
C
 970  WRITE (MSGTXT,1970) TYPE
      CALL MSGWRT (8)
      MSGTXT = INLINE(:80)
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('DOIT ERROR',I4,' ON ',A,' FILE TYPE',A)
 1030 FORMAT ('Bytes     Date      Name')
 1900 FORMAT (A,I5,' files of type ',A,' total',F9.3,' Mbytes')
 1970 FORMAT ('TYPE',I3,' NOT THAT EXPECTED. INLINE =')
      END
      SUBROUTINE COUNT (OPCODE, INEXT, INDISK, XLATED, DETIME, IERR)
C-----------------------------------------------------------------------
C   DOIT does the ls -lt to a /tmp file, then reads it finding the time
C   of each matching file, and counting those that are old enough
C   Inputs:
C      OPCODE   C*4     'LIST', 'DELE'
C      INEXT    C*2     'MS', 'RL', 'SG', 'TG'
C      INDISK   I       AIPS disk number
C      XLATED   C*(*)   Address of $DA0n
C      DETTIME  R       Age cutoff
C   Output
C      IERR     I       error code
C-----------------------------------------------------------------------
      CHARACTER OPCODE*4, INEXT*2, XLATED*(*)
      REAL      DETIME
      INTEGER   INDISK, IERR
C
      INTEGER   I, J, JTRIM, LUN, FIND, TYPE, IDATE(3), DAY, YEAR, JT,
     *   CURENT, FSIZE, KBPTR, CDAY, TDAY, TCOUNT, IPOS, IMONTH, LPOS,
     *   DCOUNT(50000), IUSER
      REAL      DIFF
      CHARACTER COMAND*256, TFILE*12, INLINE*256, FNAME*14, STRNG*128,
     *   MONTH*3, MONTHS(12)*3, MM*2, EXTYPS(4)*2, CNAME*5, CUSER*3
      DOUBLE PRECISION XX, TSPACE, DSPACE(50000), MEG
      INCLUDE 'INCS:DMSG.INC'
      DATA LUN /3/
      DATA MONTHS /'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG',
     *   'SEP','OCT','NOV','DEC'/
      DATA EXTYPS /'MS', 'RL', 'SG', 'TG'/
C-----------------------------------------------------------------------
      CALL ZDATE (IDATE)
      CURENT = IDATE(1)
      CALL DAYNUM (IDATE(1), IDATE(3), IDATE(2), CDAY)
      CNAME = 'DA01:'
      CALL ZEHEX (INDISK, 1, CNAME(4:4))
      CALL FILL (50000, 0, DCOUNT)
      CALL DFILL (50000, 0.0D0, DSPACE)
      MEG = 1024.0D0 ** 2
C                                       build ls command
      J = JTRIM (XLATED)
      IF (INEXT.EQ.'??') THEN
         TFILE = '/tmp/QQ.list'
      ELSE
         TFILE = '/tmp/' // INEXT // '.list'
         end if
      COMAND = 'ls -lt ' // XLATED(:J) // INEXT // '* > ' // TFILE
      I = JTRIM (COMAND)
      J = 0
      CALL ZSHCMD (I, COMAND, J, TFILE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'DOING ls -lt TO FILE', INEXT
         GO TO 980
         END IF
C                                       open the file
      CALL ZTXOPN ('READ', LUN, FIND, TFILE, .TRUE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TEXT FILE', INEXT
         GO TO 980
         END IF
      TSPACE = 0.0D0
      TCOUNT = 0
C                                       read the file
 20   CALL ZTXIO ('READ', LUN, FIND, INLINE, IERR)
      IF (IERR.EQ.2) THEN
         IERR = 0
         GO TO 900
      ELSE IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE', INEXT
         GO TO 980
      ELSE
         JT = JTRIM (INLINE)
         FNAME = INLINE(JT-13:JT)
         J = JT
C                                       need to parse time
         KBPTR = 1
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         IPOS = KBPTR
C                                       File size
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         FSIZE = XX
C                                       date
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.2) GO TO 970
         MONTH = STRNG
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.NE.1) GO TO 970
         DAY = XX + 0.01
         CALL GETFLD (INLINE, KBPTR, J, TYPE, XX, STRNG)
         IF (TYPE.EQ.1) THEN
            YEAR = XX + 0.01
         ELSE IF (TYPE.EQ.2) THEN
            YEAR = CURENT
         ELSE
            GO TO 970
            END IF
         LPOS = KBPTR
C                                       exclude standard on ??
         IF (INEXT.EQ.'??') THEN
            MM = FNAME(:2)
            DO 25 I = 1,4
               IF (MM.EQ.EXTYPS(I)) GO TO 20
 25            CONTINUE
            END IF
         CALL CHLTOU (3, MONTH)
         IMONTH = 0
         DO 30 I = 1,12
            IF (MONTH.EQ.MONTHS(I)) IMONTH = I
 30         CONTINUE
         IF (IMONTH.EQ.0) THEN
            DIFF = 2 * DETIME
            FSIZE = 0
         ELSE
            CALL DAYNUM (YEAR, DAY, IMONTH, TDAY)
            DIFF = CDAY - TDAY + 365.25 * (CURENT - YEAR)
            END IF
         IF (DIFF.GT.DETIME) THEN
            TCOUNT = TCOUNT + 1
            TSPACE = TSPACE + FSIZE / MEG
            IF (FNAME(14:).EQ.';') THEN
               CUSER = FNAME(11:13)
               CALL ZHEX10 (CUSER, IUSER, IERR)
               IF (IERR.EQ.0) THEN
                  DCOUNT(IUSER) = DCOUNT(IUSER) + 1
                  DSPACE(IUSER) = DSPACE(IUSER) + FSIZE / MEG
                  END IF
               END IF
            END IF
         GO TO 20
         END IF
C                                       close
 900  CALL ZTXCLS (LUN, FIND, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'CLOSING TEXT FILE', INEXT
         GO TO 980
         END IF
      CALL ZTXZAP (LUN, TFILE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'DELETING TEXT FILE', INEXT
         GO TO 980
         END IF
      WRITE (MSGTXT,1900) TCOUNT, INEXT, TSPACE
      CALL MSGWRT (3)
C                                       report
      DO 910 I = 1,50000
         IF (DCOUNT(I).GT.0) THEN
            WRITE (MSGTXT,1910) I, DCOUNT(I), DSPACE(I)
            CALL MSGWRT (3)
            END IF
 910     CONTINUE
      GO TO 999
C
 970  WRITE (MSGTXT,1970) TYPE
      CALL MSGWRT (8)
      MSGTXT = INLINE(:80)
      CALL MSGWRT (8)
      GO TO 900
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('COUNT ERROR',I4,' ON ',A,' FILE TYPE',A)
 1900 FORMAT ('Found',I10,' files of type ''',A,'''',F12.4,' Mbytes')
 1910 FORMAT ('User',I6,' has',I8,' files',F12.4,' Mbytes')
 1970 FORMAT ('TYPE',I3,' NOT THAT EXPECTED. INLINE =')
      END
      SUBROUTINE GETFLD (KARBUF, KBPTR, KARLIM, TYPE, X, STRNG)
C-----------------------------------------------------------------------
C   GETFLD finds the next non-blank character in KARBUF and determines
C   whether the token begun with that character is symbolic (1st char
C   is A - Z), numeric (1st char is 0 - 9 or .), or hollerith (1st
C   char is ').
C   Inputs:
C      KARBUF   C*(*)   Line being parsed
C      KARLIM   I       Limit of string
C   In/out
C      KBPTR    I       Character position
C   Output
C      TYPE     I       1 float, 2 string, 0 error
C      X        D       numeric
C      STRNG    C*(*)   string
C-----------------------------------------------------------------------
      CHARACTER KARBUF*(*), STRNG*(*)
      INTEGER   KBPTR, KARLIM, TYPE
      DOUBLE PRECISION X
C
      CHARACTER M*1
      INTEGER   J, NKAR
      DOUBLE PRECISION DBLX
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      TYPE = 0
      NKAR = 0
C                                        skip leading blanks
 10   IF (KBPTR.GT.KARLIM) GO TO 999
         M = KARBUF(KBPTR:KBPTR)
         IF (M.NE.' ') GO TO 20
         KBPTR = KBPTR + 1
         GO TO 10
C                                        classify type by first char.
20    IF ((M.LE.'9') .AND. (M.GE.'0')) THEN
         IF (KARBUF(KBPTR+2:KBPTR+2).NE.':') GO TO 50
         END IF
      IF (M.EQ.'.') GO TO 50
C                                       In-line comment
      IF (M.NE.'$') GO TO 30
         KBPTR = KARLIM + 1
         GO TO 999
C-----------------------------------------------------------------------
C      S Y M B O L I C    F I E L D
C-----------------------------------------------------------------------
C                                        find end
 30   J = KBPTR
 35   NKAR = NKAR + 1
         J = J + 1
         IF (J.GT.KARLIM) THEN
            NKAR = NKAR - 1
            GO TO 40
            END IF
         M = KARBUF(J:J)
         IF (M.NE.' ') GO TO 35
C                                        locate in symbol table
 40   TYPE = 2
      STRNG = KARBUF(KBPTR:KBPTR+NKAR-1)
      KBPTR = KBPTR + NKAR
      GO TO 999
C-----------------------------------------------------------------------
C        N U M E R I C    F I E L D
C-----------------------------------------------------------------------
C                                        find value
 50   CALL GETNUM (KARBUF, KARLIM, KBPTR, DBLX)
      IF (DBLX.NE.DBLANK) THEN
         TYPE = 1
         X = DBLX
         END IF
      GO TO 999
C
 999  RETURN
      END
