LOCAL INCLUDE 'IANTB.INC'
      INCLUDE 'INCS:PUVD.INC'
C                                       Local include for IANTB
      HOLLERITH XNAMEI(3), XCLAIN(2), XOUFIL(12)
      CHARACTER LNAME*12, LCLASS*6, LOUFIL*48
      DOUBLE PRECISION FREQS(MAXIF)
      REAL      XINSEQ, XINDIS, XANT(50), XSUBA, XFRQID, XTYVER, XGCVER
      INTEGER   INSEQ, INDISK, IANTWT(50), NANTWT, ITYVER, IGCVER,
     *   ISUBA, NPARM, INVERS, ISUB1, ISUB2, TLUN, TIND, IFRQID
C                                       Input parameters
      COMMON /INPARM/ XNAMEI, XCLAIN, XINSEQ, XINDIS, XANT, XSUBA,
     *   XFRQID, XTYVER, XGCVER, XOUFIL
      COMMON /INVAL/ FREQS, IANTWT, NANTWT, INSEQ, INDISK, ISUBA,
     *   ITYVER, IGCVER, NPARM, INVERS, ISUB1, ISUB2, TLUN, TIND, IFRQID
      COMMON /CHVAL/ LNAME, LCLASS, LOUFIL
C                                       Buffers
      INTEGER   NBUF1, NBUF2
      PARAMETER (NBUF1 = 512, NBUF2 = 512)
      INTEGER   BUFF1(NBUF1), BUFF2(NBUF2)
      COMMON /WRKBUF/ BUFF1, BUFF2
C                                       General global variables
      INTEGER   ILUN1, ILUN2, ICNO, NPOLUV, NIFUV, IPOLUV, IPLROW
      LOGICAL   ANTNEG
      COMMON /GLBLVR/ ILUN1, ILUN2, ICNO, NPOLUV, NIFUV, IPOLUV, IPLROW,
     *   ANTNEG
C
LOCAL END
LOCAL INCLUDE 'DGCV.INC'
C                                       Include for gain curve table
C                                       (used by GETGC and GCVAL)
C                                       Requires INCS:PUVD.INC and
C                                       INCS:PGCV.INC
      INTEGER MAXVAL
      PARAMETER (MAXVAL = 10)
      REAL XVALGC(2,MAXIF,MAXVAL), YVALGC(2,MAXIF,MXTBGC,MAXVAL),
     *   GAINGC(2,MAXIF,MXTBGC,MAXVAL), SENSGC(2,MAXIF,MAXVAL)
      INTEGER ITPGC(2,MAXIF,MAXVAL), NTGC(2,MAXIF,MAXVAL),
     *   IXTGC(2,MAXIF,MAXVAL), IYTGC(2,MAXIF,MAXVAL), IANTGC,
     *   ISUBGC, IFQDGC, NXVAL
      COMMON /GCCOM/ XVALGC, YVALGC, GAINGC, SENSGC,
     *   ITPGC, NTGC, IXTGC, IYTGC, IANTGC, ISUBGC, IFQDGC, NXVAL
C                                       End Include
LOCAL END
      PROGRAM IANTB
C-----------------------------------------------------------------------
C! Write GC and TY data in ANTAB format
C# UV Calibration EXT-util VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2021-2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Task IANTB writes TY and GC data in ANTAB format
C   Inputs:
C      AIPS adverb       Local var.       Description
C      INNAME            LNAME            Input uv-file name.
C      INCLASS           LCLASS           Class of input uv-file
C      INSEQ             INSEQ            Seq. no. of input uv-file
C      INDISK            INDISK           Disk no. of input file
C      ANTENNAS          XANT             Antennas to calibrate
C      SUBARRAY          ISUBA            Subarray to calibrate
C      OUTTEXT           LOUFIL           Output filr
C-----------------------------------------------------------------------
      INCLUDE 'IANTB.INC'
      CHARACTER LPGM*6
      INTEGER   IRET
      INCLUDE 'INCS:DCAT.INC'
      DATA LPGM /'IANTB '/
C-----------------------------------------------------------------------
C                                       Get input parameters and perform
C                                       general initialisation
      CALL IANTBI (LPGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Perform the amplitude
C                                       calibration
      IF (ISUBA.LE.0) THEN
         CALL FNDEXT ('AN', CATBLK, ISUB2)
         ISUB1 = 1
      ELSE
         ISUB1 = ISUBA
         ISUB2 = ISUBA
         END IF
      DO 20 ISUBA = ISUB1,ISUB2
         CALL IANTBO (IRET)
         IF (IRET.NE.0) GO TO 990
 20      CONTINUE
      IF (ISUB1.EQ.ISUB2) THEN
         ISUBA = ISUB1
      ELSE
         ISUBA = 0
         END IF
C                                       Close down files/exit
 990  CALL DIE (IRET, BUFF1)
C
 999  STOP
      END
      SUBROUTINE IANTBI (LPGM, IRET)
C------------------------------------------------------------------------
C   Read input parameters for IANTB and perform general initialisation
C   Inputs:
C      LPGM    C*6      Task name
C   Outputs:
C      IRET    I        Return code (0 => ok)
C------------------------------------------------------------------------
      CHARACTER LPGM*6
      INTEGER IRET
C
      INCLUDE 'IANTB.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DMSG.INC'
      LOGICAL WTRUE
      CHARACTER LSTAT*4, LTYPE*2
      INTEGER IERR, I, IROUND, J
      DATA WTRUE /.TRUE./
C------------------------------------------------------------------------
      IRET = 0
C                                       General LUNs for table I/O
      ILUN1 = 27
      ILUN2 = 28
C                                       Initialise AIPS from disk
      CALL ZDCHIN (WTRUE)
C                                       Compute catalog rec. pointers
      CALL VHDRIN
C                                       Initialise /CFILES/
      NSCR = 0
      NCFILE = 0
C                                       Get input adverbs
      NPARM = 73
      CALL GTPARM (LPGM, NPARM, RQUICK, XNAMEI, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = WTRUE
         IRET = 1
C                                       Check if initiator (AIPS)
C                                       not found
         IF (IERR.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
         CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, BUFF1, IERR)
      IF (IERR.NE.0) IRET = 1
C                                       Abort if error obtaining
C                                       input parameters
      IF (IRET.NE.0) GO TO 999
C                                       Convert input parameters
      CALL H2CHR (48, 1, XOUFIL, LOUFIL)
      CALL H2CHR (12, 1, XNAMEI, LNAME)
      CALL H2CHR (6, 1, XCLAIN, LCLASS)
      INSEQ = XINSEQ
      INDISK = XINDIS
C                                       Antennas wanted
      NANTWT = 0
      ANTNEG = .FALSE.
      DO 150 I = 1, 50
         J = IROUND (XANT(I))
         IF (J.GT.0) THEN
            NANTWT = NANTWT + 1
            IANTWT(NANTWT) = J
         ELSE IF (J.LT.0) THEN
            NANTWT = NANTWT + 1
            IANTWT(NANTWT) = -J
            ANTNEG = .TRUE.
            END IF
 150     CONTINUE
C                                       Subarray
      ISUBA = XSUBA
      ISUBA = MAX (ISUBA, 0)
C                                       Table version numbers
      ITYVER = XTYVER
      ITYVER = MAX (0, ITYVER)
      IGCVER = XGCVER
      IGCVER = MAX (0, IGCVER)
C                                       Find uv-file in catalog directory
      LSTAT = 'SRCH'
      LTYPE = 'UV'
      ICNO = 1
      CALL CATDIR ('SRCH', INDISK, ICNO, LNAME, LCLASS, INSEQ, LTYPE,
     *   NLUSER, LSTAT, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1020) IERR, LNAME, LCLASS, INSEQ, INDISK
         IRET = 2
         GO TO 990
         END IF
C                                       Read catalog header; mark file
C                                       status as 'WRITE'
      CALL CATIO ('READ', INDISK, ICNO, CATBLK, 'WRIT', BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR, LNAME, LCLASS, INSEQ, INDISK
         IRET = 3
         GO TO 990
         END IF
C                                       Add to /CFILES/
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = INDISK
      FCNO(NCFILE) = ICNO
      FRW(NCFILE) = 1
C                                       Convert input parameters
      CALL CHR2H (12, LNAME, 1, XNAMEI)
      CALL CHR2H (6, LCLASS, 1, XCLAIN)
      XINSEQ = INSEQ
      XINDIS = INDISK
C                                       Get uv-header information
      CALL UVPGET (IERR)
      IF (IERR.NE.0) THEN
         IRET = 4
         WRITE (MSGTXT,1000) IERR, 'PARSING UV HEADER'
         GO TO 990
         END IF
C                                       No. of IFs/polzns. in header
      IF (JLOCIF.GT.0) THEN
         NIFUV = CATBLK(KINAX+JLOCIF)
      ELSE
         NIFUV = 1
         END IF
      IF (JLOCS.GT.0) THEN
         NPOLUV = MIN (2, CATBLK(KINAX+JLOCS))
      ELSE
         NPOLUV = 1
         END IF
      IPOLUV = 1
C                                       First polzn (RR,XX) = 1
      IF ((ICOR0.EQ.-1).OR.(ICOR0.EQ.-5)) IPOLUV = 1
C                                       (LL,YY) = 2
      IF ((ICOR0.EQ.-2).OR.(ICOR0.EQ.-6)) IPOLUV = 2
C                                       For all multi-Stokes datasets
C                                       expect both R and L in the
C                                       tables
      IF (NPOLUV.GT.1) IPOLUV = 1
C                                       open output
      TLUN = 3
      CALL ZTXOPN ('WRIT', TLUN, TIND, LOUFIL, .TRUE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING OUTPUT TEXT FILE'
         GO TO 990
         END IF
      GO TO 999
C
C                                       Error
 990  CALL MSGWRT (8)
C                                       Exit
 999  RETURN
C----------------------------------------------------------------------
1000  FORMAT ('IANTBI: ERROR',I3,' ON ',A)
1020  FORMAT ('IANTBI: ERR',I3,' FINDING ',A12,'.',A6,'.',I4,'.',I3)
1040  FORMAT ('IANTBI: ERR',I3,' READING HEADER ',A12,'.',A6,'.',I4,'.',
     *   I3)
      END
      SUBROUTINE IANTBO (IRET)
C----------------------------------------------------------------------
C   Write ANTAB file from GC and TY
C   Outputs:
C      IRET    I   Return code (0 => ok)
C----------------------------------------------------------------------
      INTEGER IRET
C
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:PTYTAB.INC'
      INCLUDE 'INCS:PGCV.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'IANTB.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DANT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'DGCV.INC'
      INCLUDE 'INCS:DMSG.INC'
      CHARACTER BNDCOD(MAXIF)*8, CTYPE(3)*5, STRING*256, OBSDAT*8,
     *   CIF(16,2)*3
      DOUBLE PRECISION JD0, XFREQ(2)
      REAL FKEY(2,2), TIMETY, TINTTY, TSYST(2,MAXIF), TANT(2,MAXIF),
     *   TBWFQ(MAXIF), CHBWFQ(MAXIF), RTT, TMAX, TMIN
      INTEGER SIDFQ(MAXIF), KEY(2,2), IERR, ITYRNO, TYKOLS(MAXTYC),
     *   TYNUMV(MAXTYC), NPOLTY, NIFTY, IER, JREC, ITYSOU, ITYANT,
     *   ITYSUB, ITYFQD, I, NROW, K, KEYSUB(2,2), LANT, NA, JTRIM,
     *   IDATE(3), DAYN, JTT(3), DAYM, KTT(2)
      EQUIVALENCE (KTT(1), JTT(2))
      DATA KEYSUB /4*1/
      DATA CTYPE /'EQUAT', 'ALTAZ', 'ELEV'/
C----------------------------------------------------------------------
      IRET = 0
C                                       Get antenna table information
      CALL GETANT (INDISK, ICNO, ISUBA, CATBLK, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         IRET = 1
         WRITE (MSGTXT,1000) IERR, 'READING ANTENNA TABLE'
         GO TO 900
         END IF
      CALL JULDAY (RDATE, JD0)
      DO 5 I = 1,9
         WRITE (CIF(I,1),1001) 'R', I
         WRITE (CIF(I,2),1001) 'L', I
 5       CONTINUE
      DO 6 I = 10,16
         WRITE (CIF(I,1),1002) 'R', I
         WRITE (CIF(I,2),1002) 'L', I
 6       CONTINUE
C                                       Strip null characters from
C                                       antenna names returned by
C                                       GETANT and check if DOFIT,
C                                       TREC and TAU0 are set
      DO 10 I = 1, NSTNS
         K = JTRIM (STNNAM(I))
 10      CONTINUE
C                                       get frequency
      IFRQID = MAX (0.0, XFRQID) + 0.1
      I = MAX (1, IFRQID)
      CALL GETFQ (I, INDISK, ICNO, CATBLK, ILUN2, FREQS, TBWFQ,
     *   CHBWFQ, SIDFQ, BNDCOD, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING FQ TABLE'
         GO TO 900
         END IF
      XFREQ(1) = 1.D18
      XFREQ(2) = -XFREQ(1)
      DO 15 I = 1,NIFUV
         XFREQ(1) = MIN (XFREQ(1), FREQS(I))
         XFREQ(2) = MAX (XFREQ(2), FREQS(I))
         XFREQ(1) = MIN (XFREQ(1), FREQS(I)+TBWFQ(I))
         XFREQ(2) = MAX (XFREQ(2), FREQS(I)+TBWFQ(I))
 15      CONTINUE
      XFREQ(1) = XFREQ(1) / 1.D6
      XFREQ(2) = XFREQ(2) / 1.D6
C                                       day number
      CALL H2CHR (8, 1, CATH(KHDOB), OBSDAT)
      CALL DATEST (OBSDAT, IDATE)
      CALL DAYNUM (IDATE(1), IDATE(3), IDATE(2), DAYN)
C                                       Sort TY table into (Ant, Suba,
C                                       Fqid, Time) order.
      KEY(1,1) = TYIANT
      FKEY(1,1) = 1000.0
      KEY(2,1) = TYISUB
      FKEY(2,1) = 1.0
      KEY(1,2) = TYIFQI
      FKEY(1,2) = 100.0
      KEY(2,2) = TYRTIM
      FKEY(2,2) = 1.0
      CALL TABSRT (INDISK, ICNO, 'TY', ITYVER, ITYVER, KEY, KEYSUB,
     *   FKEY, BUFF2, CATBLK, IERR)
      IF (IERR.NE.0) THEN
         IRET = 3
         WRITE (MSGTXT,1000) IERR, 'SORTING TY TABLE'
         GO TO 900
         END IF
C                                       Open input TY table
      CALL TYINI ('READ', BUFF1, INDISK, ICNO, ITYVER, CATBLK, ILUN1,
     *   ITYRNO, TYKOLS, TYNUMV, NPOLTY, NIFTY, IERR)
      IF (IERR.NE.0) THEN
         IRET = 4
         WRITE (MSGTXT,1000) IERR, 'OPENING TY TABLE'
         GO TO 900
         END IF
C
      NROW = BUFF1(5)
      JREC = 1
C                                       Reset IANTGC, ISUBGC and IFQDGC
C                                       in DGCV.INC
      IANTGC = 0
      ISUBGC = 0
      IFQDGC = 0
      LANT = 0
      NPOLUV = MAX (NPOLUV, IPOLUV)
      DO 400 JREC = 1,NROW
C                                       Read TY record
         ITYRNO = JREC
         CALL TABTY ('READ', BUFF1, ITYRNO, TYKOLS, TYNUMV, NPOLTY,
     *      NIFTY, TIMETY, TINTTY, ITYSOU, ITYANT, ITYSUB, ITYFQD,
     *      TSYST, TANT, IERR)
         IF (IERR.LT.0) GO TO 400
         IF (IERR.NE.0) THEN
            IRET = 7
            WRITE (MSGTXT,1000) IERR, 'READING TY TABLE'
            GO TO 900
            END IF
         IF ((ITYSUB.GT.0) .AND. (ITYSUB.NE.ISUBA)) GO TO 400
         IF ((ITYFQD.GT.0) .AND. (ITYFQD.NE.IFRQID) .AND.
     *      (IFRQID.GT.0)) GO TO 400
C                                       Check if record is selected
C                                       Antenna:
         IF (NANTWT.GT.0) THEN
            DO 110 I = 1,NANTWT
               IF (IANTWT(I).EQ.ITYANT) THEN
                  IF (ANTNEG) GO TO 400
                  GO TO 115
                  END IF
 110           CONTINUE
            IF (.NOT.ANTNEG) GO TO 400
            END IF
C                                       record wanted
 115     IF (LANT.NE.ITYANT) THEN
C                                       end previous
            IF (LANT.GT.0) THEN
               STRING = '/'
               K = JTRIM (STRING)
               CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
               IF (IERR.NE.0) GO TO 900
               END IF
C                                       get GC values
            CALL GETGC (BUFF2, INDISK, ICNO, IGCVER, CATBLK, ILUN2,
     *         ITYANT, ISUBA, IFRQID, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READING GC TABLE'
               IRET = 8
               GO TO 900
               END IF
            LANT = ITYANT
C                                       write header and GC
            NA = JTRIM (STNNAM(LANT))
            STRING = '! For antenna: ' // STNNAM(LANT)(:NA)
            K = JTRIM (STRING)
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            STRING = '! ----- Tsys information for ' //
     *         STNNAM(LANT)(:NA)
            K = JTRIM (STRING)
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            WRITE (STRING,1100) STNNAM(LANT)(:NA), CTYPE(ITPGC(1,1,1)),
     *         SENSGC(1,1,1), SENSGC(2,1,1), XFREQ
            K = JTRIM (STRING)
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            WRITE (STRING,1105) (GAINGC(1,1,I,1), I=1,NTGC(1,1,1))
            K = JTRIM (STRING)
            STRING(K:) = ' /'
            K = K + 1
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            STRING = 'TSYS ' // STNNAM(LANT)(:NA) //
     *         '  FT=1.0 TIMEOFF=0'
            K = JTRIM (STRING)
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            WRITE (STRING,1110) ((CIF(I,K), I=1,NIFUV),
     *         K = IPOLUV,NPOLUV)
            K = JTRIM (STRING)
            IF (STRING(K-1:K).EQ.',''') K = K - 1
            IF (STRING(K:K).EQ.'''') K = K + 1
            STRING(K:) = ' /'
            K = K + 1
            CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         CALL T2DHMS (TIMETY, 1, JTT, RTT)
         DAYM = DAYN + JTT(1)
C                                       fit print format
         TMAX = -1.E10
         TMIN = 1.E10
         DO 210 K = IPOLUV,NPOLUV
            DO 205 I = 1,NIFTY
               IF (TSYST(K,I).EQ.FBLANK) THEN
                  TSYST(K,I) = 999.0
               ELSE
                  TMAX = MAX (TMAX, TSYST(K,I))
                  TMIN = MIN (TMIN, TSYST(K,I))
                  END IF
 205           CONTINUE
 210        CONTINUE
         TMIN = -10.0 * TMIN
         TMAX = MAX (TMAX, TMIN)
         RTT = MAX (0.0, RTT)
         IF (TMAX.LT.999.95) THEN
            WRITE (STRING,1120) DAYM, KTT, RTT, ((TSYST(K,I),
     *         I = 1,NIFTY), K = IPOLUV,NPOLUV)
         ELSE IF (TMAX.LT.9999.95) THEN
            WRITE (STRING,1121) DAYM, KTT, RTT, ((TSYST(K,I),
     *         I = 1,NIFTY), K = IPOLUV,NPOLUV)
         ELSE IF (TMAX.LT.99999.95) THEN
            WRITE (STRING,1122) DAYM, KTT, RTT, ((TSYST(K,I),
     *         I = 1,NIFTY), K = IPOLUV,NPOLUV)
         ELSE
            WRITE (STRING,1123) DAYM, KTT, RTT, ((TSYST(K,I),
     *         I = 1,NIFTY), K = IPOLUV,NPOLUV)
            END IF
         IF (STRING(12:12).EQ.' ') STRING(12:12) = '0'
         K = JTRIM (STRING)
         CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
         IF (IERR.NE.0) GO TO 900
 400     CONTINUE
C                                       end previous
      IF (LANT.GT.0) THEN
         STRING = '/'
         K = JTRIM (STRING)
         CALL ZTXIO ('WRIT', TLUN, TIND, STRING(:K), IERR)
         IF (IERR.NE.0) GO TO 900
         END IF
C                                       Close tables
      CALL TABIO ('CLOS', 0, ITYRNO, BUFF1, BUFF1, IER)
      GO TO 995
C                                       Error
 900  CALL MSGWRT (8)
C                                       Exit
C                                       Close text file
 995  IF (ISUBA.EQ.ISUB2) THEN
         CALL ZTXCLS (TLUN, TIND, IER)
         IF (IRET.LE.0) THEN
            CALL CATIO ('UPDT', INDISK, ICNO, CATBLK, 'REST', BUFF1,
     *         IER)
            IF (IER.NE.0) THEN
               WRITE (MSGTXT,1650) IER
               CALL MSGWRT (7)
               END IF
            END IF
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('IANTBO: ERROR',I5,' ON ',A)
 1001 FORMAT (A,I1)
 1002 FORMAT (A,I2)
 1100 FORMAT ('GAIN ',A,1X,A,' DPFU=',F7.4,',',F7.4,' FREQ=',F10.4,',',
     *   F10.4)
 1105 FORMAT ('POLY=',F7.5,10(',',1PE11.4))
 1110 FORMAT ('INDEX= ',9('''',A2,''','),7('''',A3,''','))
 1120 FORMAT (I3,I4.2,':',I2.2,':',F4.1,16(F8.3))
 1121 FORMAT (I3,I4.2,':',I2.2,':',F4.1,16(F9.3))
 1122 FORMAT (I3,I4.2,':',I2.2,':',F4.1,16(F10.3))
 1123 FORMAT (I3,I4.2,':',I2.2,':',F4.1,16(F12.3))
 1650 FORMAT ('IANTBO: ERROR',I4,' UPDATING HEADER ON DISK')
      END
      SUBROUTINE GETGC (BUFFER, IDISK, ICNO, IVER, CATBLK, ILUN, IANT,
     *   ISUB, IFQID, IRET)
C-----------------------------------------------------------------------
C   Load all gain curve info. for a specific antenna, sub. and fqid
C   Inputs
C      IDISK   I   Disk volume of uv-file
C      ICNO    I   Catalog number of uv-file
C      CATBLK  I   Catalog header for uv-file
C      ILUN    I   LUN to use for table I/O
C      IANT    I   Antenna number
C      ISUB    I   Subarray
C      IFQID   I   Frequency ID
C   Input/output:
C      BUFFER  I(512)   I/O buffer
C      IVER    I        Version number of GC table
C   Output in common:
C      Data output in DGCV.INC
C   Output:
C      IRET    I        Return code (0 => ok)
C-----------------------------------------------------------------------
      INTEGER   IDISK, ICNO, IVER, ILUN, IANT, ISUB, IFQID, IRET
      INTEGER   BUFFER(512), CATBLK(256)
C
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:PGCV.INC'
      INCLUDE 'DGCV.INC'
      INCLUDE 'INCS:DMSG.INC'
C
      INTEGER   IGCRNO, GCKOLS(MAXGCC), GCNUMV(MAXGCC), NPOLGC, NTABGC,
     *   NOBAND, I, NROW, IERR, N, J, K, L
      LOGICAL   SAME
C-----------------------------------------------------------------------
      IRET = 0
C                                       Open GC table
      CALL GCINI ('READ', BUFFER, IDISK, ICNO, IVER, CATBLK, ILUN,
     *   IGCRNO, GCKOLS, GCNUMV, NPOLGC, NOBAND, NTABGC, IERR)
      IF (IERR.NE.0) THEN
         IRET = 1
         WRITE (MSGTXT,1020) IERR
         GO TO 990
         END IF
C
      NXVAL = 1
      NROW = BUFFER(5)
C                                       While (NOT EOF(GC_table)) do
C                                          (read record)
      DO 300 I = 1, NROW
         IGCRNO = I
         CALL TABGC ('READ', BUFFER, IGCRNO, GCKOLS, GCNUMV, NPOLGC,
     *      NTABGC, IANTGC, ISUBGC, IFQDGC, ITPGC(1,1,NXVAL),
     *      NTGC(1,1,NXVAL), IXTGC(1,1,NXVAL), IYTGC(1,1,NXVAL),
     *      XVALGC(1,1,NXVAL), YVALGC(1,1,1,NXVAL),
     *      GAINGC(1,1,1,NXVAL), SENSGC(1,1,NXVAL), IERR)
         IF (IERR.GT.0) THEN
            IRET = 2
            WRITE (MSGTXT,1040) IERR
            GO TO 990
C                                       Matching ant, subarray, fqid ?
         ELSE IF (IERR.EQ.0) THEN
            IF ((IANT.EQ.IANTGC) .AND. ((ISUB.EQ.ISUBGC) .OR.
     *         (ISUBGC.LE.0)) .AND. ((IFQID.EQ.IFQDGC) .OR.
     *         (IFQDGC.LE.0) .OR. (IFQID.LE.0))) THEN
C                                       is this a duplicate?
               IF (NXVAL.GT.1) THEN
                  SAME = .TRUE.
                  N = NXVAL - 1
                  DO 100 J = 1,NOBAND
                     DO 90 K = 1,2
                        IF (ITPGC(K,J,NXVAL).NE.ITPGC(K,J,N))
     *                     SAME = .FALSE.
                        IF (NTGC(K,J,NXVAL).NE.NTGC(K,J,N))
     *                     SAME = .FALSE.
                        IF (IXTGC(K,J,NXVAL).NE.IXTGC(K,J,N))
     *                     SAME = .FALSE.
                        IF (IYTGC(K,J,NXVAL).NE.IYTGC(K,J,N))
     *                     SAME = .FALSE.
                        IF (XVALGC(K,J,NXVAL).NE.XVALGC(K,J,N))
     *                     SAME = .FALSE.
                        IF (SENSGC(K,J,NXVAL).NE.SENSGC(K,J,N))
     *                     SAME = .FALSE.
                        DO 80 L = 1,NTGC(K,J,NXVAL)
                           IF (YVALGC(K,J,L,NXVAL).NE.YVALGC(K,J,L,N))
     *                        SAME = .FALSE.
                           IF (GAINGC(K,J,L,NXVAL).NE.GAINGC(K,J,L,N))
     *                        SAME = .FALSE.
  80                       CONTINUE
  90                    CONTINUE
  100                CONTINUE
               ELSE
                  SAME = .FALSE.
                  END IF
               IF (.NOT.SAME) THEN
                  NXVAL = NXVAL + 1
                  IF (NXVAL.GT.MAXVAL) THEN
                     IRET = 3
                     WRITE (MSGTXT,1060)
                     GO TO 990
                     END IF
                  END IF
               END IF
            END IF
 300     CONTINUE
C                                       Close GC table
      IANTGC = IANT
      ISUBGC = ISUB
      IFQDGC = IFQID
      NXVAL = NXVAL - 1
      CALL TABIO ('CLOS', 0, IGCRNO, BUFFER, BUFFER, IERR)
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
      IF (IRET.NE.1) CALL TABIO ('CLOS', 0, IGCRNO, BUFFER, BUFFER,
     *   IERR)
C                                       Exit
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT ('GETGC: ERROR',I3,' OPENING GC TABLE')
 1040 FORMAT ('GETGC: ERROR',I3,' READING GC TABLE')
 1060 FORMAT ('GETGC: PARAMETER MAXVAL TOO SMALL: CONTACT AIPS ADMIN')
      END
      SUBROUTINE T2DHMS (TIMEIN, NDIG, TIME, RTIME)
C-----------------------------------------------------------------------
C   Convert from Time to Days Hours Minutes Seconds format
C   Input:
C      TIMEIN   R       Input:  Time
C      NDIG     I       Number digits in seconds display
C   Output:
C      TIME     I(3)    Output Time in Days, Hours Minutes
C      RTIME    R       SECONDS
C-----------------------------------------------------------------------
      REAL     TIMEIN, RTIME
      INTEGER  NDIG, TIME(3)
C
      REAL     T
      INTEGER  I, J
C-----------------------------------------------------------------------
      T = TIMEIN
      IF (TIMEIN.LT.0.0) T = -T
C
      TIME(1) = T
      T = (T - TIME(1)) * 24.0
      TIME(2) = T
      T = (T - TIME(2)) * 60.0
      TIME(3) = T
      T = (T - TIME(3)) * 60.0
      RTIME   = T
      J = 10 ** NDIG
      J = MAX (1, J)
      I = J*T + 0.5
C                                       Now Remove 60 seconds
      IF (I.GE.J*60) THEN
         RTIME = RTIME - 60.0
         TIME(3) = TIME(3) + 1
         END IF
C                                       Now Remove 60 minutes
      IF (TIME(3).GE.60) THEN
         TIME(3) = TIME(3) - 60
         TIME(2) = TIME(2) + 1
         END IF
      IF (TIME(2).GE.24) THEN
         TIME(2) = TIME(2) - 24
         TIME(1) = TIME(1) + 1
         END IF
C                                       Sign
      IF (TIMEIN.LT.0.0) TIME(1) = -TIME(1)
      RTIME = MAX (0.0, RTIME)
C
 999  RETURN
      END
