LOCAL INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:PMAD.INC'
C                                       Local include for MFIMG
      INTEGER   SEQOUT, DISKO, NEWCNO, JBUFSZ, ICODE, LUNIN, FINDIN,
     *   SCRTCH(256)
      CHARACTER OPCODE*4, NAMOUT*12, CLAOUT*6, OPTYPE*4, OUTPRT*48,
     *   INFILE*48
      HOLLERITH XNAMOU(3), XCLAOU(2), XOPCOD(1), XOPTYP(1), XOUTPR(12),
     *   XINFIL(12)
      REAL      XMSIZE(2), CELLS(2), XSEQO, XDISKO, XNPTS,
     *   BUFFER(MABFSS)
C                                       Program commons
      COMMON /INPARM/ XMSIZE, CELLS, XNAMOU, XCLAOU, XSEQO, XDISKO,
     *   XOPCOD, XOPTYP, XOUTPR, XINFIL, XNPTS
      COMMON /PARMS/ SEQOUT, DISKO, NEWCNO, JBUFSZ, ICODE, LUNIN,
     *   FINDIN
      COMMON /BUFRS/ BUFFER, SCRTCH
      COMMON /CHRCOM/ OUTPRT, OPCODE, OPTYPE, NAMOUT, CLAOUT, INFILE
LOCAL END
      PROGRAM MFIMG
C-----------------------------------------------------------------------
C! Paraform task to create an AIPS image.
C# Map
C-----------------------------------------------------------------------
C;  Copyright (C) 2023-2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   MFIMGC
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      IMSIZE         XMSIZE        Image size in pixels.
C      CELLSIZE       CELLS         Pixel size in first two dim.
C      OUTNAME        NAMOUT        Name of the output image
C                                   Default output is input image.
C      OUTCLASS       CLAOUT        Class of the output image.
C                                   Default is input class.
C      OUTSEQ         SEQOUT        Seq. number of output image.
C      OUTDISK        DISKO         Disk number of the output image.
C      OPCODE         OPCODE        User specified opcode.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA PRGM /'MFIMG '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL MFIMGI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Print text file
      IF (OUTPRT.NE.' ') THEN
         CALL MFIMGP (IRET)
C                                       do INONEX file image
      ELSE IF (INFILE.NE.' ') THEN
         CALL MFIMGJ (IRET)
C                                       image magnetic field
      ELSE
         CALL MFIMGD (IRET)
         END IF
C                                       History
      IF (IRET.EQ.0) CALL MFIMGH
C                                       Close down files, etc.
 990  CALL DIE (IRET, SCRTCH)
C
 999  STOP
      END
      SUBROUTINE MFIMGI (PRGN, IRET)
C-----------------------------------------------------------------------
C   MFIMGI gets input parameters for MFIMG and creates an output file.
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      IRET    I    Error code: 0 => ok
C                     4 => user routine detected error.
C                     5 => catalog troubles
C                     8 => can't start
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      INTEGER   IRET
      CHARACTER PRGN*6
C
      CHARACTER BLANK*6, DEFNAM*12, OLDNAM*12
      INTEGER   IERR, NPARM, IROUND
      LOGICAL   T, F
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA BLANK /'      '/
      DATA T, F /.TRUE.,.FALSE./
C
C                                       Change this default output name
      DATA DEFNAM /'MFIMG MAP   '/
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (T)
      CALL VHDRIN
      JBUFSZ = 2 * MABFSS
      IRET = 0
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
C                                       Get input parameters.
      NPARM = 38
      CALL GTPARM (PRGN, NPARM, RQUICK, XMSIZE, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         IRET = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
            END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, SCRTCH, IERR)
      IF (IRET.NE.0) GO TO 999
C                                       Crunch input parameters.
      SEQOUT = IROUND (XSEQO)
      DISKO = IROUND (XDISKO)
C                                       Characters
      CALL H2CHR (4, 1, XOPCOD, OPCODE)
      CALL H2CHR (4, 1, XOPTYP, OPTYPE)
      CALL H2CHR (12, 1, XNAMOU, NAMOUT)
      CALL H2CHR (6, 1, XCLAOU, CLAOUT)
      CALL H2CHR (48, 1, XOUTPR, OUTPRT)
      IF (OUTPRT.NE.' ') GO TO 999
      CALL H2CHR (48, 1, XINFIL, INFILE)
      IRET = 5
C                                       Init CATBLK.
      CALL CATINI (CATBLK)
C                                       Create new file.
C                                       Put values in CATBLK.
      OLDNAM = DEFNAM
      CALL MAKOUT (OLDNAM, BLANK, 0, BLANK, NAMOUT, CLAOUT, SEQOUT)
      CALL CHR2H (12, NAMOUT, KHIMNO, CATH(KHIMN))
      CALL CHR2H (6, CLAOUT, KHIMCO, CATH(KHIMC))
      CALL CHR2H (2, 'MA', KHPTYO, CATH(KHPTY))
      CATBLK(KIIMS) = SEQOUT
C                                       Get user modification to CATBLK
      IRET = 4
      CALL NEWHED (IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Create output file.
      NEWCNO = 1
      IRET = 4
      CALL MCREAT (DISKO, NEWCNO, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1060) IERR
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKO
      FCNO(NCFILE) = NEWCNO
      FRW(NCFILE) = 2
      IRET = 0
      SEQOUT = CATBLK(KIIMS)
C                                       Set obs. date=current date.
      CATH(KHDOB) = CATH(KHDMP)
      CATH(KHDOB+1) = CATH(KHDMP+1)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('MFIMGI: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1060 FORMAT ('ERROR',I3,' CREATING OUTPUT FILE')
      END
      SUBROUTINE MFIMGP (IRET)
C-----------------------------------------------------------------------
C   MFIMGP prints a text file with mag field values every 5 degrees
C   Output:
C      IRET   I   Error code from writing file
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'MFIMG.INC'
      INTEGER   I, J, LUN, FIND, IB(4,2), JTRIM, JT, IROUND, DROUND
      DOUBLE PRECISION X, DATE, ALT, BF, BX, BY, BZ, CY
      REAL      GLAT, GLONG, B(4), R0, F
      CHARACTER OUTLIN*128
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA R0 /6670000.0/

      DATA LUN /3/
C-----------------------------------------------------------------------
C                                       create file
      CALL ZTXOPN ('WRIT', LUN, FIND, OUTPRT, .TRUE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING OUTPUT TEXT FILE'
         GO TO 990
         END IF
C                                       header
      WRITE (OUTLIN,2000)
      JT = JTRIM (OUTLIN)
      CALL ZTXIO ('WRIT', LUN, FIND, OUTLIN(:JT), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'WRITING HEADER LINE'
         GO TO 990
         END IF
      WRITE (OUTLIN,2010)
      JT = JTRIM (OUTLIN)
      CALL ZTXIO ('WRIT', LUN, FIND, OUTLIN(:JT), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'WRITING HEADER LINE'
         GO TO 990
         END IF
C                                       compute
      DO 100 I = 85,-85,-10
         DO 90 J = -175,180,10
            GLONG = J * DG2RAD
            GLAT = I * DG2RAD
            CALL MAGDIP (GLAT, GLONG, R0, B)
            IB(1,1) = IROUND (B(1)*1.E5)
            IB(2,1) = IROUND (B(2)*1.E5)
            IB(3,1) = IROUND (B(3)*1.E5)
            F = SQRT (B(1)*B(1) + B(2)*B(2) + B(3)*B(3))
            IB(4,1) = IROUND (F*1.E5)
            DATE = 2023.0D0
            ALT = 292.0D0
            CY = 90.0 - I
            X = J
            CALL MGRF13 (0, DATE, 1, ALT, CY, X, BX, BY, BZ, BF)
            IB(1,2) = DROUND (-BZ)
            IB(2,2) = DROUND (BY)
            IB(3,2) = DROUND (BX)
            IB(4,2) = DROUND (BF)
            WRITE (OUTLIN,2020) I, J, IB
            CALL ZTXIO ('WRIT', LUN, FIND, OUTLIN(:JT), IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'WRITING TEXT LINE'
               GO TO 990
               END IF
 90         CONTINUE
 100     CONTINUE
C
      CALL ZTXCLS (LUN, FIND, IRET)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('MFIMGP ERROR',I4,' ON ',A)
 2000 FORMAT (36X,'MAGDIP',36x,'IGRVv13')
 2010 FORMAT ('  Lat      Long',8X,'BX',8X,'BY',8X,'BZ',8X,' B',3X,
     *   8X,'BX',8X,'BY',8X,'BZ',8X,' B')
 2020 FORMAT (I5,' , ',I7,' , ',4(I7,' , '),3X,3(I7,' , '),I7)
      END
      SUBROUTINE MFIMGJ (IRET)
C-----------------------------------------------------------------------
C   reads an IONEX file to make image
C   Output:
C      IRET   i   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'MFIMG.INC'
      INTEGER   LUN, FIND, DATE(3), MDATA(73,71), I, I1, I2, I3, IB,
     *   IPOS(7), LUNO, INDO, NXO, NYO, BOTEMP, BOO, OBIND, WINO(4),
     *   NHOURS
      CHARACTER DLINE*80, CDATE*8, IFILE*48
      LOGICAL   T, F, BLNKD
      REAL      OUTMAX, OUTMIN
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUNO, LUN /16,3/
      DATA IPOS /7*1/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Open image file for write
      CALL ZPHFIL ('MA', DISKO, NEWCNO, 1, IFILE, IRET)
      CALL ZOPEN (LUNO, INDO, DISKO, IFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1020) IRET
         GO TO 990
         END IF
C                                       Setup for I/O
      NXO = CATBLK(KINAX)
      NYO = CATBLK(KINAX+1)
      WINO(1) = 1
      WINO(2) = 1
      WINO(3) = NXO
      WINO(4) = NYO
      OUTMAX = -1.0E20
      OUTMIN = 1.0E20
      BLNKD = F
C                                       open input file
      CALL ZTXOPN ('READ', LUN, FIND, INFILE, .FALSE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING IONEX FILE'
         GO TO 990
         END IF
C                                       read to first data
 10   CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ IONEX HEADER'
         GO TO 990
         END IF
      IF (DLINE(61:77).EQ.'# OF MAPS IN FILE') THEN
         READ (DLINE,1010) NHOURS
         IF (NHOURS.NE.CATBLK(KINAX+2)) THEN
            MSGTXT = 'SIZE OF IMAGE DOES NOT MATCH SIZE OF DATA'
            CALL MSGWRT (7)
            END IF
         END IF
      IF (DLINE(61:80).NE.'END OF HEADER') GO TO 10
C                                       done with header, start image
      DO 100 I3 = 1,CATBLK(KINAX+2)
         CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ IONEX DATA HEADER'
            GO TO 990
            END IF
         CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ IONEX DATA HEADER'
            GO TO 990
            END IF
         IF (I3.EQ.1) THEN
            READ (DLINE,1010) DATE
            WRITE (CDATE,1011) DATE
            CALL CHR2H (8, CDATE, 1, CATH(KHDOB))
            END IF
         CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ IONEX DATA HEADER'
            GO TO 990
            END IF
C                                       read data values
         DO 30 I2 = 71,1,-1
            DO 20 I1 = 1,73,16
               CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
               IF (IRET.NE.0) THEN
                  WRITE (MSGTXT,1000) IRET, 'READ IONEX DATA LINE'
                  GO TO 990
                  END IF
               IB = MIN (I1+15, 73)
               READ (DLINE,1020,ERR=800) (MDATA(I,I2), I = I1,IB)
 20            CONTINUE
C                                       skip next header
            CALL ZTXIO ('READ', LUN, FIND, DLINE, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ IONEX DATA TRAILER'
               GO TO 990
               END IF
 30         CONTINUE
         IPOS(3) = I3
C                                       Init output file.
         CALL COMOFF (CATBLK(KIDIM), CATBLK(KINAX), IPOS(3), BOTEMP,
     *      IRET)
         BOO = BOTEMP + 1
         CALL MINIT ('WRIT', LUNO, INDO, NXO, NYO, WINO, BUFFER, JBUFSZ,
     *      BOO, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT WRITE TO OUTPUT'
            GO TO 990
            END IF
         DO 50 I2 = 1,NYO
            IPOS(2) = I2
C                                       Write.
            CALL MDISK ('WRIT', LUNO, INDO, BUFFER, OBIND, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'WRITING OUTPUT IMAGE'
               GO TO 990
               END IF
C                                       Call MAKMAP
            IF (OPCODE.EQ.' ') THEN
               DO 40 I1 = 1,NXO
                  BUFFER(OBIND+I1-1) = MDATA(I1,I2) / 10.0
                  OUTMAX = MAX (OUTMAX, BUFFER(OBIND+I1-1))
                  OUTMIN = MIN (OUTMIN, BUFFER(OBIND+I1-1))
 40               CONTINUE
            ELSE
               CALL TECAIT (IPOS, NXO, MDATA, BUFFER(OBIND), OUTMIN,
     *            OUTMAX, BLNKD)
               END IF
 50         CONTINUE
C                                       Flush buffer.
         CALL MDISK ('FINI', LUNO, INDO, BUFFER, OBIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINISHING A PLANE'
            GO TO 990
            END IF
 100     CONTINUE
C                                       Mark blanking in CATBLK.
      CATR(KRBLK) = 0.0
      IF (BLNKD) CATR(KRBLK) = FBLANK
C                                       Update CATBLK.
      CATR(KRDMX) = OUTMAX
      CATR(KRDMN) = OUTMIN
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, 'REST', SCRTCH, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'UPDATING IMAGE CATALOG'
         GO TO 990
         END IF
C                                       Close files
      CALL ZCLOSE (LUNO, INDO, IRET)
      CALL ZTXCLS (LUN, FIND, IRET)
      IRET = 0
      GO TO 999
 800  MSGTXT = 'READ ERROR'
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('MFIMGJ: ERROR',I4,' ON ',A)
 1010 FORMAT (3I6)
 1011 FORMAT (I4.4,2I2.2)
 1020 FORMAT (16I5)
      END
      SUBROUTINE TECAIT (IPOS, NXO, MDATA, BUFFER, OUTMIN, OUTMAX,
     *   BLNKD)
C-----------------------------------------------------------------------
C   Does interesting geometries for TEC
C   Inputs
C      IPOS     I(7)   Pixel coordinate
C      NXO      I      Number X pixels
C      MDATA    I(*,*) Data
C   Outputs
C      BUFFER   R(*)   Image line
C   In/Out:
C      OUTMIN   R      image min
C      OUTMAX   R      image max
C      BLNKD    L      Blanked?
C-----------------------------------------------------------------------
      INTEGER   IPOS(7), NXO, MDATA(73,*)
      REAL      BUFFER(*), OUTMIN, OUTMAX
      LOGICAL   BLNKD
C
      INTEGER   DEPTH(5), II, JJ, IROUND, I, IERR
      DOUBLE PRECISION X, Y, Z
      REAL      XLAT, XLON, PIXX, PIXY
      LOGICAL   FIRST
      SAVE FIRST
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA FIRST /.TRUE./
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      LOCNUM = 1
      IF (FIRST) CALL SETLOC (DEPTH, .TRUE.)
      FIRST = .FALSE.
      PIXY = IPOS(2)
      DO 20 I = 1,NXO
         PIXX = I
         if ((i.eq.37) .and. (ipos(2).eq.36)) then
            msgtxt = 'we are here'
            end if
         CALL XYVAL (PIXX, PIXY, X, Y, Z, IERR)
         IF (IERR.NE.0) THEN
            BUFFER(I) = FBLANK
            BLNKD = .TRUE.
         ELSE
            XLON = 37. + X / (-5.0)
            XLAT = 36. + Y / 2.5
            II = IROUND (XLON)
            JJ = IROUND (XLAT)
            BUFFER(I) = MDATA(II,JJ) / 10.0
            OUTMIN = MIN (OUTMIN, BUFFER(I))
            OUTMAX = MAX (OUTMAX, BUFFER(I))
            END IF
 20      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE MFIMGD (IRET)
C-----------------------------------------------------------------------
C   MFIMGD accepts an image one row at a time from the user supplied
C   routine.
C   Output:
C      IRET   I  Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INTEGER   LUNO, BOTEMP, NXO, NYO, WINO(4), BOO, LIM2, LIM3, LIM4,
     *   LIM5, LIM6, LIM7, I1, I2, I3, I4, I5, I6, I7, IPOS(7), LIMO,
     *   LIMIT, OBIND, LUN1, LUN2, INDO, LIM1
      REAL      OUTMAX, OUTMIN
      CHARACTER IFILE*48, REST*4
      LOGICAL   T, F, BLNKD
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUNO, LUN1, LUN2 /16,17,18/
      DATA REST /'REST'/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Open image file for write
      CALL ZPHFIL ('MA', DISKO, NEWCNO, 1, IFILE, IRET)
      CALL ZOPEN (LUNO, INDO, DISKO, IFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1020) IRET
         GO TO 990
         END IF
C                                       Setup for I/O
      NXO = CATBLK(KINAX)
      NYO = CATBLK(KINAX+1)
      WINO(1) = 1
      WINO(2) = 1
      WINO(3) = NXO
      WINO(4) = NYO
      OUTMAX = -1.0E20
      OUTMIN = 1.0E20
      BLNKD = F
C                                       Setup for looping
      LIM1 = MAX (1, CATBLK(KINAX))
      LIM2 = MAX (1, CATBLK(KINAX+1))
      LIM3 = MAX (1, CATBLK(KINAX+2))
      LIM4 = MAX (1, CATBLK(KINAX+3))
      LIM5 = MAX (1, CATBLK(KINAX+4))
      LIM6 = MAX (1, CATBLK(KINAX+5))
      LIM7 = MAX (1, CATBLK(KINAX+6))
      IPOS(1) = 1
      LIMO = CATBLK(KINAX) - 1
C                                       Loop
      DO 700 I7 = 1,LIM7
         IPOS(7) = I7
         DO 600 I6 = 1,LIM6
            IPOS(6) = I6
            DO 500 I5 = 1,LIM5
               IPOS(5) = I5
               DO 400 I4 = 1,LIM4
                  IPOS(4) = I4
                  DO 300 I3 = 1,LIM3
      IPOS(3) = I3
C                                       Init output file.
      CALL COMOFF (CATBLK(KIDIM), CATBLK(KINAX), IPOS(3), BOTEMP, IRET)
      BOO = BOTEMP + 1
      CALL MINIT ('WRIT', LUNO, INDO, NXO, NYO, WINO, BUFFER, JBUFSZ,
     *   BOO, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1100) 'WRIT', IRET
         GO TO 990
         END IF
      DO 250 I2 = 1,LIM2
         IPOS(2) = I2
C                                       Write.
         CALL MDISK ('WRIT', LUNO, INDO, BUFFER, OBIND, IRET)
         OBIND = OBIND - 1
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1120) 'WRIT', IRET
            GO TO 990
            END IF
C                                       Call MAKMAP
         OBIND = OBIND + 1
         IF (OPCODE.NE.' ') THEN
            CALL MAKAIT (IPOS, BUFFER(OBIND), IRET)
         ELSE
            CALL MAKMAP (IPOS, BUFFER(OBIND), IRET)
            END IF
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1180) IRET
            GO TO 990
            END IF
C                                       Check max, min, blanking.
         LIMIT = OBIND + LIMO
         DO 200 I1 = OBIND,LIMIT
            BLNKD = BLNKD .OR. (BUFFER(I1).EQ.FBLANK)
            IF (BUFFER(I1).EQ.FBLANK) GO TO 200
               OUTMAX = MAX (OUTMAX, BUFFER(I1))
               OUTMIN = MIN (OUTMIN, BUFFER(I1))
 200           CONTINUE
 250     CONTINUE
C                                       Dump plane to output.
C                                       Flush buffer.
      CALL MDISK ('FINI', LUNO, INDO, BUFFER, OBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1120) 'FINI', IRET
         GO TO 990
         END IF
 300  CONTINUE
 400              CONTINUE
 500           CONTINUE
 600        CONTINUE
 700     CONTINUE
C                                       Mark blanking in CATBLK.
      CATR(KRBLK) = 0.0
      IF (BLNKD) CATR(KRBLK) = FBLANK
C                                       Update CATBLK.
      CATR(KRDMX) = OUTMAX
      CATR(KRDMN) = OUTMIN
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, REST, SCRTCH, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1260) IRET
         GO TO 990
         END IF
C                                       Final call to MAKMAP
      IPOS(1) = -1
      CALL MAKMAP (IPOS, BUFFER, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1180) IRET
         GO TO 990
         END IF
C                                       Close files
      CALL ZCLOSE (LUNO, INDO, IRET)
      IRET = 0
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1020 FORMAT ('MFIMGD: ERROR',I3,' OPENING SCRATCH FILE')
 1100 FORMAT ('MFIMGD: INIT-FOR-',A4,' ERROR',I3)
 1120 FORMAT ('MFIMGD: ',A4,' ERROR',I3)
 1180 FORMAT ('MFIMGD: MAKMAP ERROR',I3)
 1260 FORMAT ('MFIMGD: CATIO ERROR',I3,' UPDATING CATBLK')
      END
      SUBROUTINE MFIMGH
C-----------------------------------------------------------------------
C   MFIMGH copies and updates history file.
C-----------------------------------------------------------------------
      CHARACTER ATIME*8, ADATE*12, HILINE*72, REST*4
      INTEGER   LUN, IERR, TIME(3), DATE(3), J, JTRIM
      LOGICAL   T, F
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DFIL.INC'
      DATA LUN /27/
      DATA REST /'REST'/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
      IF (OUTPRT.NE.' ') GO TO 999
C                                       Write History.
      CALL HIINIT (3)
C                                       Create/open hist. file.
      CALL HICREA (LUN, DISKO, NEWCNO, CATBLK, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 999
         END IF
C                                       Get current date/time.
      CALL ZDATE (DATE)
      CALL ZTIME (TIME)
      CALL TIMDAT (TIME, DATE, ATIME, ADATE)
C                                       Write first record.
      WRITE (HILINE,1010) TSKNAM, NLUSER, ADATE, ATIME
      CALL HIADD (LUN, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 200
C                                       New history
      CALL HENCOO (TSKNAM, NAMOUT, CLAOUT, SEQOUT, DISKO, LUN,
     *   SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 200
C                                       infile
      IF (INFILE.NE.' ') THEN
         J = JTRIM (INFILE)
         WRITE (HILINE,2010) TSKNAM, INFILE(:J)
         CALL HIADD (LUN, HILINE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 200
C                                       IMSIZE
      ELSE
         WRITE (HILINE,2001) TSKNAM, XMSIZE
         CALL HIADD (LUN, HILINE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 200
C                                       CELLSIZE
         WRITE (HILINE,2002) TSKNAM, CELLS
         CALL HIADD (LUN, HILINE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 200
C                                       OPCODE
         WRITE (HILINE,2003) TSKNAM, OPCODE
         CALL HIADD (LUN, HILINE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 200
C                                       OPTYPE
         WRITE (HILINE,2004) TSKNAM, OPTYPE
         CALL HIADD (LUN, HILINE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 200
         END IF
C                                       AIPS release
      WRITE (HILINE,2005) TSKNAM, RLSNAM
      CALL HIADD (LUN, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 200
C                                       Close HI file
 200  CALL HICLOS (LUN, T, SCRTCH, IERR)
C                                        Update CATBLK.
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, REST, SCRTCH, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('MFIMGH: ERROR',I3,' COPY/OPEN HISTORY FILE')
 1010 FORMAT (A6,'/ Image created by user',I5,' at ',A12,2X,A8)
 2001 FORMAT (A6,'IMSIZE = ', 2F8.0)
 2002 FORMAT (A6,'CELLSIZE = ',2F10.5)
 2003 FORMAT (A6,'OPCODE = ''',A,'''')
 2004 FORMAT (A6,'OPTYPE = ''',A,'''')
 2005 FORMAT (A6,'RELEASE = ''',A7,' ''')
 2010 FORMAT (A6,'INFILE = ''',A,'''  / TEC file used')
      END
      SUBROUTINE NEWHED (IRET)
C-----------------------------------------------------------------------
C    Input:
C     CATBLK    I(256)  Output catalog header, also CATR, CATD
C                       The OUTNAME, OUTCLASS, OUTSEQ are entered
C                       elsewhere.
C    Output:
C     CATBLK    I(256)  Modified output catalog header.
C     IRET      I       Return error code, 0=>OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      CHARACTER BLANK*8, CODES(10)*4, UNITS(10)*8, ATYPES(2,3)*8,
     *   A3TYPE*8
      INTEGER   I, NAXIS, IROUND, NCODE, INDEX
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA BLANK /' '/
C                                       User definable values
C                                       # and value of OPCODEs
      DATA NCODE /3/
      DATA CODES /' ', 'AIT', 'MER', 7*' '/
C                                       Output units for each OPCODE.
      DATA UNITS /3*'Gauss',7*' '/
C                                       Number of axes and types.
C                                       (Set for two axes = Ra, Dec.)
      DATA NAXIS  /3/
      DATA ATYPES /'RA', 'DEC', 'RA---AIT', 'DEC--AIT', 'RA---MER',
     *   'DEC--MER'/
      DATA A3TYPE /'XYZF'/
C-----------------------------------------------------------------------
C                                       Set default OPCODE
      ICODE = 1
      IF (NCODE.GT.0) THEN
         DO 10 I = 1,NCODE
            ICODE = I
            IF (OPCODE.EQ.CODES(I)) GO TO 20
 10         CONTINUE
C                                       Default OPCODE is first.
         OPCODE = CODES(1)
         ICODE = 1
         END IF
C                                       Set output units mag field
 20   IF (INFILE.EQ.' ') THEN
         CALL CHR2H (8, UNITS(ICODE), 1, CATH(KHBUN))
C                                       Fill axis arrays.
         DO 30 I = 1,KICTPN
C                                       Fill axis type from ATYPES
            INDEX = KHCTP + (I-1) * 2
            IF (I.LE.2) CALL CHR2H (8, ATYPES(I,ICODE), 1, CATH(INDEX))
            IF (I.EQ.3) CALL CHR2H (8, A3TYPE, 1, CATH(INDEX))
 30         CONTINUE
C                                       Fill in values.
         CATBLK(KINAX) = MAX (IROUND (XMSIZE(1)), 1)
         CATBLK(KINAX+1) = MAX (IROUND (XMSIZE(2)), 1)
         CATBLK(KINAX+2) = 4
         CATR(KRCRP) = CATBLK(KINAX) / 2
         CATR(KRCRP+1) = CATBLK(KINAX+1)/2 + 1
         CATR(KRCRP+2) = 1.0
         CATD(KDCRV+2) = 1.0D0
C                                       Assume CELLSIZE in sec.
C                                       NOTE: Ra decreases with
C                                       grid number.
         CATR(KRCIC) = - CELLS(1) / 3600.
         CATR(KRCIC+1) = CELLS(2) / 3600.
         CATR(KRCIC+2) = 1.0
C                                       TEC image
      ELSE
         CALL CHR2H (8, 'TEC     ', 1, CATH(KHBUN))
C                                       Fill axis arrays.
         DO 40 I = 1,KICTPN
C                                       Fill axis type from ATYPES
            INDEX = KHCTP + (I-1) * 2
            IF (I.LE.2) CALL CHR2H (8, ATYPES(I,ICODE), 1, CATH(INDEX))
            IF (I.EQ.3) CALL CHR2H (8, 'TIME    ', 1, CATH(INDEX))
 40         CONTINUE
C                                       Fill in values.
         CATBLK(KINAX) = 73
         CATBLK(KINAX+1) = 71
         CATBLK(KINAX+2) = 13
         IF (XNPTS.GT.13.5) CATBLK(KINAX+2) = 25
         IF (XNPTS.GT.25.5) CATBLK(KINAX+2) = 49
         IF (XNPTS.GT.49.5) CATBLK(KINAX+2) = 97
         CATR(KRCRP) = CATBLK(KINAX) / 2 + 1
         CATR(KRCRP+1) = CATBLK(KINAX+1)/2 + 1
         CATR(KRCRP+2) = 1.0
         CATD(KDCRV+2) = 0.0D0
C                                       Assume CELLSIZE in sec.
C                                       NOTE: Ra decreases with
C                                       grid number.
         CATR(KRCIC) = -5.0
         CATR(KRCIC+1) = 2.5
         IF (OPCODE.EQ.'AIT') CATR(KRCIC+1) = 5.
         CATR(KRCIC+2) = 1.0 / (CATBLK(KINAX+2) - 1.0)
         END IF
C                                       Fill other character strings.
C                                       Object.
      CALL CHR2H (8, 'DummySrc', 1, CATH(KHOBJ))
C                                       Set number of axes.
      CATBLK(KIDIM) = NAXIS
C                                       User ID
      CATBLK(KIIMU) = NLUSER
C                                       Miscellaneous items.
C                                       Put other checks here.
C                                       Finished.
      IRET = 0
      GO TO 999
CC
 999  RETURN
      END
      SUBROUTINE MAKAIT (IPOS, RESULT, IRET)
C-----------------------------------------------------------------------
C  Inputs:
C     IPOS   I(7)    BLC (input image) of first value in DATA
C  Values from commons:
C  Output:
C     RESULT   R(*)  Output row.
C     IRET     I     Return code   0 => OK
C                               >0 => error, terminate.
C  Output in COMMON:
C-----------------------------------------------------------------------
      INTEGER   IPOS(7), IRET
      REAL      RESULT(*)
C
      INTEGER   NX, I, IERR, DEPTH(5)
      DOUBLE PRECISION X, Y, Z, DATE, ALT, F, BX, BY, BZ, CY
      REAL      GLAT, GLONG, RADIUS, B(3), R0, PIXX, PIXY
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:PSTD.INC'
      SAVE NX
      DATA R0 /6378000.0/
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      IRET = 0
C                                       Check if last call
      IF (IPOS(1).LT.0) GO TO 900
C                                       Check if first call on plane.
      IF (IPOS(2).GT.1) GO TO 50
C                                       First call on plane.
C                                       Set length of a row.
      LOCNUM = 1
      NX = CATBLK(KINAX)
      CALL SETLOC (DEPTH, .TRUE.)
C                                       Subsequent calls.
 50   CONTINUE
         PIXY = IPOS(2)
         DO 100 I = 1,NX
            PIXX = I
            CALL XYVAL (PIXX, PIXY, X, Y, Z, IERR)
            IF (IERR.NE.0) THEN
               RESULT(I) = FBLANK
            ELSE IF ((ABS(Y).GT.90.0D0) .OR. (ABS(X).GT.180.0D0)) THEN
               RESULT(I) = FBLANK
            ELSE IF (OPTYPE.NE.'IGRF') THEN
               GLONG = -X * DG2RAD
               GLAT  = Y * DG2RAD
               RADIUS = R0 + 450.*1000.
               CALL MAGDIP (GLAT, GLONG, RADIUS, B)
               IF (IPOS(3).LE.3) THEN
                  RESULT(I) = B(IPOS(3))
               ELSE
                  RESULT(I) = SQRT (B(1)*B(1) + B(2)*B(2) + B(3)*B(3))
                  END IF
            ELSE
               DATE = 2023.0D0
               ALT = 450.0D0
               CY = 90.0 - Y
               CALL MGRF13 (0, DATE, 1, ALT, CY, -X, BX, BY, BZ, F)
               IF (IPOS(3).EQ.1) RESULT(I) = -BZ / 1.D5
               IF (IPOS(3).EQ.2) RESULT(I) = BY / 1.D5
               IF (IPOS(3).EQ.3) RESULT(I) = BX / 1.D5
               IF (IPOS(3).EQ.4) RESULT(I) = F / 1.D5
               END IF
 100        CONTINUE
      GO TO 999
C                                       Last call - do history etc.
 900  CONTINUE
C
 999  RETURN
      END
      SUBROUTINE MAKMAP (IPOS, RESULT, IRET)
C-----------------------------------------------------------------------
C  Inputs:
C   IPOS   I(7)    BLC (input image) of first value in DATA
C  Values from commons:
C  Output:
C   RESULT   R(*)  Output row.
C   IRET     I     Return code   0 => OK
C                               >0 => error, terminate.
C  Output in COMMON:
C-----------------------------------------------------------------------
      INTEGER   IPOS(7), IRET
      REAL      RESULT(*)
C
      INTEGER   NX, I
      DOUBLE PRECISION X, Y, DATE, ALT, F, BX, BY, BZ, CY
      REAL      GLAT, GLONG, RADIUS, B(3), R0
      INCLUDE 'MFIMG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:PSTD.INC'
      SAVE NX
      DATA R0 /6378000.0/
C-----------------------------------------------------------------------
      IRET = 0
C                                       Check if last call
      IF (IPOS(1).LT.0) GO TO 900
C                                       Check if first call on plane.
      IF (IPOS(2).GT.1) GO TO 50
C                                       First call on plane.
C                                       Set length of a row.
      NX = CATBLK(KINAX)
C                                       Subsequent calls.
 50   CONTINUE
         Y = (IPOS(2) - CATR(KRCRP+1)) * CATR(KRCIC+1) + CATD(KDCRV+1)
         DO 100 I = 1,NX
            X = -(I - CATR(KRCRP)) * CATR(KRCIC) - CATD(KDCRV)
            IF ((ABS(Y).GT.90.0D0) .OR. (ABS(X).GT.180.0D0)) THEN
               RESULT(I) = FBLANK
            ELSE IF (OPTYPE.NE.'IGRF') THEN
               GLONG = X * DG2RAD
               GLAT  = Y * DG2RAD
               RADIUS = R0 + 450.*1000.
               CALL MAGDIP (GLAT, GLONG, RADIUS, B)
               IF (IPOS(3).LE.3) THEN
                  RESULT(I) = B(IPOS(3))
               ELSE
                  RESULT(I) = SQRT (B(1)*B(1) + B(2)*B(2) + B(3)*B(3))
                  END IF
            ELSE
               DATE = 2023.0D0
               ALT = 450.0D0
               CY = 90.0 - Y
               CALL MGRF13 (0, DATE, 1, ALT, CY, X, BX, BY, BZ, F)
               IF (IPOS(3).EQ.1) RESULT(I) = -BZ / 1.D5
               IF (IPOS(3).EQ.2) RESULT(I) = BY / 1.D5
               IF (IPOS(3).EQ.3) RESULT(I) = BX / 1.D5
               IF (IPOS(3).EQ.4) RESULT(I) = F / 1.D5
               END IF
 100        CONTINUE
      GO TO 999
C                                       Last call - do history etc.
 900  CONTINUE
C
 999  RETURN
      END
      SUBROUTINE MGRF13 (ISV, DATE, ITYPE, ALT, COLAT, ELONG, X, Y, Z,
     *   F)
C-----------------------------------------------------------------------
C   This subroutine was part of the file igrf13.f and was downloaded
C   from https://www.ngdc.noaa.gov/IAGA/vmod/igrf.html
C   It has been changed to AIPS coding habits.
C-----------------------------------------------------------------------
C   This is a synthesis routine for the 13th generation IGRF as agreed
C   in December 2019 by IAGA Working Group V-MOD. It is valid 1900.0 to
C   2025.0 inclusive. Values for dates from 1945.0 to 2015.0 inclusive
C   are definitive, otherwise they are non-definitive.
C   Input
C      isv   = 0 if main-field values are required
C      isv   = 1 if secular variation values are required
C      date  = year A.D. Must be greater than or equal to 1900.0 and
C              less than or equal to 2030.0. Warning message is given
C              for dates greater than 2025.0. Must be double precision.
C      itype = 1 if geodetic (spheroid)
C      itype = 2 if geocentric (sphere)
C      alt   = height in km above sea level if itype = 1
C            = distance from centre of Earth in km if itype = 2 (>3485 km)
C      colat = colatitude (0-180)
C      elong = east-longitude (0-360)
C      alt, colat and elong must be double precision.
C   Output
C      x     = north component (nT) if isv = 0, nT/year if isv = 1
C      y     = east component (nT) if isv = 0, nT/year if isv = 1
C      z     = vertical component (nT) if isv = 0, nT/year if isv = 1
C      f     = total intensity (nT) if isv = 0, rubbish if isv = 1
c
C   To get the other geomagnetic elements (D, I, H and secular
C   variations dD, dH, dI and dF) use routines ptoc and ptocsv.
c
C   Adapted from 8th generation version to include new maximum degree
C   for main-field models for 2000.0 and onwards and use WGS84 spheroid
C   instead of International Astronomical Union 1966 spheroid as
C   recommended by IAGA in July 2003. Reference radius remains as
C   6371.2 km - it is NOT the mean radius (= 6371.0 km) but 6371.2 km is
C   what is used in determining the coefficients.
C   Adaptation by Susan Macmillan, August 2003 (for 9th generation),
C   December 2004, December 2009 & December 2014;
C   by William Brown, December 2019, February 2020.
c
C   Coefficients at 1995.0 incorrectly rounded (rounded up instead of
C   to even) included as these are the coefficients published in Excel
C   spreadsheet July 2005.
C-----------------------------------------------------------------------
C      implicit double precision (a-h,o-z)
      INTEGER   ISV, ITYPE
      DOUBLE PRECISION DATE, ALT, COLAT, ELONG, X, Y, Z, F
C
      INTEGER   I, J, K, KMX, L, LL, LM, M, N, NC, NMX
C
      DOUBLE PRECISION GH(3645), G0(120), G1(120), G2(120), G3(120),
     1   G4(120), G5(120), G6(120), G7(120), G8(120), G9(120), GA(120),
     2   GB(120), GC(120), GD(120), GE(120), GF(120), GG(120), GI(120),
     3   GJ(120), GK(195), GL(195), GM(195), GP(195), GQ(195), GR(195),
     4   GS(195), P(105), Q(105), CL(13), SL(13)
      EQUIVALENCE (G0,GH(1)), (G1,GH(121)), (G2,GH(241)), (G3,GH(361)),
     1   (G4,GH(481)), (G5,GH(601)), (G6,GH(721)), (G7,GH(841)),
     2   (G8,GH(961)), (G9,GH(1081)), (GA,GH(1201)), (GB,GH(1321)),
     3   (GC,GH(1441)), (GD,GH(1561)), (GE,GH(1681)), (GF,GH(1801)),
     4   (GG,GH(1921)), (GI,GH(2041)), (GJ,GH(2161)), (GK,GH(2281)),
     5   (GL,GH(2476)), (GM,GH(2671)), (GP,GH(2866)), (GQ,GH(3061)),
     6   (GR,GH(3256)), (GS,GH(3451))
      DOUBLE PRECISION A2, B2, CD, CT, FM, FN, GMM, GN, ONE, R, RATIO,
     *   RHO, RR, SD, ST, T, TC, THREE, TWO
C
      INCLUDE 'INCS:DMSG.INC'
C
      DATA G0/ -31543.,-2298., 5922., -677., 2905.,-1061.,  924., 1121., 1900
     1           1022.,-1469., -330., 1256.,    3.,  572.,  523.,  876., 1900
     2            628.,  195.,  660.,  -69., -361., -210.,  134.,  -75., 1900
     3           -184.,  328., -210.,  264.,   53.,    5.,  -33.,  -86., 1900
     4           -124.,  -16.,    3.,   63.,   61.,   -9.,  -11.,   83., 1900
     5           -217.,    2.,  -58.,  -35.,   59.,   36.,  -90.,  -69., 1900
     6             70.,  -55.,  -45.,    0.,  -13.,   34.,  -10.,  -41., 1900
     7             -1.,  -21.,   28.,   18.,  -12.,    6.,  -22.,   11., 1900
     8              8.,    8.,   -4.,  -14.,   -9.,    7.,    1.,  -13., 1900
     9              2.,    5.,   -9.,   16.,    5.,   -5.,    8.,  -18., 1900
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1900
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,   -1., 1900
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1900
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1900
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./ 1900
      DATA G1/ -31464.,-2298., 5909., -728., 2928.,-1086., 1041., 1065., 1905
     1           1037.,-1494., -357., 1239.,   34.,  635.,  480.,  880., 1905
     2            643.,  203.,  653.,  -77., -380., -201.,  146.,  -65., 1905
     3           -192.,  328., -193.,  259.,   56.,   -1.,  -32.,  -93., 1905
     4           -125.,  -26.,   11.,   62.,   60.,   -7.,  -11.,   86., 1905
     5           -221.,    4.,  -57.,  -32.,   57.,   32.,  -92.,  -67., 1905
     6             70.,  -54.,  -46.,    0.,  -14.,   33.,  -11.,  -41., 1905
     7              0.,  -20.,   28.,   18.,  -12.,    6.,  -22.,   11., 1905
     8              8.,    8.,   -4.,  -15.,   -9.,    7.,    1.,  -13., 1905
     9              2.,    5.,   -8.,   16.,    5.,   -5.,    8.,  -18., 1905
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1905
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0., 1905
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1905
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1905
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./ 1905
      DATA G2/ -31354.,-2297., 5898., -769., 2948.,-1128., 1176., 1000., 1910
     1           1058.,-1524., -389., 1223.,   62.,  705.,  425.,  884., 1910
     2            660.,  211.,  644.,  -90., -400., -189.,  160.,  -55., 1910
     3           -201.,  327., -172.,  253.,   57.,   -9.,  -33., -102., 1910
     4           -126.,  -38.,   21.,   62.,   58.,   -5.,  -11.,   89., 1910
     5           -224.,    5.,  -54.,  -29.,   54.,   28.,  -95.,  -65., 1910
     6             71.,  -54.,  -47.,    1.,  -14.,   32.,  -12.,  -40., 1910
     7              1.,  -19.,   28.,   18.,  -13.,    6.,  -22.,   11., 1910
     8              8.,    8.,   -4.,  -15.,   -9.,    6.,    1.,  -13., 1910
     9              2.,    5.,   -8.,   16.,    5.,   -5.,    8.,  -18., 1910
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1910
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0., 1910
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1910
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1910
     e              0.,   -2.,    2.,    4.,    2.,    0.,    0.,   -6./ 1910
      DATA G3/ -31212.,-2306., 5875., -802., 2956.,-1191., 1309.,  917., 1915
     1           1084.,-1559., -421., 1212.,   84.,  778.,  360.,  887., 1915
     2            678.,  218.,  631., -109., -416., -173.,  178.,  -51., 1915
     3           -211.,  327., -148.,  245.,   58.,  -16.,  -34., -111., 1915
     4           -126.,  -51.,   32.,   61.,   57.,   -2.,  -10.,   93., 1915
     5           -228.,    8.,  -51.,  -26.,   49.,   23.,  -98.,  -62., 1915
     6             72.,  -54.,  -48.,    2.,  -14.,   31.,  -12.,  -38., 1915
     7              2.,  -18.,   28.,   19.,  -15.,    6.,  -22.,   11., 1915
     8              8.,    8.,   -4.,  -15.,   -9.,    6.,    2.,  -13., 1915
     9              3.,    5.,   -8.,   16.,    6.,   -5.,    8.,  -18., 1915
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1915
     b             -3.,    1.,   -2.,   -2.,    8.,    2.,   10.,    0., 1915
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1915
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1915
     e              0.,   -2.,    1.,    4.,    2.,    0.,    0.,   -6./ 1915
      DATA G4/ -31060.,-2317., 5845., -839., 2959.,-1259., 1407.,  823., 1920
     1           1111.,-1600., -445., 1205.,  103.,  839.,  293.,  889., 1920
     2            695.,  220.,  616., -134., -424., -153.,  199.,  -57., 1920
     3           -221.,  326., -122.,  236.,   58.,  -23.,  -38., -119., 1920
     4           -125.,  -62.,   43.,   61.,   55.,    0.,  -10.,   96., 1920
     5           -233.,   11.,  -46.,  -22.,   44.,   18., -101.,  -57., 1920
     6             73.,  -54.,  -49.,    2.,  -14.,   29.,  -13.,  -37., 1920
     7              4.,  -16.,   28.,   19.,  -16.,    6.,  -22.,   11., 1920
     8              7.,    8.,   -3.,  -15.,   -9.,    6.,    2.,  -14., 1920
     9              4.,    5.,   -7.,   17.,    6.,   -5.,    8.,  -19., 1920
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1920
     b             -3.,    1.,   -2.,   -2.,    9.,    2.,   10.,    0., 1920
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1920
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1920
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./ 1920
      DATA G5/ -30926.,-2318., 5817., -893., 2969.,-1334., 1471.,  728., 1925
     1           1140.,-1645., -462., 1202.,  119.,  881.,  229.,  891., 1925
     2            711.,  216.,  601., -163., -426., -130.,  217.,  -70., 1925
     3           -230.,  326.,  -96.,  226.,   58.,  -28.,  -44., -125., 1925
     4           -122.,  -69.,   51.,   61.,   54.,    3.,   -9.,   99., 1925
     5           -238.,   14.,  -40.,  -18.,   39.,   13., -103.,  -52., 1925
     6             73.,  -54.,  -50.,    3.,  -14.,   27.,  -14.,  -35., 1925
     7              5.,  -14.,   29.,   19.,  -17.,    6.,  -21.,   11., 1925
     8              7.,    8.,   -3.,  -15.,   -9.,    6.,    2.,  -14., 1925
     9              4.,    5.,   -7.,   17.,    7.,   -5.,    8.,  -19., 1925
     a              8.,   10.,  -20.,    1.,   14.,  -11.,    5.,   12., 1925
     b             -3.,    1.,   -2.,   -2.,    9.,    2.,   10.,    0., 1925
     c             -2.,   -1.,    2.,   -3.,   -4.,    2.,    2.,    1., 1925
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1925
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./ 1925
      DATA G6/ -30805.,-2316., 5808., -951., 2980.,-1424., 1517.,  644., 1930
     1           1172.,-1692., -480., 1205.,  133.,  907.,  166.,  896., 1930
     2            727.,  205.,  584., -195., -422., -109.,  234.,  -90., 1930
     3           -237.,  327.,  -72.,  218.,   60.,  -32.,  -53., -131., 1930
     4           -118.,  -74.,   58.,   60.,   53.,    4.,   -9.,  102., 1930
     5           -242.,   19.,  -32.,  -16.,   32.,    8., -104.,  -46., 1930
     6             74.,  -54.,  -51.,    4.,  -15.,   25.,  -14.,  -34., 1930
     7              6.,  -12.,   29.,   18.,  -18.,    6.,  -20.,   11., 1930
     8              7.,    8.,   -3.,  -15.,   -9.,    5.,    2.,  -14., 1930
     9              5.,    5.,   -6.,   18.,    8.,   -5.,    8.,  -19., 1930
     a              8.,   10.,  -20.,    1.,   14.,  -12.,    5.,   12., 1930
     b             -3.,    1.,   -2.,   -2.,    9.,    3.,   10.,    0., 1930
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1., 1930
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1930
     e              0.,   -2.,    1.,    4.,    3.,    0.,    0.,   -6./ 1930
      DATA G7/ -30715.,-2306., 5812.,-1018., 2984.,-1520., 1550.,  586., 1935
     1           1206.,-1740., -494., 1215.,  146.,  918.,  101.,  903., 1935
     2            744.,  188.,  565., -226., -415.,  -90.,  249., -114., 1935
     3           -241.,  329.,  -51.,  211.,   64.,  -33.,  -64., -136., 1935
     4           -115.,  -76.,   64.,   59.,   53.,    4.,   -8.,  104., 1935
     5           -246.,   25.,  -25.,  -15.,   25.,    4., -106.,  -40., 1935
     6             74.,  -53.,  -52.,    4.,  -17.,   23.,  -14.,  -33., 1935
     7              7.,  -11.,   29.,   18.,  -19.,    6.,  -19.,   11., 1935
     8              7.,    8.,   -3.,  -15.,   -9.,    5.,    1.,  -15., 1935
     9              6.,    5.,   -6.,   18.,    8.,   -5.,    7.,  -19., 1935
     a              8.,   10.,  -20.,    1.,   15.,  -12.,    5.,   11., 1935
     b             -3.,    1.,   -3.,   -2.,    9.,    3.,   11.,    0., 1935
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1., 1935
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1935
     e              0.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./ 1935
      DATA G8/ -30654.,-2292., 5821.,-1106., 2981.,-1614., 1566.,  528., 1940
     1           1240.,-1790., -499., 1232.,  163.,  916.,   43.,  914., 1940
     2            762.,  169.,  550., -252., -405.,  -72.,  265., -141., 1940
     3           -241.,  334.,  -33.,  208.,   71.,  -33.,  -75., -141., 1940
     4           -113.,  -76.,   69.,   57.,   54.,    4.,   -7.,  105., 1940
     5           -249.,   33.,  -18.,  -15.,   18.,    0., -107.,  -33., 1940
     6             74.,  -53.,  -52.,    4.,  -18.,   20.,  -14.,  -31., 1940
     7              7.,   -9.,   29.,   17.,  -20.,    5.,  -19.,   11., 1940
     8              7.,    8.,   -3.,  -14.,  -10.,    5.,    1.,  -15., 1940
     9              6.,    5.,   -5.,   19.,    9.,   -5.,    7.,  -19., 1940
     a              8.,   10.,  -21.,    1.,   15.,  -12.,    5.,   11., 1940
     b             -3.,    1.,   -3.,   -2.,    9.,    3.,   11.,    1., 1940
     c             -2.,   -2.,    2.,   -3.,   -4.,    2.,    2.,    1., 1940
     d             -5.,    2.,   -2.,    6.,    6.,   -4.,    4.,    0., 1940
     e              0.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./ 1940
      DATA G9/ -30594.,-2285., 5810.,-1244., 2990.,-1702., 1578.,  477., 1945
     1           1282.,-1834., -499., 1255.,  186.,  913.,  -11.,  944., 1945
     2            776.,  144.,  544., -276., -421.,  -55.,  304., -178., 1945
     3           -253.,  346.,  -12.,  194.,   95.,  -20.,  -67., -142., 1945
     4           -119.,  -82.,   82.,   59.,   57.,    6.,    6.,  100., 1945
     5           -246.,   16.,  -25.,   -9.,   21.,  -16., -104.,  -39., 1945
     6             70.,  -40.,  -45.,    0.,  -18.,    0.,    2.,  -29., 1945
     7              6.,  -10.,   28.,   15.,  -17.,   29.,  -22.,   13., 1945
     8              7.,   12.,   -8.,  -21.,   -5.,  -12.,    9.,   -7., 1945
     9              7.,    2.,  -10.,   18.,    7.,    3.,    2.,  -11., 1945
     a              5.,  -21.,  -27.,    1.,   17.,  -11.,   29.,    3., 1945
     b             -9.,   16.,    4.,   -3.,    9.,   -4.,    6.,   -3., 1945
     c              1.,   -4.,    8.,   -3.,   11.,    5.,    1.,    1., 1945
     d              2.,  -20.,   -5.,   -1.,   -1.,   -6.,    8.,    6., 1945
     e             -1.,   -4.,   -3.,   -2.,    5.,    0.,   -2.,   -2./ 1945
      DATA GA/ -30554.,-2250., 5815.,-1341., 2998.,-1810., 1576.,  381., 1950
     1           1297.,-1889., -476., 1274.,  206.,  896.,  -46.,  954., 1950
     2            792.,  136.,  528., -278., -408.,  -37.,  303., -210., 1950
     3           -240.,  349.,    3.,  211.,  103.,  -20.,  -87., -147., 1950
     4           -122.,  -76.,   80.,   54.,   57.,   -1.,    4.,   99., 1950
     5           -247.,   33.,  -16.,  -12.,   12.,  -12., -105.,  -30., 1950
     6             65.,  -55.,  -35.,    2.,  -17.,    1.,    0.,  -40., 1950
     7             10.,   -7.,   36.,    5.,  -18.,   19.,  -16.,   22., 1950
     8             15.,    5.,   -4.,  -22.,   -1.,    0.,   11.,  -21., 1950
     9             15.,   -8.,  -13.,   17.,    5.,   -4.,   -1.,  -17., 1950
     a              3.,   -7.,  -24.,   -1.,   19.,  -25.,   12.,   10., 1950
     b              2.,    5.,    2.,   -5.,    8.,   -2.,    8.,    3., 1950
     c            -11.,    8.,   -7.,   -8.,    4.,   13.,   -1.,   -2., 1950
     d             13.,  -10.,   -4.,    2.,    4.,   -3.,   12.,    6., 1950
     e              3.,   -3.,    2.,    6.,   10.,   11.,    3.,    8./ 1950
      DATA GB/ -30500.,-2215., 5820.,-1440., 3003.,-1898., 1581.,  291., 1955
     1           1302.,-1944., -462., 1288.,  216.,  882.,  -83.,  958., 1955
     2            796.,  133.,  510., -274., -397.,  -23.,  290., -230., 1955
     3           -229.,  360.,   15.,  230.,  110.,  -23.,  -98., -152., 1955
     4           -121.,  -69.,   78.,   47.,   57.,   -9.,    3.,   96., 1955
     5           -247.,   48.,   -8.,  -16.,    7.,  -12., -107.,  -24., 1955
     6             65.,  -56.,  -50.,    2.,  -24.,   10.,   -4.,  -32., 1955
     7              8.,  -11.,   28.,    9.,  -20.,   18.,  -18.,   11., 1955
     8              9.,   10.,   -6.,  -15.,  -14.,    5.,    6.,  -23., 1955
     9             10.,    3.,   -7.,   23.,    6.,   -4.,    9.,  -13., 1955
     a              4.,    9.,  -11.,   -4.,   12.,   -5.,    7.,    2., 1955
     b              6.,    4.,   -2.,    1.,   10.,    2.,    7.,    2., 1955
     c             -6.,    5.,    5.,   -3.,   -5.,   -4.,   -1.,    0., 1955
     d              2.,   -8.,   -3.,   -2.,    7.,   -4.,    4.,    1., 1955
     e             -2.,   -3.,    6.,    7.,   -2.,   -1.,    0.,   -3./ 1955
      DATA GC/ -30421.,-2169., 5791.,-1555., 3002.,-1967., 1590.,  206., 1960
     1           1302.,-1992., -414., 1289.,  224.,  878., -130.,  957., 1960
     2            800.,  135.,  504., -278., -394.,    3.,  269., -255., 1960
     3           -222.,  362.,   16.,  242.,  125.,  -26., -117., -156., 1960
     4           -114.,  -63.,   81.,   46.,   58.,  -10.,    1.,   99., 1960
     5           -237.,   60.,   -1.,  -20.,   -2.,  -11., -113.,  -17., 1960
     6             67.,  -56.,  -55.,    5.,  -28.,   15.,   -6.,  -32., 1960
     7              7.,   -7.,   23.,   17.,  -18.,    8.,  -17.,   15., 1960
     8              6.,   11.,   -4.,  -14.,  -11.,    7.,    2.,  -18., 1960
     9             10.,    4.,   -5.,   23.,   10.,    1.,    8.,  -20., 1960
     a              4.,    6.,  -18.,    0.,   12.,   -9.,    2.,    1., 1960
     b              0.,    4.,   -3.,   -1.,    9.,   -2.,    8.,    3., 1960
     c              0.,   -1.,    5.,    1.,   -3.,    4.,    4.,    1., 1960
     d              0.,    0.,   -1.,    2.,    4.,   -5.,    6.,    1., 1960
     e              1.,   -1.,   -1.,    6.,    2.,    0.,    0.,   -7./ 1960
      DATA GD/ -30334.,-2119., 5776.,-1662., 2997.,-2016., 1594.,  114., 1965
     1           1297.,-2038., -404., 1292.,  240.,  856., -165.,  957., 1965
     2            804.,  148.,  479., -269., -390.,   13.,  252., -269., 1965
     3           -219.,  358.,   19.,  254.,  128.,  -31., -126., -157., 1965
     4            -97.,  -62.,   81.,   45.,   61.,  -11.,    8.,  100., 1965
     5           -228.,   68.,    4.,  -32.,    1.,   -8., -111.,   -7., 1965
     6             75.,  -57.,  -61.,    4.,  -27.,   13.,   -2.,  -26., 1965
     7              6.,   -6.,   26.,   13.,  -23.,    1.,  -12.,   13., 1965
     8              5.,    7.,   -4.,  -12.,  -14.,    9.,    0.,  -16., 1965
     9              8.,    4.,   -1.,   24.,   11.,   -3.,    4.,  -17., 1965
     a              8.,   10.,  -22.,    2.,   15.,  -13.,    7.,   10., 1965
     b             -4.,   -1.,   -5.,   -1.,   10.,    5.,   10.,    1., 1965
     c             -4.,   -2.,    1.,   -2.,   -3.,    2.,    2.,    1., 1965
     d             -5.,    2.,   -2.,    6.,    4.,   -4.,    4.,    0., 1965
     e              0.,   -2.,    2.,    3.,    2.,    0.,    0.,   -6./ 1965
      DATA GE/ -30220.,-2068., 5737.,-1781., 3000.,-2047., 1611.,   25., 1970
     1           1287.,-2091., -366., 1278.,  251.,  838., -196.,  952., 1970
     2            800.,  167.,  461., -266., -395.,   26.,  234., -279., 1970
     3           -216.,  359.,   26.,  262.,  139.,  -42., -139., -160., 1970
     4            -91.,  -56.,   83.,   43.,   64.,  -12.,   15.,  100., 1970
     5           -212.,   72.,    2.,  -37.,    3.,   -6., -112.,    1., 1970
     6             72.,  -57.,  -70.,    1.,  -27.,   14.,   -4.,  -22., 1970
     7              8.,   -2.,   23.,   13.,  -23.,   -2.,  -11.,   14., 1970
     8              6.,    7.,   -2.,  -15.,  -13.,    6.,   -3.,  -17., 1970
     9              5.,    6.,    0.,   21.,   11.,   -6.,    3.,  -16., 1970
     a              8.,   10.,  -21.,    2.,   16.,  -12.,    6.,   10., 1970
     b             -4.,   -1.,   -5.,    0.,   10.,    3.,   11.,    1., 1970
     c             -2.,   -1.,    1.,   -3.,   -3.,    1.,    2.,    1., 1970
     d             -5.,    3.,   -1.,    4.,    6.,   -4.,    4.,    0., 1970
     e              1.,   -1.,    0.,    3.,    3.,    1.,   -1.,   -4./ 1970
      DATA GF/ -30100.,-2013., 5675.,-1902., 3010.,-2067., 1632.,  -68., 1975
     1           1276.,-2144., -333., 1260.,  262.,  830., -223.,  946., 1975
     2            791.,  191.,  438., -265., -405.,   39.,  216., -288., 1975
     3           -218.,  356.,   31.,  264.,  148.,  -59., -152., -159., 1975
     4            -83.,  -49.,   88.,   45.,   66.,  -13.,   28.,   99., 1975
     5           -198.,   75.,    1.,  -41.,    6.,   -4., -111.,   11., 1975
     6             71.,  -56.,  -77.,    1.,  -26.,   16.,   -5.,  -14., 1975
     7             10.,    0.,   22.,   12.,  -23.,   -5.,  -12.,   14., 1975
     8              6.,    6.,   -1.,  -16.,  -12.,    4.,   -8.,  -19., 1975
     9              4.,    6.,    0.,   18.,   10.,  -10.,    1.,  -17., 1975
     a              7.,   10.,  -21.,    2.,   16.,  -12.,    7.,   10., 1975
     b             -4.,   -1.,   -5.,   -1.,   10.,    4.,   11.,    1., 1975
     c             -3.,   -2.,    1.,   -3.,   -3.,    1.,    2.,    1., 1975
     d             -5.,    3.,   -2.,    4.,    5.,   -4.,    4.,   -1., 1975
     e              1.,   -1.,    0.,    3.,    3.,    1.,   -1.,   -5./ 1975
      DATA GG/ -29992.,-1956., 5604.,-1997., 3027.,-2129., 1663., -200., 1980
     1           1281.,-2180., -336., 1251.,  271.,  833., -252.,  938., 1980
     2            782.,  212.,  398., -257., -419.,   53.,  199., -297., 1980
     3           -218.,  357.,   46.,  261.,  150.,  -74., -151., -162., 1980
     4            -78.,  -48.,   92.,   48.,   66.,  -15.,   42.,   93., 1980
     5           -192.,   71.,    4.,  -43.,   14.,   -2., -108.,   17., 1980
     6             72.,  -59.,  -82.,    2.,  -27.,   21.,   -5.,  -12., 1980
     7             16.,    1.,   18.,   11.,  -23.,   -2.,  -10.,   18., 1980
     8              6.,    7.,    0.,  -18.,  -11.,    4.,   -7.,  -22., 1980
     9              4.,    9.,    3.,   16.,    6.,  -13.,   -1.,  -15., 1980
     a              5.,   10.,  -21.,    1.,   16.,  -12.,    9.,    9., 1980
     b             -5.,   -3.,   -6.,   -1.,    9.,    7.,   10.,    2., 1980
     c             -6.,   -5.,    2.,   -4.,   -4.,    1.,    2.,    0., 1980
     d             -5.,    3.,   -2.,    6.,    5.,   -4.,    3.,    0., 1980
     e              1.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./ 1980
      DATA GI/ -29873.,-1905., 5500.,-2072., 3044.,-2197., 1687., -306., 1985
     1           1296.,-2208., -310., 1247.,  284.,  829., -297.,  936., 1985
     2            780.,  232.,  361., -249., -424.,   69.,  170., -297., 1985
     3           -214.,  355.,   47.,  253.,  150.,  -93., -154., -164., 1985
     4            -75.,  -46.,   95.,   53.,   65.,  -16.,   51.,   88., 1985
     5           -185.,   69.,    4.,  -48.,   16.,   -1., -102.,   21., 1985
     6             74.,  -62.,  -83.,    3.,  -27.,   24.,   -2.,   -6., 1985
     7             20.,    4.,   17.,   10.,  -23.,    0.,   -7.,   21., 1985
     8              6.,    8.,    0.,  -19.,  -11.,    5.,   -9.,  -23., 1985
     9              4.,   11.,    4.,   14.,    4.,  -15.,   -4.,  -11., 1985
     a              5.,   10.,  -21.,    1.,   15.,  -12.,    9.,    9., 1985
     b             -6.,   -3.,   -6.,   -1.,    9.,    7.,    9.,    1., 1985
     c             -7.,   -5.,    2.,   -4.,   -4.,    1.,    3.,    0., 1985
     d             -5.,    3.,   -2.,    6.,    5.,   -4.,    3.,    0., 1985
     e              1.,   -1.,    2.,    4.,    3.,    0.,    0.,   -6./ 1985
      DATA GJ/ -29775.,-1848., 5406.,-2131., 3059.,-2279., 1686., -373., 1990
     1           1314.,-2239., -284., 1248.,  293.,  802., -352.,  939., 1990
     2            780.,  247.,  325., -240., -423.,   84.,  141., -299., 1990
     3           -214.,  353.,   46.,  245.,  154., -109., -153., -165., 1990
     4            -69.,  -36.,   97.,   61.,   65.,  -16.,   59.,   82., 1990
     5           -178.,   69.,    3.,  -52.,   18.,    1.,  -96.,   24., 1990
     6             77.,  -64.,  -80.,    2.,  -26.,   26.,    0.,   -1., 1990
     7             21.,    5.,   17.,    9.,  -23.,    0.,   -4.,   23., 1990
     8              5.,   10.,   -1.,  -19.,  -10.,    6.,  -12.,  -22., 1990
     9              3.,   12.,    4.,   12.,    2.,  -16.,   -6.,  -10., 1990
     a              4.,    9.,  -20.,    1.,   15.,  -12.,   11.,    9., 1990
     b             -7.,   -4.,   -7.,   -2.,    9.,    7.,    8.,    1., 1990
     c             -7.,   -6.,    2.,   -3.,   -4.,    2.,    2.,    1., 1990
     d             -5.,    3.,   -2.,    6.,    4.,   -4.,    3.,    0., 1990
     e              1.,   -2.,    3.,    3.,    3.,   -1.,    0.,   -6./ 1990
      DATA GK/ -29692.,-1784., 5306.,-2200., 3070.,-2366., 1681., -413., 1995
     1           1335.,-2267., -262., 1249.,  302.,  759., -427.,  940., 1995
     2            780.,  262.,  290., -236., -418.,   97.,  122., -306., 1995
     3           -214.,  352.,   46.,  235.,  165., -118., -143., -166., 1995
     4            -55.,  -17.,  107.,   68.,   67.,  -17.,   68.,   72., 1995
     5           -170.,   67.,   -1.,  -58.,   19.,    1.,  -93.,   36., 1995
     6             77.,  -72.,  -69.,    1.,  -25.,   28.,    4.,    5., 1995
     7             24.,    4.,   17.,    8.,  -24.,   -2.,   -6.,   25., 1995
     8              6.,   11.,   -6.,  -21.,   -9.,    8.,  -14.,  -23., 1995
     9              9.,   15.,    6.,   11.,   -5.,  -16.,   -7.,   -4., 1995
     a              4.,    9.,  -20.,    3.,   15.,  -10.,   12.,    8., 1995
     b             -6.,   -8.,   -8.,   -1.,    8.,   10.,    5.,   -2., 1995
     c             -8.,   -8.,    3.,   -3.,   -6.,    1.,    2.,    0., 1995
     d             -4.,    4.,   -1.,    5.,    4.,   -5.,    2.,   -1., 1995
     e              2.,   -2.,    5.,    1.,    1.,   -2.,    0.,   -7., 1995
     f           75*0./                                                  1995
      DATA GL/ -29619.4,-1728.2, 5186.1,-2267.7, 3068.4,-2481.6, 1670.9, 2000
     1           -458.0, 1339.6,-2288.0, -227.6, 1252.1,  293.4,  714.5, 2000
     2           -491.1,  932.3,  786.8,  272.6,  250.0, -231.9, -403.0, 2000
     3            119.8,  111.3, -303.8, -218.8,  351.4,   43.8,  222.3, 2000
     4            171.9, -130.4, -133.1, -168.6,  -39.3,  -12.9,  106.3, 2000
     5             72.3,   68.2,  -17.4,   74.2,   63.7, -160.9,   65.1, 2000
     6             -5.9,  -61.2,   16.9,    0.7,  -90.4,   43.8,   79.0, 2000
     7            -74.0,  -64.6,    0.0,  -24.2,   33.3,    6.2,    9.1, 2000
     8             24.0,    6.9,   14.8,    7.3,  -25.4,   -1.2,   -5.8, 2000
     9             24.4,    6.6,   11.9,   -9.2,  -21.5,   -7.9,    8.5, 2000
     a            -16.6,  -21.5,    9.1,   15.5,    7.0,    8.9,   -7.9, 2000
     b            -14.9,   -7.0,   -2.1,    5.0,    9.4,  -19.7,    3.0, 2000
     c             13.4,   -8.4,   12.5,    6.3,   -6.2,   -8.9,   -8.4, 2000
     d             -1.5,    8.4,    9.3,    3.8,   -4.3,   -8.2,   -8.2, 2000
     e              4.8,   -2.6,   -6.0,    1.7,    1.7,    0.0,   -3.1, 2000
     f              4.0,   -0.5,    4.9,    3.7,   -5.9,    1.0,   -1.2, 2000
     g              2.0,   -2.9,    4.2,    0.2,    0.3,   -2.2,   -1.1, 2000
     h             -7.4,    2.7,   -1.7,    0.1,   -1.9,    1.3,    1.5, 2000
     i             -0.9,   -0.1,   -2.6,    0.1,    0.9,   -0.7,   -0.7, 2000
     j              0.7,   -2.8,    1.7,   -0.9,    0.1,   -1.2,    1.2, 2000
     k             -1.9,    4.0,   -0.9,   -2.2,   -0.3,   -0.4,    0.2, 2000
     l              0.3,    0.9,    2.5,   -0.2,   -2.6,    0.9,    0.7, 2000
     m             -0.5,    0.3,    0.3,    0.0,   -0.3,    0.0,   -0.4, 2000
     n              0.3,   -0.1,   -0.9,   -0.2,   -0.4,   -0.4,    0.8, 2000
     o             -0.2,   -0.9,   -0.9,    0.3,    0.2,    0.1,    1.8, 2000
     p             -0.4,   -0.4,    1.3,   -1.0,   -0.4,   -0.1,    0.7, 2000
     q              0.7,   -0.4,    0.3,    0.3,    0.6,   -0.1,    0.3, 2000
     r              0.4,   -0.2,    0.0,   -0.5,    0.1,   -0.9/         2000
      DATA GM/-29554.63,-1669.05, 5077.99,-2337.24, 3047.69,-2594.50,    2005
     1          1657.76, -515.43, 1336.30,-2305.83, -198.86, 1246.39,    2005
     2           269.72,  672.51, -524.72,  920.55,  797.96,  282.07,    2005
     3           210.65, -225.23, -379.86,  145.15,  100.00, -305.36,    2005
     4          -227.00,  354.41,   42.72,  208.95,  180.25, -136.54,    2005
     5          -123.45, -168.05,  -19.57,  -13.55,  103.85,   73.60,    2005
     6            69.56,  -20.33,   76.74,   54.75, -151.34,   63.63,    2005
     7           -14.58,  -63.53,   14.58,    0.24,  -86.36,   50.94,    2005
     8            79.88,  -74.46,  -61.14,   -1.65,  -22.57,   38.73,    2005
     9             6.82,   12.30,   25.35,    9.37,   10.93,    5.42,    2005
     a           -26.32,    1.94,   -4.64,   24.80,    7.62,   11.20,    2005
     b           -11.73,  -20.88,   -6.88,    9.83,  -18.11,  -19.71,    2005
     c            10.17,   16.22,    9.36,    7.61,  -11.25,  -12.76,    2005
     d            -4.87,   -0.06,    5.58,    9.76,  -20.11,    3.58,    2005
     e            12.69,   -6.94,   12.67,    5.01,   -6.72,  -10.76,    2005
     f            -8.16,   -1.25,    8.10,    8.76,    2.92,   -6.66,    2005
     g            -7.73,   -9.22,    6.01,   -2.17,   -6.12,    2.19,    2005
     h             1.42,    0.10,   -2.35,    4.46,   -0.15,    4.76,    2005
     i             3.06,   -6.58,    0.29,   -1.01,    2.06,   -3.47,    2005
     j             3.77,   -0.86,   -0.21,   -2.31,   -2.09,   -7.93,    2005
     k             2.95,   -1.60,    0.26,   -1.88,    1.44,    1.44,    2005
     l            -0.77,   -0.31,   -2.27,    0.29,    0.90,   -0.79,    2005
     m            -0.58,    0.53,   -2.69,    1.80,   -1.08,    0.16,    2005
     n            -1.58,    0.96,   -1.90,    3.99,   -1.39,   -2.15,    2005
     o            -0.29,   -0.55,    0.21,    0.23,    0.89,    2.38,    2005
     p            -0.38,   -2.63,    0.96,    0.61,   -0.30,    0.40,    2005
     q             0.46,    0.01,   -0.35,    0.02,   -0.36,    0.28,    2005
     r             0.08,   -0.87,   -0.49,   -0.34,   -0.08,    0.88,    2005
     s            -0.16,   -0.88,   -0.76,    0.30,    0.33,    0.28,    2005
     t             1.72,   -0.43,   -0.54,    1.18,   -1.07,   -0.37,    2005
     u            -0.04,    0.75,    0.63,   -0.26,    0.21,    0.35,    2005
     v             0.53,   -0.05,    0.38,    0.41,   -0.22,   -0.10,    2005
     w            -0.57,   -0.18,   -0.82/                               2005
      DATA GP/-29496.57,-1586.42, 4944.26,-2396.06, 3026.34,-2708.54,    2010
     1          1668.17, -575.73, 1339.85,-2326.54, -160.40, 1232.10,    2010
     2           251.75,  633.73, -537.03,  912.66,  808.97,  286.48,    2010
     3           166.58, -211.03, -356.83,  164.46,   89.40, -309.72,    2010
     4          -230.87,  357.29,   44.58,  200.26,  189.01, -141.05,    2010
     5          -118.06, -163.17,   -0.01,   -8.03,  101.04,   72.78,    2010
     6            68.69,  -20.90,   75.92,   44.18, -141.40,   61.54,    2010
     7           -22.83,  -66.26,   13.10,    3.02,  -78.09,   55.40,    2010
     8            80.44,  -75.00,  -57.80,   -4.55,  -21.20,   45.24,    2010
     9             6.54,   14.00,   24.96,   10.46,    7.03,    1.64,    2010
     a           -27.61,    4.92,   -3.28,   24.41,    8.21,   10.84,    2010
     b           -14.50,  -20.03,   -5.59,   11.83,  -19.34,  -17.41,    2010
     c            11.61,   16.71,   10.85,    6.96,  -14.05,  -10.74,    2010
     d            -3.54,    1.64,    5.50,    9.45,  -20.54,    3.45,    2010
     e            11.51,   -5.27,   12.75,    3.13,   -7.14,  -12.38,    2010
     f            -7.42,   -0.76,    7.97,    8.43,    2.14,   -8.42,    2010
     g            -6.08,  -10.08,    7.01,   -1.94,   -6.24,    2.73,    2010
     h             0.89,   -0.10,   -1.07,    4.71,   -0.16,    4.44,    2010
     i             2.45,   -7.22,   -0.33,   -0.96,    2.13,   -3.95,    2010
     j             3.09,   -1.99,   -1.03,   -1.97,   -2.80,   -8.31,    2010
     k             3.05,   -1.48,    0.13,   -2.03,    1.67,    1.65,    2010
     l            -0.66,   -0.51,   -1.76,    0.54,    0.85,   -0.79,    2010
     m            -0.39,    0.37,   -2.51,    1.79,   -1.27,    0.12,    2010
     n            -2.11,    0.75,   -1.94,    3.75,   -1.86,   -2.12,    2010
     o            -0.21,   -0.87,    0.30,    0.27,    1.04,    2.13,    2010
     p            -0.63,   -2.49,    0.95,    0.49,   -0.11,    0.59,    2010
     q             0.52,    0.00,   -0.39,    0.13,   -0.37,    0.27,    2010
     r             0.21,   -0.86,   -0.77,   -0.23,    0.04,    0.87,    2010
     s            -0.09,   -0.89,   -0.87,    0.31,    0.30,    0.42,    2010
     t             1.66,   -0.45,   -0.59,    1.08,   -1.14,   -0.31,    2010
     u            -0.07,    0.78,    0.54,   -0.18,    0.10,    0.38,    2010
     v             0.49,    0.02,    0.44,    0.42,   -0.25,   -0.26,    2010
     w            -0.53,   -0.26,   -0.79/                               2010
      DATA GQ/-29441.46,-1501.77, 4795.99,-2445.88, 3012.20,-2845.41,    2015
     1          1676.35, -642.17, 1350.33,-2352.26, -115.29, 1225.85,    2015
     2           245.04,  581.69, -538.70,  907.42,  813.68,  283.54,    2015
     3           120.49, -188.43, -334.85,  180.95,   70.38, -329.23,    2015
     4          -232.91,  360.14,   46.98,  192.35,  196.98, -140.94,    2015
     5          -119.14, -157.40,   15.98,    4.30,  100.12,   69.55,    2015
     6            67.57,  -20.61,   72.79,   33.30, -129.85,   58.74,    2015
     7           -28.93,  -66.64,   13.14,    7.35,  -70.85,   62.41,    2015
     8            81.29,  -75.99,  -54.27,   -6.79,  -19.53,   51.82,    2015
     9             5.59,   15.07,   24.45,    9.32,    3.27,   -2.88,    2015
     a           -27.50,    6.61,   -2.32,   23.98,    8.89,   10.04,    2015
     b           -16.78,  -18.26,   -3.16,   13.18,  -20.56,  -14.60,    2015
     c            13.33,   16.16,   11.76,    5.69,  -15.98,   -9.10,    2015
     d            -2.02,    2.26,    5.33,    8.83,  -21.77,    3.02,    2015
     e            10.76,   -3.22,   11.74,    0.67,   -6.74,  -13.20,    2015
     f            -6.88,   -0.10,    7.79,    8.68,    1.04,   -9.06,    2015
     g            -3.89,  -10.54,    8.44,   -2.01,   -6.26,    3.28,    2015
     h             0.17,   -0.40,    0.55,    4.55,   -0.55,    4.40,    2015
     i             1.70,   -7.92,   -0.67,   -0.61,    2.13,   -4.16,    2015
     j             2.33,   -2.85,   -1.80,   -1.12,   -3.59,   -8.72,    2015
     k             3.00,   -1.40,    0.00,   -2.30,    2.11,    2.08,    2015
     l            -0.60,   -0.79,   -1.05,    0.58,    0.76,   -0.70,    2015
     m            -0.20,    0.14,   -2.12,    1.70,   -1.44,   -0.22,    2015
     n            -2.57,    0.44,   -2.01,    3.49,   -2.34,   -2.09,    2015
     o            -0.16,   -1.08,    0.46,    0.37,    1.23,    1.75,    2015
     p            -0.89,   -2.19,    0.85,    0.27,    0.10,    0.72,    2015
     q             0.54,   -0.09,   -0.37,    0.29,   -0.43,    0.23,    2015
     r             0.22,   -0.89,   -0.94,   -0.16,   -0.03,    0.72,    2015
     s            -0.02,   -0.92,   -0.88,    0.42,    0.49,    0.63,    2015
     t             1.56,   -0.42,   -0.50,    0.96,   -1.24,   -0.19,    2015
     u            -0.10,    0.81,    0.42,   -0.13,   -0.04,    0.38,    2015
     v             0.48,    0.08,    0.48,    0.46,   -0.30,   -0.35,    2015
     w            -0.43,   -0.36,   -0.71/                               2015
      DATA GR/ -29404.8, -1450.9,  4652.5, -2499.6,  2982.0, -2991.6,    2020
     1           1677.0,  -734.6,  1363.2, -2381.2,   -82.1,  1236.2,    2020
     2            241.9,   525.7,  -543.4,   903.0,   809.5,   281.9,    2020
     3             86.3,  -158.4,  -309.4,   199.7,    48.0,  -349.7,    2020
     4           -234.3,   363.2,    47.7,   187.8,   208.3,  -140.7,    2020
     5           -121.2,  -151.2,    32.3,    13.5,    98.9,    66.0,    2020
     6             65.5,   -19.1,    72.9,    25.1,  -121.5,    52.8,    2020
     7            -36.2,   -64.5,    13.5,     8.9,   -64.7,    68.1,    2020
     8             80.6,   -76.7,   -51.5,    -8.2,   -16.9,    56.5,    2020
     9              2.2,    15.8,    23.5,     6.4,    -2.2,    -7.2,    2020
     a            -27.2,     9.8,    -1.8,    23.7,     9.7,     8.4,    2020
     b            -17.6,   -15.3,    -0.5,    12.8,   -21.1,   -11.7,    2020
     c             15.3,    14.9,    13.7,     3.6,   -16.5,    -6.9,    2020
     d             -0.3,     2.8,     5.0,     8.4,   -23.4,     2.9,    2020
     e             11.0,    -1.5,     9.8,    -1.1,    -5.1,   -13.2,    2020
     f             -6.3,     1.1,     7.8,     8.8,     0.4,    -9.3,    2020
     g             -1.4,   -11.9,     9.6,    -1.9,    -6.2,     3.4,    2020
     h             -0.1,    -0.2,     1.7,     3.6,    -0.9,     4.8,    2020
     i              0.7,    -8.6,    -0.9,    -0.1,     1.9,    -4.3,    2020
     j              1.4,    -3.4,    -2.4,    -0.1,    -3.8,    -8.8,    2020
     k              3.0,    -1.4,     0.0,    -2.5,     2.5,     2.3,    2020
     l             -0.6,    -0.9,    -0.4,     0.3,     0.6,    -0.7,    2020
     m             -0.2,    -0.1,    -1.7,     1.4,    -1.6,    -0.6,    2020
     n             -3.0,     0.2,    -2.0,     3.1,    -2.6,    -2.0,    2020
     o             -0.1,    -1.2,     0.5,     0.5,     1.3,     1.4,    2020
     p             -1.2,    -1.8,     0.7,     0.1,     0.3,     0.8,    2020
     q              0.5,    -0.2,    -0.3,     0.6,    -0.5,     0.2,    2020
     r              0.1,    -0.9,    -1.1,     0.0,    -0.3,     0.5,    2020
     s              0.1,    -0.9,    -0.9,     0.5,     0.6,     0.7,    2020
     t              1.4,    -0.3,    -0.4,     0.8,    -1.3,     0.0,    2020
     u             -0.1,     0.8,     0.3,     0.0,    -0.1,     0.4,    2020
     v              0.5,     0.1,     0.5,     0.5,    -0.4,    -0.5,    2020
     w             -0.4,    -0.4,    -0.6/                               2020
      DATA GS/      5.7,     7.4,   -25.9,   -11.0,    -7.0,   -30.2,    2022
     1             -2.1,   -22.4,     2.2,    -5.9,     6.0,     3.1,    2022
     2             -1.1,   -12.0,     0.5,    -1.2,    -1.6,    -0.1,    2022
     3             -5.9,     6.5,     5.2,     3.6,    -5.1,    -5.0,    2022
     4             -0.3,     0.5,     0.0,    -0.6,     2.5,     0.2,    2022
     5             -0.6,     1.3,     3.0,     0.9,     0.3,    -0.5,    2022
     6             -0.3,     0.0,     0.4,    -1.6,     1.3,    -1.3,    2022
     7             -1.4,     0.8,     0.0,     0.0,     0.9,     1.0,    2022
     8             -0.1,    -0.2,     0.6,     0.0,     0.6,     0.7,    2022
     9             -0.8,     0.1,    -0.2,    -0.5,    -1.1,    -0.8,    2022
     a              0.1,     0.8,     0.3,     0.0,     0.1,    -0.2,    2022
     b             -0.1,     0.6,     0.4,    -0.2,    -0.1,     0.5,    2022
     c              0.4,    -0.3,     0.3,    -0.4,    -0.1,     0.5,    2022
     d              0.4,     0.0, 115*0.0/                               2022
C-----------------------------------------------------------------------
C
C     Set initial values
C
      X     = 0.0D0
      Y     = 0.0D0
      Z     = 0.0D0
c
C     error return if date out of bounds
c
      IF ((DATE.LT.1900.0) .OR. (DATE.GT.2030.0)) THEN
         F     = 1.0D8
         WRITE (MSGTXT,1010) DATE
         CALL MSGWRT (8)
         GO TO 999
         END IF
C                                       marginal results > 2025
      IF (DATE.GT.2025.0) THEN
         WRITE (MSGTXT,1015)
         CALL MSGWRT (6)
         WRITE (MSGTXT,1016) DATE
         CALL MSGWRT (6)
         END IF
C                                       date >= 2020
      IF (DATE.GE.2020.0) THEN
         T     = DATE - 2020.0
         TC    = 1.0
         IF (ISV.EQ.1) THEN
            t = 1.0
            tc = 0.0
            END IF
C
C   pointer for last coefficient in pen-ultimate set of MF coefficients.
c
         LL    = 3255
         NMX   = 13
         NC    = NMX*(NMX+2)
         KMX   = (NMX+1)*(NMX+2)/2
C                                       date < 2020
      ELSE
         T     = 0.2*(DATE - 1900.0)
         LL    = T
         ONE   = LL
         T     = T - ONE
c
C     SH models before 1995.0 are only to degree 10
c
         IF (DATE.LT.1995.0) then
            NMX   = 10
            NC    = NMX*(NMX+2)
            LL    = NC*LL
            KMX   = (NMX+1)*(NMX+2)/2
         ELSE
            NMX   = 13
            NC    = NMX*(NMX+2)
            LL    = 0.2*(DATE - 1995.0)
C
C     19 is the number of SH models that extend to degree 10
c
            LL    = 120*19 + NC*LL
            KMX   = (NMX+1)*(NMX+2)/2
            END IF
         TC    = 1.0 - T
         IF (ISV.EQ.1) THEN
            TC = -0.2
            T = 0.2
            END IF
         END IF
C
      R     = ALT
      ONE   = COLAT*0.017453292
      CT    = COS(ONE)
      ST    = SIN(ONE)
      ONE   = ELONG*0.017453292
      CL(1) = COS(ONE)
      SL(1) = SIN(ONE)
      CD    = 1.0
      SD    = 0.0
      L     = 1
      M     = 1
      N     = 0
c
C     conversion from geodetic to geocentric coordinates
C     (using the WGS84 spheroid)
c
      IF (ITYPE.NE.2) THEN
         A2    = 40680631.6D0
         B2    = 40408296.0D0
         ONE   = A2 * ST * ST
         TWO   = B2 * CT * CT
         THREE = ONE + TWO
         RHO   = SQRT (THREE)
         R     = SQRT (ALT*(ALT + 2.0*RHO) + (A2*ONE + B2*TWO)/THREE)
         CD    = (ALT + RHO) / R
         SD    = (A2 - B2) / RHO * CT * ST / R
         ONE   = CT
         CT    = CT*CD -  ST*SD
         ST    = ST*CD + ONE*SD
         END IF
c
      RATIO = 6371.2D0 / R
      RR    = RATIO * RATIO
c
C     computation of Schmidt quasi-normal coefficients p and x(=q)
c
      P(1)  = 1.0
      P(3)  = ST
      Q(1)  = 0.0
      Q(3)  =  CT
      DO 10 K = 2,KMX
         IF (N.LT.M) THEN
            M     = 0
            N     = N + 1
            RR    = RR * RATIO
            FN    = N
            GN    = N - 1
            END IF
         FM    = M
         IF (M.NE.N) THEN
            GMM    = M * M
            ONE   = SQRT (FN*FN - GMM)
            TWO   = SQRT (GN*GN - GMM) / ONE
            THREE = (FN + GN) / ONE
            I     = K - N
            J     = I - N + 1
            P(K)  = THREE*CT*P(I) - TWO*P(J)
            Q(K)  = THREE*(CT*Q(I) - ST*P(I)) - TWO*Q(J)
         ELSE IF (K.NE.3) THEN
            ONE   = SQRT (1.0 - 0.5/FM)
            J     = K - N - 1
            P(K)  = ONE * ST * P(J)
            Q(K)  = ONE * (ST*Q(J) + CT*P(J))
            CL(M) = CL(M-1)*CL(1) - SL(M-1)*SL(1)
            SL(M) = SL(M-1)*CL(1) + CL(M-1)*SL(1)
            END IF
c
C     synthesis of x, y and z in geocentric coordinates
c
         LM    = LL + L
         ONE   = (TC*GH(LM) + T*GH(LM+NC)) * RR
         IF (M.EQ.0) THEN
            X     = X + ONE*Q(K)
            Z     = Z - (FN + 1.0)*ONE*P(K)
            L     = L + 1
         ELSE
            TWO   = (TC*GH(LM+1) + T*GH(LM+NC+1))*RR
            THREE = ONE*CL(M) + TWO*SL(M)
            X     = X + THREE*Q(K)
            Z     = Z - (FN + 1.0)*THREE*P(K)
            IF (ST.NE.0.0) THEN
               Y     = Y + (ONE*SL(M) - TWO*CL(M))*FM*P(K)/ST
            ELSE
               Y     = Y + (ONE*SL(M) - TWO*CL(M))*Q(K)*CT
               END IF
            L     = L + 2
            END IF
         M     = M + 1
 10      CONTINUE
c
C     conversion to coordinate system specified by itype
c
      ONE   = X
      X     = X*CD +   Z*SD
      Z     = Z*CD - ONE*SD
      F     = SQRT (X*X + Y*Y + Z*Z)
c
 999  RETURN
C-----------------------------------------------------------------------
 1010 FORMAT ('MGRF13 WILL NOT WORK WITH A DATE OF', F9.3,'.  Date must'
     *   ' be in the range 1900 - 2030')
 1015 FORMAT ('This version of the IGRF (13) is intended for use up',
     *   ' to 2025.0.')
 1016 FORMAT ('values for',F9.3,' will be computed but may be of',
     *   ' reduced accuracy')
      END
