LOCAL INCLUDE 'SYFIX.INC'
C                                       Local include for SYFIX
      INCLUDE 'INCS:ZPBUFSZ.INC'
      HOLLERITH XNAMEI(3), XCLAIN(2)
      REAL      XSIN, XDISIN, XINVER, PRTLEV
      REAL      BUFF1(UVBFSS)
      INTEGER   SEQIN, DISKIN, JBUFSZ, CATOLD(256), OLDCNO, INVERS,
     *   OUTVER, NFIXED, NFAILD
      LOGICAL   TIMDBG
      CHARACTER NAMEIN*12, CLAIN*6
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XINVER, PRTLEV
      COMMON /TPARMS/ CATOLD, SEQIN, DISKIN, OLDCNO, INVERS, OUTVER,
     *   NFIXED, NFAILD, TIMDBG
      COMMON /CHARPM/ NAMEIN, CLAIN
      COMMON /BUFRS/ BUFF1, JBUFSZ
C                                       End local include for SYFIX
LOCAL END
LOCAL INCLUDE 'TIMES.INC'
      INTEGER   MAXTIM
      PARAMETER (MAXTIM=100000)
C
      INTEGER   SRCTIM(MAXTIM), NUMTIM
      DOUBLE PRECISION STIME(MAXTIM), ETIME(MAXTIM), INTIME, NNTIME
      COMMON /TIMEC/ STIME, ETIME, INTIME, NNTIME, SRCTIM, NUMTIM
LOCAL END
      PROGRAM SYFIX
C-----------------------------------------------------------------------
C! Make SY source numbers match the vis data
C# Utility UV UV-util VLA VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   SYFIX makes sure that the source numbers in the SY table match
C   those in the data
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input VU data.
C      INVERS         INVERS        SY table version
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER  IRET
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA PRGM /'SYFIX '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL SYFIXI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Call routine that reads vis
C                                       makes time/source list
      CALL SYFIXU (IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Apply that list to the SY
      CALL SYFIXD (IRET)
      IF (IRET.NE.0) GO TO 990
C                                       history
      CALL SYFIXH
C                                       Close down files, etc.
 990  CALL DIE (IRET, BUFF1)
C
 999  STOP
      END
      SUBROUTINE SYFIXI (PRGN, JERR)
C-----------------------------------------------------------------------
C   SYFIXI gets input parameters for SYFIX and creates an output file
C   if necessary.
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      JERR    I    Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C-----------------------------------------------------------------------
      INTEGER   JERR
      CHARACTER PRGN*6
C
      CHARACTER STAT*4, BLANK*6, PTYPE*2
      INTEGER   IROUND, NPARM, IERR, NVER
      LOGICAL   T, F
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA BLANK  /'      '/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (T)
      CALL VHDRIN
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
      NFIXED = 0
      NFAILD = 0
C                                       Get input parameters.
      NPARM = 9
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, BUFF1, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
      INVERS = XINVER + 0.1
      TIMDBG = PRTLEV.GT.0.0
C                                       Get CATBLK from old file.
      OLDCNO = 1
      PTYPE = 'UV'
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, STAT, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      NLUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'REST', BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR
         GO TO 990
         END IF
C                                       Save input CATBLK
      CALL COPY (256, CATBLK, CATOLD)
C                                       Get uv header info.
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
C                                        Put input file in READ
      PTYPE = 'UV'
      CALL CATDIR ('CSTA', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, 'WRIT', BUFF1, IERR)
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = OLDCNO
      FRW(NCFILE) = 1
C                                       get and sort SY
      CALL FNDEXT ('SY', CATBLK, NVER)
      IF ((INVERS.LE.0) .OR. (INVERS.GT.NVER)) INVERS = NVER
      OUTVER = NVER + 1
      IF (NVER.LE.0) THEN
         MSGTXT = 'NO SY TABLE FOUND'
         GO TO 990
         END IF
      CALL H2CHR (2, 1, CATH(KITYP), PTYPE)
      IF (PTYPE(:1).NE.'T') THEN
         MSGTXT = 'DATA SET NOT IN TIME ORDER: SORT IT'
         GO TO 990
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
      JERR = 5
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYFIXI: ERROR',I3,' OBTAINING INPUT PARAMETERS')
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1040 FORMAT ('ERROR',I3,' COPYING CATBLK ')
      END
      SUBROUTINE SYFIXU (IRET)
C-----------------------------------------------------------------------
C   SYFIXU sends uv data one point at a time to the time listing
C   routine.
C   Output:
C      IRET    I  Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      CHARACTER IFILE*48
      INTEGER   INIO, IPTRI, LUNI, INDI, ILENBU, IBIND, I, INCX, BO, VO,
     *   NUMVIS, XCOUNT, VISINC, VISMSG
      LOGICAL   T, F
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA LUNI /16/
      DATA VO, BO /0, 1/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Dimension of complex axis
      INCX = CATBLK(KINAX)
      VISINC = CATBLK(KIGCN) / 20
      VISMSG = CATBLK(KIGCN) / 10
      VISINC = MAX (20000, MIN (200000,VISINC))
      VISMSG = (VISMSG / VISINC) * VISINC
      IF (VISMSG.LT.VISINC) VISMSG = 100 * VISINC
C                                       Open and init for read
C                                       visibility file
      CALL ZPHFIL ('UV', DISKIN, FCNO(NCFILE), 1, IFILE, IRET)
      CALL ZOPEN (LUNI, INDI, DISKIN, IFILE, T, F, F, IRET)
      IF (IRET.GT.0) THEN
         WRITE (MSGTXT,1000) IRET
         GO TO 990
         END IF
C                                       Init vis file for read.
      ILENBU = 0
      CALL UVINIT ('READ', LUNI, INDI, NVIS, VO, LREC, ILENBU, JBUFSZ,
     *   BUFF1, BO, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1030) IRET
         GO TO 990
         END IF
      NUMVIS = 0
      XCOUNT = 0
C                                       Loop
 100  CONTINUE
C                                       Read vis. record.
         CALL UVDISK ('READ', LUNI, INDI, BUFF1, INIO, IBIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1100) IRET
            GO TO 990
            END IF
         IPTRI = IBIND
C                                       Out of data?
         IF (INIO.LE.0) GO TO 200
C                                       Loop over buffer
         DO 190 I = 1,INIO
            NUMVIS = NUMVIS + 1
            IF (MOD(NUMVIS-1,VISMSG).EQ.0) THEN
               WRITE (MSGTXT,1105) NUMVIS
               CALL MSGWRT (2)
            ELSE IF (MOD(NUMVIS-1,VISINC).EQ.0) THEN
               WRITE (MSGTXT,1105) NUMVIS
               CALL MSGWRT (1)
               END IF
            CALL DIDTIM (NUMVIS, BUFF1(IPTRI), IRET)
C                                       OK, but no output please
            IPTRI = IPTRI + LREC
 190        CONTINUE
C                                       Read next buffer.
         GO TO 100
C                                       done
 200  CALL ZCLOSE (LUNI, INDI, IRET)
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYFIXU: ERROR',I3,' OPEN-FOR-READ VIS FILE')
 1030 FORMAT ('SYFIXU: ERROR',I3,' INIT-FOR-READ VIS FILE')
 1100 FORMAT ('SYFIXU: ERROR',I3,' READING VIS FILE')
 1105 FORMAT ('SYFIXU: at visibility record',I10)
      END
      SUBROUTINE SYFIXH
C-----------------------------------------------------------------------
C   SYFIXH copies and updates history file.  It also copies any tables.
C-----------------------------------------------------------------------
      CHARACTER HILINE*72, TTIME(2)*12
      INTEGER   HLUN, IERR, DATE(3), TIME(3)
      LOGICAL   T, F
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA HLUN /27/
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
      CALL HIOPEN (HLUN, DISKIN, OLDCNO, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       New history
      CALL ZDATE (DATE)
      CALL ZTIME (TIME)
      DATE(1) = -DATE(1)
      CALL TIMDAT (TIME, DATE, TTIME(2), TTIME)
      WRITE (HILINE,1000) TSKNAM, RLSNAM, TTIME
      CALL HIADD (HLUN, HILINE, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 100
C                                       versions
      WRITE (HILINE,1010) TSKNAM, INVERS
      CALL HIADD (HLUN, HILINE, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 100
      WRITE (HILINE,1011) TSKNAM, OUTVER
      CALL HIADD (HLUN, HILINE, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 100
      WRITE (HILINE,1020) TSKNAM, NFIXED
      CALL HIADD (HLUN, HILINE, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 100
      MSGTXT = HILINE(7:)
      CALL MSGWRT (3)
      WRITE (HILINE,1021) TSKNAM, NFAILD
      CALL HIADD (HLUN, HILINE, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 100
      MSGTXT = HILINE(7:)
      CALL MSGWRT (3)
C                                       Close HI file
 100  CALL HICLOS (HLUN, T, BUFF1, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT (A6,'RELEASE =''',A7,' ''  /********* Start ',
     *   A9,2X,A8)
 1010 FORMAT (A6,'INVERS  =',I4,'/    input SY version')
 1011 FORMAT (A6,'OUTVERS =',I4,'/    output SY version')
 1020 FORMAT (A6,'/   number lines altered',I10)
 1021 FORMAT (A6,'/   number lines failed: no data at time',I6)
      END
      SUBROUTINE DIDTIM (NUMVIS, RPARM, IRET)
C-----------------------------------------------------------------------
C   Make time list
C   Inputs:
C      NUMVIS  I    Visibility number, -1 => final call, no data
C                   passed but allows any operations to be completed.
C      RPARM   R(*) Random parameter array which includes U,V,W etc
C                   but also any other random parameters.
c   Output
C      IRET       I    Return code  -1 => don't write
C                                    0 => OK
C                                   >0 => error, terminate.
C-----------------------------------------------------------------------
      INTEGER   NUMVIS, IRET
      REAL      RPARM(*)
C
      INTEGER   LSTSRC, CURSRC
      DOUBLE PRECISION TIME
      INCLUDE 'TIMES.INC'
      INCLUDE 'INCS:DUVH.INC'
      SAVE LSTSRC
      DATA LSTSRC /0/
C-----------------------------------------------------------------------
      IRET = 0
      IF (NUMVIS.EQ.1) THEN
         NUMTIM = 0
         NNTIME = 0.0D0
         INTIME = 0.0D0
         END IF
      CURSRC = RPARM(1+ILOCSU)
      TIME = RPARM(1+ILOCT)
      IF (CURSRC.NE.LSTSRC) THEN
         NUMTIM = NUMTIM + 1
         SRCTIM(NUMTIM) = CURSRC
         STIME(NUMTIM) = TIME
         ETIME(NUMTIM) = TIME
         LSTSRC = CURSRC
         NNTIME = NNTIME + 1.0D0
         INTIME = INTIME + RPARM(1+ILOCIT)
      ELSE
         ETIME(NUMTIM) = MAX (ETIME(NUMTIM), TIME)
         END IF
C
 999  RETURN
      END
      SUBROUTINE SYFIXD (IRET)
C-----------------------------------------------------------------------
C   SYFIXD sorts the input SY table if needed and then reads it, fixes
C   the source number, and write it to a new SY table
C   Output:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   LUNSY, ISYRNO, SYKOLS(MAXSYC), SYNUMV(MAXSYC), NUMANT,
     *   NUMPOL, NUMIF, SYBUF1(512), SYBUF2(512), LUNSY2, OSYRNO, IREC,
     *   NREC, CALTYP, SOURID, ANTNO, SUBA, FREQID, KEYSUB(2,2),
     *   KEY(2,2)
      DOUBLE PRECISION TIME
      REAL      TIMEI, PDIFF(2,MAXIF), PSUM(2,MAXIF), PGAIN(2,MAXIF),
     *   FKEY(2,2)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA FKEY /1.0,0.0, 1.0,0.0/
      DATA KEYSUB /4*1/
C-----------------------------------------------------------------------
      LUNSY = 29
      CALL SYINI ('READ', SYBUF1, DISKIN, OLDCNO, INVERS, CATBLK, LUNSY,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING THE INPUT SY TABLE FOR READ'
         GO TO 990
         END IF
C                                       sort needed?
      KEY(1,2) = 4
      KEY(1,1) = 1
      IF ((SYBUF1(43).NE.KEY(1,1)) .OR. (SYBUF1(44).NE.KEY(1,2))) THEN
         CALL TABIO ('CLOS', 0, ISYRNO, SYBUF1, SYBUF1, IRET)
         CALL TABSRT (DISKIN, OLDCNO, 'SY', INVERS, INVERS, KEY, KEYSUB,
     *      FKEY, SYBUF1, CATBLK, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SORTING INPUT SY TABLE'
            GO TO 990
            END IF
         CALL SYINI ('READ', SYBUF1, DISKIN, OLDCNO, INVERS, CATBLK,
     *      LUNSY, ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'REOPENING INPUT SY AFTER SORT'
            GO TO 990
            END IF
         END IF
C                                       create output
      LUNSY2 = 30
      CALL SYINI ('WRIT', SYBUF2, DISKIN, OLDCNO, OUTVER, CATBLK,
     *   LUNSY2, OSYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING THE OUTPUT SY TABLE'
         GO TO 990
         END IF
C                                       read loop
      NREC = SYBUF1(5)
      DO 100 IREC = 1,NREC
         CALL TABSY ('READ', SYBUF1, ISYRNO, SYKOLS, SYNUMV, NUMPOL,
     *      NUMIF, TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID,
     *      PDIFF, PSUM, PGAIN, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING INPUT SY TABLE'
            GO TO 990
            END IF
C                                       look up source ID
         CALL FNDSRC (IREC, TIME, SOURID)
C                                       write the new SY table
         CALL TABSY ('WRIT', SYBUF2, OSYRNO, SYKOLS, SYNUMV, NUMPOL,
     *      NUMIF, TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID,
     *      PDIFF, PSUM, PGAIN, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITING OUTPUT SY TABLE'
            GO TO 990
            END IF
 100     CONTINUE
C                                       close them
      CALL TABSY ('CLOS', SYBUF2, OSYRNO, SYKOLS, SYNUMV, NUMPOL, NUMIF,
     *   TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID, PDIFF, PSUM,
     *   PGAIN, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSING OUTPUT SY TABLE'
         GO TO 990
         END IF
      CALL TABSY ('CLOS', SYBUF1, ISYRNO, SYKOLS, SYNUMV, NUMPOL, NUMIF,
     *   TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID, PDIFF, PSUM,
     *   PGAIN, IREC)
C                                       last message?
      CALL DOMSG (0, 0, 0)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYFIXD ERROR',I4,' ON ',A)
      END
      SUBROUTINE FNDSRC (IREC, TIME, SRC)
C-----------------------------------------------------------------------
C   Looks in time/source list to find the time
C   Inputs:
C      TIME   D   Time in days
C      SRC    I   What we think source number is
C   Outputs
C      SRC    I   Source number
C-----------------------------------------------------------------------
      DOUBLE PRECISION TIME
      INTEGER   IREC, SRC
C
      INCLUDE 'TIMES.INC'
      INCLUDE 'SYFIX.INC'
      INTEGER   CURTIM, I, J
      LOGICAL   FIRST
      DOUBLE PRECISION DEPS
      INCLUDE 'INCS:DMSG.INC'
      SAVE CURTIM, FIRST, DEPS
      DATA CURTIM /1/
      DATA FIRST /.TRUE./
C-----------------------------------------------------------------------
      IF (FIRST) THEN
         DEPS = INTIME / NNTIME / 2.01
         DEPS = DEPS / (24.0D0 * 3600.0D0)
         DO 20 I = 1,NUMTIM
            ETIME(I) = ETIME(I) + DEPS
            STIME(I) = STIME(I) - DEPS
 20         CONTINUE
         FIRST = .FALSE.
         END IF
C                                       current time?
      IF ((TIME.GE.STIME(CURTIM)) .AND. (TIME.LE.ETIME(CURTIM))) THEN
         CALL DOMSG (IREC, SRC, SRCTIM(CURTIM))
         SRC = SRCTIM(CURTIM)
         GO TO 999
         END IF
C                                       next time?
      IF ((TIME.GE.STIME(CURTIM+1)) .AND. (TIME.LE.ETIME(CURTIM+1)))
     *   THEN
         CURTIM = CURTIM + 1
         CALL DOMSG (IREC, SRC, SRCTIM(CURTIM))
         SRC = SRCTIM(CURTIM)
         GO TO 999
         END IF
C                                       general search
      IF (TIME.LT.STIME(CURTIM)) CURTIM = 1
      J = CURTIM
      DO 100 I = J,NUMTIM
         IF (TIME.GT.ETIME(I)+0.001) GO TO 110
         IF ((TIME.GE.STIME(I)) .AND. (TIME.LE.ETIME(I))) THEN
            CURTIM = I
            CALL DOMSG (IREC, SRC, SRCTIM(CURTIM))
            SRC = SRCTIM(CURTIM)
            GO TO 999
            END IF
 100     CONTINUE
C                                       count failed, leave source numb
 110  NFAILD = NFAILD + 1
      WRITE (MSGTXT,1110) IREC, SRC
      IF (TIMDBG) CALL MSGWRT (2)
C
 999  RETURN
C-----------------------------------------------------------------------
 1110 FORMAT ('No vis data for record',I8,' left source as',I5)
      END
      SUBROUTINE DOMSG (IREC, SRC, SRCTIM)
C-----------------------------------------------------------------------
C   Does message logic
C   Inputs:
C      IREC      I   SY table current record
C      SRC       I   input SY table source
C      SRCTIM    i   correct SY table source number
C-----------------------------------------------------------------------
      INTEGER   IREC, SRC, SRCTIM
C
      INTEGER   LSRC, LSRCT, LREC1, LREC2
      INCLUDE 'SYFIX.INC'
      INCLUDE 'INCS:DMSG.INC'
      SAVE LSRC, LSRCT, LREC1, LREC2
      DATA LSRC, LSRCT, LREC1, LREC2 /4*-1/
C-----------------------------------------------------------------------
C                                       no change sample
      IF (SRC.EQ.SRCTIM) THEN
         IF ((LREC1.GT.0) .AND. (LREC2.GE.LREC1)) THEN
            WRITE (MSGTXT,1000) LREC1, LREC2, LSRC, LSRCT
            IF (TIMDBG) CALL MSGWRT (2)
            END IF
         LREC1 = -1
         LREC2 = -1
         LSRC = -1
         LSRCT = -1
C                                       sample changing
      ELSE
C                                       print previous?
         IF ((SRC.NE.LSRC) .OR. (SRCTIM.NE.LSRCT)) THEN
            IF ((LREC1.GT.0) .AND. (LREC2.GE.LREC1)) THEN
               WRITE (MSGTXT,1000) LREC1, LREC2, LSRC, LSRCT
               IF (TIMDBG) CALL MSGWRT (2)
               END IF
            LSRC = SRC
            LSRCT = SRCTIM
            LREC1 = IREC
            END IF
         LREC2 = IREC
         NFIXED = NFIXED + 1
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('Corrected records',I9,' to',I9,' from source',I5,' to',
     *   I5)
      END
