LOCAL INCLUDE 'VLBCD.INC'
C                                                          Include VLBCD
C                                       Local include for VLBCD
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MAXCDC
      PARAMETER (MAXCDC=7)
C                                       Inputs and general info
      INTEGER   SEQIN, DISKIN, ISUBA, LUNK, FINDK, OLDCNO, ADDED, NPOL,
     *   NIFS
      LOGICAL   DOCONC
      REAL      XSIN, XDISIN, XSUBA, XCDVER, BADD(10)
      HOLLERITH XNAMEI(3), XCLAIN(2), XNAME2(12)
      CHARACTER NAMEIN*12, CLAIN*6, NAME2*48
C                                       Buffers and file info
      INTEGER   SCBUFF(512), CDVER, CDTOT
C                                       Inputs and general info
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XNAME2, XSUBA,
     *   XCDVER, BADD
      COMMON /TASKPM/ SEQIN, DISKIN, ISUBA, LUNK, FINDK, OLDCNO,
     *   CDTOT, ADDED, DOCONC, NPOL, NIFS
C                                       CHARACTER info
      COMMON /CHRCOM/ NAMEIN, CLAIN, NAME2
C                                       Buffers and file info
      COMMON /SCFILE/ SCBUFF, CDVER
C                                       FQ table information
      DOUBLE PRECISION DFRQ(MAXIF)
      INTEGER   FREQID
      COMMON /NXFQIN/ DFRQ, FREQID
C                                                          End VLBCD
LOCAL END
      PROGRAM VLBCD
C-----------------------------------------------------------------------
C! Read in VLBA tot data from ascii file.
C# UV Calibration EXT-util VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Task VLBCD reads an ascii file containing the pulse-cal, cable cal
C   and state count information generated by the VLBA monitoring system.
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input UV data.
C      INFILE         INFIL         Name of aux. file.
C      SUBARRAY       ISUBA         Subarray number
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET
      INCLUDE 'VLBCD.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      DATA PRGM /'VLBCD '/
C-----------------------------------------------------------------------
C                                       Get input parameters
      CALL VLBCDI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Read total power ascii file
      CALL READCD (IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Copy and update HI file.
      CALL VLBCDH
C                                       Close down files, etc.
 990  CALL DIE (IRET, SCBUFF)
 999  STOP
      END
      SUBROUTINE VLBCDI (PRGN, JERR)
C-----------------------------------------------------------------------
C   VLBCDI gets input parameters for VLBCD.
C   Inputs:  PRGN    C*6       Program name
C   Output:  JERR    I         Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => cannot start
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      CHARACTER PRGN*6
      INTEGER   JERR
C
      CHARACTER STAT*4, UTYPE*2, LINE*80
      LOGICAL   T, F
      INTEGER   NPARM, IERR, LC, JTRIM, IROUND, I, VER, LUNSC, LUNTMP
      REAL      CHOFF
      INCLUDE 'VLBCD.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCHND.INC'
      DATA T, F /.TRUE.,.FALSE./
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (T)
      CALL VHDRIN
      LUNK = 10
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
C                                       Get input parameters.
      NPARM = 31
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, SCBUFF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
            CALL MSGWRT (8)
            END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, SCBUFF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
C                                       Convert characters
      DO 5 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 5       CONTINUE
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (48, 1, XNAME2, NAME2)
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
      ISUBA = IROUND (XSUBA)
      ISUBA = MAX (ISUBA, 1)
      ADDED = 0
C                                       Find file, read CATBLK
      OLDCNO = 1
      STAT = 'SRCH'
      UTYPE = 'UV'
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN, UTYPE,
     *   NLUSER, STAT, SCBUFF, IERR)
      IF (IERR.GT.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      NLUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'WRIT', SCBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'COPYING CATBLK'
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = OLDCNO
      FRW(NCFILE) = 1
C                                       Get uv header info.
      CALL UVPGET (JERR)
      IF (JERR.NE.0) GO TO 999
      NPOL = MIN  (2, CATBLK(KINAX+JLOCS))
      NIFS = CATBLK(KINAX+JLOCIF)
C                                       Open text file
      LC = JTRIM (NAME2)
      CALL ZTXOPN ('QRED', LUNK, FINDK, NAME2, F, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TEXT FILE'
         JERR = IERR
         GO TO 990
         END IF
C                                       read first line
      CALL ZTXIO ('READ', LUNK, FINDK, LINE, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READ FIRST TEXT LINE'
         JERR = IERR
         GO TO 990
         END IF
      IF (LINE(:14).NE.'! Produced by:') THEN
         MSGTXT = 'FILE HAS FORMAT UNCERTAINTIES'
         JERR = 8
         GO TO 990
         END IF
      CALL ZTXCLS (LUNK, FINDK, IERR)
      IF (NAME2(LC:LC).EQ.'_') NAME2(LC+1:) = '  '
C                                       get frequencies
      VER = 1
      LUNSC = LUNTMP (1)
      CALL CHNDAT ('READ', SCBUFF, DISKIN, OLDCNO, VER, CATBLK, LUNSC,
     *   I, FOFF, ISBAND, FINC, BNDCOD, FREQID, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING FREQUENCY INFORMATION'
         JERR = 10
         GO TO 990
      END IF
      CHOFF = (CATBLK(KINAX+JLOCF)/2.0 - CATR(KRCRP+JLOCF))
      DO 70 I = 1,NIFS
         DFRQ(I) = (CATD(KDCRV+JLOCF) + FOFF(I) + CHOFF*FINC(I)) / 1.0D6
 70      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('VLBCDI: ERROR',I3,' ON ',A)
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
      END
      SUBROUTINE READCD (IERR)
C-----------------------------------------------------------------------
C   READCD builds an CD table from the DiFX ascii format file
C   Can loop over VLBA named files
C   Output:
C      IRET   I   > 0 -> failure of some sort
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'VLBCD.INC'
      INTEGER   SUBA, JTRIM, KBPLIM, KBP, IP,
     *   LUNCD, CDBUFF(512), ICDRNO, CDKOLS(MAXCDC), NP,
     *   CDNUMV(MAXCDC), I, NOSTA, IROUND, IR, IL,
     *   J, NLINE
      LOGICAL   FIRST
      CHARACTER TELNAM*8, LLINE*5000, NAMTEL*8, OBSDAT*8
      DOUBLE PRECISION  XX
      REAL      TCAL(4,MAXIF)
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DANS.INC'
      DATA FIRST /.TRUE./
C-----------------------------------------------------------------------
      CALL H2CHR (8, 1, CATH(KHDOB), OBSDAT)
      TELNAM = ' '
C                                       Get list of station names
      SUBA = ISUBA
      CALL GETANT (DISKIN, OLDCNO, SUBA, CATBLK, SCBUFF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING ANTENNA DATA'
         CALL MSGWRT (7)
         END IF
C                                       file name
      CALL ZTXOPN ('READ', LUNK, FINDK, NAME2, .FALSE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING TEXT FILE'
         GO TO 990
         END IF
C                                       read a line
 100  CALL ZTXIO ('READ', LUNK, FINDK, LLINE, IERR)
      IF (IERR.EQ.2) THEN
         GO TO 200
      ELSE IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE'
         GO TO 990
      ELSE
         NLINE = NLINE + 1
         KBPLIM = JTRIM (LLINE)
C                                       found block of data
         IF (LLINE(:6).EQ.'TSYS  ') THEN
C                                       antenna data
C                                       telescope name
            NAMTEL = LLINE(7:8)
            CALL CHLTOU (8, NAMTEL)
            IF (NAMTEL.NE.TELNAM) THEN
               NOSTA = 0
               DO 125 I = 1,NSTNS
                  IF (NAMTEL.EQ.STNNAM(I)) NOSTA = TELNO(I)
 125              CONTINUE
               MSGTXT = 'Data line changes telescope from ' //
     *            TELNAM(:JTRIM(TELNAM)) // ' to ' //
     *            NAMTEL(:JTRIM(NAMTEL))
               IF (TELNAM.NE.' ') CALL MSGWRT (6)
               TELNAM = NAMTEL
               END IF
            CALL ZTXIO ('READ', LUNK, FINDK, LLINE, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE IN A CD'
               GO TO 990
               END IF
            CALL ZTXIO ('READ', LUNK, FINDK, LLINE, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE IN A CD'
               GO TO 990
               END IF
            IF (LLINE(3:4).NE.TELNAM) THEN
               WRITE (MSGTXT,1125) TELNAM(:2), LLINE(:12)
               IERR = 10
               GO TO 990
               END IF
C                                       create CD table
            IF (FIRST) THEN
C                                       CD number
               CDVER = IROUND (XCDVER)
C                                       Check to see if CD table exists
               CALL FNDEXT ('CD', CATBLK, CDTOT)
               IF (CDVER.LE.0) CDVER = CDTOT + 1
               LUNCD = 30
               CALL CDINI ('WRIT', CDBUFF, DISKIN, OLDCNO, CDVER,
     *            CATBLK, LUNCD, ICDRNO, CDKOLS, CDNUMV, NSTNS, NPOL,
     *            NIFS, OBSDAT, IERR)
               IF (IERR.NE.0) THEN
                  WRITE (MSGTXT,1000) IERR, 'OPENING CD TABLE'
                  GO TO 990
                  END IF
C                                       warning of concatenation
               IF (CDVER.LE.CDTOT) THEN
                  DOCONC = .TRUE.
                  WRITE (MSGTXT,1111) CDVER
                  CALL REFRMT (MSGTXT, '_', I)
                  CALL MSGWRT (5)
                  END IF
C                                       Update CATBLK
               CALL CATIO ('UPDT', DISKIN, OLDCNO, CATBLK, 'REST',
     *            SCBUFF, IERR)
               FIRST = .FALSE.
               END IF
C                                       Read for pol and IF
            NP = 4 * NIFS
            CALL RFILL (NP, FBLANK, TCAL)
            NP = NPOL * NIFS
            DO 150 I = 1,NP
               CALL ZTXIO ('READ', LUNK, FINDK, LLINE, IERR)
               IF (IERR.NE.0) THEN
                  WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE IN A CD'
                  GO TO 990
                  END IF
               KBPLIM = JTRIM (LLINE)
               IR = INDEX (LLINE, 'RCP')
               IL = INDEX (LLINE, 'LCP')
               IP = 1
               IF (IL.GT.0) IP = 2
               J = INDEX (LLINE, 'MHz') + 3
               KBP = INDEX (LLINE(J:), 'MHz') + J - 9
               IF (KBP.LE.0) THEN
                  IERR = 10
                  MSGTXT = 'ERROR PARSING CD TEXT LINE'
                  GO TO 990
                  END IF
               CALL GETNUM (LLINE, KBPLIM, KBP, XX)
               DO 130 J = 1,NIFS
                  IF (ABS(XX-DFRQ(J)).LE.8.0D0) GO TO 135
 130           CONTINUE
               WRITE (MSGTXT,1130) XX, (DFRQ(J), J = 1,MIN(8,NIFS))
               CALL MSGWRT (7)
               GO TO 150
 135           KBP = KBP + 3
               CALL GETNUM (LLINE, KBPLIM, KBP, XX)
               TCAL(IP,J) = XX
 150           CONTINUE
            CALL TABCD ('WRIT', CDBUFF, ICDRNO, CDKOLS, CDNUMV, NPOL,
     *         NIFS, NOSTA, ISUBA, FREQID, TCAL, IERR)
            IF (IERR.NE.0) THEN
               WRITE (MSGTXT,1000) IERR, 'WRITING OUTPUT CD TABLE'
               GO TO 990
               END IF
            ADDED = ADDED + 1
            END IF
         GO TO 100
         END IF
C                                       close input text file
 200  CALL ZTXCLS (LUNK, FINDK, IERR)
      CALL TABCD ('CLOS', CDBUFF, ICDRNO, CDKOLS, CDNUMV, NPOL,
     *   NIFS, NOSTA, ISUBA, FREQID, TCAL, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'CLOSING CD TABLE'
         GO TO 990
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('READCD ERROR',I4,' ON ',A)
 1111 FORMAT ('READCD: Concatenating to CD table',I5)
 1125 FORMAT ('READCD: EXPECTED ''',A,''' GOT ''',A)
 1130 FORMAT ('FREQ',F7.0,' NOT IN',8F7.0)
      END
      SUBROUTINE VLBCDH
C-----------------------------------------------------------------------
C   VLBCDH copies and updates history file.
C-----------------------------------------------------------------------
      INTEGER   LUN1, IERR, ITIME(3), DATE(3), I
      CHARACTER HILINE*72, CITIME*20
      INCLUDE 'VLBCD.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LUN1 /27/
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       Copy/open history file.
      CALL HIOPEN (LUN1, DISKIN, FCNO(NCFILE), SCBUFF, IERR)
      IF (IERR.GT.2) THEN
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 100
         END IF
C                                       Task message
      CALL ZDATE (DATE)
      CALL ZTIME (ITIME)
      CALL TIMDAT (ITIME, DATE, CITIME(13:20), CITIME(1:12))
      WRITE (HILINE,1010) TSKNAM, RLSNAM, CITIME(1:12), CITIME(13:20)
      CALL HIADD (LUN1, HILINE, SCBUFF, IERR)
      IF (IERR.NE.0) GO TO 100
C                                       File name
      WRITE (HILINE,2000) TSKNAM, NAME2
      CALL HIADD (LUN1, HILINE, SCBUFF, IERR)
      IF (IERR.NE.0) GO TO 100
C                                       Version #
      IF (DOCONC) THEN
         WRITE (HILINE,2001) TSKNAM, CDVER, ADDED
         CALL HIADD (LUN1, HILINE, SCBUFF, IERR)
         IF (IERR.NE.0) GO TO 100
         WRITE (MSGTXT,1020) ADDED, CDVER
         CALL REFRMT (MSGTXT, '_', I)
         CALL MSGWRT (4)
      ELSE
         WRITE (HILINE,2002) TSKNAM, CDVER, ADDED
         CALL HIADD (LUN1, HILINE, SCBUFF, IERR)
         IF (IERR.NE.0) GO TO 100
         WRITE (MSGTXT,1021) ADDED, CDVER
         CALL REFRMT (MSGTXT, '_', I)
         CALL MSGWRT (4)
         END IF
C                                       Close HI file
 100  CALL HICLOS (LUN1, .TRUE., SCBUFF, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('VLBCDH: ERROR',I3,' OPENING HISTORY FILE')
 1010 FORMAT (A6,'RELEASE =''',A,' ''  /********* Start ',
     *   A12,2X,A8)
 1020 FORMAT (I10,' records added to old CD table version',I4)
 1021 FORMAT (I10,' records written to new CD table version',I4)
 2000 FORMAT (A6,'INFILE = ''',A48,'''')
 2001 FORMAT (A6,'CDVERS =',I4,'  / Concatenated',I8,
     *   ' records to existing table')
 2002 FORMAT (A6,'CDVERS =',I4,'  / Wrote',I8,
     *   ' records to new table')
      END
