LOCAL INCLUDE 'WXLOD.INC'
      INCLUDE 'INCS:PUVD.INC'
C                                       Local include for WXLOD
      HOLLERITH XNAMEI(3), XCLAIN(2), XINFIL(12)
      REAL      XINSEQ, XINDIS
      CHARACTER LNAME*12, LCLASS*6, LINFIL*48
      INTEGER   INSEQ, INDISK, IWXVER, NPARM, TXLUN, TXIND
C                                       Input parameters
      COMMON /INPARM/ XNAMEI, XCLAIN, XINSEQ, XINDIS, XINFIL
      COMMON /INVAL/ INSEQ, INDISK, NPARM, TXLUN, TXIND, IWXVER
      COMMON /CHVAL/ LNAME, LCLASS, LINFIL
C                                       Buffers
      INTEGER   NBUF1
      PARAMETER (NBUF1 = 512)
      INTEGER   BUFF1(NBUF1)
      COMMON /WRKBUF/ BUFF1
C                                       General global variables
      INTEGER   ILUN1, ILUN2, ICNO, MAXREC
      COMMON /GLBLVR/ ILUN1, ILUN2, ICNO, MAXREC
C
LOCAL END
      PROGRAM WXLOD
C-----------------------------------------------------------------------
C! Read weather data in KEYIN form into WX table
C# UV Calibration EXT-util VLB
C-----------------------------------------------------------------------
C;  Copyright (C) 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Task WXLOD reads in weather data making a WX table
C   Inputs:
C      AIPS adverb       Local var.       Description
C      INNAME            LNAME            Input uv-file name.
C      INCLASS           LCLASS           Class of input uv-file
C      INSEQ             INSEQ            Seq. no. of input uv-file
C      INDISK            INDISK           Disk no. of input file
C      ANTENNAS          XANT             Antennas to calibrate
C      INTEXT            LINFIL           Input filr
C-----------------------------------------------------------------------
      INCLUDE 'WXLOD.INC'
      CHARACTER LPGM*6
      INTEGER   IRET
      INCLUDE 'INCS:DCAT.INC'
      DATA LPGM /'WXLOD '/
C-----------------------------------------------------------------------
C                                       Get input parameters and perform
C                                       general initialisation
      CALL WXLODI (LPGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       Load the data
      CALL WXLODD (IRET)
      IF (IRET.NE.0) GO TO 990
      CALL WXLODH
C                                       Close down files/exit
 990  CALL DIE (IRET, BUFF1)
C
 999  STOP
      END
      SUBROUTINE WXLODI (LPGM, IRET)
C------------------------------------------------------------------------
C   Read input parameters for WXLOD and perform general initialisation
C   Inputs:
C      LPGM    C*6      Task name
C   Outputs:
C      IRET    I        Return code (0 => ok)
C------------------------------------------------------------------------
      CHARACTER LPGM*6
      INTEGER   IRET
C
      INCLUDE 'WXLOD.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DMSG.INC'
      LOGICAL   WTRUE
      CHARACTER LSTAT*4, LTYPE*2
      INTEGER   IERR
      DATA WTRUE /.TRUE./
C------------------------------------------------------------------------
      IRET = 0
C                                       General LUNs for table I/O
      ILUN1 = 27
      ILUN2 = 28
C                                       Initialise AIPS from disk
      CALL ZDCHIN (WTRUE)
C                                       Compute catalog rec. pointers
      CALL VHDRIN
C                                       Initialise /CFILES/
      NSCR = 0
      NCFILE = 0
C                                       Get input adverbs
      NPARM = 19
      CALL GTPARM (LPGM, NPARM, RQUICK, XNAMEI, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = WTRUE
         IRET = 1
C                                       Check if initiator (AIPS)
C                                       not found
         IF (IERR.EQ.1) GO TO 999
         WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
         CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, BUFF1, IERR)
      IF (IERR.NE.0) IRET = 1
C                                       Abort if error obtaining
C                                       input parameters
      IF (IRET.NE.0) GO TO 999
C                                       Convert input parameters
      CALL H2CHR (48, 1, XINFIL, LINFIL)
      CALL H2CHR (12, 1, XNAMEI, LNAME)
      CALL H2CHR (6, 1, XCLAIN, LCLASS)
      INSEQ = XINSEQ
      INDISK = XINDIS
C                                       Find uv-file in catalog directory
      LSTAT = 'SRCH'
      LTYPE = 'UV'
      ICNO = 1
      CALL CATDIR ('SRCH', INDISK, ICNO, LNAME, LCLASS, INSEQ, LTYPE,
     *   NLUSER, LSTAT, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1020) IERR, LNAME, LCLASS, INSEQ, INDISK
         IRET = 2
         GO TO 990
         END IF
C                                       Read catalog header; mark file
C                                       status as 'WRITE'
      CALL CATIO ('READ', INDISK, ICNO, CATBLK, 'WRIT', BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR, LNAME, LCLASS, INSEQ, INDISK
         IRET = 3
         GO TO 990
         END IF
C                                       Add to /CFILES/
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = INDISK
      FCNO(NCFILE) = ICNO
      FRW(NCFILE) = 1
C                                       Convert input parameters
      CALL CHR2H (12, LNAME, 1, XNAMEI)
      CALL CHR2H (6, LCLASS, 1, XCLAIN)
      XINSEQ = INSEQ
      XINDIS = INDISK
C                                       Get uv-header information
      CALL UVPGET (IERR)
      IF (IERR.NE.0) THEN
         IRET = 4
         WRITE (MSGTXT,1000) IERR, 'PARSING UV HEADER'
         GO TO 990
         END IF
C                                       open output
      TXLUN = 3
      CALL ZTXOPN ('READ', TXLUN, TXIND, LINFIL, .TRUE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPENING INPUT TEXT FILE'
         GO TO 990
         END IF
      GO TO 999
C
C                                       Error
 990  CALL MSGWRT (8)
C                                       Exit
 999  RETURN
C----------------------------------------------------------------------
1000  FORMAT ('WXLODI: ERROR',I3,' ON ',A)
1020  FORMAT ('WXLODI: ERR',I3,' FINDING ',A12,'.',A6,'.',I4,'.',I3)
1040  FORMAT ('WXLODI: ERR',I3,' READING HEADER ',A12,'.',A6,'.',I4,'.',
     *   I3)
      END
      SUBROUTINE WXLODD (IRET)
C----------------------------------------------------------------------
C   Write ANTAB file from GC and TY
C   Outputs:
C      IRET    I   Return code (0 => ok)
C----------------------------------------------------------------------
      INTEGER IRET
C
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'INCS:DWXV.INC'
      INCLUDE 'WXLOD.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DANS.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      CHARACTER STRING*256, OBSDAT*8, OBSCOD*8, TEL*8
      INTEGER   IERR, ISUBA, WXBUFF(512), LUNWX, IWXRNO, WXKOLS(MAXWXC),
     *   WXNUMV(MAXWXC), TABVER, JTRIM, IDATE(3), DAYN, JTIME(4), ITEL,
     *   NR(MAXANT), I, J, K, IER, KBP, KBPLIM
      DOUBLE PRECISION TIME, XX
      REAL      DTIME, TT, PP, DP, WS, WD, RR, WG, TTA(7)
      EQUIVALENCE (TT, TTA)
      COMMON /WXLOCL/ TT, PP, DP, WS, WD, RR, WG
      DATA LUNWX /24/
C----------------------------------------------------------------------
      IRET = 0
      CALL FILL (MAXANT, 0, NR)
      MAXREC = 0
C                                       Get antenna table information
      ISUBA = 1
      CALL GETANT (INDISK, ICNO, ISUBA, CATBLK, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         IRET = 1
         WRITE (MSGTXT,1000) IERR, 'READING ANTENNA TABLE'
         GO TO 990
         END IF
C                                       Strip null characters from
C                                       antenna names returned by
C                                       GETANT
      DO 10 I = 1,NSTNS
         K = JTRIM (STNNAM(I))
 10      CONTINUE
C                                       day number
      CALL H2CHR (8, 1, CATH(KHDOB), OBSDAT)
      CALL DATEST (OBSDAT, IDATE)
      CALL DAYNUM (IDATE(1), IDATE(3), IDATE(2), DAYN)
C                                       create WX table
      IWXVER = 0
      TABVER = 4
      CALL H2CHR (8, 1, CATH(KHOBS), OBSCOD)
      CALL WXINI ('WRIT', WXBUFF, INDISK, ICNO, IWXVER, CATBLK, LUNWX,
     *   IWXRNO, WXKOLS, WXNUMV, OBSCOD, OBSDAT, TABVER, IERR)
      IF (IERR.NE.0) THEN
         IRET = 2
         WRITE (MSGTXT,1000) IERR, 'CREATING WX TABLE'
         GO TO 990
         END IF
C                                       read for a WEATHER line
 20   CALL ZTXIO ('READ', TXLUN, TXIND, STRING, IERR)
      IF (IERR.EQ.2) THEN
         GO TO 900
      ELSE IF (IERR.GT.0) THEN
         IRET = 3
         WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE'
         GO TO 990
      ELSE
         J = JTRIM (STRING)
         IF (STRING(:8).EQ.'WEATHER ') THEN
            J = INDEX ('/', STRING)
            K = INDEX (STRING, '/')
            TEL = STRING(9:K-1)
            DO 25 ITEL = 1,NSTNS
               IF (TEL.EQ.STNNAM(ITEL)) GO TO 50
 25            CONTINUE
            K = JTRIM (TEL)
            WRITE (MSGTXT,1025) TEL(:K)
            CALL MSGWRT (7)
            END IF
         GO TO 20
         END IF
C                                       Read data for this antenna
 50   CALL ZTXIO ('READ', TXLUN, TXIND, STRING, IERR)
      IF (IERR.EQ.2) THEN
         GO TO 990
      ELSE IF (IERR.GT.0) THEN
         IRET = 3
         WRITE (MSGTXT,1000) IERR, 'READING TEXT FILE'
         GO TO 990
      ELSE
         KBPLIM = JTRIM (STRING)
         IF (STRING(:1).EQ.'/') THEN
            K = JTRIM (TEL)
            WRITE (MSGTXT,1040) NR(ITEL), TEL(:K)
            CALL MSGWRT (3)
            GO TO 20
            END IF
C        READ (STRING,1050) JTIME, TT, PP, DP, WS, WD, RR, WG
         READ (STRING,1050) JTIME
         TIME = ((JTIME(4)/60.0 + JTIME(3)) / 60.0 + JTIME(2)) / 24.0
         TIME = JTIME(1) - DAYN + TIME
         CALL RFILL (7, -999.0, TTA)
         KBP = 13
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) TT = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) PP = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) DP = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) WS = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) WD = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) RR = XX
         CALL GETNUM (STRING, KBPLIM, KBP, XX)
         IF (XX.NE.DBLANK) WG = XX
         CALL TABWX ('WRIT', WXBUFF, IWXRNO, WXKOLS, WXNUMV, TIME,
     *      DTIME, ITEL, ISUBA, TT, PP, DP, WS, WD, WG, RR, 0.0, 0.0,
     *      IERR)
         IF (IERR.NE.0) THEN
            IRET = 4
            WRITE (MSGTXT,1000) IERR, 'WRITING WX TABLE'
            GO TO 990
            END IF
         NR(ITEL) = NR(ITEL) + 1
         MAXREC = MAXREC + 1
C                                       allow / at end of line
         IF (STRING(KBPLIM:KBPLIM).EQ.'/') THEN
            K = JTRIM (TEL)
            WRITE (MSGTXT,1040) NR(ITEL), TEL(:K)
            CALL MSGWRT (3)
            GO TO 20
            END IF
         GO TO 50
         END IF
C                                       Close tables
 900  CALL TABIO ('CLOS', 0, IWXRNO, WXBUFF, WXBUFF, IER)
      DO 910 I = 1,NSTNS
         IF (NR(I).EQ.0) THEN
            K = JTRIM (STNNAM(I))
            WRITE (MSGTXT,1900) STNNAM(I)(:K)
            CALL MSGWRT (6)
            END IF
 910     CONTINUE
      GO TO 995
C                                       Error
 990  CALL MSGWRT (8)
C                                       try to close table
      CALL TABIO ('CLOS', 0, IWXRNO, WXBUFF, WXBUFF, IER)
C                                       Exit
C                                       Close text file
 995  CALL ZTXCLS (TXLUN, TXIND, IER)
      IF (IRET.LE.0) THEN
         CALL CATIO ('UPDT', INDISK, ICNO, CATBLK, 'REST', BUFF1, IER)
         IF (IER.NE.0) THEN
            WRITE (MSGTXT,1000) IER, 'UPDATING HEADER ON DISK'
            CALL MSGWRT (7)
            END IF
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('WXLODD: ERROR',I5,' ON ',A)
 1025 FORMAT ('ANTENNA  ''',A,'''  NOT IN DATA SET')
 1040 FORMAT ('Wrote',I6,'  WX records for  ''',A,'''')
 1050 FORMAT (I3,3(1X,I2),F7.1,F8.1,2F7.1,F8.1,F8.2,F7.1)
 1900 FORMAT ('No records found for antenna  ''',A,'''')
      END
      SUBROUTINE WXLODH
C-----------------------------------------------------------------------
C   Adds history info to input file
C-----------------------------------------------------------------------
C
      INCLUDE 'WXLOD.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      LOGICAL   WUPDAT
      CHARACTER LHIREC*72, LTIME*20
      INTEGER   IERR, LDATE(3), ITIME(3), JTRIM
C----------------------------------------------------------------------
      CALL HIINIT (3)
C                                       Open history table
      CALL HIOPEN (ILUN1, INDISK, ICNO, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR
         GO TO 990
         END IF
C                                       Task name and time
      CALL ZDATE (LDATE)
      CALL ZTIME (ITIME)
      CALL TIMDAT (ITIME, LDATE, LTIME(13:20), LTIME(1:12))
      WRITE (LHIREC,1010) TSKNAM, RLSNAM, LTIME(1:12), LTIME(13:20)
      CALL HIADD (ILUN1, LHIREC, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       UV-file name
      WRITE (LHIREC,1020) TSKNAM, LNAME, LCLASS, INDISK, INSEQ
      CALL HIADD (ILUN1, LHIREC, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       Calibration file name
      WRITE (LHIREC,1040) TSKNAM, LINFIL(:JTRIM(LINFIL))
      CALL HIADD (ILUN1, LHIREC, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       version number
      WRITE (LHIREC,1050) TSKNAM, IWXVER
      CALL HIADD (ILUN1, LHIREC, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
      WRITE (LHIREC,1051) TSKNAM, MAXREC
      CALL HIADD (ILUN1, LHIREC, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       Close HI file
      WUPDAT = .TRUE.
      CALL HICLOS (ILUN1, WUPDAT, BUFF1, IERR)
      IF (IERR.NE.0) GO TO 980
      GO TO 999
C                                       Error
980   WRITE (MSGTXT,1980) IERR
C
990   CALL MSGWRT (8)
C                                       Exit
999   RETURN
C----------------------------------------------------------------------
 1000 FORMAT ('WXLODH: ERROR',I3,' OPENING HI TABLE')
 1010 FORMAT (A6,'RELEASE: ',A8,' START TIME: ',A12,2X,A8)
 1020 FORMAT (A6,'INNAME= ',A12,'.',A6,'.',I3,'.',I4)
 1040 FORMAT (A6,'INFILE= ''',A,'''')
 1050 FORMAT (A6,'WXVER =',I4,'    / Weather file version number')
 1051 FORMAT (A6,'/  MAXREC =',I8,'  records written in the WX table')
 1980 FORMAT ('WXLODH: ERROR',I3,' PROCESSING HISTORY FILE')
      END
