LOCAL INCLUDE 'RMTFC.INC'
      INTEGER   MAXPNT
      PARAMETER (MAXPNT = 2000)
C
      REAL      XP(MAXPNT), BP(MAXPNT,2), YP(MAXPNT,2), SCALE(2)
      INTEGER   NP
      COMMON /LSDATA/ XP, BP, YP, NP, SCALE
C                                       INPARM declarations.
      HOLLERITH XINFIL(12), XOUFIL(12), XOPTYP(1)
      REAL      APARM(10)
      CHARACTER INFILE*48, OUFILE*48, LINE1*72, OPTYPE*4
C                                       Parameters from AIPS.
      COMMON /INPARM/ XINFIL, XOPTYP, APARM, XOUFIL
      COMMON /LSCHAR/ INFILE, OUFILE, LINE1, OPTYPE
C
LOCAL END
      PROGRAM RMTFC
C-----------------------------------------------------------------------
C! cross-correlation test
C# Analysis polarization
C-----------------------------------------------------------------------
C;  Copyright (C) 2020, 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   RMTFC is a task to read RMTF from a TARS output file and make plots
C   of RM spectra for selected models
C   Inputs:   (from AIPS)
C       INFILE    H(12)  Input text file
C       APARM     R(10)  Plot controls
C       OUTFILE   H(12)  output text file
C-----------------------------------------------------------------------
      CHARACTER PRGNAM*6
      INTEGER   NPARMS, IERR, BUFF1(256)
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'RMTFC.INC'
      DATA PRGNAM /'RMTFC '/
C-----------------------------------------------------------------------
      NPARMS = 34
C                                       Get parms from AIPS, open map
C                                       file, create plot file,
      CALL RMTFCI (PRGNAM, NPARMS, IERR)
C                                       Do computation, output
      IF (IERR.EQ.0) CALL RMTFCO (IERR)
C                                       Shutdown.
      CALL DIE (IERR, BUFF1)
C
 999  STOP
      END
      SUBROUTINE RMTFCI (PRGNAM, NPARMS, IERR)
C-----------------------------------------------------------------------
C   This routine does all the intial set up.  Get parms from AIPS,
C   open the map file, create the plot file and write the plot file
C   records to do the plot labeling.
C   Inputs:
C      PRGNAM C*6    Name of this program.
C      NPARMS I      Number of R words to get from AIPS.
C   Output:
C      IERR   I      Error code. 0=ok.
C-----------------------------------------------------------------------
      CHARACTER PRGNAM*6
      INTEGER   NPARMS, IERR
C
      INTEGER   IWORK(256), TLUN, TIND, KBP, I, JT, JTRIM, IGRP, J
      DOUBLE PRECISION X, V1, V2, TEMP
      LOGICAL   ISAMP
      CHARACTER LINE*72
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
      INCLUDE 'RMTFC.INC'
      DATA TLUN /3/
C-----------------------------------------------------------------------
C                                       Get parameters from AIPS, init
C                                       AIPS I/O, other startup things.
      CALL SETUP (PRGNAM, NPARMS, XINFIL, IWORK, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Open the map file.
C                                       OPEN text file to get info
      CALL H2CHR (48, 1, XINFIL, INFILE)
      CALL H2CHR (48, 1, XOUFIL, OUFILE)
      CALL H2CHR (4, 1, XOPTYP, OPTYPE)
      CALL ZTXOPN ('READ', TLUN, TIND, INFILE, .FALSE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN INPUT TEXT FILE'
         CALL MSGWRT (8)
         GO TO 999
         END IF
C                                       Read for start of first group
 15   CALL ZTXIO ('READ', TLUN, TIND, LINE, IERR)
      IF (IERR.NE.0) GO TO 999
      JT = JTRIM (LINE)
      IF (JT.LE.0) GO TO 15
      IF (LINE(:5).NE.';   K') GO TO 15
      LINE1 = LINE
C                                       parse a start-group card
 20   IGRP = IGRP + 1
      NP = 0
      I = INDEX (LINE, '10^')
      I = I + 3
      READ (LINE(I:I), 1005) J
      SCALE(1) = 10.0 ** (-J)
      I = INDEX (LINE, 'PHASE')
      IF (I.GT.0) THEN
         ISAMP = .TRUE.
         SCALE(2) = 1.0
      ELSE
         ISAMP = .FALSE.
         SCALE(2) = SCALE(1)
         END IF
C                                       read loop
 50   CALL ZTXIO ('READ', TLUN, TIND, LINE, IERR)
      IF (IERR.EQ.0) THEN
         JT = JTRIM (LINE)
         IF (LINE(:5).EQ.';   K') GO TO 20
         IF (JT.LE.0) GO TO 50
         IF ((LINE(:1).NE.' ') .AND. ((LINE(:1).LT.'0') .OR.
     *      (LINE(:1).GT.'9'))) GO TO 50
         KBP = 1
         CALL GETNUM (LINE, 80, KBP, X)
         IF (X.NE.DBLANK) THEN
            CALL GETNUM (LINE, 80, KBP, X)
            IF (X.NE.DBLANK) THEN
               XP(NP+1) = X
               CALL GETNUM (LINE, 80, KBP, X)
               IF (X.NE.DBLANK) THEN
                  V1 = X * SCALE(1)
                  CALL GETNUM (LINE, 80, KBP, X)
                  IF (X.NE.DBLANK) THEN
                     V2 = X * SCALE(2)
                     NP = NP + 1
C                                       convert
                     IF (ISAMP) THEN
                        TEMP = V1 * COS (DG2RAD * V2)
                        BP(NP,2) = V1 * SIN (DG2RAD * V2)
                        BP(NP,1) = TEMP
                     ELSE
                        BP(NP,1) = V1
                        BP(NP,2) = V2
                        END IF
                     END IF
                  END IF
               END IF
            END IF
         GO TO 50
      ELSE IF (IERR.EQ.2) THEN
         CALL ZTXCLS (TLUN, TIND, IERR)
      ELSE
         WRITE (MSGTXT,1000) IERR, 'READ TEXT FILE'
         CALL MSGWRT (8)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I3,' ON ',A)
 1005 FORMAT (I1)
      END
      SUBROUTINE RMTFCO (IERR)
C-----------------------------------------------------------------------
C   Computes model, does croas correlation, writes output
C   Output:
C      IERR   I      Error code. 0=ok.
C-----------------------------------------------------------------------
      INTEGER   IERR
C
      INCLUDE 'RMTFC.INC'
      INTEGER   TLUN, TIND, I, JT, JTRIM, J, K, L, I1, I2, IC, KK
      REAL      MODEL(MAXPNT), V1, V2, TEMP, VS, XLIM(2,2)
      LOGICAL   ISAMP
      CHARACTER LINE*72
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA TLUN /3/
C-----------------------------------------------------------------------
C                                       model
      VS = 0.0
      K = 1
      IF (OPTYPE(4:4).EQ.'2') K = 2
      KK = K
      IF (OPTYPE(:3).EQ.'BOX') THEN
         CALL RCOPY (4, APARM, XLIM)
         DO 20 I = 1,NP
            MODEL(I) = 0.0
            DO 10 J = 1,K
               IF ((XLIM(1,J).LE.XP(I)) .AND. (XLIM(2,J).GE.XP(I)))
     *            MODEL(I) = 1.0
 10            CONTINUE
            VS = VS + MODEL(I)
 20         CONTINUE
      ELSE IF (OPTYPE(:3).EQ.'GAU') THEN
         XLIM(1,1) = APARM(1)
         XLIM(2,1) = APARM(2) / LOG(2.0)
         XLIM(1,2) = APARM(3)
         XLIM(2,2) = APARM(4) / LOG(2.0)
         DO 40 I = 1,NP
            MODEL(I) = 0.0
            DO 30 J = 1,K
               MODEL(I) = MODEL(I) +
     *            EXP (-((XP(I) - XLIM(1,J)) / XLIM(2,J))**2)
 30            CONTINUE
            VS = VS + MODEL(I)
 40         CONTINUE
         END IF
C      IF (SCALE(2).EQ.SCALE(1))  SCALE(2) = SCALE(2) * VS
C      SCALE(1) = SCALE(1) * VS
C                                       convolution
      IC = (NP+1) / 2
      I1 = -(NP / 2)
      I2 = -I1
      DO 100 L = 1,2
         DO 90 K = 1,NP
            YP(K,L) = 0.0
            DO 80 I = 1,NP
               J = K - I + IC
               IF ((J.GE.1) .AND. (J.LE.NP))  THEN
                  YP(K,L) = YP(K,L) + MODEL(I) * BP(J,L)
                  END IF
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
C                                       write output
      CALL ZTXOPN ('WRIT', TLUN, TIND, OUFILE, .TRUE., IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'OPEN OUTPUT TEXT FILE'
         CALL MSGWRT (8)
         GO TO 999
         END IF
      I = INDEX (LINE1, 'PHASE')
      ISAMP =(I.GT.0)
      JT = JTRIM (LINE1)
      CALL ZTXIO ('WRIT', TLUN, TIND, LINE1(:JT), IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'WRITE OUTPUT HEADER LINE'
         GO TO 990
         END IF
      WRITE (LINE,1100) OPTYPE
      JT = JTRIM (LINE)
      CALL ZTXIO ('WRIT', TLUN, TIND, LINE(:JT), IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'WRITE OUTPUT HEADER LINE'
         GO TO 990
         END IF
      WRITE (LINE,1105) (XLIM(1,J), XLIM(2,J), J = 1,KK)
      JT = JTRIM (LINE)
      CALL ZTXIO ('WRIT', TLUN, TIND, LINE(:JT), IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'WRITE OUTPUT HEADER LINE'
         GO TO 990
         END IF
      DO 120 I = 1,NP
         V1 = YP(I,1)
         V2 = YP(I,2)
         IF (ISAMP) THEN
            TEMP = SQRT (V1*V1 + V2*V2)
            IF (TEMP.GT.0.0) V2 = ATAN2 (V2, V1) * RAD2DG
            V1 = TEMP
            END IF
         V1 = V1 / SCALE(1)
         V2 = V2 / SCALE(2)
         WRITE (LINE,1110) I, XP(I), V1, V2
         IF (I.EQ.1) JT = JTRIM (LINE)
         CALL ZTXIO ('WRIT', TLUN, TIND, LINE(:JT), IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'WRITE OUTPUT TEXT LINE'
            GO TO 990
            END IF
 120     CONTINUE
      GO TO 995
C
 990  CALL MSGWRT (8)
C
 995  CALL ZTXCLS (TLUN, TIND, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('RMTFCO ERROR',I4,' ON ',A)
 1100 FORMAT ('; OPTYPE = ''',A,'''')
 1105 FORMAT ('; APARM =',4F8.1)
 1110 FORMAT (I5,F12.1,2F14.2)
      END

