LOCAL INCLUDE 'TADIF.INC'
      INCLUDE 'INCS:PUVD.INC'
      REAL      XSEQ1, XDISK1, XVER1, XSEQ2, XDISK2, XVER2, XBCNT,
     *   XBCNT2, XECNT, XNPRT, XNDIG, DOCRT, XDOHMS, X1, XLIST(40)
      HOLLERITH XINNAM(3), XINCLS(2), XINEXT, XI2NAM(3), XI2CLS(2),
     *   XLPNAM(12)
      CHARACTER INNAM1*12, INCLS1*6, INEXT*2, INNAM2*12, INCLS2*6,
     *   LPNAME*48, FMT(128)*8
      INTEGER   BCOUNT, ECOUNT, DATP1(128,2), BUFF1(512), DATP2(128,2),
     *   BUFF2(512), INSEQ1, INDIS1, INVER1, INSEQ2, INDIS2, INVER2,
     *   CNO1, CNO2, IUSER, NKEY1, NCOL1, OUTLUN, OUTIND, PN1,
     *   COLIST(128), MCOLST, LFMT, NACROS, NIRNO, BCOUN2, NPRINT,
     *   SCRBUF(512), NCOL2, NKEY2, CATBL2(256), TABREC(XBPRSZ),
     *   TABRE2(XBPRSZ)
      REAL      TABR(XBPRSZ)
      LOGICAL   DOHMS
      EQUIVALENCE (TABR, TABREC)
      COMMON /INPARM/ XINNAM, XINCLS, XSEQ1, XDISK1, XINEXT, XVER1,
     *   XI2NAM, XI2CLS, XSEQ2, XDISK2, XVER2, XBCNT, XBCNT2, XECNT,
     *   XNPRT, XNDIG, DOCRT, XLPNAM, XDOHMS, X1, XLIST
      COMMON /CHPARM/ INNAM1, INCLS1, INEXT, INNAM2, INCLS2, LPNAME, FMT
      COMMON /TADIFP/ SCRBUF, CATBL2, BUFF1, BUFF2, DATP1, DATP2,
     *   TABREC, TABRE2, BCOUNT, ECOUNT, INSEQ1, INDIS1, INVER1, CNO1,
     *   INSEQ2, INDIS2, INVER2, CNO2, IUSER, NKEY1, NCOL1, OUTLUN,
     *   OUTIND, DOHMS, PN1, COLIST, MCOLST, LFMT, NACROS, NIRNO, NKEY2,
     *   NCOL2, BCOUN2, NPRINT
LOCAL END
LOCAL INCLUDE 'TADIFC.INC'
      INTEGER   JCOL1, JCOL2, NCH(128), FCH(128), ICH(128), IFMT(128),
     *   KTY(128), LRNO, LRNO2
      COMMON /TADIFC/ NCH, FCH, ICH, IFMT, KTY, JCOL1, JCOL2, LRNO,
     *   LRNO2
LOCAL END
      PROGRAM TADIF
C-----------------------------------------------------------------------
C! Task to print differences of table extension files.
C# Calibration EXT-appl EXT-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2019, 2022-2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   TADIF is an AIPS task to print the contents of generalized, tables
C   format extension files on the line printer or the CRT terminal.
C   AIPS adverbs:                     Use:
C     USERID     USER         User number: 0 -> login, 32000 -> any
C     INNAME     INNAM(3)     Image name: standard defaults, wildcards
C     INCLASS    INCLS(2)     Image class: ditto
C     INSEQ      XSEQ (INSEQ) Image sequence number: ditto
C     INDISK     XDISK (INDISK)  Image disk number: 0 -> any
C     INTYPE     INTYP           Image type: '  ' => any
C     INEXT      INEXT           Extension type: '  ' => 'TA'
C     INVERS     XVER (INVERS)   Extension version number
C     BCOUNT     XBCNT (BCOUNT)  First row number
C     ECOUNT     XECNT (ECOUNT)  Last row number
C     DOCRT      DOCRT           > 0. => CRT, else line printer
C     OUTPRINT   LPNAME          File to save printer output in
C     DOHMS      DOHMS           > 0. print times in hh:mm:ss.s form
C-----------------------------------------------------------------------
      INTEGER   IRET
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'TADIF.INC'
C-----------------------------------------------------------------------
C                                       Get parms, open things
      CALL PRTBIN (IRET)
C                                       check basics
      IF (IRET.EQ.0) CALL BASICS (IRET)
C                                       count line printer printing
      IF (IRET.LE.0) CALL TADICH (IRET)
C                                       do printing
      IF (IRET.EQ.0) THEN
C                                       Open output device
         IF (LPNAME.EQ.' ') DOCRT = MAX (-1.0, DOCRT)
         CALL LPOPEN (LPNAME, DOCRT, OUTLUN, OUTIND, NACROS, SCRBUF,
     *      IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET
            CALL MSGWRT (8)
         ELSE
            CALL PRTBDO (IRET)
            END IF
         END IF
C                                       close down
      IRET = MAX (0, IRET)
      CALL DIE (IRET, SCRBUF)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I5,' OPENING OUTPUT DEVICE')
      END
      SUBROUTINE PRTBIN (IRET)
C-----------------------------------------------------------------------
C   PRTBIN performs initialization for AIPS task TADIF.  It gets the
C   adverbs, opens the catalog file for 'READ', opens the table
C   extension
C   file, and opens the output device.
C   Output: IRET    I      Error code: 0 => keep going, else quit.
C-----------------------------------------------------------------------
      CHARACTER INTYP*2, STAT*4, PRGN*6
      INTEGER   IRET, I4T, NPARM, IROUND, NREC, TLUN1, TLUN2, IERR, I
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'TADIF.INC'
      DATA TLUN1, TLUN2, INTYP /27, 28, '  '/
      DATA PRGN /'TADIF '/
C-----------------------------------------------------------------------
C                                       AIPS init
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      NCFILE = 0
      NSCR = 0
C                                       get adverbs
      NPARM = 77
      IRET = 0
      CALL GTPARM (PRGN, NPARM, RQUICK, XINNAM, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         IRET = 8
         IF (IERR.EQ.1) THEN
            GO TO 999
         ELSE
            WRITE (MSGTXT,1000) IERR
            CALL MSGWRT (8)
            END IF
         END IF
C                                       restart AIPS
      IF ((IRET.NE.0) .OR. (NPOPS.GT.NINTRN) .OR. (ISBTCH.EQ.32000))
     *   DOCRT = MIN (-1.0, DOCRT)
      CALL H2CHR (48, 1, XLPNAM, LPNAME)
      IF (DOCRT.GT.0.0) RQUICK = .FALSE.
      IF (RQUICK) RQUICK = LPNAME.NE.' '
      IF (RQUICK) CALL RELPOP (IRET, SCRBUF, IERR)
      IF (IRET.NE.0) GO TO 999
      IRET = 5
C                                       Hollerith -> Char
      CALL H2CHR (12, 1, XINNAM, INNAM1)
      CALL H2CHR (6, 1, XINCLS, INCLS1)
      CALL H2CHR (2, 1, XINEXT, INEXT)
      CALL H2CHR (12, 1, XI2NAM, INNAM2)
      CALL H2CHR (6, 1, XI2CLS, INCLS2)
      LFMT = 1
      IF (XNDIG.GT.3.0) LFMT = 2
      IF (XNDIG.LE.0.0) LFMT = 3
      IF (XNDIG.LT.-3.0) LFMT = 4
C                                       find image file
      INSEQ1 = IROUND (XSEQ1)
      INDIS1 = IROUND (XDISK1)
      INVER1 = IROUND (XVER1)
      INSEQ2 = IROUND (XSEQ2)
      INDIS2 = IROUND (XDISK2)
      INVER2 = IROUND (XVER2)
      BCOUNT = IROUND (XBCNT)
      ECOUNT = IROUND (XECNT)
      IF (BCOUNT.LE.0) BCOUNT = 1
      BCOUN2 = IROUND (XBCNT2)
      IF (BCOUN2.LE.0) BCOUN2 = BCOUNT
      NPRINT = IROUND (XNPRT)
      IF (NPRINT.LE.0) NPRINT = 25
      IF (INEXT.EQ.' ') INEXT = 'TA'
      IUSER = NLUSER
      DOHMS = XDOHMS.GT.0.0
      PN1 = IROUND (X1)
      IF (PN1.LE.0) PN1 = 100000
      CNO1 = 1
      CALL CATDIR ('SRCH', INDIS1, CNO1, INNAM1, INCLS1, INSEQ1, INTYP,
     *   IUSER, STAT, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1010) IERR, INNAM1, INCLS1, INSEQ1, INTYP,
     *      INDIS1, IUSER
         GO TO 990
         END IF
C                                       Get catblk, mark file read
      CALL CATIO ('READ', INDIS1, CNO1, CATBLK, 'READ', SCRBUF, IERR)
      IF ((IERR.GT.0) .AND. (IERR.LT.5)) THEN
         WRITE (MSGTXT,1020) IERR
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = INDIS1
      FCNO(NCFILE) = CNO1
      FRW(NCFILE) = 0
C                                       Open table file
      NKEY1 = 0
      NCOL1 = 0
      NREC = 0
      CALL TABINI ('READ', INEXT, INDIS1, CNO1, INVER1, CATBLK, TLUN1,
     *   NKEY1, NREC, NCOL1, DATP1, BUFF1, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, INEXT, INVER1
         GO TO 990
         END IF
      I4T = BUFF1(5)
      IF (BCOUNT.GT.I4T) BCOUNT = 1
      IF ((ECOUNT.LT.BCOUNT) .OR. (ECOUNT.GT.I4T)) ECOUNT = I4T
      IF (ECOUNT.LE.9999999) THEN
         NIRNO = 8
      ELSE IF (ECOUNT.LE.99999999) THEN
         NIRNO = 9
      ELSE IF (ECOUNT.LE.999999999) THEN
         NIRNO = 10
      ELSE
         NIRNO = 11
         END IF
C                                       open 2nd file
      CNO2 = 1
      CALL CATDIR ('SRCH', INDIS2, CNO2, INNAM2, INCLS2, INSEQ2, INTYP,
     *   IUSER, STAT, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1010) IERR, INNAM2, INCLS2, INSEQ2, INTYP,
     *      INDIS2, IUSER
         GO TO 990
         END IF
C                                       Get catblk, mark file read
      CALL CATIO ('READ', INDIS2, CNO2, CATBL2, 'READ', SCRBUF, IERR)
      IF ((IERR.GT.0) .AND. (IERR.LT.5)) THEN
         WRITE (MSGTXT,1020) IERR
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = INDIS2
      FCNO(NCFILE) = CNO2
      FRW(NCFILE) = 0
C                                       Open table file
      NKEY2 = 0
      NCOL2 = 0
      NREC = 0
      CALL TABINI ('READ', INEXT, INDIS2, CNO2, INVER2, CATBL2, TLUN2,
     *   NKEY2, NREC, NCOL2, DATP2, BUFF2, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, INEXT, INVER2
         GO TO 990
         END IF
      I = BUFF2(5)
      IF (BCOUN2.GT.I) BCOUN2 = 1
      IF (I.NE.I4T) THEN
         WRITE (MSGTXT,1100) I4T, I
         CALL MSGWRT (7)
         END IF
C                                       set column list
      MCOLST = 0
      DO 10 I = 1,40
         I4T = IROUND (XLIST(I))
         IF ((I4T.GT.0) .AND. (I4T.LE.NCOL1)) THEN
            MCOLST = MCOLST + 1
            COLIST(MCOLST) = I4T
            END IF
 10      CONTINUE
      IF (MCOLST.LE.0) THEN
         DO 15 I = 1,NCOL1
            COLIST(I) = I
 15         CONTINUE
         MCOLST = NCOL1
         END IF
      IRET = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I5,' FINDING INPUT ADVERBS')
 1010 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I3,1X,A2,
     *   'DISK=',I2,' USER=',I5)
 1020 FORMAT ('ERROR',I5,' READING CATBLK FROM CATALOG FILE')
 1030 FORMAT ('ERROR',I5,' OPENING ',A2,' TABLE VERS=',I6)
 1100 FORMAT ('WARNING: NUMBER OF TABLE ROWS',2I7,' DIFFERENT')
      END
      SUBROUTINE BASICS (IRET)
C-----------------------------------------------------------------------
C   Checks the basic stuff: keywords, column IDs, etc
C   Output:
c      IRET   I   Error code  > 0 -> ERROR, < 0 -> DIFFER
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INTEGER   MAXKEY
      PARAMETER (MAXKEY=1024)
      INCLUDE 'TADIF.INC'
      INTEGER   KK, ITY, LENGTH, I, J, LOCS1(MAXKEY), LOCS2(MAXKEY),
     *   KEYT1(MAXKEY), KEYT2(MAXKEY), IERR, RESULT(4), RESLI(4), KT,
     *   VALUE1(2*MAXKEY), VALUE2(2*MAXKEY), JTRIM, JT, NDIF
      LOGICAL   RESLO(4)
      REAL      RES4(4)
      HOLLERITH RESH(4)
      CHARACTER TYPE1*24, TYPE2*24, UNITS1*8, UNITS2*8, CTEMP*4,
     *   DTEMP*4, KEY1(MAXKEY)*8, KEY2(MAXKEY)*8
      DOUBLE PRECISION RES8(2)
      EQUIVALENCE (RESULT, RES8, RES4, RESH, RESLI, RESLO)
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      IRET = 0
      NDIF = 0
      IF (NCOL1.NE.NCOL2) THEN
         WRITE (MSGTXT,1010) NCOL1, NCOL2
         IRET = 1
         GO TO 980
         END IF
      DO 20 KK = 1,NCOL1
         ITY = MOD (DATP1(KK,2), 10)
         LENGTH = DATP1(KK,2) / 10
         I = MOD (DATP2(KK,2), 10)
         J = DATP2(KK,2) / 10
         IF ((ITY.NE.I) .OR. (LENGTH.NE.J)) THEN
            WRITE (MSGTXT,1015) KK, ITY, I, LENGTH, J
            CALL MSGWRT (4)
            NDIF = NDIF + 1
            END IF
         CALL TABIO ('READ', 3, KK, TABREC, BUFF1, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'READ TABLE 1'
            IRET = 8
            GO TO 980
            END IF
         CALL H2CHR (24, 1, TABR, TYPE1)
         JT = JTRIM (TYPE1)
         CALL TABIO ('READ', 3, KK, TABREC, BUFF2, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'READ TABLE 2'
            IRET = 8
            GO TO 980
            END IF
         CALL H2CHR (24, 1, TABR, TYPE2)
         JT = JTRIM (TYPE2)
         CALL TABIO ('READ', 4, KK, TABREC, BUFF1, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'READ TABLE 1'
            IRET = 8
            GO TO 980
            END IF
         CALL H2CHR (8, 1, TABR, UNITS1)
         JT = JTRIM (UNITS1)
         CALL TABIO ('READ', 4, KK, TABREC, BUFF2, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'READ TABLE 2'
            IRET = 8
            GO TO 980
            END IF
         CALL H2CHR (8, 1, TABR, UNITS2)
         JT = JTRIM (UNITS2)
         IF (TYPE1.NE.TYPE2) THEN
            WRITE (MSGTXT,1020) KK, TYPE1(:JTRIM(TYPE1)),
     *         TYPE2(:JTRIM(TYPE2))
            CALL MSGWRT (4)
            NDIF = NDIF + 1
            END IF
         IF (UNITS1.NE.UNITS2) THEN
            WRITE (MSGTXT,1025) KK, TYPE1(:JTRIM(TYPE1)),
     *         TYPE2(:JTRIM(TYPE2))
            CALL MSGWRT (4)
            NDIF = NDIF + 1
            END IF
 20      CONTINUE
      IF (IRET.NE.0) GO TO 999
C                                       keywords
      CALL TABKEY ('ALL ', KEY1, NKEY1, BUFF1, LOCS1, VALUE1, KEYT1,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ KEYWORDS TABLE 1'
         GO TO 980
         END IF
      CALL TABKEY ('ALL ', KEY2, NKEY2, BUFF2, LOCS2, VALUE2, KEYT2,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ KEYWORDS TABLE 2'
         GO TO 980
         END IF
      IF (NKEY1.NE.NKEY2) THEN
         WRITE (MSGTXT,1030) NKEY1, NKEY2
         CALL MSGWRT (4)
         NDIF = NDIF + 1
         END IF
      NKEY1 = MIN (NKEY1, NKEY2)
      DO 30 KK = 1,NKEY1
         IF (KEY1(KK).NE.KEY2(KK)) THEN
            WRITE (MSGTXT,1031) KK, KEY1(KK), KEY2(KK)
            CALL MSGWRT (4)
            NDIF = NDIF + 1
         ELSE IF (KEYT1(KK).NE.KEYT2(KK)) THEN
            WRITE (MSGTXT,1032) KK, KEY1(KK), KEYT1(KK), KEYT2(KK)
            CALL MSGWRT (4)
            NDIF = NDIF + 1
         ELSE
            KT = KEYT1(KK)
C                                       Copy value to RESULT for
C                                       EQUIVALENCE
            CALL COPY (2, VALUE1(LOCS1(KK)), RESULT(1))
            CALL COPY (2, VALUE2(LOCS2(KK)), RESULT(3))
            IF (KT.EQ.1) THEN
               IF (ABS(RES8(1)-RES8(2)).GT.1.E-6) THEN
                  WRITE (MSGTXT,1041) KK, KEY1(KK), RES8(1), RES8(2)
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
            ELSE IF (KT.EQ.2) THEN
               IF (ABS(RES4(1)-RES4(3)).GT.1.E-5) THEN
                  WRITE (MSGTXT,1042) KK, KEY1(KK), RES4(1), RES4(3)
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
            ELSE IF (KT.EQ.3) THEN
               CALL H2CHR (8, 1, RES4(1), CTEMP)
               CALL H2CHR (8, 1, RES4(3), DTEMP)
               JT = JTRIM (CTEMP)
               JT = JTRIM (DTEMP)
               IF (CTEMP.NE.DTEMP) THEN
                  WRITE (MSGTXT,1043) KK, KEY1(KK), CTEMP, DTEMP
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
            ELSE IF (KT.EQ.4) THEN
               IF (RESLI(1).NE.RESLI(3)) THEN
                  WRITE (MSGTXT,1044) KK, KEY1(KK), RESLI(1), RESLI(3)
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
            ELSE IF (KT.EQ.5) THEN
               IF (RESLO(1).NEQV.RESLO(3)) THEN
                  WRITE (MSGTXT,1045) KK, KEY1(KK), RESLI(1), RESLI(3)
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
            ELSE IF (KT.EQ.6) THEN
               IF (RESULT(1).NE.RESULT(3)) THEN
                  WRITE (MSGTXT,1046) KK, KEY1(KK), RESULT(1), RESULT(3)
                  CALL MSGWRT (4)
                  NDIF = NDIF + 1
                  END IF
               END IF
            END IF
 30      CONTINUE
      IF (NDIF.GT.0) THEN
         IRET = -NDIF
         WRITE (MSGTXT,1050) NDIF
         CALL MSGWRT (4)
         END IF
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('BASICS ERROR',I5,' ON ',A)
 1010 FORMAT ('NUMBER COLUMNS:',2I4,' DIFFERENT!')
 1015 FORMAT ('COLUMN',I4,' TYPES',2I2,' LENGTHS',2I5,' DIFFER')
 1020 FORMAT ('COLUMN',I4,' DATA TYPE ''',A,''' ''',A,''' DIFFER')
 1025 FORMAT ('COLUMN',I4,' DATA UNITS ''',A,''' ''',A,''' DIFFER')
 1030 FORMAT ('NUMBER KEYWORDS',2I3,' DIFFER')
 1031 FORMAT ('KEYWORD',I3,'= ''',A,''' ''',A,''' DIFFER')
 1032 FORMAT ('KEYTYPE',I3,1X,A,'= ',3I3,' DIFFER')
 1041 FORMAT ('KEYVAL',I3,1X,A,'= ',2(1PD18.13),' DIFFER')
 1042 FORMAT ('KEYVAL',I3,1X,A,'= ',2(1PE14.7),' DIFFER')
 1043 FORMAT ('KEYVAL',I3,1X,A,'= ''',A,''' ''',A,''' DIFFER')
 1044 FORMAT ('KEYVAL',I3,1X,A,'= ',2I12,' DIFFER')
 1045 FORMAT ('KEYVAL',I3,1X,A,'= ',2L4,' DIFFER')
 1046 FORMAT ('KEYVAL',I3,1X,A,'= ',2I6,' DIFFER')
 1050 FORMAT ('FOUND',I4,' DIFFERENCES IN THE TABLE BASICS')
      END
      SUBROUTINE TADICH (IRET)
C-----------------------------------------------------------------------
C   TADICH checks the output line count for direct to printer
C   Output:
C      IRET   I   Error code: 0 => OK or user terminates,
C                    2 => error writing, 3 => error reading
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MAXKEY
C                                       MAXKEY=max. no. keyword-values
      PARAMETER (MAXKEY=1024)
      CHARACTER TITL1*132, TITL2*132, LINE*132, MSGBUF*72, SCRTCH*132,
     *   COLNUM*132, ALL*4, CTEMP1*132, KEYWRD(MAXKEY)*8, ATIME*8,
     *   ADATE*12, BTIME*8, BDATE*12, SORTOR(5)*8, XROW*4, XNUMB1*8,
     *   XCOLN*8, CTEMP*12, SORTS(2)*12, DOTS*20, XNUMB2*8, STR*4,
     *   LINE1*132, LINE2*132
      INTEGER   IRET, IRNO, RESLI(XBPRSZ), IPRINT, I, J, K, L, M,
     *   N, NLINE, RESULT(XBPRSZ), IERR, II, JJ, NUMKEY, IPOINT,
     *   LOCS(MAXKEY), KEYTYP(MAXKEY), VALUES(4*MAXKEY), LENGTH, MAXLEN,
     *   NCOPY, KT, IEL, JTRIM, KK, NCOUNT, TTY(2)
      LOGICAL   RESLO(XBPRSZ), FIRST, ISDIFF
      REAL      RES4(XBPRSZ), BUFF4(512)
      HOLLERITH RESH(XBPRSZ)
      DOUBLE PRECISION    RES8(XBPRSZ/2)
      INCLUDE 'TADIFC.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'TADIF.INC'
      EQUIVALENCE (BUFF1, BUFF4)
      EQUIVALENCE (RESULT, RES8, RES4, RESH, RESLI, RESLO)
      DATA SORTOR /'ASCEND  ','ASCEAB  ','DESCND  ',
     *   'DESCAB  ', '        '/
      DATA ALL /'ALL '/
      DATA XROW, XNUMB1, XNUMB2, XCOLN /' ROW','F NUMBER','  NUMBER',
     *   'COL. NO.'/
      DATA DOTS /'++++++++++++++++++++'/
      DATA TTY /5,0/
C-----------------------------------------------------------------------
C                                       init counters, line size
      IRET = 0
      IF ((DOCRT.GT.0.0) .OR. (LPNAME.NE.' ')) GO TO 999
      JCOL2 = 0
      FIRST = .TRUE.
      IPRINT = 0
      NCOUNT = 0
      NACROS = 132
C                                       get column dimensions scales
      CALL PRTSCL (KTY, IFMT, ICH, NCH, RESULT, IERR)
      IF (IERR.NE.0) GO TO 960
C                                       Loop: list all columns to fit
 10   JCOL1 = JCOL2 + 1
         MAXLEN = 1
C                                       how many columns this pass
         N = NIRNO + 1
         DO 15 KK = JCOL1,MCOLST
            J = COLIST(KK)
            I = MOD (DATP1(J,2), 10)
            LENGTH = DATP1(J,2) / 10
            NCH(KK) = MIN (NCH(KK), NACROS-10)
            N = N + NCH(KK) + 2
            IF (N.LE.NACROS) JCOL2 = KK
            IF (N.GT.NACROS) GO TO 20
            IF ((I.NE.3) .AND. (I.NE.7)) MAXLEN = MAX (MAXLEN, LENGTH)
 15         CONTINUE
C                                       Blanks between
 20      IF (JCOL2.LT.JCOL1) JCOL2 = JCOL1
         N = 9
         DO 25 KK = JCOL1,JCOL2
            N = N + NCH(KK)
 25         CONTINUE
         N = (NACROS - N) / (JCOL2 - JCOL1 + 1)
         N = MIN (N, 6)
         FCH(JCOL1) = 9 + N
         IF (JCOL1.LT.JCOL2) THEN
            I = JCOL1 + 1
            DO 30 KK = I,JCOL2
               FCH(KK) = FCH(KK-1) + NCH(KK-1) + N
 30            CONTINUE
            END IF
C                                       Primary page: heading info
         IRNO = BUFF1(5)
         SORTS(1) = ' '
         SORTS(2) = ' '
         II = 5
         JJ = 5
         IF (BUFF1(43).GT.0) II = 1
         IF (BUFF1(44).GT.0) JJ = 1
         IF (BUFF1(43).LT.0) II = 3
         IF (BUFF1(44).LT.0) JJ = 3
         IF (BUFF1(43).GT.256) II = 2
         IF (BUFF1(44).GT.256) JJ = 2
         IF (BUFF1(43).LT.-256) II = 4
         IF (BUFF1(44).LT.-256) JJ = 4
         I = ABS(BUFF1(43))
         IF (I.GT.256) I = I - 256
         J = ABS(BUFF1(44))
         IF (J.GT.256) J = J - 256
         IF (I.GT.0) WRITE (CTEMP,1035) I, SORTOR(II)(1:6)
         IF (I.GT.0) SORTS(1)(1:12) = CTEMP(1:12)
         IF (J.GT.0) WRITE (CTEMP,1035) J, SORTOR(JJ)(1:6)
         IF (J.GT.0) SORTS(2)(1:12) = CTEMP(1:12)
         CALL TIMDAT (BUFF1(14), BUFF1(11), ATIME, ADATE)
         CALL TIMDAT (BUFF1(36), BUFF1(33), BTIME, BDATE)
         I = 100 + 1
         N = I + 13
C                                         First page
         NLINE = 900
         IF (.NOT.FIRST) GO TO 90
         NLINE = 999
         WRITE (TITL1,1040) INNAM1, INCLS1, INSEQ1, INDIS1, INEXT,
     *      INVER1
         CALL H2CHR (112, 1, BUFF4(I), CTEMP1)
         M = JTRIM (CTEMP1)
         WRITE (TITL2,1041) CTEMP1
         IF (DOCRT.LE.-2.5) THEN
            NCOUNT = NCOUNT + 1
         ELSE
            CALL H2CHR (5, 1, BUFF4(29), CTEMP1)
            M = JTRIM (CTEMP1)
            WRITE (LINE,1042) CTEMP1, ADATE, ATIME
            NCOUNT = NCOUNT + 1
            CALL H2CHR (5, 1, BUFF4(39), CTEMP1)
            M = JTRIM (CTEMP1)
            WRITE (LINE,1043) CTEMP1, BDATE, BTIME
            NCOUNT = NCOUNT + 1
            END IF
         WRITE (LINE,1044) NCOL1, IRNO, SORTS
         CALL REFRMT (LINE, '_', I)
         NCOUNT = NCOUNT + 1
         IF (PN1.GT.0) THEN
            WRITE (LINE,1045) PN1
            NCOUNT = NCOUNT + 1
            END IF
C                                       selection strings
         IF ((BUFF1(61).GT.0) .AND. (DOCRT.GT.-2.5)) THEN
            N = BUFF1(61)
            DO 55 I = 1,N
               IRNO = I
               CALL TABIO ('READ', 2, IRNO, RESULT, BUFF1, IERR)
               IF (IERR.NE.0) GO TO 960
               M = BUFF1(63+I) - BUFF1(62+I)
               IF (I.EQ.N) M = BUFF1(62) - BUFF1(62+I)
               M = MIN (M, 28)
               IF (16+4*M.GT.NACROS) M = (NACROS - 16)
               CALL H2CHR (M, 1, RES4(1), CTEMP1)
               L = JTRIM (CTEMP1)
               WRITE (LINE,1050) CTEMP1
               NCOUNT = NCOUNT + 1
 55            CONTINUE
            END IF
C                                       Keyword/value pairs
         IF ((BUFF1(53).GT.0) .AND. (JCOL1.LE.1) .AND. (DOCRT.GT.-2.5))
     *      THEN
            NUMKEY = MAXKEY
            NUMKEY = MIN (NUMKEY, BUFF1(53))
            CALL TABKEY (ALL, KEYWRD, NUMKEY, BUFF1, LOCS, VALUES,
     *         KEYTYP, IERR)
            IF (IERR.NE.0) GO TO 90
            WRITE (LINE,1060) BUFF1(53)
            NCOUNT = NCOUNT + 1
            NCOPY = 2
            NCOPY = MAX (NCOPY, 1)
C                                       Loop through keywords.
            DO 70 IEL = 1,NUMKEY
               IPOINT = LOCS(IEL)
               KT = KEYTYP(IEL)
C                                       Copy value to RESULT for
C                                       EQUIVALENCE
               CALL COPY (NCOPY, VALUES(IPOINT), RESULT)
               IF (KT.EQ.1) THEN
                  WRITE (LINE,1061) KEYWRD(IEL), RES8(1)
               ELSE IF (KT.EQ.2) THEN
                  WRITE (LINE,1062) KEYWRD(IEL), RES4(1)
               ELSE IF (KT.EQ.3) THEN
                  CALL H2CHR (8, 1, RES4(1), CTEMP)
                  M = JTRIM (CTEMP)
                  WRITE (LINE,1063) KEYWRD(IEL), CTEMP
               ELSE IF (KT.EQ.4) THEN
                  WRITE (LINE,1064) KEYWRD(IEL), RESLI(1)
               ELSE IF (KT.EQ.5) THEN
                  WRITE (LINE,1065) KEYWRD(IEL), RESLO(1)
               ELSE IF (KT.EQ.6) THEN
                  WRITE (LINE,1066) KEYWRD(IEL), RESULT(1)
                  END IF
               NCOUNT = NCOUNT + 1
 70            CONTINUE
            END IF
C                                       Tell if it can be FITS ASCII
         IF (DOCRT.GT.-2.5) THEN
            IF (BUFF1(60).NE.1) WRITE (LINE,1080)
            IF (BUFF1(60).EQ.1) WRITE (LINE,1081)
            NCOUNT = NCOUNT + 1
            END IF
C                                       List column numbers
 90      TITL1 = ' '
         TITL2 = ' '
         COLNUM = ' '
         LINE = ' '
         COLNUM(1:8) = XCOLN(1:8)
C                                       Column number
         DO 92 KK = JCOL1,JCOL2
            J = COLIST(KK)
            WRITE (CTEMP,1090) J
            N = 1
            IF (J.GT.9) N = 2
            IF (J.GT.99) N = 3
            K = (NCH(KK)+1 - N) / 2
            COLNUM(FCH(KK)+K:FCH(KK)+K+N-1) = CTEMP(6-N:5)
 92         CONTINUE
         IF ((FIRST) .AND. (DOCRT.GT.-2.5)) THEN
            NCOUNT = NCOUNT + 1
            END IF
         NCOUNT = NCOUNT + 1
C                                       Prepare page titles
         TITL1(5:8) = XROW(1:4)
         TITL2(1:8) = XNUMB2(1:8)
         DO 95 KK = JCOL1,JCOL2
            J = COLIST(KK)
C                                       Column label
            IRNO = J
            CALL TABIO ('READ', 3, IRNO, RESULT, BUFF1, IERR)
            IF (IERR.NE.0) GO TO 960
            I = MIN (24, NCH(KK))
            CALL H2CHR (I, 1, RESH(1), SCRTCH(:I))
            M = JTRIM (SCRTCH(:I))
            IF (M.GT.0) TITL1(FCH(KK):) = SCRTCH(:M)
 95         CONTINUE
         DO 99 KK = JCOL1,JCOL2
            J = COLIST(KK)
            IRNO = J
            CALL TABIO ('READ', 4, IRNO, RESULT, BUFF1, IERR)
            IF (IERR.NE.0) GO TO 960
            CALL H2CHR (8, 1, RESH, SCRTCH)
            IF (KTY(KK).GT.10) SCRTCH = 'D/HMS'
            M = JTRIM (SCRTCH(:8))
            IF (M.GT.0) TITL2(FCH(KK):) = SCRTCH(:M)
 99         CONTINUE
C                                       Output the lines
         NCOUNT = NCOUNT + 1
         NCOUNT = NCOUNT + 1
         IF ((DOCRT.GT.-2.5) .AND. (DOCRT.LE.0.0)) THEN
            NCOUNT = NCOUNT + 1
            END IF
C                                       Output loop
         LRNO = 0
         LRNO2 = 0
         DO 150 IRNO = BCOUNT,ECOUNT
C                                       Loop over element in arrays.
            DO 145 IEL = 1,MIN(MAXLEN,PN1)
               IF (ISDIFF (IRNO, IEL, LINE1, LINE2, IERR)) THEN
                  IF (IERR.GT.0) GO TO 960
C                                       row number
                  WRITE (MSGBUF,1100) IRNO
                  LINE1(1:NIRNO) = MSGBUF(13-NIRNO:12)
                  IF (IERR.LT.0) LINE(1:1) = '*'
                  KK = IRNO - BCOUNT + BCOUN2
                  WRITE (MSGBUF,1100) KK
                  LINE2(1:NIRNO) = MSGBUF(13-NIRNO:12)
                  IF (IERR.LT.0) LINE2(1:1) = '*'
C                                       do output finally
                  NCOUNT = NCOUNT + 2
                  IPRINT = IPRINT + 1
                  IF (IPRINT.GE.NPRINT) THEN
                     GO TO 200
                     END IF
                  END IF
               IF (IERR.GT.0) GO TO 960
 145           CONTINUE
 150        CONTINUE
C                                       loop for more columns
         FIRST = .FALSE.
         IF (JCOL2.LT.MCOLST) GO TO 10
C                                       Close down
 200  IF ((NPOPS.GT.NINTRN) .OR. (ISBTCH.EQ.32000)) THEN
         IF (NCOUNT.GT.1000) THEN
            IRET = -1
            END IF
      ELSE IF (NCOUNT.GT.500) THEN
         TTY(1) = 5
         CALL ZOPEN (TTY(1), TTY(2), 1, SCRTCH, .FALSE., .FALSE.,
     *      .TRUE., IRET)
         MSGTXT = 'PROBLEM OPENING TERMINAL'
         IF (IRET.GT.0) GO TO 995
         WRITE (SCRTCH,1200) NCOUNT
         CALL ZTTYIO ('WRIT', TTY(1), TTY(2), 72, SCRTCH, IRET)
         MSGTXT = 'PROBLEM DOING IO TO TERMINAL'
         IF (IRET.GT.0) GO TO 995
         SCRTCH = 'Do you really want to print this much??' //
     *      ' Enter Y or y if so'
         CALL INQSTR (TTY, SCRTCH, 1, STR, IRET)
         IF (IRET.GT.0) GO TO 995
         IF ((STR(:1).NE.'y') .AND. (STR(:1).NE.'Y')) THEN
            IRET = -1
            SCRTCH = 'Good choice - save trees'
         ELSE
            SCRTCH = 'OKAY, printing anyway'
            END IF
         CALL ZTTYIO ('WRIT', TTY(1), TTY(2), 72, SCRTCH, I)
         CALL ZCLOSE (TTY(1), TTY(2), I)
         END IF
      GO TO 999
C                                       errors
 960  IRET = 3
      WRITE (MSGTXT,1960) IERR
      GO TO 995
C
 995  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1035 FORMAT (I3,1X,'(',A6,')')
 1040 FORMAT (A12,'.',A6,'.',I4,'  Disk=',I2,4X,A2,' Table version',
     *   I4)
 1041 FORMAT ('Title: ',A56)
 1042 FORMAT ('Created by      ',A5,' on ',A12,A8)
 1043 FORMAT ('Last written by ',A5,' on ',A12,A8)
 1044 FORMAT ('Ncol',I4,'__Nrow',I12,'____','Sort cols:',2('_',A12))
 1045 FORMAT ('Printing array indices 1 -',I6)
 1050 FORMAT (3X,'Selected on: ',A112)
 1060 FORMAT (3X,' Table has ',I5,' keyword-value pairs:')
 1061 FORMAT (3X,A8,' = ',1PD20.13)
 1062 FORMAT (3X,A8,' = ',1PE14.7)
 1063 FORMAT (3X,A8,' =  ',A8)
 1064 FORMAT (3X,A8,' = ',I12)
 1065 FORMAT (3X,A8,' = ',L2)
 1066 FORMAT (3X,A8,' = ',I6)
 1080 FORMAT (3X,'Table can be written as a FITS ASCII table')
 1081 FORMAT (3X,'Table format incompatable with FITS ASCII tables')
 1090 FORMAT (I5)
 1100 FORMAT (I12)
 1200 FORMAT ('Requested print job is',I10,' lines long!')
 1960 FORMAT ('ERROR',I5,' READING TABLE DATA')
      END
      SUBROUTINE PRTBDO (IRET)
C-----------------------------------------------------------------------
C   PRTBDO reads, formats, and prints a table extension file
C   Output:
C      IRET   I   Error code: 0 => OK or user terminates,
C                    2 => error writing, 3 => error reading
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   MAXKEY
C                                       MAXKEY=max. no. keyword-values
      PARAMETER (MAXKEY=1024)
      CHARACTER TITL1*132, TITL2*132, LINE*132, MSGBUF*72, SCRTCH*132,
     *   COLNUM*132, ALL*4, CTEMP1*132, KEYWRD(MAXKEY)*8, ATIME*8,
     *   ADATE*12, BTIME*8, BDATE*12, SORTOR(5)*8, XROW*4, XNUMB1*8,
     *   XCOLN*8, CTEMP*12, SORTS(2)*12, DOTS*20, XNUMB2*8,
     *   LINE1*132, LINE2*132
      INTEGER   IRET, IRNO, RESLI(XBPRSZ), IPRINT, IPAGE, I, J, K, L, M,
     *   N, NLINE, RESULT(XBPRSZ), IERR, II, JJ, NUMKEY, IPOINT,
     *   LOCS(MAXKEY), KEYTYP(MAXKEY), VALUES(4*MAXKEY), LENGTH, MAXLEN,
     *   NCOPY, KT, IEL, JTRIM, KK
      LOGICAL   RESLO(XBPRSZ), FIRST, ISDIFF
      REAL      RES4(XBPRSZ), BUFF4(512)
      HOLLERITH RESH(XBPRSZ)
      DOUBLE PRECISION    RES8(XBPRSZ/2)
      INCLUDE 'TADIFC.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'TADIF.INC'
      EQUIVALENCE (BUFF1, BUFF4)
      EQUIVALENCE (RESULT, RES8, RES4, RESH, RESLI, RESLO)
      DATA SORTOR /'ASCEND  ','ASCEAB  ','DESCND  ',
     *   'DESCAB  ', '        '/
      DATA ALL /'ALL '/
      DATA XROW, XNUMB1, XNUMB2, XCOLN /' ROW','F NUMBER','  NUMBER',
     *   'COL. NO.'/
      DATA DOTS /'++++++++++++++++++++'/
C-----------------------------------------------------------------------
C                                       init counters, line size
      IRET = 0
      JCOL2 = 0
      FIRST = .TRUE.
      IPRINT = 0
C                                       get column dimensions scales
      CALL PRTSCL (KTY, IFMT, ICH, NCH, RESULT, IERR)
      IF (IERR.NE.0) GO TO 960
C                                       Loop: list all columns to fit
 10   JCOL1 = JCOL2 + 1
         MAXLEN = 1
C                                       how many columns this pass
         N = NIRNO + 1
         DO 15 KK = JCOL1,MCOLST
            J = COLIST(KK)
            I = MOD (DATP1(J,2), 10)
            LENGTH = DATP1(J,2) / 10
            NCH(KK) = MIN (NCH(KK), NACROS-10)
            N = N + NCH(KK) + 2
            IF (N.LE.NACROS) JCOL2 = KK
            IF (N.GT.NACROS) GO TO 20
            IF ((I.NE.3) .AND. (I.NE.7)) MAXLEN = MAX (MAXLEN, LENGTH)
 15         CONTINUE
C                                       Blanks between
 20      IF (JCOL2.LT.JCOL1) JCOL2 = JCOL1
         N = 9
         DO 25 KK = JCOL1,JCOL2
            N = N + NCH(KK)
 25         CONTINUE
         N = (NACROS - N) / (JCOL2 - JCOL1 + 1)
         N = MIN (N, 6)
         FCH(JCOL1) = 9 + N
         IF (JCOL1.LT.JCOL2) THEN
            I = JCOL1 + 1
            DO 30 KK = I,JCOL2
               FCH(KK) = FCH(KK-1) + NCH(KK-1) + N
 30            CONTINUE
            END IF
C                                       Primary page: heading info
         IRNO = BUFF1(5)
         SORTS(1) = ' '
         SORTS(2) = ' '
         II = 5
         JJ = 5
         IF (BUFF1(43).GT.0) II = 1
         IF (BUFF1(44).GT.0) JJ = 1
         IF (BUFF1(43).LT.0) II = 3
         IF (BUFF1(44).LT.0) JJ = 3
         IF (BUFF1(43).GT.256) II = 2
         IF (BUFF1(44).GT.256) JJ = 2
         IF (BUFF1(43).LT.-256) II = 4
         IF (BUFF1(44).LT.-256) JJ = 4
         I = ABS(BUFF1(43))
         IF (I.GT.256) I = I - 256
         J = ABS(BUFF1(44))
         IF (J.GT.256) J = J - 256
         IF (I.GT.0) WRITE (CTEMP,1035) I, SORTOR(II)(1:6)
         IF (I.GT.0) SORTS(1)(1:12) = CTEMP(1:12)
         IF (J.GT.0) WRITE (CTEMP,1035) J, SORTOR(JJ)(1:6)
         IF (J.GT.0) SORTS(2)(1:12) = CTEMP(1:12)
         CALL TIMDAT (BUFF1(14), BUFF1(11), ATIME, ADATE)
         CALL TIMDAT (BUFF1(36), BUFF1(33), BTIME, BDATE)
         I = 100 + 1
         N = I + 13
C                                         First page
         NLINE = 900
         IF (.NOT.FIRST) GO TO 90
         NLINE = 999
         WRITE (TITL1,1040) INNAM1, INCLS1, INSEQ1, INDIS1, INEXT,
     *      INVER1
         CALL H2CHR (112, 1, BUFF4(I), CTEMP1)
         M = JTRIM (CTEMP1)
         WRITE (TITL2,1041) CTEMP1
         IF (DOCRT.LE.-2.5) THEN
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         TITL1, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
         ELSE
            CALL H2CHR (5, 1, BUFF4(29), CTEMP1)
            M = JTRIM (CTEMP1)
            WRITE (LINE,1042) CTEMP1, ADATE, ATIME
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            CALL H2CHR (5, 1, BUFF4(39), CTEMP1)
            M = JTRIM (CTEMP1)
            WRITE (LINE,1043) CTEMP1, BDATE, BTIME
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
         WRITE (LINE,1044) NCOL1, IRNO, SORTS
         CALL REFRMT (LINE, '_', I)
         CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *      LINE, NLINE, IPAGE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 970
         IF (PN1.GT.0) THEN
            WRITE (LINE,1045) PN1
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
C                                       selection strings
         IF ((BUFF1(61).GT.0) .AND. (DOCRT.GT.-2.5)) THEN
            N = BUFF1(61)
            DO 55 I = 1,N
               IRNO = I
               CALL TABIO ('READ', 2, IRNO, RESULT, BUFF1, IERR)
               IF (IERR.NE.0) GO TO 960
               M = BUFF1(63+I) - BUFF1(62+I)
               IF (I.EQ.N) M = BUFF1(62) - BUFF1(62+I)
               M = MIN (M, 28)
               IF (16+4*M.GT.NACROS) M = (NACROS - 16)
               CALL H2CHR (M, 1, RES4(1), CTEMP1)
               L = JTRIM (CTEMP1)
               WRITE (LINE,1050) CTEMP1
               CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *            LINE, NLINE, IPAGE, SCRTCH, IERR)
               IF (IERR.NE.0) GO TO 970
 55            CONTINUE
            END IF
C                                       Keyword/value pairs
         IF ((BUFF1(53).GT.0) .AND. (JCOL1.LE.1) .AND. (DOCRT.GT.-2.5))
     *      THEN
            NUMKEY = MAXKEY
            NUMKEY = MIN (NUMKEY, BUFF1(53))
            CALL TABKEY (ALL, KEYWRD, NUMKEY, BUFF1, LOCS, VALUES,
     *         KEYTYP, IERR)
            IF (IERR.NE.0) GO TO 90
            WRITE (LINE,1060) BUFF1(53)
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            NCOPY = 2
            NCOPY = MAX (NCOPY, 1)
C                                       Loop through keywords.
            DO 70 IEL = 1,NUMKEY
               IPOINT = LOCS(IEL)
               KT = KEYTYP(IEL)
C                                       Copy value to RESULT for
C                                       EQUIVALENCE
               CALL COPY (NCOPY, VALUES(IPOINT), RESULT)
               IF (KT.EQ.1) THEN
                  WRITE (LINE,1061) KEYWRD(IEL), RES8(1)
               ELSE IF (KT.EQ.2) THEN
                  WRITE (LINE,1062) KEYWRD(IEL), RES4(1)
               ELSE IF (KT.EQ.3) THEN
                  CALL H2CHR (8, 1, RES4(1), CTEMP)
                  M = JTRIM (CTEMP)
                  WRITE (LINE,1063) KEYWRD(IEL), CTEMP
               ELSE IF (KT.EQ.4) THEN
                  WRITE (LINE,1064) KEYWRD(IEL), RESLI(1)
               ELSE IF (KT.EQ.5) THEN
                  WRITE (LINE,1065) KEYWRD(IEL), RESLO(1)
               ELSE IF (KT.EQ.6) THEN
                  WRITE (LINE,1066) KEYWRD(IEL), RESULT(1)
                  END IF
               CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *            LINE, NLINE, IPAGE, SCRTCH, IERR)
               IF (IERR.NE.0) GO TO 970
 70            CONTINUE
            END IF
C                                       Tell if it can be FITS ASCII
         IF (DOCRT.GT.-2.5) THEN
            IF (BUFF1(60).NE.1) WRITE (LINE,1080)
            IF (BUFF1(60).EQ.1) WRITE (LINE,1081)
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
C                                       List column numbers
 90      TITL1 = ' '
         TITL2 = ' '
         COLNUM = ' '
         LINE = ' '
         COLNUM(1:8) = XCOLN(1:8)
C                                       Column number
         DO 92 KK = JCOL1,JCOL2
            J = COLIST(KK)
            WRITE (CTEMP,1090) J
            N = 1
            IF (J.GT.9) N = 2
            IF (J.GT.99) N = 3
            K = (NCH(KK)+1 - N) / 2
            COLNUM(FCH(KK)+K:FCH(KK)+K+N-1) = CTEMP(6-N:5)
 92         CONTINUE
         IF ((FIRST) .AND. (DOCRT.GT.-2.5)) THEN
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
         CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *      COLNUM, NLINE, IPAGE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 970
C                                       Prepare page titles
         TITL1(5:8) = XROW(1:4)
         TITL2(1:8) = XNUMB2(1:8)
         DO 95 KK = JCOL1,JCOL2
            J = COLIST(KK)
C                                       Column label
            IRNO = J
            CALL TABIO ('READ', 3, IRNO, RESULT, BUFF1, IERR)
            IF (IERR.NE.0) GO TO 960
            I = MIN (24, NCH(KK))
            CALL H2CHR (I, 1, RESH(1), SCRTCH(:I))
            M = JTRIM (SCRTCH(:I))
            IF (M.GT.0) TITL1(FCH(KK):) = SCRTCH(:M)
 95         CONTINUE
         DO 99 KK = JCOL1,JCOL2
            J = COLIST(KK)
            IRNO = J
            CALL TABIO ('READ', 4, IRNO, RESULT, BUFF1, IERR)
            IF (IERR.NE.0) GO TO 960
            CALL H2CHR (8, 1, RESH, SCRTCH)
            IF (KTY(KK).GT.10) SCRTCH = 'D/HMS'
            M = JTRIM (SCRTCH(:8))
            IF (M.GT.0) TITL2(FCH(KK):) = SCRTCH(:M)
 99         CONTINUE
C                                       Output the lines
         CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *      TITL1, NLINE, IPAGE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 970
         CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *      TITL2, NLINE, IPAGE, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 970
         IF ((DOCRT.GT.-2.5) .AND. (DOCRT.LE.0.0)) THEN
            CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1, TITL2,
     *         LINE, NLINE, IPAGE, SCRTCH, IERR)
            IF (IERR.NE.0) GO TO 970
            END IF
C                                       Output loop
         LRNO = 0
         LRNO2 = 0
         DO 150 IRNO = BCOUNT,ECOUNT
C                                       Loop over element in arrays.
            DO 145 IEL = 1,MIN(MAXLEN,PN1)
               IF (ISDIFF (IRNO, IEL, LINE1, LINE2, IERR)) THEN
                  IF (IERR.GT.0) GO TO 960
C                                       row number
                  WRITE (MSGBUF,1100) IRNO
                  LINE1(1:NIRNO) = MSGBUF(13-NIRNO:12)
                  IF (IERR.LT.0) LINE(1:1) = '*'
                  KK = IRNO - BCOUNT + BCOUN2
                  WRITE (MSGBUF,1100) KK
                  LINE2(1:NIRNO) = MSGBUF(13-NIRNO:12)
                  IF (IERR.LT.0) LINE2(1:1) = '*'
C                                       do output finally
                  CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1,
     *               TITL2, LINE1, NLINE, IPAGE, SCRTCH, IERR)
                  IF (IERR.NE.0) GO TO 970
                  CALL PRTLIN (OUTLUN, OUTIND, DOCRT, NACROS, TITL1,
     *               TITL2, LINE2, NLINE, IPAGE, SCRTCH, IERR)
                  IF (IERR.NE.0) GO TO 970
                  IPRINT = IPRINT + 1
                  IF (IPRINT.GE.NPRINT) THEN
                     MSGTXT = 'Line count limit reached'
                     CALL MSGWRT (3)
                     GO TO 200
                     END IF
                  END IF
               IF (IERR.GT.0) GO TO 960
 145           CONTINUE
 150        CONTINUE
C                                       loop for more columns
         FIRST = .FALSE.
         IF (JCOL2.LT.MCOLST) GO TO 10
C                                       Close down
 200  CALL TABIO ('CLOS', 3, IRNO, RESULT, BUFF1, IERR)
      CALL TABIO ('CLOS', 3, IRNO, RESULT, BUFF2, IERR)
      CALL LPCLOS (OUTLUN, OUTIND, NLINE, IERR)
      GO TO 999
C                                       errors
 960  IRET = 3
      WRITE (MSGTXT,1960) IERR
      GO TO 995
 970  IRET = 0
      IF (IERR.LT.0) GO TO 200
         IRET = 2
         WRITE (MSGTXT,1970) IERR
C
 995  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1035 FORMAT (I3,1X,'(',A6,')')
 1040 FORMAT (A12,'.',A6,'.',I4,'  Disk=',I2,4X,A2,' Table version',
     *   I4)
 1041 FORMAT ('Title: ',A56)
 1042 FORMAT ('Created by      ',A5,' on ',A12,A8)
 1043 FORMAT ('Last written by ',A5,' on ',A12,A8)
 1044 FORMAT ('Ncol',I4,'__Nrow',I12,'____','Sort cols:',2('_',A12))
 1045 FORMAT ('Printing array indices 1 -',I6)
 1050 FORMAT (3X,'Selected on: ',A112)
 1060 FORMAT (3X,' Table has ',I5,' keyword-value pairs:')
 1061 FORMAT (3X,A8,' = ',1PD20.13)
 1062 FORMAT (3X,A8,' = ',1PE14.7)
 1063 FORMAT (3X,A8,' =  ',A8)
 1064 FORMAT (3X,A8,' = ',I12)
 1065 FORMAT (3X,A8,' = ',L2)
 1066 FORMAT (3X,A8,' = ',I6)
 1080 FORMAT (3X,'Table can be written as a FITS ASCII table')
 1081 FORMAT (3X,'Table format incompatable with FITS ASCII tables')
 1090 FORMAT (I5)
 1100 FORMAT (I12)
 1960 FORMAT ('ERROR',I5,' READING TABLE DATA')
 1970 FORMAT ('ERROR',I5,' WRITING OUTPUT')
      END
      LOGICAL FUNCTION ISDIFF (IRNO, IEL, LINE1, LINE2, IRET)
C-----------------------------------------------------------------------
C   ISDIFF compares two table rows and formats them if they differ.
C   Input:
C      IRNO    I       Row number table 1
C      IEL     I       Subscript
C   Output:
C      LINE1   C*(*)   PRTAB row table 1
C      LINE2   C*(*)   PRTAB row table 2
C      IRET    I       I/O error code
C      ISDIFF  L       True if rows differ
C-----------------------------------------------------------------------
      INTEGER   IRNO, IEL, IRET
      CHARACTER LINE1*(*), LINE2*(*)
C
      INCLUDE 'TADIF.INC'
      INCLUDE 'TADIFC.INC'
      CHARACTER MSGBUF*72, TSGBUF*72, SCRTCH*132, CHSIGN*1
      INTEGER   KK, I, K, J, IERR, IERR2, RESULT(XBPRSZ), RESLI(XBPRSZ),
     *   TESULT(XBPRSZ), TESLI(XBPRSZ), IRNO2, JTRIM, HMS(3), L, LENGTH,
     *   M, N, RTYPE, BITS(64)
      LOGICAL   RESLO(XBPRSZ), TESLO(XBPRSZ)
      REAL      RES4(XBPRSZ), TES4(XBPRSZ), SEC, TDAY
      HOLLERITH RESH(XBPRSZ), TESH(XBPRSZ)
      DOUBLE PRECISION RES8(XBPRSZ/2), TES8(XBPRSZ/2)
      EQUIVALENCE (RESULT, RES8, RES4, RESH, RESLI, RESLO)
      EQUIVALENCE (TESULT, TES8, TES4, TESH, TESLI, TESLO)
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      ISDIFF = .FALSE.
      IRNO2 = IRNO - BCOUNT + BCOUN2
      LINE1 = ' '
      LINE2 = ' '
      DO 100 KK = JCOL1,JCOL2
         J = COLIST(KK)
C                                       get data.
         CALL GETCOL (IRNO, J, DATP1, LRNO, BUFF1, RTYPE, RESULT,
     *      TABREC, IERR)
         CALL GETCOL (IRNO2, J, DATP2, LRNO2, BUFF2, RTYPE, TESULT,
     *      TABRE2, IERR2)
         IF ((IERR.GT.0) .OR. (IERR2.GT.0)) GO TO 960
         IF ((IERR.LT.0) .AND. (IERR2.LT.0)) GO TO 999
         I = KTY(KK)
C                                       See which have data.
         LENGTH = RTYPE/10
         IF (LENGTH.LT.IEL) GO TO 100
         IF ((IEL.GT.1) .AND. ((I.EQ.3).OR.(I.EQ.7))) GO TO 100
C                                       character
         IF (I.EQ.3) THEN
            L = FCH(KK) + MAX (0, (NCH(KK)-ICH(KK))/2)
            CALL H2CHR (ICH(KK), 1, RESH, SCRTCH)
            M = JTRIM (SCRTCH(:ICH(KK)))
            IF (M.GT.0) LINE1(L:L+M-1) = SCRTCH(:M)
            CALL H2CHR (ICH(KK), 1, TESH, SCRTCH)
            M = JTRIM (SCRTCH(:ICH(KK)))
            IF (M.GT.0) LINE2(L:L+M-1) = SCRTCH(:M)
C                                       bit
         ELSE IF (I.EQ.7) THEN
            L = FCH(KK) + MAX (0, (NCH(KK)-ICH(KK))/2)
            N = (ICH(KK) - 1) / NBITWD + 1
            DO 25 I = 1,N
               M = NBITWD
               IF (I.EQ.N) M = ICH(KK) - (N-1)*NBITWD
               CALL ZGTBIT (M, RESULT(I), BITS)
               WRITE (MSGBUF,1120) (BITS(K), K = 1,M)
               LINE1(L:L+M-1) = MSGBUF(1:M)
               L = L + M
 25            CONTINUE
            L = FCH(KK) + MAX (0, (NCH(KK)-ICH(KK))/2)
            N = (ICH(KK) - 1) / NBITWD + 1
            DO 26 I = 1,N
               M = NBITWD
               IF (I.EQ.N) M = ICH(KK) - (N-1)*NBITWD
               CALL ZGTBIT (M, TESULT(I), BITS)
               WRITE (MSGBUF,1120) (BITS(K), K = 1,M)
               LINE2(L:L+M-1) = MSGBUF(1:M)
               L = L + M
 26            CONTINUE
C                                       numeric
         ELSE
C                                       double precision
            IF (I.EQ.1) THEN
               IF (RES8(IEL).EQ.DBLANK) THEN
                  IF (NCH(KK).GE.4) THEN
                     MSGBUF = ' '
                     MSGBUF(NCH(KK)-3:) = 'INDE'
                  ELSE
                     MSGBUF = 'INDE'
                     END IF
               ELSE IF (IFMT(KK).EQ.1) THEN
                  WRITE (MSGBUF,1101) RES8(IEL)
               ELSE IF (IFMT(KK).EQ.2) THEN
                  WRITE (MSGBUF,1111) RES8(IEL)
               ELSE
                  WRITE (MSGBUF,FMT(KK)) RES8(IEL)
                  END IF
               IF (TES8(IEL).EQ.DBLANK) THEN
                  IF (NCH(KK).GE.4) THEN
                     TSGBUF = ' '
                     TSGBUF(NCH(KK)-3:) = 'INDE'
                  ELSE
                     TSGBUF = 'INDE'
                     END IF
               ELSE IF (IFMT(KK).EQ.1) THEN
                  WRITE (TSGBUF,1101) TES8(IEL)
               ELSE IF (IFMT(KK).EQ.2) THEN
                  WRITE (TSGBUF,1111) TES8(IEL)
               ELSE
                  WRITE (TSGBUF,FMT(KK)) TES8(IEL)
                  END IF
               END IF
C                                       single precision
            IF (I.EQ.2) THEN
               IF (RES4(IEL).EQ.FBLANK) THEN
                  IF (NCH(KK).GE.4) THEN
                     MSGBUF = ' '
                     MSGBUF(NCH(KK)-3:) = 'INDE'
                  ELSE
                     MSGBUF = 'INDE'
                     END IF
               ELSE IF (IFMT(KK).EQ.1) THEN
                  WRITE (MSGBUF,1102) RES4(IEL)
               ELSE IF (IFMT(KK).EQ.2) THEN
                  WRITE (MSGBUF,1112) RES4(IEL)
               ELSE
                  WRITE (MSGBUF,FMT(KK)) RES4(IEL)
                  END IF
               IF (TES4(IEL).EQ.FBLANK) THEN
                  IF (NCH(KK).GE.4) THEN
                     TSGBUF = ' '
                     TSGBUF(NCH(KK)-3:) = 'INDE'
                  ELSE
                     TSGBUF = 'INDE'
                     END IF
               ELSE IF (IFMT(KK).EQ.1) THEN
                  WRITE (TSGBUF,1102) TES4(IEL)
               ELSE IF (IFMT(KK).EQ.2) THEN
                  WRITE (TSGBUF,1112) TES4(IEL)
               ELSE
                  WRITE (TSGBUF,FMT(KK)) TES4(IEL)
                  END IF
               END IF
            IF (I.EQ.4) THEN
               WRITE (MSGBUF,1103) RESLI(IEL)
               WRITE (TSGBUF,1103) TESLI(IEL)
               END IF
            IF (I.EQ.5) THEN
               WRITE (MSGBUF,1104) RESLO(IEL)
               WRITE (TSGBUF,1104) TESLO(IEL)
               END IF
            IF (I.EQ.6) THEN
               WRITE (MSGBUF,1103) RESULT(IEL)
               WRITE (TSGBUF,1103) TESULT(IEL)
               END IF
C                                       time in h:m:s.s
            IF (I.GT.10) THEN
               IF (I.EQ.12) THEN
                  TDAY = RES4(IEL)
               ELSE
                  TDAY = RES8(IEL)
                  END IF
               CALL TFDHMS (TDAY, 1, CHSIGN, HMS, SEC)
               WRITE (MSGBUF,1107) HMS, SEC
               IF (MSGBUF(11:11).EQ.' ') MSGBUF(11:11) = '0'
               IF (MSGBUF(12:12).EQ.' ') MSGBUF(12:12) = '0'
               IF (CHSIGN.EQ.'-') THEN
                  IF (MSGBUF(2:2).EQ.' ') THEN
                     MSGBUF(2:2) = CHSIGN
                  ELSE
                     MSGBUF(ICH(KK):ICH(KK)) = CHSIGN
                     END IF
                  END IF
               IF (I.EQ.12) THEN
                  TDAY = TES4(IEL)
               ELSE
                  TDAY = TES8(IEL)
                  END IF
               CALL TFDHMS (TDAY, 1, CHSIGN, HMS, SEC)
               WRITE (TSGBUF,1107) HMS, SEC
               IF (TSGBUF(11:11).EQ.' ') TSGBUF(11:11) = '0'
               IF (TSGBUF(12:12).EQ.' ') TSGBUF(12:12) = '0'
               IF (CHSIGN.EQ.'-') THEN
                  IF (TSGBUF(2:2).EQ.' ') THEN
                     TSGBUF(2:2) = CHSIGN
                  ELSE
                     TSGBUF(ICH(KK):ICH(KK)) = CHSIGN
                     END IF
                  END IF
               END IF
            LINE1(FCH(KK):FCH(KK)+NCH(KK)-1) = MSGBUF(ICH(KK):)
            LINE2(FCH(KK):FCH(KK)+NCH(KK)-1) = TSGBUF(ICH(KK):)
            END IF
 100     CONTINUE
      ISDIFF = LINE1.NE.LINE2
      GO TO 999
C
 960  IRET = 3
      WRITE (MSGTXT,1960) IERR, IERR2
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1101 FORMAT (1PD13.6)
 1102 FORMAT (1PE10.3)
 1111 FORMAT (1PD17.10)
 1112 FORMAT (1PE13.6)
 1103 FORMAT (I12)
 1104 FORMAT (11X,L1)
 1107 FORMAT (I3,'/',I2.2,':',I2.2,':',F4.1)
 1120 FORMAT (64I1)
 1960 FORMAT ('ERRORS',2I5,' READING TABLE DATA')
      END
      SUBROUTINE PRTSCL (KTY, IFMT, ICH, NCH, RESULT, IERR)
C-----------------------------------------------------------------------
C   determines the number of characters required for each column
C   In/out (common):
C      DOHMS    L        Do conversion Days -> HH MM SS.S ?
C   Outputs:
C      KTY      I(128)   type of column: 1-7 = dp, sp, ch, i, l, i
C                           11,12 = dp and sp time in D/HMS
C      IFMT     I(128)   format type code - 1,2 exp   3,4 Fm.n
C      ICH      I(128)   start character position; number characters in
C                        actual data for character and bit columns
C      NCH      I(128)   number of characters: assume formats
C                        Level 1: 1PD13.6, 1PE10.3, I12, L12
C                        Level 2: 1PD17.10, 1PE13.6, I12, L12
C      RESULT   I(*)     buffer
C      IERR     I        TABIO error code
C   Common:
C      FMT      C(*)*8   F type format to use
C-----------------------------------------------------------------------
      INTEGER   KTY(128), IFMT(128), ICH(128), NCH(128), RESULT(*),
     *   IERR
C
      INTEGER   LCH(7,4), I, J, LENGTH, IMX(128), IMN(128), LMN(128), K,
     *   IL, JTRIM, IC, IRNO, TCNT, KK, LL, LEC, IDUM(32), JJ,
     *   ISRES(128), IDRES(256)
      CHARACTER HDR(128)*24, TSTR*128, UNITS*24
      REAL      SMN(128), SMX(128), SRES(128), SMA(128), TEMP, RDUM(32)
      DOUBLE PRECISION DRES(128)
      EQUIVALENCE (IDUM, RDUM), (ISRES, SRES), (IDRES, DRES)
      INCLUDE 'TADIF.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LCH /13, 10, 0, 1, 1, 1, 0,
     *          17, 13, 0, 1, 1, 1, 0,
     *          13, 10, 0, 1, 1, 1, 0,
     *          17, 13, 0, 1, 1, 1, 0/
C-----------------------------------------------------------------------
C                                       set non-integer lengths
      K = 0
      IERR = 0
      TCNT = 0
      DO 20 KK = 1,MCOLST
         J = COLIST(KK)
C                                       basics
         I = MOD (DATP1(J,2), 10)
         KTY(KK) = I
         LENGTH = DATP1(J,2) / 10
         ICH(KK) = 1
         NCH(KK) = LCH(I,LFMT)
         IFMT(KK) = LFMT
C                                       check header, units strings
         CALL TABIO ('READ', 3, J, RESULT, BUFF1, IERR)
         IF (IERR.NE.0) GO TO 999
         CALL COPY (6, RESULT, IDUM)
         CALL H2CHR (24, 1, RDUM, HDR(KK))
         IL = JTRIM (HDR(KK))
         IF (IL.GT.9) IL = MIN (8, IL)
         CALL TABIO ('READ', 4, J, RESULT, BUFF1, IERR)
         IF (IERR.NE.0) GO TO 999
         CALL COPY (2, RESULT, IDUM)
         CALL H2CHR (8, 1, RDUM, UNITS)
         IC = JTRIM (UNITS)
         IC = MAX (IC, IL, 2)
C                                       is it a time?
         IF ((I.LT.3) .AND. (DOHMS) .AND. (UNITS(:8).EQ.'DAYS') .AND.
     *      (HDR(KK)(:4).EQ.'TIME')) THEN
            KTY(KK) = 10 + I
            NCH(KK) = 10
            ICH(KK) = 5
            TCNT = TCNT + 1
            IC = MAX (IC, 5)
            END IF
         LMN(KK) = LENGTH
         IMN(KK) = 2000000000
         IMX(KK) = -IMN(KK)
         SMN(KK) = 1.E20
         SMX(KK) = -SMN(KK)
         SMA(KK) = SMN(KK)
         IF (I.EQ.3) THEN
            ICH(KK) = 1
            NCH(KK) = 1
         ELSE IF (I.EQ.7) THEN
            NCH(KK) = LENGTH
            ICH(KK) = LENGTH
         ELSE
            IF (I.EQ.5) ICH(KK) = 12 - IC/2
            END IF
         NCH(KK) = MAX (IC, NCH(KK))
 20      CONTINUE
      DOHMS = TCNT.GT.0
C                                       find integer max/min(s)
C                                       find length of chars too
      LEC = BCOUNT + 50000
      LEC = MIN (LEC, ECOUNT)
      DO 140 IRNO = BCOUNT,LEC
C                                       get row
         CALL TABIO ('READ', 0, IRNO, TABREC, BUFF1, IERR)
         IF (IERR.GT.0) GO TO 999
         IF (IERR.LT.0) GO TO 140
         DO 135 KK = 1,MCOLST
            J = COLIST(KK)
            K = DATP1(J,1)
            LENGTH = LMN(KK)
C                                       integer
            IF ((KTY(KK).EQ.4) .OR. (KTY(KK).EQ.6)) THEN
C                                       get data.
               CALL COPY (LENGTH, TABREC(K), RESULT)
C                                       get max/min
               DO 110 I = 1,LENGTH
                  IMN(KK) = MIN (IMN(KK), RESULT(I))
                  IMX(KK) = MAX (IMX(KK), RESULT(I))
 110              CONTINUE
C                                       characters
            ELSE IF (KTY(KK).EQ.3) THEN
               LENGTH = LMN(KK)
               LENGTH = MIN (LENGTH, 128)
               K = DATP1(J,1)
               JJ = (LENGTH + 3) / 4
               CALL COPY (JJ, TABREC(K), IDUM)
               CALL H2CHR (LENGTH, 1, RDUM, TSTR(:LENGTH))
               K = JTRIM (TSTR(:LENGTH))
               ICH(KK) = MAX (K, ICH(KK))
C                                       single float
            ELSE IF (KTY(KK).EQ.2) THEN
C                                       get data.
               LENGTH = MIN (128, LENGTH)
               CALL COPY (LENGTH, TABREC(K), ISRES)
C                                       get max/min
               DO 115 I = 1,LENGTH
                  IF (SRES(I).NE.FBLANK) THEN
                     SMN(KK) = MIN (SMN(KK), SRES(I))
                     IF (SRES(I).NE.0.0) SMA(KK) = MIN (SMA(KK),
     *                  ABS(SRES(I)))
                     SMX(KK) = MAX (SMX(KK), SRES(I))
                     END IF
 115              CONTINUE
C                                       double float
            ELSE IF (KTY(KK).EQ.1) THEN
C                                       get data.
               LENGTH = MIN (128, LENGTH) * NWDPDP
               K = (K-1) * NWDPDP + 1
               CALL COPY (LENGTH, TABREC(K), IDRES)
C                                       get max/min
               LENGTH = LENGTH / NWDPDP
               DO 120 I = 1,LENGTH
                  IF (DRES(I).NE.DBLANK) THEN
                     SRES(I) = DRES(I)
                     SMN(KK) = MIN (SMN(KK), SRES(I))
                     SMX(KK) = MAX (SMX(KK), SRES(I))
                     IF (SRES(I).NE.0.0) SMA(KK) = MIN (SMA(KK),
     *                  ABS(SRES(I)))
                     END IF
 120              CONTINUE
C                                       time
            ELSE IF (KTY(KK).EQ.12) THEN
C                                       get data.
               LENGTH = MIN (128, LENGTH)
               CALL COPY (LENGTH, TABREC(K), ISRES)
C                                       get max/min
               DO 125 I = 1,LENGTH
                  RESULT(I) = SRES(I)
                  SMN(KK) = MIN (SMN(KK), SRES(I))
                  IMN(KK) = MIN (IMN(KK), RESULT(I))
                  IMX(KK) = MAX (IMX(KK), RESULT(I))
 125              CONTINUE
C                                       time
            ELSE IF (KTY(KK).EQ.11) THEN
C                                       get data.
               LENGTH = MIN (128, LENGTH) * NWDPDP
               K = (K-1) * NWDPDP + 1
               CALL COPY (LENGTH, TABREC(K), IDRES)
C                                       get max/min
               LENGTH = LENGTH / NWDPDP
               DO 130 I = 1,LENGTH
                  RESULT(I) = DRES(I)
                  IMN(KK) = MIN (IMN(KK), RESULT(I))
                  IMX(KK) = MAX (IMX(KK), RESULT(I))
                  TEMP = DRES(I)
                  SMN(KK) = MIN (SMN(KK), TEMP)
 130           CONTINUE
               END IF
 135        CONTINUE
 140     CONTINUE
C                                       to characters
      DO 150 KK = 1,MCOLST
         IF ((KTY(KK).EQ.4) .OR. (KTY(KK).EQ.6)) THEN
            IMN(KK) = -10 * IMN(KK)
            K = MAX (IMX(KK), IMN(KK))
            LENGTH = 1
            IF (K.GT.9) LENGTH = 2
            IF (K.GT.99) LENGTH = 3
            IF (K.GT.999) LENGTH = 4
            IF (K.GT.9999) LENGTH = 5
            IF (K.GT.99999) LENGTH = 6
            IF (K.GT.999999) LENGTH = 7
            IF (K.GT.9999999) LENGTH = 8
            IF (K.GT.99999999) LENGTH = 9
            IF (K.GT.999999999) LENGTH = 10
            IF (LENGTH.GE.NCH(KK)) THEN
               NCH(KK) = LENGTH
               ICH(KK) = 13 - LENGTH
            ELSE
               ICH(KK) = 12 - (NCH(KK) + LENGTH - 1) / 2
               END IF
         ELSE IF (KTY(KK).EQ.3) THEN
            NCH(KK) = MAX (NCH(KK), ICH(KK))
         ELSE IF (KTY(KK).LT.3) THEN
C                                       no max min found
            IF (SMN(KK).GT.SMX(KK)) THEN
               IF (LFMT.LE.2) THEN
                  SMN(KK) = -1.0
                  SMX(KK) = 1.0
                  END IF
               END IF
C                                       check format
            IF (LFMT.GT.2) THEN
               TEMP = MAX (ABS(SMN(KK)), ABS(SMX(KK)))
               IF ((TEMP.GT.0.0) .AND. (TEMP.LT.10.0**(2-2*LFMT)))
     *            IFMT(KK) = LFMT - 2
               END IF
            IF (IFMT(KK).LE.2) THEN
               IF (SMN(KK).LT.0.0) THEN
                  NCH(KK) = MAX (NCH(KK), LCH(KTY(KK),LFMT))
               ELSE
                  ICH(KK) = 2
                  END IF
            ELSE IF (SMN(KK).GT.SMX(KK)) THEN
               IF (LFMT.EQ.3) THEN
                  FMT(KK) = '(F9.4)'
                  NCH(KK) = 9
               ELSE
                  FMT(KK) = '(F12.6)'
                  NCH(KK) = 12
                  END IF
            ELSE
               IF (SMN(KK).LT.0.0) SMX(KK) = MAX (-10.*SMN(KK),
     *            ABS (SMX(KK)))
               IF (SMX(KK).EQ.0.0) THEN
                  K = 2
               ELSE
                  K = LOG10 (SMX(KK))
                  END IF
               K = MAX (1, K+1)
               IF (SMN(KK).LT.0) K = K + 1
               IF ((SMA(KK).NE.0.0) .AND. (SMA(KK).NE.1.E20)) THEN
                  I = LOG10 (SMA(KK))
               ELSE
                  I = -1
                  END IF
               IF (KTY(KK).EQ.2) THEN
                  LL = 0
               ELSE
                  LL = 3
                  END IF
               IF (LFMT.EQ.3) THEN
                  I = MAX (2+LL, -I+2)
               ELSE
                  I = MAX (5+LL, -I+2)
                  END IF
               IF (I+K+1.GT.NCH(KK)) I = NCH(KK) - K - 1
               I = MAX (0, I)
               NCH(KK) = I + K + 1
               WRITE (FMT(KK),1000) NCH(KK), I
               CALL DEFRMT (FMT(KK), ' ', I)
               END IF
         ELSE IF (KTY(KK).GT.10) THEN
            IF (HDR(KK).EQ.'TIME') ICH(KK) = 3
            IF (IMX(KK).GT.0) ICH(KK) = 3
            IF (IMX(KK).GT.9) ICH(KK) = 2
            IF (IMX(KK).GT.99) ICH(KK) = 1
            IF (SMN(KK).LT.0.0) ICH(KK) = MIN (2, ICH(KK))
            IF (IMN(KK).LT.-9) ICH(KK) = 1
            NCH(KK) = MAX (NCH(KK), 15-ICH(KK))
            END IF
 150     CONTINUE
      IERR = 0
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('(F',I2,'.',I2,')')
      END
