LOCAL INCLUDE 'XMBUFRS'
      INCLUDE 'INCS:PMAD.INC'
      REAL     BUFF1(MABFSS), BUFF2(MABFSS)
      INTEGER  SCRTCH(512)
      COMMON /BUFRS/ BUFF1, BUFF2, SCRTCH
LOCAL END
LOCAL INCLUDE 'UNSPX.INC'
      INCLUDE 'XMBUFRS'
      CHARACTER NAMEIN(3)*12, CLAIN(3)*6, NAMOUT*12, CLAOUT*6
      HOLLERITH XNAMEI(3), XCLAIN(2), XNAMOU(3), XCLAOU(2), XNAME2(3),
     *   XCLAS2(2), XNAME3(3), XCLAS3(2), CATOH(256,4)
      REAL      XSEQIN, XDISKI, XSEQO, XDISKO, XSEQ2, XDISK2, XSEQ3,
     *   XDISK3, BLC(7), TRC(7), DOBLNK, BADD(10)
      DOUBLE PRECISION CATOD(128,4), FV, RV, DV, RA0, DE0, DEFREQ,
     *   XFREQ(MAXIMG)
      REAL      CATOR(256,4), PMIN, PMAX, FI, RI, DI, FR, RR, DR,
     *   MROT
      INTEGER   CATOLD(256,3), SEQIN(3), SEQOUT, DISKIN(3), DISKO,
     *   NEWCNO, OLDCNO(3), JBUFSZ, FAX, RAX, DAX, NCOUT
      COMMON /INPARM/ XNAMEI, XCLAIN, XSEQIN, XDISKI, XNAMOU, XCLAOU,
     *   XSEQO, XDISKO, XNAME2, XCLAS2, XSEQ2, XDISK2, XNAME3, XCLAS3,
     *   XSEQ3, XDISK3, BLC, TRC, DOBLNK, BADD
      COMMON /CHPARM/ NAMEIN, CLAIN, NAMOUT, CLAOUT
      COMMON /PARMS/ CATOLD, FV, RV, DV, RA0, DE0, XFREQ, DEFREQ,
     *   PMAX, PMIN, SEQIN, SEQOUT, DISKIN, DISKO, NEWCNO, OLDCNO,
     *   JBUFSZ, FI, RI, DI, FR, RR, DR, FAX, RAX, DAX, MROT, NCOUT
      EQUIVALENCE (CATOLD, CATOR, CATOH, CATOD)
LOCAL END
      PROGRAM UNSPX
C-----------------------------------------------------------------------
C! UNSPX corrects a cube for spectral index model
C# Map-util Spectral
C-----------------------------------------------------------------------
C;  Copyright (C) 2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   UNSPX fits 1-dimensional spectral inices to rows of an image.  It
C   fits
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input image.
C      INCLASS        CLAIN         Class of input image.
C      INSEQ          SEQIN         Seq. of input image.
C      INDISK         DISKIN        Disk number of input image.
C      OUTNAME        NAMOUT        Name of the output image
C                                   Default output is input image.
C      OUTSEQ         SEQOUT        Seq. number of output image.
C      OUTDISK        DISKO         Disk number of the output image.
C      BLC(7)         BLC           Bottom left corner of subimage
C                                   of input image.
C      TRC(7)         TRC           Top right corner of subimage.
C      FLUX           FCUT          Flux cutoff: use only data >
C                                   FLUX.
C      OPTYPE         XOPTYP        '': Blank illegal velocities;
C      BADD(10)       IBAD          Disk numbers to avoid.
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, NWORDS, NX, NY, NM
      REAL      MAPS(2)
      LONGINT   PMAPS
      INCLUDE 'UNSPX.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA PRGM /'UNSPX'/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL UNSPXI (PRGM, IRET)
      IF (IRET.NE.0) GO TO 995
      NX = CATOLD(KINAX,2)
      NY = CATOLD(KINAX+1,2)
      NM = 2
      IF (NAMEIN(3).EQ.' ') NM = 1
      NWORDS = (2 * NX * NY - 1) / 1024 + 4
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, MAPS, PMAPS, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'STARTING UP TASK'
         GO TO 990
         END IF
      NWORDS = 2 * NX * NY
      CALL RFILL (NWORDS, 0.0, MAPS(1+PMAPS))
C                                       read in model
      CALL UNSPXG (NX, NY, NM, MAPS(1+PMAPS), IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING MODEL IMAGES'
         GO TO 990
         END IF
C                                       do output
      IF (RAX.EQ.1) THEN
         CALL UNSPX1 (NX, NY, NM, MAPS(1+PMAPS), IRET)
      ELSE
         CALL UNSPX2 (NX, NY, NM, MAPS(1+PMAPS), IRET)
         END IF
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'WRITING OUTPUT IMAGE'
         GO TO 990
         END IF
C                                       history to output
      CALL UNSPXH
      GO TO 995
C
 990  CALL MSGWRT (8)
C                                       Close down files, etc.
 995  CALL DIE (IRET, SCRTCH)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('ERROR',I5,' ON ',A)
      END
      SUBROUTINE UNSPXI (PRGN, IRET)
C-----------------------------------------------------------------------
C   UNSPXI gets input parameters for UNSPX.
C   Inputs:
C      PRGN   C*6   Program name (2 chars/word)
C   Output:
C      IRET   I      Error code: 0 => ok
C                                4 => user routine detected error.
C                                5 => catalog troubles
C                                8 => can't start
C                               <0 => failed to get all frequencies
C      /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      CHARACTER STAT*4, PRGN*6, OTYPE*8, MTYPE*2, FRQTYP*8
      INTEGER   IRET, I, IERR, NPARM, IROUND, NAX, J, DUM, FLX, FOFF
      DOUBLE PRECISION C1CRV
      REAL      C1CRP, C1CIC
      INCLUDE 'UNSPX.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:PSTD.INC'
      DATA FRQTYP /'FREQ'/
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      JBUFSZ = 2 * MABFSS
      IRET = 0
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
C                                       Get input parameters.
C                                       Fixed PPM 1996.09.30: was 38
      NPARM = 53
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         IRET = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR, 'GETTING ADVERB VALUES'
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (IRET, SCRTCH, IERR)
      IF (IRET.NE.0) GO TO 999
      IRET = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAMEI, NAMEIN(1))
      CALL H2CHR (6, 1, XCLAIN, CLAIN(1))
      CALL H2CHR (12, 1, XNAME2, NAMEIN(2))
      CALL H2CHR (6, 1, XCLAS2, CLAIN(2))
      CALL H2CHR (12, 1, XNAME3, NAMEIN(3))
      CALL H2CHR (6, 1, XCLAS3, CLAIN(3))
      CALL H2CHR (12, 1, XNAMOU, NAMOUT)
      CALL H2CHR (6, 1, XCLAOU, CLAOUT)
      SEQIN(1) = IROUND (XSEQIN)
      SEQIN(2) = IROUND (XSEQ2)
      SEQIN(3) = IROUND (XSEQ3)
      SEQOUT = IROUND (XSEQO)
      DISKIN(1) = IROUND (XDISKI)
      DISKIN(2) = IROUND (XDISK2)
      DISKIN(3) = IROUND (XDISK3)
      DISKO = IROUND (XDISKO)
      DO 20 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 20      CONTINUE
C                                       Get CATBLK from old file.
      OLDCNO(1) = 1
      MTYPE = 'MA'
      CALL CATDIR ('SRCH', DISKIN(1), OLDCNO(1), NAMEIN(1), CLAIN(1),
     *   SEQIN(1), MTYPE, NLUSER, STAT, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1020) IERR, NAMEIN(1), CLAIN(1), SEQIN(1),
     *      DISKIN(1), NLUSER
         GO TO 990
         END IF
C                                       Read CATBLK and mark 'READ'.
      CALL CATIO ('READ', DISKIN(1), OLDCNO(1), CATOLD(1,1), 'READ',
     *   SCRTCH,IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'READING IMAGE HEADER'
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN(1)
      FCNO(NCFILE) = OLDCNO(1)
      FRW(NCFILE) = 0
C                                       Copy old CATBLK to new.
      CALL COPY (256, CATOLD(1,1), CATBLK)
C                                       Put new values in CATBLK.
      CALL MAKOUT (NAMEIN, CLAIN, SEQIN, ' ', NAMOUT, CLAOUT,
     *   SEQOUT)
      CALL CHR2H (12, NAMOUT, KHIMNO, CATH(KHIMN))
      CALL CHR2H (6, CLAOUT, KHIMCO, CATH(KHIMN))
      CATBLK(KIIMS) = SEQOUT
C                                       Set defaults on BLC,TRC
      CALL WINDOW (CATOLD(KIDIM,1), CATOLD(KINAX,1), BLC, TRC, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Get modification to CATBLK
      DUM = 0.0
      CALL SUBHDR (BLC, TRC, DUM, DUM)
      NEWCNO = 0
C                                       Make names, classes, disks OK.
      CALL H2CHR (12, KHIMNO, CATH(KHIMN), NAMOUT)
      CALL H2CHR (6, KHIMCO, CATH(KHIMN), CLAOUT)
      PMAX = -1.E15
      PMIN = -PMAX
C                                       PBCORR parameters
      FAX = 0
      FLX = 0
      RAX = 0
      DAX = 0
      NAX = CATOLD(KIDIM,1)
      DO 40 I = 1,NAX
         CALL H2CHR (8, 1, CATOH(KHCTP+2*(I-1),1), OTYPE)
         IF (OTYPE(:4).EQ.'FREQ') THEN
            FAX = I
            J = I
            FV = CATOD(KDCRV+I-1,1)
            FI = CATOR(KRCIC+I-1,1)
            FR = CATOR(KRCRP+I-1,1)
         ELSE IF (OTYPE(:8).EQ.'SEQ.NUM.') THEN
            FLX = I
         ELSE IF (OTYPE(:8).EQ.'FQID') THEN
            FLX = I
         ELSE IF ((OTYPE(:2).EQ.'RA') .OR. (OTYPE(2:4).EQ.'LON')) THEN
            RAX = I
            RV = CATOD(KDCRV+I-1,1) * DG2RAD
            RI = CATOR(KRCIC+I-1,1) * DG2RAD
            RR = CATOR(KRCRP+I-1,1)
         ELSE IF ((OTYPE(:3).EQ.'DEC') .OR. (OTYPE(2:4).EQ.'LAT')) THEN
            DAX = I
            DV = CATOD(KDCRV+I-1,1) * DG2RAD
            DI = CATOR(KRCIC+I-1,1) * DG2RAD
            DR = CATOR(KRCRP+I-1,1)
            MROT = CATOR(KRCRT+I-1,1) * DG2RAD
            END IF
 40      CONTINUE
      RA0 = CATOD(KDORA,1) * DG2RAD
      DE0 = CATOD(KDODE,1) * DG2RAD
      IF ((RA0.EQ.0.0D0) .AND. (DE0.EQ.0.0D0)) THEN
         RA0 = RV
         DE0 = DV
         END IF
C                                       model images
      DO 60 I = 2,3
         IF ((I.EQ.3) .AND. (NAMEIN(I).EQ.' ')) GO TO 60
         OLDCNO(I) = 1
         MTYPE = 'MA'
         CALL CATDIR ('SRCH', DISKIN(I), OLDCNO(I), NAMEIN(I), CLAIN(I),
     *      SEQIN(I), MTYPE, NLUSER, STAT, SCRTCH, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1020) IERR, NAMEIN(I), CLAIN(I), SEQIN(I),
     *         DISKIN(I), NLUSER
            GO TO 990
            END IF
C                                       Read CATBLK and mark 'READ'.
         CALL CATIO ('READ', DISKIN(I), OLDCNO(I), CATOLD(1,I), 'READ',
     *      SCRTCH, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'READING IMAGE HEADER'
            GO TO 990
            END IF
         NCFILE = NCFILE + 1
         FVOL(NCFILE) = DISKIN(I)
         FCNO(NCFILE) = OLDCNO(I)
         FRW(NCFILE) = 0
C                                       does it match
         IF ((CATOLD(KINAX,I).NE.CATBLK(KINAX+RAX-1)) .OR.
     *      (CATOLD(KINAX+1,I).NE.CATBLK(KINAX+DAX-1))) THEN
            WRITE (MSGTXT,1060) I
            IERR = 10
            GO TO 990
            END IF
         CALL AXEFND (8, FRQTYP, CATOLD(KIDIM,I), CATOH(KHCTP,I),
     *      FOFF, IERR)
         IF (IERR.NE.0) THEN
            WRITE (MSGTXT,1000) IERR, 'FINDING FREQ AXIS'
            GO TO 990
            END IF
         IF (I.EQ.2) THEN
            DEFREQ = CATOD(KDCRV+FOFF,I)
         ELSE
            IF (ABS(CATOD(KDCRV+FOFF,I)-DEFREQ).GT.100.) THEN
               IERR = 10
               WRITE (MSGTXT,1061) I
               GO TO 990
               END IF
            END IF
 60      CONTINUE
      IF ((DAX.NE.RAX+1) .OR. (RAX.GT.2)) THEN
         IERR = 10
         MSGTXT = 'INPUT IMAGE WRONG TRANSPOSITION'
         GO TO 990
         END IF
C                                       Create
      DISKO = XDISKO + 0.01
      NEWCNO = 1
      CALL MCREAT (DISKO, NEWCNO, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'CREATING OUTPUT IMAGE FILE'
         GO TO 990
         END IF
C                                       Record the creation
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKO
      FCNO(NCFILE) = NEWCNO
      FRW(NCFILE) = 2
      NCOUT = NCFILE
      SEQOUT = CATBLK(KIIMS)
C                                       copy most keywords
      CALL KEYPCP (DISKIN, OLDCNO, DISKO, NEWCNO, 0, ' ', IERR)
      IRET = 0
C                                       get frequencies
      IF (FLX.EQ.0) FLX = FAX
      NAX = CATOLD(KINAX+FLX-1,1)
      CALL H2CHR (8, 1, CATOH(KHCTP+2*(FLX-1),1), OTYPE)
      IF (OTYPE(:4).EQ.'FREQ') THEN
         DO 110 I = 1,NAX
            XFREQ(I) = FV + FI * (I - FR)
            XFREQ(I) = LOG10 (XFREQ(I)/DEFREQ)
 110        CONTINUE
      ELSE IF (OTYPE.EQ.'SEQ.NUM.') THEN
         CALL HIGET (DISKIN(1), OLDCNO(1), NAX, DEFREQ, XFREQ, IRET)
      ELSE
         C1CRV = CATOD(KDCRV+FLX-1,1)
         C1CRP = CATOR(KRCRP+FLX-1,1)
         C1CIC = CATOR(KRCIC+FLX-1,1)
         CALL FQGET (DISKIN(1), OLDCNO(1), NAX, FV, C1CRV, C1CRP, C1CIC,
     *      CATOLD(1,1), DEFREQ, XFREQ, IRET)
         END IF
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UNSPXI: ERROR',I3,' ON ',A)
 1020 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I3,' DISK=',
     *   I2,' USID=',I5)
 1060 FORMAT ('UNSPXI: MODEL IMAGE',I2,' XY DIMENSIONS DO NOT MATCH')
 1061 FORMAT ('UNSPXI: MODEL IMAGE',I2,' REFERENCE FREQ DOES NOT MATCH')
      END
      SUBROUTINE FQGET (DISK, CNO, NF, FV, CV, CP, CI, CATBLK, DEFREQ,
     *   XFREQ, IRET)
C-----------------------------------------------------------------------
C   Gets the frequencies from the FQ table
C   Inputs:
C      DISK     I        disk
C      CNO      I        calatog number
C      NF       I        Number of frequencies
C      FV       D        Header ref frequency
C      CV       D        FQID axis ref value
C      CP       D        FQID axis ref pixel
C      CI       D        FQID axis increment
C      CATBLK   I(256)   old image header
C      DEFREQ   D        ref freq
C   Outputs:
C      XFREQ    D(*)     LOG10(freq/FV)
C      IERR     I        Error code
C-----------------------------------------------------------------------
      INTEGER   DISK, CNO, NF, CATBLK(*), IRET
      DOUBLE PRECISION FV, CV, DEFREQ, XFREQ(*)
      REAL      CP, CI
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   BUFFER(512), VER, LUN, IFQRNO, FQKOLS(MAXFQC),
     *   FQNUMV(MAXFQC), NUMIF, FQID, IFSIDE, IREC, NREC, I, MF
      DOUBLE PRECISION IFFREQ
      REAL      IFCHW, IFTBW
      CHARACTER BNDCOD*8
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       open
      VER = 1
      LUN = 20
      NUMIF = 1
      CALL FQINI ('READ', BUFFER, DISK, CNO, VER, CATBLK, LUN, IFQRNO,
     *   FQKOLS, FQNUMV, NUMIF, IRET)
      IF (IRET.NE.0) GO TO 999
      NREC = BUFFER(5)
C                                       read
      DO 10 IREC = 1,NREC
         CALL TABFQ ('READ', BUFFER, IFQRNO, FQKOLS, FQNUMV, NUMIF,
     *      FQID, IFFREQ, IFCHW, IFTBW, IFSIDE, BNDCOD, IRET)
         IF (IRET.NE.0) GO TO 20
         I = (FQID - CV) / CI + CP + 0.5
         IF ((I.GE.1) .AND. (I.LE.NF)) XFREQ(I) = IFFREQ + FV
 10      CONTINUE
 20   CALL TABFQ ('CLOS', BUFFER, IFQRNO, FQKOLS, FQNUMV, NUMIF,
     *   FQID, IFFREQ, IFCHW, IFTBW, IFSIDE, BNDCOD, IREC)
C                                       test
      MF = NF
      DO 30 I = 1,NF
         IF (XFREQ(I).GT.0.0D0) THEN
            MF = MF - 1
            XFREQ(I) = LOG10 (XFREQ(I)/DEFREQ)
            END IF
 30      CONTINUE
      IF (IRET.LE.0) IRET = -MF
      IF (MF.GT.0) THEN
         WRITE (MSGTXT,1030) MF
         CALL MSGWRT (7)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT ('WARNING:',I3,' FREQUENCY PLANES NOT FOUND IN FQ FILE')
      END
      SUBROUTINE HIGET (DISK, CNO, NF, DEFREQ, XFREQ, IRET)
C-----------------------------------------------------------------------
C   HIGET tries to get the frequencies from the history file
C   Inputs:
C      DISK    I      Disk number
C      CNO     I      Catalog number
C      NF      I      Number of frequencies
C   Output
C      XFREQ   D(*)   Frequencies
C      IRET    I      Error code
C-----------------------------------------------------------------------
      INTEGER   DISK, CNO, NF, IRET
      DOUBLE PRECISION DEFREQ, XFREQ(*)
C
      INTEGER   IHLUN, NREC, IHPTR, HIBUFF(256), IBLK, ICARD, IP, MF,
     *   ICUR, IHIND, II
      CHARACTER LINE*72, CTYP*8
      DOUBLE PRECISION X
      REAL      HRBUFF(256)
      EQUIVALENCE (HIBUFF, HRBUFF)
      INCLUDE 'INCS:DHIS.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      MF = 0
      CALL DFILL (NF, 0.0D0, XFREQ)
C                                       open history file
      IHLUN = 27
C                                       Open history file.
      CALL HIINIT (3)
      CALL HIOPEN (IHLUN, DISK, CNO, HIBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      CALL HILOCT ('SRCH', IHLUN, IHPTR, IRET)
      IF (IRET.NE.0) GO TO 100
C                                       Determine no. of hist. recs.
      NREC = HITAB(IHPTR+2)
      IHIND = HITAB(IHPTR+1)
      IBLK = 0
      ICARD = NHILPR
      DO 20 ICUR = 1,NREC
C                                       Read next buffer.
         ICARD = ICARD + 1
         IF (ICARD.GT.NHILPR) THEN
            IBLK = IBLK + 1
            ICARD = 1
            CALL ZFIO ('READ', IHLUN, IHIND, IBLK, HIBUFF, IRET)
            IF (IRET.NE.0) GO TO 100
            END IF
C                                       desired task?
         II = (ICARD-1) * NHIWPL + 5
         CALL H2CHR (72, 1, HRBUFF(II), LINE)
         IF (LINE(:12).EQ.'MCUBE COORD=') THEN
            READ (LINE,1000) X, CTYP, IP
C                                       test
            IF ((CTYP(:4).EQ.'FREQ') .AND. (IP.GT.0) .AND. (IP.LE.NF))
     *         THEN
               XFREQ(IP) = X
               MF = MF + 1
               WRITE (MSGTXT,1001) CTYP, X, IP
               CALL MSGWRT (3)
            ELSE
               WRITE (MSGTXT,1010) X, CTYP, IP
               CALL MSGWRT (7)
               END IF
            END IF
 20      CONTINUE
C                                       Close history file.
 100  CALL HICLOS (IHLUN, .FALSE., HIBUFF, II)
C                                       fill it all in??
      MF = NF
      DO 110 II = 1,NF
         IF (XFREQ(II).GT.0.0D0) THEN
            MF = MF - 1
            XFREQ(II) = LOG10 (XFREQ(II)/DEFREQ)
            END IF
 110     CONTINUE
      IF (IRET.LE.0) IRET = -MF
      IF (MF.GT.0) THEN
         WRITE (MSGTXT,1110) MF
         CALL MSGWRT (7)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT (12X,E13.5,5X,13X,A8,11X,I5)
 1001 FORMAT ('Found in MCUBE history ',A8,' F=',1PE13.5,' plane',I5)
 1010 FORMAT ('Coordinate mismatch',1PE13.5,' ''',A8,''' plane',I5)
 1110 FORMAT ('WARNING:',I3,
     *   ' FREQUENCY PLANES NOT FOUND IN HISTORY FILE')
      END
      SUBROUTINE UNSPXG (NX, NY, NM, MAPS, IRET)
C-----------------------------------------------------------------------
C   UNSPXG reads in the 1 or 2 model images
c   Inputs:
C      NX      I      Number X pixels
C      NY      I      Number Y pixels
C      NM      I      Number model images
C   Outputs:
C      NMAPS   R(*)   model images
C      IRET    I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NM, IRET
      REAL      MAPS(NX,NY,NM)
C
      INCLUDE 'UNSPX.INC'
      INCLUDE 'XMBUFRS'
      INTEGER   I, J, IY, LUN, FIND, LUNTMP, BIND, BLKOF, WIN(4)
      CHARACTER PNAME*48
      INCLUDE 'INCS:DMSG.INC'
      DATA BLKOF /1/
C-----------------------------------------------------------------------
      DO 30 I = 1,NM
         J = I + 1
         CALL ZPHFIL ('MA', DISKIN(J), OLDCNO(J), 1, PNAME, IRET)
         LUN = LUNTMP (0)
         CALL ZOPEN (LUN, FIND, DISKIN(J), PNAME, .TRUE., .FALSE.,
     *      .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) J, IRET, 'OPEN FILE'
            GO TO 990
            END IF
         WIN(1) = 1
         WIN(2) = 1
         WIN(3) = NX
         WIN(4) = NY
         CALL MINIT ('READ', LUN, FIND, NX, NY, WIN, BUFF1, JBUFSZ,
     *      BLKOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) J, IRET, 'INIT I/O'
            GO TO 990
            END IF
         DO 20 IY = 1,NY
            CALL MDISK ('READ', LUN, FIND, BUFF1, BIND, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) J, IRET, 'READ IMAGE FILE'
               GO TO 990
               END IF
            CALL RCOPY (NX, BUFF1(BIND), MAPS(1,IY,I))
 20         CONTINUE
         CALL ZCLOSE (LUN, FIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) J, IRET, 'CLOSE IMAGE FILE'
            GO TO 990
            END IF
 30      CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UNSPXG IMAGE',I2,' RROR',I4,' ON ',A)
      END
      SUBROUTINE UNSPXH
C-----------------------------------------------------------------------
C   UNSPXH copies and updates history file.
C-----------------------------------------------------------------------
C
      CHARACTER HILINE*72
      INTEGER   LUN1, LUN2, IERR
      LOGICAL   T
      INCLUDE 'UNSPX.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA LUN1, LUN2 /27,28/
      DATA T /.TRUE./
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       Copy/open history file.
      CALL HISCOP (LUN1, LUN2, DISKIN(1), DISKO, OLDCNO(1), NEWCNO,
     *   CATBLK, SCRTCH(257), SCRTCH, IERR)
      IF (IERR.LE.2) GO TO 10
         WRITE (MSGTXT,1000) IERR
         CALL MSGWRT (6)
         GO TO 50
C                                       New history
 10   CALL HENCO1 (TSKNAM, NAMEIN(1), CLAIN(1), SEQIN(1), DISKIN(1),
     *   LUN2, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
      CALL HENCO2 (TSKNAM, NAMEIN(2), CLAIN(2), SEQIN(2), DISKIN(2),
     *   LUN2, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
      IF (NAMEIN(3).NE.' ') THEN
         CALL HENCO3 (TSKNAM, NAMEIN(3), CLAIN(3), SEQIN(3), DISKIN(3),
     *      LUN2, SCRTCH, IERR)
         IF (IERR.NE.0) GO TO 50
         END IF
      CALL HENCOO (TSKNAM, NAMOUT, CLAOUT, SEQOUT, DISKO, LUN2,
     *   SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
C                                       BLC
      WRITE (HILINE,2000) TSKNAM, BLC
      CALL HIADD (LUN2, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
C                                       TRC
      WRITE (HILINE,2001) TSKNAM, TRC
      CALL HIADD (LUN2, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
C                                       DOBLANK
      IF (DOBLNK.GT.0.0) THEN
         HILINE = TSKNAM // 'DOBLANK = 1   ' //
     *      '/ output not blanked when model blanked'
      ELSE
         HILINE = TSKNAM // 'DOBLANK = -1  ' //
     *      '/ output blanked when model blanked'
         END IF
      CALL HIADD (LUN2, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
C                                       ref freq
      WRITE (HILINE,2025) TSKNAM, DEFREQ/1.D9
      CALL HIADD (LUN2, HILINE, SCRTCH, IERR)
      IF (IERR.NE.0) GO TO 50
C                                       Close HI file
 50   CALL HICLOS (LUN2, T, SCRTCH, IERR)
C                                        Update CATBLK and close
      CALL CATIO ('UPDT', DISKO, NEWCNO, CATBLK, 'CLWR', SCRTCH, IERR)
      FRW(NCOUT) = -1
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UNSPXH: ERROR',I3,' COPY/OPEN HISTORY FILE')
 2000 FORMAT (A6,'BLC =',6(F6.0,','),F6.0)
 2001 FORMAT (A6,'TRC =',6(F6.0,','),F6.0)
 2025 FORMAT (A6,'REFREQ = ',F9.4,4X,'/ reference frequency GHz')
      END
      SUBROUTINE UNSPX1 (NX, NY, NM, MAPS, IRET)
C-----------------------------------------------------------------------
C   UNSPX1 applies the model to an XYF cube
c   Inputs:
C      NX      I      Number X pixels
C      NY      I      Number Y pixels
C      NM      I      Number model images
C      NMAPS   R(*)   model images
C   Outputs:
C      IRET    I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NM, IRET
      REAL      MAPS(NX,NY,*)
C
      INCLUDE 'UNSPX.INC'
      INCLUDE 'XMBUFRS'
      INTEGER   IX, IY, IZ, LUN1, LUN2, FIND1, FIND2, BIND1, BIND2,
     *   DEPTH(5), BLKOF, WINI(4), LUNTMP, NZ, WINO(4), LZ
      CHARACTER PNAME*48
      REAL      TMOD
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      WINI(1) = BLC(1) + 0.1
      WINI(2) = BLC(2) + 0.1
      WINI(3) = TRC(1) + 0.1
      WINI(4) = TRC(2) + 0.1
      CALL ZPHFIL ('MA', DISKIN(1), OLDCNO(1), 1, PNAME, IRET)
      LUN1 = LUNTMP(0)
      CALL ZOPEN (LUN1, FIND1, DISKIN(1), PNAME, .TRUE., .FALSE.,
     *   .TRUE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN INPUT FILE'
         GO TO 990
         END IF
      WINO(1) = 1
      WINO(2) = 1
      WINO(3) = NX
      WINO(4) = NY
      CALL ZPHFIL ('MA', DISKO, NEWCNO, 1, PNAME, IRET)
      LUN2 = LUNTMP(0)
      CALL ZOPEN (LUN2, FIND2, DISKO, PNAME, .TRUE., .TRUE., .TRUE.,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN OUTPUT FILE'
         GO TO 990
         END IF
      NZ = CATBLK(KINAX+2)
      DO 50 LZ = 1,NZ
         IZ = LZ + BLC(3) - 0.9
         DEPTH(1) = IZ
         CALL COMOFF (CATOLD(KIDIM,1), CATOLD(KINAX,1), DEPTH, BLKOF,
     *      IRET)
         BLKOF = BLKOF + 1
         CALL MINIT ('READ', LUN1, FIND1, CATOLD(KINAX,1),
     *      CATOLD(KINAX+1,1), WINI, BUFF1, JBUFSZ, BLKOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT READ I/O'
            GO TO 990
            END IF
         DEPTH(1) = LZ
         CALL COMOFF (CATBLK(KIDIM), CATBLK(KINAX), DEPTH, BLKOF, IRET)
         BLKOF = BLKOF + 1
         CALL MINIT ('WRIT', LUN2, FIND2, NX, NY, WINO, BUFF2, JBUFSZ,
     *      BLKOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT READ I/O'
            GO TO 990
            END IF
         DO 30 IY = 1,NY
            CALL MDISK ('READ', LUN1, FIND1, BUFF1, BIND1, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ INPUT IMAGE'
               GO TO 990
               END IF
            CALL MDISK ('WRIT', LUN2, FIND2, BUFF2, BIND2, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT IMAGE'
               GO TO 990
               END IF
            DO 20 IX = 1,NX
               IF ((BUFF1(BIND1+IX-1).EQ.FBLANK) .OR.
     *            (MAPS(IX,IY,1).EQ.FBLANK) .OR.
     *            (MAPS(IX,IY,2).EQ.FBLANK)) THEN
                  IF (DOBLNK.LE.0.0) THEN
                     BUFF2(BIND2+IX-1) = FBLANK
                  ELSE
                     BUFF2(BIND2+IX-1) = BUFF1(BIND1+IX-1)
                     END IF
               ELSE
                  TMOD =  MAPS(IX,IY,1) * XFREQ(IZ) + MAPS(IX,IY,2) *
     *               (XFREQ(IZ)**2)
                  TMOD = 10.0 ** TMOD
                  IF (TMOD.LE.0.0) THEN
                     IF (DOBLNK.LE.0.0) THEN
                        BUFF2(BIND2+IX-1) = FBLANK
                     ELSE
                        BUFF2(BIND2+IX-1) = BUFF1(BIND1+IX-1)
                        END IF
                  ELSE
                     BUFF2(BIND2+IX-1) = BUFF1(BIND1+IX-1) / TMOD
                     PMIN = MIN (PMIN, BUFF2(BIND2+IX-1))
                     PMAX = MAX (PMAX, BUFF2(BIND2+IX-1))
                     END IF
                  END IF
 20            CONTINUE
 30         CONTINUE
         CALL MDISK ('FINI', LUN2, FIND2, BUFF2, BIND2, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINISH WRITE PLANE'
            GO TO 990
            END IF
 50      CONTINUE
      CALL ZCLOSE (LUN1, FIND1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE INPUT FILE'
         END IF
      CALL ZCLOSE (LUN2, FIND2, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE OUTPUT FILE'
         END IF
      CATR(KRDMX) = PMAX
      CATR(KRDMN) = PMIN
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UNSPX1 ERROR',I4,' ON ',A)
      END
      SUBROUTINE UNSPX2 (NX, NY, NM, MAPS, IRET)
C-----------------------------------------------------------------------
C   UNSPX2 applies the model to an FXY cube
c   Inputs:
C      NX      I      Number X pixels
C      NY      I      Number Y pixels
C      NM      I      Number model images
C      NMAPS   R(*)   model images
C   Outputs:
C      IRET    I      error code
C-----------------------------------------------------------------------
      INTEGER   NX, NY, NM, IRET
      REAL      MAPS(NX,NY,*)
C
      INCLUDE 'UNSPX.INC'
      INCLUDE 'XMBUFRS'
      INTEGER   IX, IY, IZ, LUN1, LUN2, FIND1, FIND2, BIND1, BIND2,
     *   DEPTH(5), BLKOF, WINI(4), LUNTMP, NZ, WINO(4), LZ
      CHARACTER PNAME*48
      REAL      TMOD
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA DEPTH /5*1/
C-----------------------------------------------------------------------
      NZ = CATBLK(KINAX)
      WINI(1) = BLC(1) + 0.1
      WINI(2) = BLC(2) + 0.1
      WINI(3) = TRC(1) + 0.1
      WINI(4) = TRC(2) + 0.1
      CALL ZPHFIL ('MA', DISKIN(1), OLDCNO(1), 1, PNAME, IRET)
      LUN1 = LUNTMP(0)
      CALL ZOPEN (LUN1, FIND1, DISKIN(1), PNAME, .TRUE., .FALSE.,
     *   .TRUE., IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN INPUT FILE'
         GO TO 990
         END IF
      WINO(1) = 1
      WINO(2) = 1
      WINO(3) = NZ
      WINO(4) = NX
      CALL ZPHFIL ('MA', DISKO, NEWCNO, 1, PNAME, IRET)
      LUN2 = LUNTMP(0)
      CALL ZOPEN (LUN2, FIND2, DISKO, PNAME, .TRUE., .TRUE., .TRUE.,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN OUTPUT FILE'
         GO TO 990
         END IF
      DO 50 IY = 1,NY
         DEPTH(1) = IY + BLC(3) - 0.9
         CALL COMOFF (CATOLD(KIDIM,1), CATOLD(KINAX,1), DEPTH, BLKOF,
     *      IRET)
         BLKOF = BLKOF + 1
         CALL MINIT ('READ', LUN1, FIND1, CATOLD(KINAX,1),
     *      CATOLD(KINAX+1,1), WINI, BUFF1, JBUFSZ, BLKOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT READ I/O'
            GO TO 990
            END IF
         DEPTH(1) = IY
         CALL COMOFF (CATBLK(KIDIM), CATBLK(KINAX), DEPTH, BLKOF, IRET)
         BLKOF = BLKOF + 1
         CALL MINIT ('WRIT', LUN2, FIND2, NZ, NX, WINO, BUFF2, JBUFSZ,
     *      BLKOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT READ I/O'
            GO TO 990
            END IF
         DO 30 IX = 1,NX
            CALL MDISK ('READ', LUN1, FIND1, BUFF1, BIND1, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ INPUT IMAGE'
               GO TO 990
               END IF
            CALL MDISK ('WRIT', LUN2, FIND2, BUFF2, BIND2, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'WRITE OUTPUT IMAGE'
               GO TO 990
               END IF
            DO 20 LZ = 1,NZ
               IZ = LZ + BLC(1) - 0.9
               IF ((BUFF1(BIND1+IZ-1).EQ.FBLANK) .OR.
     *            (MAPS(IX,IY,1).EQ.FBLANK) .OR.
     *            (MAPS(IX,IY,2).EQ.FBLANK)) THEN
                  IF (DOBLNK.LE.0.0) THEN
                     BUFF2(BIND2+IX-1) = FBLANK
                  ELSE
                     BUFF2(BIND2+IX-1) = BUFF1(BIND1+IX-1)
                     END IF
                  BUFF2(BIND2+IZ-1) = FBLANK
               ELSE
                  TMOD =  MAPS(IX,IY,1) * XFREQ(IZ) + MAPS(IX,IY,2) *
     *               (XFREQ(IZ)**2)
                  TMOD = 10.0 ** TMOD
                  IF (TMOD.LE.0.0) THEN
                     IF (DOBLNK.LE.0.0) THEN
                        BUFF2(BIND2+IX-1) = FBLANK
                     ELSE
                        BUFF2(BIND2+IX-1) = BUFF1(BIND1+IX-1)
                        END IF
                     BUFF2(BIND2+IZ-1) = FBLANK
                  ELSE
                     BUFF2(BIND2+IZ-1) = BUFF1(BIND1+IZ-1) / TMOD
                     PMIN = MIN (PMIN, BUFF2(BIND2+IZ-1))
                     PMAX = MAX (PMAX, BUFF2(BIND2+IZ-1))
                     END IF
                  END IF
 20            CONTINUE
 30         CONTINUE
         CALL MDISK ('FINI', LUN2, FIND2, BUFF2, BIND2, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINISH WRITE PLANE'
            GO TO 990
            END IF
 50      CONTINUE
      CALL ZCLOSE (LUN1, FIND1, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE INPUT FILE'
         END IF
      CALL ZCLOSE (LUN2, FIND2, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSE OUTPUT FILE'
         END IF
      CATR(KRDMX) = PMAX
      CATR(KRDMN) = PMIN
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('UNSPX2 ERROR',I4,' ON ',A)
      END
