      SUBROUTINE FINDIT (LUN, FIND, IREC, JREC, JBUFSZ, BUFF1, ITIME,
     *   IRET)
C-----------------------------------------------------------------------
C! Tries to find integration time in a uv data set
C# UV
C-----------------------------------------------------------------------
C;  Copyright (C) 2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Find integration time in open uv data set
C   Inputs:
C      LUN      I      LUN open data set
C      FIND     I      FTAB pointer open data set
C      IREC     I      Initial data record
C      JREC     I      Last data record
C      JBUFSZ   I      size of buffer in AIPS bytes
C   Outputs:
C      BUFF1    R(*)   I/O buffer
C      ITIME    R      integration time in seconds
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   LUN, FIND, IREC, JREC, JBUFSZ, IRET
      REAL      BUFF1(*), ITIME
C
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INTEGER   I, ILENBU, VO, MVIS, BO, CREC, IN, NDIFF, JTIME, LTIME,
     *   TDIFF, CNT(10000), IP(4), IM(4), IBIND, INIO, NDBG, M
      CHARACTER SORT*2
      REAL      TEST, MULT, SN, SX
      DOUBLE PRECISION S, SS, NS
      DATA VO, BO /0, 1/
      DATA MULT /864000./
C-----------------------------------------------------------------------
C                                       can we do this?
      ITIME = 0.0
      IF (ILOCIT.LT.0) THEN
         CALL H2CHR (2, 1, CATH(KITYP), SORT)
         IF ((SORT(:1).NE.'T') .AND. (SORT(2:).NE.'T')) THEN
            IRET = 10
            MSGTXT = 'DATA SET LACKS INTTIME, NOT IN TIME ORDER'
            GO TO 980
            END IF
         END IF
C                                       init the I/O
      ILENBU = 0
      VO = MAX (0, IREC-1)
      MVIS = JREC - IREC + 1
      CALL UVINIT ('READ', LUN, FIND, MVIS, VO, LREC, ILENBU, JBUFSZ,
     *   BUFF1, BO, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIT IO FROM INPUT DATA SET'
         GO TO 980
         END IF
      CREC = IREC
      NDIFF = 0
      LTIME = -1000.0
      TDIFF = 1000000
      CALL FILL (10000, 0, CNT)
      NDBG = 0
      NS = 0.0D0
      S = 0.0D0
      SS = 0.0D0
      SN = 1.E10
      SX = -SN
      M = 0
 20   CALL UVDISK ('READ', LUN, FIND, BUFF1, INIO, IBIND, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READ INPUT DATA SET'
         GO TO 980
         END IF
      DO 100 IN = 1,INIO
C                                       easy check
         IF (ILOCIT.GE.0) THEN
            IF (ITIME.LE.0.0) ITIME = BUFF1(IBIND+ILOCIT)
            TEST = BUFF1(IBIND+ILOCIT)
            IF (ABS(TEST-ITIME).GT.0.05) NDIFF = NDIFF + 1
            M = M + 1
            S = S + TEST
            SS = SS + TEST*TEST
            NS = NS + 1.0D0
            SN = MIN (TEST, SN)
            SX = MAX (TEST, SX)
         ELSE
            JTIME = MULT * BUFF1(IBIND+ILOCT) + 0.5
            IF (LTIME.LT.0) LTIME = JTIME
            I = JTIME - LTIME
            IF ((I.LT.10000) .AND. (I.GT.0)) THEN
               CNT(I) = CNT(I) + 1
               NDBG = NDBG + 1
c               dbg(1,ndbg) = i
c               dbg(2,ndbg) = crec
               END IF
            LTIME = JTIME
            END IF
         IBIND = IBIND + LREC
         CREC = CREC + 1
 100     CONTINUE
      IF (CREC.LT.JREC) GO TO 20
C                                       analyze, report
      IF (ILOCIT.GE.0) THEN
         WRITE (MSGTXT,1100) ITIME
         CALL MSGWRT (5)
         WRITE (MSGTXT,1101) NDIFF, M
         CALL REFRMT (MSGTXT, '_', I)
         CALL MSGWRT (5)
         IF (NDIFF.GT.0) THEN
            S = S / NS
            SS = SS/NS - S * S
            IF (SS.GT.0.0D0) SS = SQRT (SS)
            WRITE (MSGTXT,1102) S, SS
            CALL MSGWRT (5)
            WRITE (MSGTXT,1103) SN, SX
            CALL MSGWRT (5)
            END IF
      ELSE
         CALL FILL (4, 0, IP)
         CALL FILL (4, 0, IM)
         DO 120 I = 1,10000
            IF (CNT(I).GT.IM(1)) THEN
               IM(4) = IM(3)
               IP(4) = IP(3)
               IM(3) = IM(2)
               IP(3) = IP(2)
               IM(2) = IM(1)
               IP(2) = IP(1)
               IP(1) = I
               IM(1) = CNT(I)
            ELSE IF (CNT(I).GT.IM(2)) THEN
               IM(4) = IM(3)
               IP(4) = IP(3)
               IM(3) = IM(2)
               IP(3) = IP(2)
               IP(2) = I
               IM(2) = CNT(I)
            ELSE IF (CNT(I).GT.IM(3)) THEN
               IM(4) = IM(3)
               IP(4) = IP(3)
               IM(3) = CNT(I)
               IP(3) = I
            ELSE IF (CNT(I).GT.IM(4)) THEN
               IM(4) = CNT(I)
               IP(4) = I
               END IF
 120        CONTINUE
         ITIME = IP(1) / 10.0
         WRITE (MSGTXT,1120) ITIME
         CALL MSGWRT (5)
         WRITE (MSGTXT,1121) IM, IP
         CALL REFRMT (MSGTXT, '_', I)
         CALL MSGWRT (5)
         WRITE (MSGTXT,1122) NDBG
         CALL MSGWRT (5)
         END IF
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('FINDIT ERROR',I4,' ON ',A)
 1100 FORMAT ('FINDIT: INTTIM parameter yields',F7.2,' seconds')
 1101 FORMAT (I10,' of_',I10,' samples disagreed')
 1102 FORMAT ('MEAN INTTIM',F7.2,' +-',F7.2)
 1103 FORMAT ('MIN INTTIM',F7.2,' MAX',F7.2)
 1120 FORMAT ('FINDIT time samples yield',F7.1,' seconds int time')
 1121 FORMAT ('Peaks',4('_',I7),' at',4I5)
 1122 FORMAT ('Total number of intervals',I8)
      END
