      SUBROUTINE FXSEG (LFUNC, NFFT, DBITS, DFACT, IRET)
C----------------------------------------------------------------------
C! Calculate the VLBA segmentation loss factor
C# Calibration UV
C----------------------------------------------------------------------
C;  Copyright (C) 1995, 2007, 2011, 2014
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Calculate the VLBA segmentation loss corrections
C   Inputs:
C      LFUNC   C*8    FFT weighting function ('HANNING', 'UNIFORM')
C                        only 1st 4 characters checked
C      NFFT    I      FFT size (in bits)
C      DBITS   D      Delay error (in bits)
C   Outputs:
C      DFACT   D      Amplitude loss factor
C      IRET    I      Return code (0=>ok; else error)
C----------------------------------------------------------------------
      CHARACTER LFUNC*(*)
      DOUBLE PRECISION DBITS, DFACT
      INTEGER NFFT, IRET
C
      DOUBLE PRECISION DFRAC, DSLOPE, DOFFST
      DOUBLE PRECISION D2048(2048), D1024(1024), D512(512), D256(256),
     *   D128(128), D64(64)
      INTEGER IBIT, JBIT, K, INTBIT
      DATA (D2048(K), K = 1, 74) / 0.10000000D+01, 0.99994427D+00,
     *   0.99988902D+00, 0.99983341D+00, 0.99977815D+00, 0.99972254D+00,
     *   0.99966729D+00, 0.99961162D+00, 0.99955618D+00, 0.99949700D+00,
     *   0.99943775D+00, 0.99937856D+00, 0.99931914D+00, 0.99925995D+00,
     *   0.99920052D+00, 0.99914134D+00, 0.99908209D+00, 0.99901313D+00,
     *   0.99894410D+00, 0.99887526D+00, 0.99880606D+00, 0.99873722D+00,
     *   0.99866825D+00, 0.99859923D+00, 0.99853021D+00, 0.99843866D+00,
     *   0.99834728D+00, 0.99825549D+00, 0.99816412D+00, 0.99807256D+00,
     *   0.99798101D+00, 0.99788946D+00, 0.99779803D+00, 0.99769562D+00,
     *   0.99759299D+00, 0.99749058D+00, 0.99738795D+00, 0.99728549D+00,
     *   0.99718291D+00, 0.99708045D+00, 0.99697787D+00, 0.99684972D+00,
     *   0.99672157D+00, 0.99659342D+00, 0.99646527D+00, 0.99633718D+00,
     *   0.99620903D+00, 0.99608088D+00, 0.99595273D+00, 0.99578679D+00,
     *   0.99562061D+00, 0.99545467D+00, 0.99528873D+00, 0.99512255D+00,
     *   0.99495661D+00, 0.99479043D+00, 0.99462450D+00, 0.99443334D+00,
     *   0.99424261D+00, 0.99405146D+00, 0.99386090D+00, 0.99366957D+00,
     *   0.99347895D+00, 0.99328768D+00, 0.99309707D+00, 0.99287850D+00,
     *   0.99266058D+00, 0.99244195D+00, 0.99222422D+00, 0.99200559D+00,
     *   0.99178785D+00, 0.99156922D+00, 0.99135137D+00, 0.99111664D+00/
      DATA (D2048(K), K = 75, 148) / 0.99088228D+00, 0.99064761D+00,
     *   0.99041307D+00, 0.99017835D+00, 0.98994380D+00, 0.98970914D+00,
     *   0.98947459D+00, 0.98922569D+00, 0.98897660D+00, 0.98872751D+00,
     *   0.98847842D+00, 0.98822951D+00, 0.98798043D+00, 0.98773134D+00,
     *   0.98748231D+00, 0.98720795D+00, 0.98693359D+00, 0.98665929D+00,
     *   0.98638493D+00, 0.98611063D+00, 0.98583627D+00, 0.98556197D+00,
     *   0.98528761D+00, 0.98496878D+00, 0.98465002D+00, 0.98433119D+00,
     *   0.98401254D+00, 0.98369372D+00, 0.98337507D+00, 0.98305631D+00,
     *   0.98273766D+00, 0.98240006D+00, 0.98206264D+00, 0.98172522D+00,
     *   0.98138779D+00, 0.98105019D+00, 0.98071283D+00, 0.98037523D+00,
     *   0.98003799D+00, 0.97968411D+00, 0.97933078D+00, 0.97897696D+00,
     *   0.97862345D+00, 0.97826976D+00, 0.97791630D+00, 0.97756243D+00,
     *   0.97720891D+00, 0.97682083D+00, 0.97643274D+00, 0.97604465D+00,
     *   0.97565657D+00, 0.97526848D+00, 0.97488034D+00, 0.97449225D+00,
     *   0.97410417D+00, 0.97370684D+00, 0.97330964D+00, 0.97291231D+00,
     *   0.97251517D+00, 0.97211778D+00, 0.97172046D+00, 0.97132331D+00,
     *   0.97092593D+00, 0.97049928D+00, 0.97007263D+00, 0.96964604D+00,
     *   0.96921939D+00, 0.96879274D+00, 0.96836627D+00, 0.96793944D+00,
     *   0.96751297D+00, 0.96706712D+00, 0.96662176D+00, 0.96617591D+00/
      DATA (D2048(K), K = 149, 222) / 0.96573061D+00, 0.96528471D+00,
     *   0.96483922D+00, 0.96439350D+00, 0.96394801D+00, 0.96348166D+00,
     *   0.96301526D+00, 0.96254891D+00, 0.96208256D+00, 0.96161622D+00,
     *   0.96114969D+00, 0.96068347D+00, 0.96021694D+00, 0.95972532D+00,
     *   0.95923358D+00, 0.95874196D+00, 0.95825034D+00, 0.95775872D+00,
     *   0.95726693D+00, 0.95677531D+00, 0.95628375D+00, 0.95575446D+00,
     *   0.95522505D+00, 0.95469576D+00, 0.95416635D+00, 0.95363706D+00,
     *   0.95310766D+00, 0.95257837D+00, 0.95204896D+00, 0.95151150D+00,
     *   0.95097387D+00, 0.95043647D+00, 0.94989884D+00, 0.94936138D+00,
     *   0.94882381D+00, 0.94828635D+00, 0.94774872D+00, 0.94719344D+00,
     *   0.94663811D+00, 0.94608277D+00, 0.94552749D+00, 0.94497234D+00,
     *   0.94441700D+00, 0.94386172D+00, 0.94330639D+00, 0.94271874D+00,
     *   0.94213104D+00, 0.94154340D+00, 0.94095594D+00, 0.94036824D+00,
     *   0.93978059D+00, 0.93919289D+00, 0.93860525D+00, 0.93801200D+00,
     *   0.93741840D+00, 0.93682516D+00, 0.93623155D+00, 0.93563837D+00,
     *   0.93504477D+00, 0.93445152D+00, 0.93385792D+00, 0.93324310D+00,
     *   0.93262798D+00, 0.93201298D+00, 0.93139780D+00, 0.93078303D+00,
     *   0.93016785D+00, 0.92955285D+00, 0.92893773D+00, 0.92828751D+00,
     *   0.92763728D+00, 0.92698693D+00, 0.92633671D+00, 0.92568648D+00/
      DATA (D2048(K), K = 223, 296) / 0.92503631D+00, 0.92438608D+00,
     *   0.92373568D+00, 0.92307073D+00, 0.92240584D+00, 0.92174089D+00,
     *   0.92107594D+00, 0.92041081D+00, 0.91974604D+00, 0.91908091D+00,
     *   0.91841596D+00, 0.91773117D+00, 0.91704583D+00, 0.91636103D+00,
     *   0.91567588D+00, 0.91499090D+00, 0.91430575D+00, 0.91362077D+00,
     *   0.91293561D+00, 0.91224444D+00, 0.91155326D+00, 0.91086221D+00,
     *   0.91017103D+00, 0.90948004D+00, 0.90878886D+00, 0.90809768D+00,
     *   0.90740669D+00, 0.90669775D+00, 0.90598893D+00, 0.90528011D+00,
     *   0.90457135D+00, 0.90386254D+00, 0.90315378D+00, 0.90244496D+00,
     *   0.90173620D+00, 0.90099996D+00, 0.90026397D+00, 0.89952773D+00,
     *   0.89879173D+00, 0.89805555D+00, 0.89731950D+00, 0.89658332D+00,
     *   0.89584732D+00, 0.89508945D+00, 0.89433175D+00, 0.89357394D+00,
     *   0.89281625D+00, 0.89205837D+00, 0.89130056D+00, 0.89054286D+00,
     *   0.88978499D+00, 0.88900971D+00, 0.88823444D+00, 0.88745916D+00,
     *   0.88668388D+00, 0.88590854D+00, 0.88513309D+00, 0.88435781D+00,
     *   0.88358253D+00, 0.88279241D+00, 0.88200229D+00, 0.88121200D+00,
     *   0.88042188D+00, 0.87963176D+00, 0.87884170D+00, 0.87805158D+00,
     *   0.87726146D+00, 0.87644976D+00, 0.87563807D+00, 0.87482649D+00,
     *   0.87401479D+00, 0.87320316D+00, 0.87239152D+00, 0.87157989D+00/
      DATA (D2048(K), K = 297, 370) / 0.87076819D+00, 0.86994970D+00,
     *   0.86913097D+00, 0.86831248D+00, 0.86749381D+00, 0.86667514D+00,
     *   0.86585641D+00, 0.86503792D+00, 0.86421925D+00, 0.86338556D+00,
     *   0.86255169D+00, 0.86171776D+00, 0.86088407D+00, 0.86005020D+00,
     *   0.85921651D+00, 0.85838264D+00, 0.85754877D+00, 0.85668248D+00,
     *   0.85581619D+00, 0.85494965D+00, 0.85408336D+00, 0.85321689D+00,
     *   0.85235053D+00, 0.85148424D+00, 0.85061777D+00, 0.84974444D+00,
     *   0.84887111D+00, 0.84799778D+00, 0.84712446D+00, 0.84625095D+00,
     *   0.84537762D+00, 0.84450430D+00, 0.84363079D+00, 0.84275550D+00,
     *   0.84188020D+00, 0.84100491D+00, 0.84012961D+00, 0.83925432D+00,
     *   0.83837903D+00, 0.83750373D+00, 0.83662844D+00, 0.83573407D+00,
     *   0.83483976D+00, 0.83394539D+00, 0.83305103D+00, 0.83215672D+00,
     *   0.83126235D+00, 0.83036816D+00, 0.82947367D+00, 0.82857031D+00,
     *   0.82766736D+00, 0.82676405D+00, 0.82586086D+00, 0.82495755D+00,
     *   0.82405454D+00, 0.82315123D+00, 0.82224804D+00, 0.82132047D+00,
     *   0.82039326D+00, 0.81946564D+00, 0.81853843D+00, 0.81761080D+00,
     *   0.81668341D+00, 0.81575578D+00, 0.81482857D+00, 0.81388420D+00,
     *   0.81293976D+00, 0.81199539D+00, 0.81105101D+00, 0.81010658D+00,
     *   0.80916220D+00, 0.80821776D+00, 0.80727339D+00, 0.80632144D+00/
      DATA (D2048(K), K = 371, 444) / 0.80536950D+00, 0.80441737D+00,
     *   0.80346560D+00, 0.80251348D+00, 0.80156153D+00, 0.80060941D+00,
     *   0.79965764D+00, 0.79869395D+00, 0.79773039D+00, 0.79676670D+00,
     *   0.79580295D+00, 0.79483944D+00, 0.79387569D+00, 0.79291219D+00,
     *   0.79194826D+00, 0.79096568D+00, 0.78998309D+00, 0.78900033D+00,
     *   0.78801775D+00, 0.78703499D+00, 0.78605241D+00, 0.78506964D+00,
     *   0.78408700D+00, 0.78310865D+00, 0.78213012D+00, 0.78115159D+00,
     *   0.78017306D+00, 0.77919465D+00, 0.77821612D+00, 0.77723759D+00,
     *   0.77625906D+00, 0.77526593D+00, 0.77427268D+00, 0.77327937D+00,
     *   0.77228630D+00, 0.77129298D+00, 0.77029973D+00, 0.76930660D+00,
     *   0.76831335D+00, 0.76730669D+00, 0.76630020D+00, 0.76529354D+00,
     *   0.76428688D+00, 0.76328033D+00, 0.76227367D+00, 0.76126701D+00,
     *   0.76026034D+00, 0.75924695D+00, 0.75823337D+00, 0.75721979D+00,
     *   0.75620615D+00, 0.75519276D+00, 0.75417918D+00, 0.75316554D+00,
     *   0.75215209D+00, 0.75112838D+00, 0.75010461D+00, 0.74908090D+00,
     *   0.74805725D+00, 0.74703348D+00, 0.74600977D+00, 0.74498600D+00,
     *   0.74396235D+00, 0.74292850D+00, 0.74189472D+00, 0.74086100D+00,
     *   0.73982722D+00, 0.73879343D+00, 0.73775971D+00, 0.73672593D+00,
     *   0.73569214D+00, 0.73464906D+00, 0.73360598D+00, 0.73256296D+00/
      DATA (D2048(K), K = 445, 518) / 0.73151982D+00, 0.73047674D+00,
     *   0.72943372D+00, 0.72839063D+00, 0.72734761D+00, 0.72630113D+00,
     *   0.72525471D+00, 0.72420835D+00, 0.72316194D+00, 0.72211552D+00,
     *   0.72106910D+00, 0.72002274D+00, 0.71897626D+00, 0.71792144D+00,
     *   0.71686667D+00, 0.71581179D+00, 0.71475703D+00, 0.71370214D+00,
     *   0.71264732D+00, 0.71159244D+00, 0.71053767D+00, 0.70947421D+00,
     *   0.70841074D+00, 0.70734739D+00, 0.70628393D+00, 0.70522046D+00,
     *   0.70415699D+00, 0.70309365D+00, 0.70203018D+00, 0.70095628D+00,
     *   0.69988263D+00, 0.69880879D+00, 0.69773501D+00, 0.69666123D+00,
     *   0.69558746D+00, 0.69451362D+00, 0.69343996D+00, 0.69235629D+00,
     *   0.69127262D+00, 0.69018888D+00, 0.68910521D+00, 0.68802154D+00,
     *   0.68693787D+00, 0.68585420D+00, 0.68477046D+00, 0.68369186D+00,
     *   0.68261325D+00, 0.68153459D+00, 0.68045598D+00, 0.67937738D+00,
     *   0.67829877D+00, 0.67722011D+00, 0.67614144D+00, 0.67506242D+00,
     *   0.67398334D+00, 0.67290425D+00, 0.67182517D+00, 0.67074603D+00,
     *   0.66966701D+00, 0.66858792D+00, 0.66750878D+00, 0.66642326D+00,
     *   0.66533768D+00, 0.66425204D+00, 0.66316646D+00, 0.66208088D+00,
     *   0.66099536D+00, 0.65990973D+00, 0.65882415D+00, 0.65773535D+00,
     *   0.65664655D+00, 0.65555775D+00, 0.65446901D+00, 0.65338016D+00/
      DATA (D2048(K), K = 519, 592) / 0.65229142D+00, 0.65120262D+00,
     *   0.65011382D+00, 0.64901221D+00, 0.64791059D+00, 0.64680898D+00,
     *   0.64570731D+00, 0.64460570D+00, 0.64350414D+00, 0.64240247D+00,
     *   0.64130080D+00, 0.64019197D+00, 0.63908327D+00, 0.63797438D+00,
     *   0.63686556D+00, 0.63575673D+00, 0.63464797D+00, 0.63353914D+00,
     *   0.63243032D+00, 0.63131821D+00, 0.63020599D+00, 0.62909389D+00,
     *   0.62798166D+00, 0.62686956D+00, 0.62575746D+00, 0.62464523D+00,
     *   0.62353313D+00, 0.62243205D+00, 0.62133098D+00, 0.62022990D+00,
     *   0.61912888D+00, 0.61802781D+00, 0.61692685D+00, 0.61582577D+00,
     *   0.61472470D+00, 0.61362582D+00, 0.61252695D+00, 0.61142814D+00,
     *   0.61032927D+00, 0.60923040D+00, 0.60813153D+00, 0.60703266D+00,
     *   0.60593379D+00, 0.60482615D+00, 0.60371840D+00, 0.60261071D+00,
     *   0.60150301D+00, 0.60039538D+00, 0.59928763D+00, 0.59817994D+00,
     *   0.59707230D+00, 0.59596336D+00, 0.59485435D+00, 0.59374541D+00,
     *   0.59263647D+00, 0.59152758D+00, 0.59041852D+00, 0.58930963D+00,
     *   0.58820063D+00, 0.58708453D+00, 0.58596843D+00, 0.58485228D+00,
     *   0.58373624D+00, 0.58262014D+00, 0.58150399D+00, 0.58038789D+00,
     *   0.57927179D+00, 0.57816023D+00, 0.57704878D+00, 0.57593721D+00,
     *   0.57482570D+00, 0.57371420D+00, 0.57260269D+00, 0.57149112D+00/
      DATA (D2048(K), K = 593, 666) / 0.57037961D+00, 0.56927633D+00,
     *   0.56817305D+00, 0.56706983D+00, 0.56596655D+00, 0.56486326D+00,
     *   0.56376004D+00, 0.56265676D+00, 0.56155348D+00, 0.56044459D+00,
     *   0.55933565D+00, 0.55822676D+00, 0.55711776D+00, 0.55600888D+00,
     *   0.55489993D+00, 0.55379105D+00, 0.55268210D+00, 0.55158085D+00,
     *   0.55047965D+00, 0.54937845D+00, 0.54827720D+00, 0.54717594D+00,
     *   0.54607481D+00, 0.54497355D+00, 0.54387230D+00, 0.54277122D+00,
     *   0.54167026D+00, 0.54056919D+00, 0.53946817D+00, 0.53836709D+00,
     *   0.53726614D+00, 0.53616506D+00, 0.53506398D+00, 0.53395724D+00,
     *   0.53285044D+00, 0.53174371D+00, 0.53063691D+00, 0.52953017D+00,
     *   0.52842337D+00, 0.52731663D+00, 0.52620989D+00, 0.52510196D+00,
     *   0.52399403D+00, 0.52288610D+00, 0.52177817D+00, 0.52067024D+00,
     *   0.51956230D+00, 0.51845443D+00, 0.51734650D+00, 0.51625043D+00,
     *   0.51515436D+00, 0.51405829D+00, 0.51296222D+00, 0.51186609D+00,
     *   0.51077002D+00, 0.50967395D+00, 0.50857788D+00, 0.50747937D+00,
     *   0.50638086D+00, 0.50528240D+00, 0.50418389D+00, 0.50308537D+00,
     *   0.50198686D+00, 0.50088835D+00, 0.49978986D+00, 0.49869865D+00,
     *   0.49760741D+00, 0.49651620D+00, 0.49542508D+00, 0.49433383D+00,
     *   0.49324262D+00, 0.49215138D+00, 0.49106026D+00, 0.48997891D+00/
      DATA (D2048(K), K = 667, 740) / 0.48889756D+00, 0.48781624D+00,
     *   0.48673499D+00, 0.48565364D+00, 0.48457229D+00, 0.48349097D+00,
     *   0.48240972D+00, 0.48132506D+00, 0.48024046D+00, 0.47915581D+00,
     *   0.47807124D+00, 0.47698665D+00, 0.47590199D+00, 0.47481743D+00,
     *   0.47373277D+00, 0.47266257D+00, 0.47159237D+00, 0.47052225D+00,
     *   0.46945205D+00, 0.46838185D+00, 0.46731165D+00, 0.46624145D+00,
     *   0.46517128D+00, 0.46409854D+00, 0.46302584D+00, 0.46195313D+00,
     *   0.46088040D+00, 0.45980769D+00, 0.45873499D+00, 0.45766228D+00,
     *   0.45658955D+00, 0.45551431D+00, 0.45443910D+00, 0.45336387D+00,
     *   0.45228863D+00, 0.45121342D+00, 0.45013818D+00, 0.44906294D+00,
     *   0.44798771D+00, 0.44692731D+00, 0.44586691D+00, 0.44480652D+00,
     *   0.44374612D+00, 0.44268569D+00, 0.44162530D+00, 0.44056490D+00,
     *   0.43950450D+00, 0.43845901D+00, 0.43741342D+00, 0.43636784D+00,
     *   0.43532237D+00, 0.43427679D+00, 0.43323120D+00, 0.43218562D+00,
     *   0.43114015D+00, 0.43009260D+00, 0.42904505D+00, 0.42799750D+00,
     *   0.42695001D+00, 0.42590246D+00, 0.42485490D+00, 0.42380735D+00,
     *   0.42275989D+00, 0.42171720D+00, 0.42067468D+00, 0.41963196D+00,
     *   0.41858944D+00, 0.41754675D+00, 0.41650423D+00, 0.41546163D+00,
     *   0.41441900D+00, 0.41338030D+00, 0.41234159D+00, 0.41130298D+00/
      DATA (D2048(K), K = 741, 814) / 0.41026428D+00, 0.40922558D+00,
     *   0.40818688D+00, 0.40714818D+00, 0.40610948D+00, 0.40508026D+00,
     *   0.40405104D+00, 0.40302181D+00, 0.40199259D+00, 0.40096337D+00,
     *   0.39993414D+00, 0.39890492D+00, 0.39787570D+00, 0.39685115D+00,
     *   0.39582658D+00, 0.39480203D+00, 0.39377749D+00, 0.39275295D+00,
     *   0.39172840D+00, 0.39070383D+00, 0.38967928D+00, 0.38867667D+00,
     *   0.38767403D+00, 0.38667142D+00, 0.38566878D+00, 0.38466617D+00,
     *   0.38366354D+00, 0.38266090D+00, 0.38165829D+00, 0.38065395D+00,
     *   0.37964961D+00, 0.37864530D+00, 0.37764096D+00, 0.37663662D+00,
     *   0.37563229D+00, 0.37462795D+00, 0.37362364D+00, 0.37263563D+00,
     *   0.37164757D+00, 0.37065959D+00, 0.36967152D+00, 0.36868352D+00,
     *   0.36769548D+00, 0.36670747D+00, 0.36571944D+00, 0.36473054D+00,
     *   0.36374161D+00, 0.36275271D+00, 0.36176375D+00, 0.36077484D+00,
     *   0.35978591D+00, 0.35879701D+00, 0.35780805D+00, 0.35682118D+00,
     *   0.35583431D+00, 0.35484743D+00, 0.35386059D+00, 0.35287371D+00,
     *   0.35188684D+00, 0.35089996D+00, 0.34991309D+00, 0.34894839D+00,
     *   0.34798378D+00, 0.34701908D+00, 0.34605440D+00, 0.34508970D+00,
     *   0.34412509D+00, 0.34316039D+00, 0.34219572D+00, 0.34124467D+00,
     *   0.34029362D+00, 0.33934256D+00, 0.33839151D+00, 0.33744046D+00/
      DATA (D2048(K), K = 815, 888) / 0.33648944D+00, 0.33553839D+00,
     *   0.33458734D+00, 0.33363882D+00, 0.33269027D+00, 0.33174175D+00,
     *   0.33079320D+00, 0.32984468D+00, 0.32889614D+00, 0.32794762D+00,
     *   0.32699910D+00, 0.32606134D+00, 0.32512358D+00, 0.32418585D+00,
     *   0.32324809D+00, 0.32231033D+00, 0.32137260D+00, 0.32043484D+00,
     *   0.31949711D+00, 0.31856760D+00, 0.31763813D+00, 0.31670865D+00,
     *   0.31577918D+00, 0.31484967D+00, 0.31392020D+00, 0.31299073D+00,
     *   0.31206125D+00, 0.31113696D+00, 0.31021270D+00, 0.30928844D+00,
     *   0.30836415D+00, 0.30743989D+00, 0.30651563D+00, 0.30559134D+00,
     *   0.30466709D+00, 0.30376258D+00, 0.30285808D+00, 0.30195358D+00,
     *   0.30104908D+00, 0.30014458D+00, 0.29924008D+00, 0.29833558D+00,
     *   0.29743108D+00, 0.29654059D+00, 0.29565009D+00, 0.29475963D+00,
     *   0.29386914D+00, 0.29297864D+00, 0.29208818D+00, 0.29119769D+00,
     *   0.29030719D+00, 0.28942221D+00, 0.28853720D+00, 0.28765219D+00,
     *   0.28676718D+00, 0.28588220D+00, 0.28499720D+00, 0.28411219D+00,
     *   0.28322718D+00, 0.28235060D+00, 0.28147399D+00, 0.28059739D+00,
     *   0.27972078D+00, 0.27884418D+00, 0.27796757D+00, 0.27709100D+00,
     *   0.27621439D+00, 0.27534911D+00, 0.27448383D+00, 0.27361855D+00,
     *   0.27275327D+00, 0.27188799D+00, 0.27102271D+00, 0.27015743D+00/
      DATA (D2048(K), K = 889, 962) / 0.26929215D+00, 0.26843825D+00,
     *   0.26758438D+00, 0.26673046D+00, 0.26587656D+00, 0.26502264D+00,
     *   0.26416874D+00, 0.26331481D+00, 0.26246092D+00, 0.26162422D+00,
     *   0.26078746D+00, 0.25995073D+00, 0.25911397D+00, 0.25827724D+00,
     *   0.25744051D+00, 0.25660378D+00, 0.25576705D+00, 0.25494036D+00,
     *   0.25411367D+00, 0.25328699D+00, 0.25246030D+00, 0.25163361D+00,
     *   0.25080693D+00, 0.24998026D+00, 0.24915357D+00, 0.24833694D+00,
     *   0.24752033D+00, 0.24670370D+00, 0.24588709D+00, 0.24507046D+00,
     *   0.24425384D+00, 0.24343722D+00, 0.24262060D+00, 0.24181117D+00,
     *   0.24100174D+00, 0.24019231D+00, 0.23938288D+00, 0.23857343D+00,
     *   0.23776400D+00, 0.23695457D+00, 0.23614514D+00, 0.23535152D+00,
     *   0.23455791D+00, 0.23376429D+00, 0.23297067D+00, 0.23217705D+00,
     *   0.23138343D+00, 0.23058982D+00, 0.22979620D+00, 0.22901551D+00,
     *   0.22823484D+00, 0.22745417D+00, 0.22667348D+00, 0.22589281D+00,
     *   0.22511213D+00, 0.22433145D+00, 0.22355077D+00, 0.22278591D+00,
     *   0.22202104D+00, 0.22125618D+00, 0.22049132D+00, 0.21972646D+00,
     *   0.21896160D+00, 0.21819673D+00, 0.21743187D+00, 0.21667995D+00,
     *   0.21592802D+00, 0.21517609D+00, 0.21442418D+00, 0.21367225D+00,
     *   0.21292032D+00, 0.21216840D+00, 0.21141647D+00, 0.21066456D+00/
      DATA (D2048(K), K = 963,1036) / 0.20991263D+00, 0.20916070D+00,
     *   0.20840877D+00, 0.20765686D+00, 0.20690493D+00, 0.20615301D+00,
     *   0.20540108D+00, 0.20467360D+00, 0.20394611D+00, 0.20321864D+00,
     *   0.20249115D+00, 0.20176367D+00, 0.20103619D+00, 0.20030871D+00,
     *   0.19958122D+00, 0.19886380D+00, 0.19814639D+00, 0.19742897D+00,
     *   0.19671154D+00, 0.19599412D+00, 0.19527671D+00, 0.19455929D+00,
     *   0.19384187D+00, 0.19312805D+00, 0.19241422D+00, 0.19170040D+00,
     *   0.19098657D+00, 0.19027275D+00, 0.18955892D+00, 0.18884510D+00,
     *   0.18813135D+00, 0.18744412D+00, 0.18675689D+00, 0.18606967D+00,
     *   0.18538244D+00, 0.18469521D+00, 0.18400799D+00, 0.18332076D+00,
     *   0.18263352D+00, 0.18195061D+00, 0.18126769D+00, 0.18058479D+00,
     *   0.17990187D+00, 0.17921896D+00, 0.17853604D+00, 0.17785314D+00,
     *   0.17717022D+00, 0.17649521D+00, 0.17582020D+00, 0.17514519D+00,
     *   0.17447019D+00, 0.17379518D+00, 0.17312019D+00, 0.17244518D+00,
     *   0.17177017D+00, 0.17111744D+00, 0.17046472D+00, 0.16981199D+00,
     *   0.16915928D+00, 0.16850656D+00, 0.16785383D+00, 0.16720112D+00,
     *   0.16654839D+00, 0.16590358D+00, 0.16525877D+00, 0.16461395D+00,
     *   0.16396913D+00, 0.16332433D+00, 0.16267951D+00, 0.16203469D+00,
     *   0.16138987D+00, 0.16075872D+00, 0.16012757D+00, 0.15949641D+00/
      DATA (D2048(K), K =1037,1110) / 0.15886526D+00, 0.15823410D+00,
     *   0.15760294D+00, 0.15697178D+00, 0.15634063D+00, 0.15572312D+00,
     *   0.15510564D+00, 0.15448813D+00, 0.15387064D+00, 0.15325314D+00,
     *   0.15263565D+00, 0.15201814D+00, 0.15140064D+00, 0.15079501D+00,
     *   0.15018937D+00, 0.14958374D+00, 0.14897810D+00, 0.14837246D+00,
     *   0.14776683D+00, 0.14716119D+00, 0.14655556D+00, 0.14595926D+00,
     *   0.14536297D+00, 0.14476667D+00, 0.14417039D+00, 0.14357410D+00,
     *   0.14297780D+00, 0.14238152D+00, 0.14178522D+00, 0.14120367D+00,
     *   0.14062211D+00, 0.14004056D+00, 0.13945900D+00, 0.13887745D+00,
     *   0.13829589D+00, 0.13771434D+00, 0.13713278D+00, 0.13656327D+00,
     *   0.13599375D+00, 0.13542424D+00, 0.13485472D+00, 0.13428521D+00,
     *   0.13371570D+00, 0.13314618D+00, 0.13257667D+00, 0.13201830D+00,
     *   0.13145992D+00, 0.13090156D+00, 0.13034318D+00, 0.12978481D+00,
     *   0.12922643D+00, 0.12866807D+00, 0.12810969D+00, 0.12756822D+00,
     *   0.12702674D+00, 0.12648526D+00, 0.12594378D+00, 0.12540230D+00,
     *   0.12486082D+00, 0.12431934D+00, 0.12377787D+00, 0.12324385D+00,
     *   0.12270983D+00, 0.12217581D+00, 0.12164178D+00, 0.12110776D+00,
     *   0.12057374D+00, 0.12003972D+00, 0.11950570D+00, 0.11898556D+00,
     *   0.11846542D+00, 0.11794529D+00, 0.11742515D+00, 0.11690501D+00/
      DATA (D2048(K), K =1111,1184) / 0.11638487D+00, 0.11586474D+00,
     *   0.11534460D+00, 0.11483830D+00, 0.11433200D+00, 0.11382570D+00,
     *   0.11331940D+00, 0.11281310D+00, 0.11230680D+00, 0.11180050D+00,
     *   0.11129420D+00, 0.11079592D+00, 0.11029766D+00, 0.10979939D+00,
     *   0.10930111D+00, 0.10880283D+00, 0.10830457D+00, 0.10780629D+00,
     *   0.10730802D+00, 0.10682349D+00, 0.10633896D+00, 0.10585442D+00,
     *   0.10536988D+00, 0.10488536D+00, 0.10440082D+00, 0.10391629D+00,
     *   0.10343175D+00, 0.10296234D+00, 0.10249293D+00, 0.10202351D+00,
     *   0.10155410D+00, 0.10108469D+00, 0.10061527D+00, 0.10014586D+00,
     *   0.99676445D-01, 0.99215299D-01, 0.98754153D-01, 0.98293006D-01,
     *   0.97831860D-01, 0.97370714D-01, 0.96909568D-01, 0.96448421D-01,
     *   0.95987275D-01, 0.95534757D-01, 0.95082238D-01, 0.94629712D-01,
     *   0.94177194D-01, 0.93724675D-01, 0.93272157D-01, 0.92819631D-01,
     *   0.92367113D-01, 0.91932207D-01, 0.91497295D-01, 0.91062389D-01,
     *   0.90627484D-01, 0.90192571D-01, 0.89757666D-01, 0.89322753D-01,
     *   0.88887848D-01, 0.88462822D-01, 0.88037804D-01, 0.87612778D-01,
     *   0.87187752D-01, 0.86762726D-01, 0.86337708D-01, 0.85912682D-01,
     *   0.85487656D-01, 0.85070901D-01, 0.84654145D-01, 0.84237382D-01,
     *   0.83820626D-01, 0.83403870D-01, 0.82987115D-01, 0.82570359D-01/
      DATA (D2048(K), K =1185,1258) / 0.82153603D-01, 0.81752300D-01,
     *   0.81350997D-01, 0.80949694D-01, 0.80548391D-01, 0.80147095D-01,
     *   0.79745792D-01, 0.79344489D-01, 0.78943186D-01, 0.78547187D-01,
     *   0.78151189D-01, 0.77755183D-01, 0.77359185D-01, 0.76963186D-01,
     *   0.76567188D-01, 0.76171182D-01, 0.75775184D-01, 0.75396664D-01,
     *   0.75018138D-01, 0.74639618D-01, 0.74261092D-01, 0.73882572D-01,
     *   0.73504046D-01, 0.73125526D-01, 0.72747000D-01, 0.72376929D-01,
     *   0.72006851D-01, 0.71636774D-01, 0.71266696D-01, 0.70896618D-01,
     *   0.70526548D-01, 0.70156470D-01, 0.69786392D-01, 0.69424346D-01,
     *   0.69062300D-01, 0.68700254D-01, 0.68338208D-01, 0.67976162D-01,
     *   0.67614123D-01, 0.67252077D-01, 0.66890031D-01, 0.66543505D-01,
     *   0.66196993D-01, 0.65850474D-01, 0.65503947D-01, 0.65157436D-01,
     *   0.64810917D-01, 0.64464390D-01, 0.64117879D-01, 0.63776962D-01,
     *   0.63436046D-01, 0.63095130D-01, 0.62754214D-01, 0.62413294D-01,
     *   0.62072378D-01, 0.61731458D-01, 0.61390541D-01, 0.61062202D-01,
     *   0.60733866D-01, 0.60405526D-01, 0.60077190D-01, 0.59748851D-01,
     *   0.59420515D-01, 0.59092175D-01, 0.58763839D-01, 0.58445923D-01,
     *   0.58128010D-01, 0.57810094D-01, 0.57492182D-01, 0.57174265D-01,
     *   0.56856353D-01, 0.56538437D-01, 0.56220524D-01, 0.55911507D-01/
      DATA (D2048(K), K =1259,1332) / 0.55602487D-01, 0.55293467D-01,
     *   0.54984450D-01, 0.54675430D-01, 0.54366414D-01, 0.54057393D-01,
     *   0.53748377D-01, 0.53450007D-01, 0.53151637D-01, 0.52853264D-01,
     *   0.52554894D-01, 0.52256525D-01, 0.51958155D-01, 0.51659785D-01,
     *   0.51361412D-01, 0.51071849D-01, 0.50782286D-01, 0.50492719D-01,
     *   0.50203156D-01, 0.49913593D-01, 0.49624026D-01, 0.49334463D-01,
     *   0.49044900D-01, 0.48765160D-01, 0.48485424D-01, 0.48205689D-01,
     *   0.47925953D-01, 0.47646217D-01, 0.47366481D-01, 0.47086746D-01,
     *   0.46807006D-01, 0.46536516D-01, 0.46266023D-01, 0.45995526D-01,
     *   0.45725033D-01, 0.45454539D-01, 0.45184050D-01, 0.44913549D-01,
     *   0.44643059D-01, 0.44382293D-01, 0.44121530D-01, 0.43860763D-01,
     *   0.43599997D-01, 0.43339234D-01, 0.43078467D-01, 0.42817701D-01,
     *   0.42556938D-01, 0.42305876D-01, 0.42054817D-01, 0.41803755D-01,
     *   0.41552693D-01, 0.41301634D-01, 0.41050572D-01, 0.40799513D-01,
     *   0.40548451D-01, 0.40303770D-01, 0.40059090D-01, 0.39814409D-01,
     *   0.39569728D-01, 0.39325047D-01, 0.39080366D-01, 0.38835686D-01,
     *   0.38591005D-01, 0.38356613D-01, 0.38122222D-01, 0.37887830D-01,
     *   0.37653435D-01, 0.37419043D-01, 0.37184652D-01, 0.36950260D-01,
     *   0.36715869D-01, 0.36489923D-01, 0.36263976D-01, 0.36038030D-01/
      DATA (D2048(K), K =1333,1406) / 0.35812087D-01, 0.35586141D-01,
     *   0.35360195D-01, 0.35134248D-01, 0.34908302D-01, 0.34690928D-01,
     *   0.34473553D-01, 0.34256175D-01, 0.34038801D-01, 0.33821426D-01,
     *   0.33604052D-01, 0.33386674D-01, 0.33169299D-01, 0.32958113D-01,
     *   0.32746922D-01, 0.32535736D-01, 0.32324549D-01, 0.32113362D-01,
     *   0.31902168D-01, 0.31690981D-01, 0.31479795D-01, 0.31278696D-01,
     *   0.31077595D-01, 0.30876495D-01, 0.30675394D-01, 0.30474294D-01,
     *   0.30273195D-01, 0.30072095D-01, 0.29870994D-01, 0.29676992D-01,
     *   0.29482992D-01, 0.29288990D-01, 0.29094988D-01, 0.28900987D-01,
     *   0.28706986D-01, 0.28512985D-01, 0.28318983D-01, 0.28132036D-01,
     *   0.27945088D-01, 0.27758140D-01, 0.27571192D-01, 0.27384246D-01,
     *   0.27197298D-01, 0.27010350D-01, 0.26823401D-01, 0.26644541D-01,
     *   0.26465680D-01, 0.26286820D-01, 0.26107959D-01, 0.25929099D-01,
     *   0.25750238D-01, 0.25571378D-01, 0.25392517D-01, 0.25220431D-01,
     *   0.25048343D-01, 0.24876256D-01, 0.24704168D-01, 0.24532080D-01,
     *   0.24359994D-01, 0.24187906D-01, 0.24015818D-01, 0.23851352D-01,
     *   0.23686886D-01, 0.23522416D-01, 0.23357952D-01, 0.23193488D-01,
     *   0.23029024D-01, 0.22864562D-01, 0.22700097D-01, 0.22541769D-01,
     *   0.22383440D-01, 0.22225112D-01, 0.22066785D-01, 0.21908456D-01/
      DATA (D2048(K), K =1407,1480) / 0.21750128D-01, 0.21591799D-01,
     *   0.21433473D-01, 0.21282243D-01, 0.21131013D-01, 0.20979784D-01,
     *   0.20828554D-01, 0.20677324D-01, 0.20526094D-01, 0.20374866D-01,
     *   0.20223636D-01, 0.20079101D-01, 0.19934567D-01, 0.19790031D-01,
     *   0.19645495D-01, 0.19500962D-01, 0.19356426D-01, 0.19211890D-01,
     *   0.19067356D-01, 0.18928211D-01, 0.18789068D-01, 0.18649925D-01,
     *   0.18510781D-01, 0.18371638D-01, 0.18232493D-01, 0.18093349D-01,
     *   0.17954206D-01, 0.17822554D-01, 0.17690903D-01, 0.17559251D-01,
     *   0.17427599D-01, 0.17295947D-01, 0.17164296D-01, 0.17032644D-01,
     *   0.16900992D-01, 0.16774088D-01, 0.16647184D-01, 0.16520280D-01,
     *   0.16393378D-01, 0.16266475D-01, 0.16139571D-01, 0.16012667D-01,
     *   0.15885765D-01, 0.15765805D-01, 0.15645845D-01, 0.15525886D-01,
     *   0.15405927D-01, 0.15285968D-01, 0.15166009D-01, 0.15046050D-01,
     *   0.14926090D-01, 0.14810759D-01, 0.14695427D-01, 0.14580096D-01,
     *   0.14464764D-01, 0.14349433D-01, 0.14234101D-01, 0.14118769D-01,
     *   0.14003438D-01, 0.13893498D-01, 0.13783557D-01, 0.13673618D-01,
     *   0.13563678D-01, 0.13453737D-01, 0.13343797D-01, 0.13233857D-01,
     *   0.13123917D-01, 0.13020570D-01, 0.12917223D-01, 0.12813876D-01,
     *   0.12710529D-01, 0.12607182D-01, 0.12503835D-01, 0.12400489D-01/
      DATA (D2048(K), K =1481,1554) / 0.12297142D-01, 0.12197331D-01,
     *   0.12097519D-01, 0.11997707D-01, 0.11897895D-01, 0.11798085D-01,
     *   0.11698273D-01, 0.11598461D-01, 0.11498650D-01, 0.11404547D-01,
     *   0.11310444D-01, 0.11216342D-01, 0.11122239D-01, 0.11028135D-01,
     *   0.10934032D-01, 0.10839930D-01, 0.10745827D-01, 0.10656666D-01,
     *   0.10567506D-01, 0.10478345D-01, 0.10389185D-01, 0.10300023D-01,
     *   0.10210863D-01, 0.10121702D-01, 0.10032542D-01, 0.99474415D-02,
     *   0.98623410D-02, 0.97772414D-02, 0.96921409D-02, 0.96070403D-02,
     *   0.95219398D-02, 0.94368402D-02, 0.93517397D-02, 0.92714624D-02,
     *   0.91911843D-02, 0.91109071D-02, 0.90306299D-02, 0.89503527D-02,
     *   0.88700745D-02, 0.87897973D-02, 0.87095201D-02, 0.86332085D-02,
     *   0.85568978D-02, 0.84805870D-02, 0.84042754D-02, 0.83279647D-02,
     *   0.82516531D-02, 0.81753423D-02, 0.80990307D-02, 0.80274092D-02,
     *   0.79557877D-02, 0.78841662D-02, 0.78125438D-02, 0.77409227D-02,
     *   0.76693008D-02, 0.75976793D-02, 0.75260573D-02, 0.74578207D-02,
     *   0.73895841D-02, 0.73213475D-02, 0.72531109D-02, 0.71848743D-02,
     *   0.71166377D-02, 0.70484011D-02, 0.69801644D-02, 0.69160289D-02,
     *   0.68518934D-02, 0.67877579D-02, 0.67236228D-02, 0.66594873D-02,
     *   0.65953517D-02, 0.65312162D-02, 0.64670807D-02, 0.64067137D-02/
      DATA (D2048(K), K =1555,1628) / 0.63463463D-02, 0.62859794D-02,
     *   0.62256120D-02, 0.61652451D-02, 0.61048781D-02, 0.60445108D-02,
     *   0.59841438D-02, 0.59273192D-02, 0.58704941D-02, 0.58136694D-02,
     *   0.57568448D-02, 0.57000201D-02, 0.56431950D-02, 0.55863704D-02,
     *   0.55295457D-02, 0.54760752D-02, 0.54226047D-02, 0.53691338D-02,
     *   0.53156633D-02, 0.52621928D-02, 0.52087223D-02, 0.51552518D-02,
     *   0.51017809D-02, 0.50516059D-02, 0.50014304D-02, 0.49512549D-02,
     *   0.49010799D-02, 0.48509045D-02, 0.48007290D-02, 0.47505535D-02,
     *   0.47003785D-02, 0.46531809D-02, 0.46059834D-02, 0.45587863D-02,
     *   0.45115887D-02, 0.44643912D-02, 0.44171936D-02, 0.43699965D-02,
     *   0.43227989D-02, 0.42786733D-02, 0.42345482D-02, 0.41904226D-02,
     *   0.41462970D-02, 0.41021719D-02, 0.40580463D-02, 0.40139207D-02,
     *   0.39697955D-02, 0.39285161D-02, 0.38872364D-02, 0.38459569D-02,
     *   0.38046774D-02, 0.37633979D-02, 0.37221184D-02, 0.36808390D-02,
     *   0.36395595D-02, 0.36008984D-02, 0.35622374D-02, 0.35235765D-02,
     *   0.34849155D-02, 0.34462544D-02, 0.34075934D-02, 0.33689325D-02,
     *   0.33302715D-02, 0.32942332D-02, 0.32581948D-02, 0.32221565D-02,
     *   0.31861183D-02, 0.31500799D-02, 0.31140416D-02, 0.30780034D-02,
     *   0.30419650D-02, 0.30085032D-02, 0.29750413D-02, 0.29415793D-02/
      DATA (D2048(K), K =1629,1702) / 0.29081174D-02, 0.28746554D-02,
     *   0.28411935D-02, 0.28077315D-02, 0.27742696D-02, 0.27431117D-02,
     *   0.27119538D-02, 0.26807957D-02, 0.26496379D-02, 0.26184800D-02,
     *   0.25873219D-02, 0.25561641D-02, 0.25250062D-02, 0.24961114D-02,
     *   0.24672167D-02, 0.24383222D-02, 0.24094274D-02, 0.23805327D-02,
     *   0.23516382D-02, 0.23227434D-02, 0.22938489D-02, 0.22669465D-02,
     *   0.22400441D-02, 0.22131416D-02, 0.21862392D-02, 0.21593370D-02,
     *   0.21324346D-02, 0.21055322D-02, 0.20786298D-02, 0.20539192D-02,
     *   0.20292085D-02, 0.20044977D-02, 0.19797871D-02, 0.19550764D-02,
     *   0.19303657D-02, 0.19056550D-02, 0.18809444D-02, 0.18579690D-02,
     *   0.18349937D-02, 0.18120183D-02, 0.17890430D-02, 0.17660677D-02,
     *   0.17430923D-02, 0.17201171D-02, 0.16971417D-02, 0.16759790D-02,
     *   0.16548162D-02, 0.16336534D-02, 0.16124907D-02, 0.15913279D-02,
     *   0.15701653D-02, 0.15490025D-02, 0.15278397D-02, 0.15083717D-02,
     *   0.14889035D-02, 0.14694354D-02, 0.14499674D-02, 0.14304993D-02,
     *   0.14110311D-02, 0.13915631D-02, 0.13720950D-02, 0.13542295D-02,
     *   0.13363642D-02, 0.13184987D-02, 0.13006333D-02, 0.12827680D-02,
     *   0.12649025D-02, 0.12470371D-02, 0.12291716D-02, 0.12128486D-02,
     *   0.11965255D-02, 0.11802024D-02, 0.11638793D-02, 0.11475562D-02/
      DATA (D2048(K), K =1703,1776) / 0.11312331D-02, 0.11149100D-02,
     *   0.10985869D-02, 0.10835379D-02, 0.10684890D-02, 0.10534400D-02,
     *   0.10383911D-02, 0.10233421D-02, 0.10082932D-02, 0.99324423D-03,
     *   0.97819534D-03, 0.96458686D-03, 0.95097843D-03, 0.93737000D-03,
     *   0.92376157D-03, 0.91015315D-03, 0.89654472D-03, 0.88293623D-03,
     *   0.86932781D-03, 0.85691351D-03, 0.84449921D-03, 0.83208486D-03,
     *   0.81967056D-03, 0.80725626D-03, 0.79484191D-03, 0.78242761D-03,
     *   0.77001331D-03, 0.75870747D-03, 0.74740162D-03, 0.73609577D-03,
     *   0.72478992D-03, 0.71348407D-03, 0.70217822D-03, 0.69087237D-03,
     *   0.67956652D-03, 0.66933129D-03, 0.65909600D-03, 0.64886070D-03,
     *   0.63862541D-03, 0.62839012D-03, 0.61815488D-03, 0.60791959D-03,
     *   0.59768429D-03, 0.58847608D-03, 0.57926780D-03, 0.57005958D-03,
     *   0.56085130D-03, 0.55164308D-03, 0.54243481D-03, 0.53322659D-03,
     *   0.52401837D-03, 0.51571149D-03, 0.50740462D-03, 0.49909775D-03,
     *   0.49079087D-03, 0.48248403D-03, 0.47417716D-03, 0.46587028D-03,
     *   0.45756344D-03, 0.45009126D-03, 0.44261909D-03, 0.43514691D-03,
     *   0.42767471D-03, 0.42020253D-03, 0.41273035D-03, 0.40525818D-03,
     *   0.39778600D-03, 0.39110781D-03, 0.38442962D-03, 0.37775139D-03,
     *   0.37107320D-03, 0.36439497D-03, 0.35771678D-03, 0.35103859D-03/
      DATA (D2048(K), K =1777,1850) / 0.34436036D-03, 0.33843261D-03,
     *   0.33250486D-03, 0.32657708D-03, 0.32064933D-03, 0.31472158D-03,
     *   0.30879382D-03, 0.30286607D-03, 0.29693829D-03, 0.29165289D-03,
     *   0.28636746D-03, 0.28108203D-03, 0.27579663D-03, 0.27051120D-03,
     *   0.26522577D-03, 0.25994037D-03, 0.25465494D-03, 0.24999218D-03,
     *   0.24532946D-03, 0.24066672D-03, 0.23600398D-03, 0.23134124D-03,
     *   0.22667850D-03, 0.22201576D-03, 0.21735302D-03, 0.21324873D-03,
     *   0.20914443D-03, 0.20504014D-03, 0.20093584D-03, 0.19683156D-03,
     *   0.19272727D-03, 0.18862297D-03, 0.18451868D-03, 0.18093106D-03,
     *   0.17734345D-03, 0.17375585D-03, 0.17016823D-03, 0.16658062D-03,
     *   0.16299300D-03, 0.15940539D-03, 0.15581778D-03, 0.15267945D-03,
     *   0.14954111D-03, 0.14640279D-03, 0.14326446D-03, 0.14012613D-03,
     *   0.13698780D-03, 0.13384948D-03, 0.13071115D-03, 0.12799964D-03,
     *   0.12528813D-03, 0.12257663D-03, 0.11986512D-03, 0.11715361D-03,
     *   0.11444210D-03, 0.11173059D-03, 0.10901909D-03, 0.10667263D-03,
     *   0.10432617D-03, 0.10197970D-03, 0.99633238D-04, 0.97286771D-04,
     *   0.94940311D-04, 0.92593851D-04, 0.90247384D-04, 0.88237888D-04,
     *   0.86228385D-04, 0.84218889D-04, 0.82209393D-04, 0.80199890D-04,
     *   0.78190395D-04, 0.76180891D-04, 0.74171396D-04, 0.72455332D-04/
      DATA (D2048(K), K =1851,1924) / 0.70739276D-04, 0.69023219D-04,
     *   0.67307155D-04, 0.65591099D-04, 0.63875035D-04, 0.62158979D-04,
     *   0.60442919D-04, 0.58989761D-04, 0.57536603D-04, 0.56083449D-04,
     *   0.54630291D-04, 0.53177133D-04, 0.51723975D-04, 0.50270817D-04,
     *   0.48817659D-04, 0.47600028D-04, 0.46382393D-04, 0.45164761D-04,
     *   0.43947126D-04, 0.42729494D-04, 0.41511859D-04, 0.40294228D-04,
     *   0.39076593D-04, 0.38059032D-04, 0.37041471D-04, 0.36023910D-04,
     *   0.35006349D-04, 0.33988788D-04, 0.32971227D-04, 0.31953667D-04,
     *   0.30936106D-04, 0.30099836D-04, 0.29263569D-04, 0.28427301D-04,
     *   0.27591033D-04, 0.26754768D-04, 0.25918500D-04, 0.25082232D-04,
     *   0.24245965D-04, 0.23557821D-04, 0.22869677D-04, 0.22181533D-04,
     *   0.21493390D-04, 0.20805246D-04, 0.20117102D-04, 0.19428959D-04,
     *   0.18740815D-04, 0.18186580D-04, 0.17632343D-04, 0.17078108D-04,
     *   0.16523873D-04, 0.15969637D-04, 0.15415402D-04, 0.14861166D-04,
     *   0.14306930D-04, 0.13860979D-04, 0.13415029D-04, 0.12969078D-04,
     *   0.12523127D-04, 0.12077177D-04, 0.11631226D-04, 0.11185274D-04,
     *   0.10739323D-04, 0.10387442D-04, 0.10035560D-04, 0.96836784D-05,
     *   0.93317967D-05, 0.89799150D-05, 0.86280334D-05, 0.82761517D-05,
     *   0.79242700D-05, 0.76496099D-05, 0.73749488D-05, 0.71002878D-05/
      DATA (D2048(K), K =1925,1998) / 0.68256272D-05, 0.65509666D-05,
     *   0.62763056D-05, 0.60016450D-05, 0.57269840D-05, 0.55169080D-05,
     *   0.53068320D-05, 0.50967560D-05, 0.48866800D-05, 0.46766040D-05,
     *   0.44665280D-05, 0.42564520D-05, 0.40463760D-05, 0.38885996D-05,
     *   0.37308234D-05, 0.35730470D-05, 0.34152706D-05, 0.32574942D-05,
     *   0.30997178D-05, 0.29419416D-05, 0.27841652D-05, 0.26682460D-05,
     *   0.25523268D-05, 0.24364078D-05, 0.23204886D-05, 0.22045695D-05,
     *   0.20886503D-05, 0.19727313D-05, 0.18568121D-05, 0.17741506D-05,
     *   0.16914892D-05, 0.16088277D-05, 0.15261661D-05, 0.14435046D-05,
     *   0.13608432D-05, 0.12781817D-05, 0.11955202D-05, 0.11383943D-05,
     *   0.10812684D-05, 0.10241424D-05, 0.96701649D-06, 0.90989056D-06,
     *   0.85276463D-06, 0.79563870D-06, 0.73851277D-06, 0.70047270D-06,
     *   0.66243263D-06, 0.62439256D-06, 0.58635248D-06, 0.54831241D-06,
     *   0.51027234D-06, 0.47223224D-06, 0.43419217D-06, 0.40997287D-06,
     *   0.38575359D-06, 0.36153429D-06, 0.33731502D-06, 0.31309571D-06,
     *   0.28887644D-06, 0.26465716D-06, 0.24043786D-06, 0.22578344D-06,
     *   0.21112901D-06, 0.19647459D-06, 0.18182017D-06, 0.16716574D-06,
     *   0.15251132D-06, 0.13785689D-06, 0.12320247D-06, 0.11493193D-06,
     *   0.10666140D-06, 0.98390856D-07, 0.90120324D-07, 0.81849784D-07/
      DATA (D2048(K), K =1999,2048) / 0.73579251D-07, 0.65308711D-07,
     *   0.57038179D-07, 0.52771284D-07, 0.48504390D-07, 0.44237495D-07,
     *   0.39970601D-07, 0.35703707D-07, 0.31436812D-07, 0.27169916D-07,
     *   0.22903022D-07, 0.20977984D-07, 0.19052946D-07, 0.17127906D-07,
     *   0.15202868D-07, 0.13277830D-07, 0.11352792D-07, 0.94277528D-08,
     *   0.75027140D-08, 0.67869950D-08, 0.60712755D-08, 0.53555560D-08,
     *   0.46398365D-08, 0.39241170D-08, 0.32083975D-08, 0.24926781D-08,
     *   0.17769587D-08, 0.15826038D-08, 0.13882490D-08, 0.11938941D-08,
     *   0.99953923D-09, 0.80518436D-09, 0.61082955D-09, 0.41647469D-09,
     *   0.22211984D-09, 0.19435485D-09, 0.16658987D-09, 0.13882490D-09,
     *   0.11105992D-09, 0.83294933D-10, 0.55529959D-10, 0.27764980D-10,
     *   0.00000000D+00, 0.00000000D+00, 0.00000000D+00, 0.00000000D+00,
     *   0.00000000D+00, 0.00000000D+00, 0.00000000D+00, 0.00000000D+00/
      DATA (D1024(K), K = 1, 74) / 0.10000000D+01, 0.99988866D+00,
     *   0.99977714D+00, 0.99966598D+00, 0.99955440D+00, 0.99943626D+00,
     *   0.99931854D+00, 0.99920028D+00, 0.99908257D+00, 0.99894392D+00,
     *   0.99880564D+00, 0.99866694D+00, 0.99852866D+00, 0.99834585D+00,
     *   0.99816316D+00, 0.99798030D+00, 0.99779761D+00, 0.99759293D+00,
     *   0.99738806D+00, 0.99718332D+00, 0.99697846D+00, 0.99672168D+00,
     *   0.99646503D+00, 0.99620819D+00, 0.99595159D+00, 0.99561983D+00,
     *   0.99528790D+00, 0.99495614D+00, 0.99462402D+00, 0.99424171D+00,
     *   0.99385989D+00, 0.99347752D+00, 0.99309546D+00, 0.99265903D+00,
     *   0.99222291D+00, 0.99178654D+00, 0.99135017D+00, 0.99088120D+00,
     *   0.99041241D+00, 0.98994327D+00, 0.98947471D+00, 0.98897654D+00,
     *   0.98847890D+00, 0.98798072D+00, 0.98748291D+00, 0.98693401D+00,
     *   0.98638469D+00, 0.98583573D+00, 0.98528647D+00, 0.98464882D+00,
     *   0.98401123D+00, 0.98337340D+00, 0.98273575D+00, 0.98206103D+00,
     *   0.98138630D+00, 0.98071158D+00, 0.98003685D+00, 0.97932982D+00,
     *   0.97862303D+00, 0.97791600D+00, 0.97720921D+00, 0.97643286D+00,
     *   0.97565633D+00, 0.97487992D+00, 0.97410339D+00, 0.97330886D+00,
     *   0.97251421D+00, 0.97171968D+00, 0.97092479D+00, 0.97007149D+00,
     *   0.96921808D+00, 0.96836478D+00, 0.96751148D+00, 0.96662027D+00/
      DATA (D1024(K), K = 75, 148) / 0.96572924D+00, 0.96483827D+00,
     *   0.96394724D+00, 0.96301448D+00, 0.96208197D+00, 0.96114910D+00,
     *   0.96021652D+00, 0.95923299D+00, 0.95824957D+00, 0.95726597D+00,
     *   0.95628262D+00, 0.95522398D+00, 0.95416504D+00, 0.95310640D+00,
     *   0.95204747D+00, 0.95097250D+00, 0.94989753D+00, 0.94882256D+00,
     *   0.94774759D+00, 0.94663709D+00, 0.94552654D+00, 0.94441599D+00,
     *   0.94330525D+00, 0.94213003D+00, 0.94095480D+00, 0.93977952D+00,
     *   0.93860412D+00, 0.93741786D+00, 0.93623137D+00, 0.93504506D+00,
     *   0.93385857D+00, 0.93262827D+00, 0.93139815D+00, 0.93016779D+00,
     *   0.92893767D+00, 0.92763728D+00, 0.92633682D+00, 0.92503643D+00,
     *   0.92373604D+00, 0.92240590D+00, 0.92107606D+00, 0.91974592D+00,
     *   0.91841596D+00, 0.91704565D+00, 0.91567552D+00, 0.91430515D+00,
     *   0.91293484D+00, 0.91155249D+00, 0.91017032D+00, 0.90878779D+00,
     *   0.90740561D+00, 0.90598828D+00, 0.90457118D+00, 0.90315384D+00,
     *   0.90173650D+00, 0.90026438D+00, 0.89879227D+00, 0.89732015D+00,
     *   0.89584804D+00, 0.89433223D+00, 0.89281642D+00, 0.89130062D+00,
     *   0.88978499D+00, 0.88823426D+00, 0.88668352D+00, 0.88513273D+00,
     *   0.88358217D+00, 0.88200194D+00, 0.88042152D+00, 0.87884134D+00,
     *   0.87726110D+00, 0.87563771D+00, 0.87401456D+00, 0.87239122D+00/
      DATA (D1024(K), K = 149, 222) / 0.87076783D+00, 0.86913085D+00,
     *   0.86749381D+00, 0.86585683D+00, 0.86421996D+00, 0.86255211D+00,
     *   0.86088419D+00, 0.85921639D+00, 0.85754848D+00, 0.85581571D+00,
     *   0.85408300D+00, 0.85235023D+00, 0.85061741D+00, 0.84887052D+00,
     *   0.84712362D+00, 0.84537667D+00, 0.84362978D+00, 0.84187919D+00,
     *   0.84012878D+00, 0.83837819D+00, 0.83662760D+00, 0.83483887D+00,
     *   0.83305001D+00, 0.83126116D+00, 0.82947224D+00, 0.82766581D+00,
     *   0.82585895D+00, 0.82405245D+00, 0.82224572D+00, 0.82039094D+00,
     *   0.81853610D+00, 0.81668133D+00, 0.81482649D+00, 0.81293780D+00,
     *   0.81104904D+00, 0.80916017D+00, 0.80727148D+00, 0.80536789D+00,
     *   0.80346406D+00, 0.80156046D+00, 0.79965663D+00, 0.79772937D+00,
     *   0.79580194D+00, 0.79387486D+00, 0.79194742D+00, 0.78998226D+00,
     *   0.78801692D+00, 0.78605175D+00, 0.78408641D+00, 0.78212947D+00,
     *   0.78017259D+00, 0.77821571D+00, 0.77625877D+00, 0.77427220D+00,
     *   0.77228558D+00, 0.77029890D+00, 0.76831234D+00, 0.76629901D+00,
     *   0.76428568D+00, 0.76227242D+00, 0.76025909D+00, 0.75823212D+00,
     *   0.75620520D+00, 0.75417829D+00, 0.75215113D+00, 0.75010371D+00,
     *   0.74805623D+00, 0.74600887D+00, 0.74396139D+00, 0.74189389D+00,
     *   0.73982632D+00, 0.73775893D+00, 0.73569137D+00, 0.73360521D+00/
      DATA (D1024(K), K = 223, 296) / 0.73151916D+00, 0.72943294D+00,
     *   0.72734684D+00, 0.72525400D+00, 0.72316122D+00, 0.72106838D+00,
     *   0.71897554D+00, 0.71686584D+00, 0.71475625D+00, 0.71264660D+00,
     *   0.71053690D+00, 0.70841002D+00, 0.70628315D+00, 0.70415640D+00,
     *   0.70202953D+00, 0.69988197D+00, 0.69773453D+00, 0.69558698D+00,
     *   0.69343948D+00, 0.69127214D+00, 0.68910480D+00, 0.68693745D+00,
     *   0.68477005D+00, 0.68261290D+00, 0.68045557D+00, 0.67829841D+00,
     *   0.67614108D+00, 0.67398292D+00, 0.67182481D+00, 0.66966665D+00,
     *   0.66750842D+00, 0.66533726D+00, 0.66316605D+00, 0.66099483D+00,
     *   0.65882361D+00, 0.65664607D+00, 0.65446848D+00, 0.65229088D+00,
     *   0.65011328D+00, 0.64791012D+00, 0.64570689D+00, 0.64350367D+00,
     *   0.64130050D+00, 0.63908291D+00, 0.63686532D+00, 0.63464773D+00,
     *   0.63243014D+00, 0.63020587D+00, 0.62798154D+00, 0.62575728D+00,
     *   0.62353295D+00, 0.62133086D+00, 0.61912864D+00, 0.61692649D+00,
     *   0.61472434D+00, 0.61252660D+00, 0.61032891D+00, 0.60813117D+00,
     *   0.60593343D+00, 0.60371804D+00, 0.60150260D+00, 0.59928715D+00,
     *   0.59707177D+00, 0.59485382D+00, 0.59263587D+00, 0.59041792D+00,
     *   0.58819997D+00, 0.58596778D+00, 0.58373559D+00, 0.58150333D+00,
     *   0.57927114D+00, 0.57704818D+00, 0.57482517D+00, 0.57260215D+00/
      DATA (D1024(K), K = 297, 370) / 0.57037914D+00, 0.56817263D+00,
     *   0.56596607D+00, 0.56375957D+00, 0.56155300D+00, 0.55933517D+00,
     *   0.55711734D+00, 0.55489945D+00, 0.55268162D+00, 0.55047923D+00,
     *   0.54827666D+00, 0.54607427D+00, 0.54387170D+00, 0.54166967D+00,
     *   0.53946745D+00, 0.53726542D+00, 0.53506321D+00, 0.53284973D+00,
     *   0.53063631D+00, 0.52842277D+00, 0.52620929D+00, 0.52399343D+00,
     *   0.52177757D+00, 0.51956171D+00, 0.51734591D+00, 0.51515377D+00,
     *   0.51296163D+00, 0.51076943D+00, 0.50857729D+00, 0.50638032D+00,
     *   0.50418329D+00, 0.50198627D+00, 0.49978930D+00, 0.49760693D+00,
     *   0.49542457D+00, 0.49324220D+00, 0.49105987D+00, 0.48889726D+00,
     *   0.48673469D+00, 0.48457208D+00, 0.48240951D+00, 0.48024017D+00,
     *   0.47807086D+00, 0.47590151D+00, 0.47373223D+00, 0.47159189D+00,
     *   0.46945158D+00, 0.46731123D+00, 0.46517092D+00, 0.46302551D+00,
     *   0.46088007D+00, 0.45873466D+00, 0.45658922D+00, 0.45443878D+00,
     *   0.45228833D+00, 0.45013785D+00, 0.44798741D+00, 0.44586658D+00,
     *   0.44374579D+00, 0.44162500D+00, 0.43950418D+00, 0.43741313D+00,
     *   0.43532205D+00, 0.43323100D+00, 0.43113995D+00, 0.42904490D+00,
     *   0.42694989D+00, 0.42485487D+00, 0.42275986D+00, 0.42067465D+00,
     *   0.41858947D+00, 0.41650426D+00, 0.41441903D+00, 0.41234154D+00/
      DATA (D1024(K), K = 371, 444) / 0.41026407D+00, 0.40818664D+00,
     *   0.40610915D+00, 0.40405071D+00, 0.40199226D+00, 0.39993382D+00,
     *   0.39787537D+00, 0.39582628D+00, 0.39377716D+00, 0.39172807D+00,
     *   0.38967898D+00, 0.38767374D+00, 0.38566849D+00, 0.38366324D+00,
     *   0.38165799D+00, 0.37964931D+00, 0.37764066D+00, 0.37563208D+00,
     *   0.37362340D+00, 0.37164736D+00, 0.36967131D+00, 0.36769527D+00,
     *   0.36571923D+00, 0.36374140D+00, 0.36176354D+00, 0.35978571D+00,
     *   0.35780787D+00, 0.35583410D+00, 0.35386035D+00, 0.35188660D+00,
     *   0.34991279D+00, 0.34798345D+00, 0.34605411D+00, 0.34412473D+00,
     *   0.34219536D+00, 0.34029329D+00, 0.33839118D+00, 0.33648908D+00,
     *   0.33458701D+00, 0.33268994D+00, 0.33079287D+00, 0.32889581D+00,
     *   0.32699874D+00, 0.32512325D+00, 0.32324776D+00, 0.32137227D+00,
     *   0.31949678D+00, 0.31763780D+00, 0.31577885D+00, 0.31391987D+00,
     *   0.31206092D+00, 0.31021237D+00, 0.30836385D+00, 0.30651531D+00,
     *   0.30466679D+00, 0.30285776D+00, 0.30104876D+00, 0.29923975D+00,
     *   0.29743075D+00, 0.29564980D+00, 0.29386884D+00, 0.29208788D+00,
     *   0.29030690D+00, 0.28853691D+00, 0.28676689D+00, 0.28499690D+00,
     *   0.28322691D+00, 0.28147370D+00, 0.27972049D+00, 0.27796730D+00,
     *   0.27621409D+00, 0.27448353D+00, 0.27275297D+00, 0.27102244D+00/
      DATA (D1024(K), K = 445, 518) / 0.26929188D+00, 0.26758409D+00,
     *   0.26587629D+00, 0.26416850D+00, 0.26246071D+00, 0.26078728D+00,
     *   0.25911379D+00, 0.25744036D+00, 0.25576693D+00, 0.25411355D+00,
     *   0.25246018D+00, 0.25080684D+00, 0.24915345D+00, 0.24752022D+00,
     *   0.24588698D+00, 0.24425374D+00, 0.24262050D+00, 0.24100164D+00,
     *   0.23938277D+00, 0.23776390D+00, 0.23614503D+00, 0.23455781D+00,
     *   0.23297057D+00, 0.23138334D+00, 0.22979610D+00, 0.22823475D+00,
     *   0.22667339D+00, 0.22511204D+00, 0.22355068D+00, 0.22202095D+00,
     *   0.22049123D+00, 0.21896151D+00, 0.21743178D+00, 0.21592793D+00,
     *   0.21442409D+00, 0.21292023D+00, 0.21141639D+00, 0.20991255D+00,
     *   0.20840870D+00, 0.20690486D+00, 0.20540100D+00, 0.20394604D+00,
     *   0.20249107D+00, 0.20103611D+00, 0.19958115D+00, 0.19814631D+00,
     *   0.19671148D+00, 0.19527663D+00, 0.19384180D+00, 0.19241415D+00,
     *   0.19098651D+00, 0.18955886D+00, 0.18813115D+00, 0.18675670D+00,
     *   0.18538225D+00, 0.18400779D+00, 0.18263334D+00, 0.18126751D+00,
     *   0.17990169D+00, 0.17853586D+00, 0.17717004D+00, 0.17582002D+00,
     *   0.17447002D+00, 0.17312001D+00, 0.17176999D+00, 0.17046455D+00,
     *   0.16915911D+00, 0.16785367D+00, 0.16654822D+00, 0.16525860D+00,
     *   0.16396897D+00, 0.16267934D+00, 0.16138971D+00, 0.16012740D+00/
      DATA (D1024(K), K = 519, 592) / 0.15886509D+00, 0.15760279D+00,
     *   0.15634046D+00, 0.15510547D+00, 0.15387048D+00, 0.15263548D+00,
     *   0.15140049D+00, 0.15018922D+00, 0.14897795D+00, 0.14776668D+00,
     *   0.14655541D+00, 0.14536282D+00, 0.14417024D+00, 0.14297765D+00,
     *   0.14178507D+00, 0.14062196D+00, 0.13945885D+00, 0.13829574D+00,
     *   0.13713264D+00, 0.13599361D+00, 0.13485458D+00, 0.13371556D+00,
     *   0.13257653D+00, 0.13145979D+00, 0.13034305D+00, 0.12922630D+00,
     *   0.12810956D+00, 0.12702660D+00, 0.12594365D+00, 0.12486069D+00,
     *   0.12377773D+00, 0.12270969D+00, 0.12164165D+00, 0.12057361D+00,
     *   0.11950557D+00, 0.11846530D+00, 0.11742502D+00, 0.11638474D+00,
     *   0.11534447D+00, 0.11433187D+00, 0.11331928D+00, 0.11230668D+00,
     *   0.11129408D+00, 0.11029755D+00, 0.10930101D+00, 0.10830447D+00,
     *   0.10730793D+00, 0.10633886D+00, 0.10536980D+00, 0.10440073D+00,
     *   0.10343167D+00, 0.10249285D+00, 0.10155402D+00, 0.10061520D+00,
     *   0.99676363D-01, 0.98754071D-01, 0.97831786D-01, 0.96909493D-01,
     *   0.95987201D-01, 0.95082156D-01, 0.94177097D-01, 0.93272053D-01,
     *   0.92367016D-01, 0.91497198D-01, 0.90627387D-01, 0.89757569D-01,
     *   0.88887751D-01, 0.88037707D-01, 0.87187663D-01, 0.86337611D-01,
     *   0.85487567D-01, 0.84654048D-01, 0.83820537D-01, 0.82987025D-01/
      DATA (D1024(K), K = 593, 666) / 0.82153514D-01, 0.81350908D-01,
     *   0.80548309D-01, 0.79745702D-01, 0.78943104D-01, 0.78151099D-01,
     *   0.77359103D-01, 0.76567098D-01, 0.75775102D-01, 0.75018056D-01,
     *   0.74261010D-01, 0.73503964D-01, 0.72746918D-01, 0.72006769D-01,
     *   0.71266614D-01, 0.70526466D-01, 0.69786310D-01, 0.69062226D-01,
     *   0.68338133D-01, 0.67614041D-01, 0.66889949D-01, 0.66196926D-01,
     *   0.65503895D-01, 0.64810857D-01, 0.64117834D-01, 0.63435994D-01,
     *   0.62754162D-01, 0.62072325D-01, 0.61390489D-01, 0.60733818D-01,
     *   0.60077142D-01, 0.59420466D-01, 0.58763791D-01, 0.58127962D-01,
     *   0.57492133D-01, 0.56856308D-01, 0.56220479D-01, 0.55602442D-01,
     *   0.54984406D-01, 0.54366369D-01, 0.53748332D-01, 0.53151593D-01,
     *   0.52554853D-01, 0.51958110D-01, 0.51361371D-01, 0.50782245D-01,
     *   0.50203115D-01, 0.49623985D-01, 0.49044859D-01, 0.48485387D-01,
     *   0.47925916D-01, 0.47366440D-01, 0.46806980D-01, 0.46265990D-01,
     *   0.45725003D-01, 0.45184013D-01, 0.44643022D-01, 0.44121493D-01,
     *   0.43599963D-01, 0.43078434D-01, 0.42556901D-01, 0.42054780D-01,
     *   0.41552659D-01, 0.41050538D-01, 0.40548418D-01, 0.40059056D-01,
     *   0.39569695D-01, 0.39080337D-01, 0.38590975D-01, 0.38122188D-01,
     *   0.37653405D-01, 0.37184622D-01, 0.36715839D-01, 0.36263946D-01/
      DATA (D1024(K), K = 667, 740) / 0.35812058D-01, 0.35360165D-01,
     *   0.34908276D-01, 0.34473523D-01, 0.34038775D-01, 0.33604022D-01,
     *   0.33169273D-01, 0.32746892D-01, 0.32324515D-01, 0.31902138D-01,
     *   0.31479757D-01, 0.31077558D-01, 0.30675359D-01, 0.30273158D-01,
     *   0.29870959D-01, 0.29482957D-01, 0.29094955D-01, 0.28706951D-01,
     *   0.28318949D-01, 0.27945055D-01, 0.27571158D-01, 0.27197264D-01,
     *   0.26823370D-01, 0.26465649D-01, 0.26107928D-01, 0.25750207D-01,
     *   0.25392486D-01, 0.25048312D-01, 0.24704136D-01, 0.24359962D-01,
     *   0.24015788D-01, 0.23686860D-01, 0.23357933D-01, 0.23029005D-01,
     *   0.22700079D-01, 0.22383424D-01, 0.22066766D-01, 0.21750111D-01,
     *   0.21433454D-01, 0.21130996D-01, 0.20828538D-01, 0.20526079D-01,
     *   0.20223619D-01, 0.19934550D-01, 0.19645480D-01, 0.19356411D-01,
     *   0.19067340D-01, 0.18789053D-01, 0.18510766D-01, 0.18232478D-01,
     *   0.17954191D-01, 0.17690888D-01, 0.17427584D-01, 0.17164281D-01,
     *   0.16900977D-01, 0.16647171D-01, 0.16393363D-01, 0.16139558D-01,
     *   0.15885752D-01, 0.15645834D-01, 0.15405915D-01, 0.15165997D-01,
     *   0.14926078D-01, 0.14695415D-01, 0.14464753D-01, 0.14234089D-01,
     *   0.14003427D-01, 0.13783546D-01, 0.13563666D-01, 0.13343787D-01,
     *   0.13123906D-01, 0.12917213D-01, 0.12710519D-01, 0.12503826D-01/
      DATA (D1024(K), K = 741, 814) / 0.12297132D-01, 0.12097510D-01,
     *   0.11897886D-01, 0.11698264D-01, 0.11498640D-01, 0.11310435D-01,
     *   0.11122230D-01, 0.10934024D-01, 0.10745819D-01, 0.10567497D-01,
     *   0.10389176D-01, 0.10210855D-01, 0.10032534D-01, 0.98623335D-02,
     *   0.96921325D-02, 0.95219323D-02, 0.93517322D-02, 0.91911769D-02,
     *   0.90306224D-02, 0.88700680D-02, 0.87095127D-02, 0.85568912D-02,
     *   0.84042689D-02, 0.82516465D-02, 0.80990242D-02, 0.79557812D-02,
     *   0.78125382D-02, 0.76692947D-02, 0.75260513D-02, 0.73895780D-02,
     *   0.72531053D-02, 0.71166321D-02, 0.69801589D-02, 0.68518878D-02,
     *   0.67236172D-02, 0.65953461D-02, 0.64670756D-02, 0.63463412D-02,
     *   0.62256074D-02, 0.61048730D-02, 0.59841392D-02, 0.58704894D-02,
     *   0.57568401D-02, 0.56431908D-02, 0.55295411D-02, 0.54226001D-02,
     *   0.53156591D-02, 0.52087181D-02, 0.51017771D-02, 0.50014262D-02,
     *   0.49010757D-02, 0.48007253D-02, 0.47003743D-02, 0.46059797D-02,
     *   0.45115850D-02, 0.44171903D-02, 0.43227957D-02, 0.42345445D-02,
     *   0.41462937D-02, 0.40580430D-02, 0.39697923D-02, 0.38872333D-02,
     *   0.38046744D-02, 0.37221154D-02, 0.36395565D-02, 0.35622346D-02,
     *   0.34849127D-02, 0.34075908D-02, 0.33302687D-02, 0.32581922D-02,
     *   0.31861158D-02, 0.31140391D-02, 0.30419626D-02, 0.29750387D-02/
      DATA (D1024(K), K = 815, 888) / 0.29081150D-02, 0.28411911D-02,
     *   0.27742675D-02, 0.27119515D-02, 0.26496358D-02, 0.25873198D-02,
     *   0.25250041D-02, 0.24672148D-02, 0.24094256D-02, 0.23516363D-02,
     *   0.22938470D-02, 0.22400422D-02, 0.21862376D-02, 0.21324328D-02,
     *   0.20786282D-02, 0.20292068D-02, 0.19797855D-02, 0.19303642D-02,
     *   0.18809428D-02, 0.18349922D-02, 0.17890416D-02, 0.17430909D-02,
     *   0.16971403D-02, 0.16548148D-02, 0.16124895D-02, 0.15701640D-02,
     *   0.15278385D-02, 0.14889024D-02, 0.14499662D-02, 0.14110301D-02,
     *   0.13720939D-02, 0.13363630D-02, 0.13006323D-02, 0.12649015D-02,
     *   0.12291707D-02, 0.11965245D-02, 0.11638784D-02, 0.11312322D-02,
     *   0.10985860D-02, 0.10684881D-02, 0.10383902D-02, 0.10082924D-02,
     *   0.97819453D-03, 0.95097767D-03, 0.92376082D-03, 0.89654396D-03,
     *   0.86932711D-03, 0.84449851D-03, 0.81966992D-03, 0.79484127D-03,
     *   0.77001267D-03, 0.74740103D-03, 0.72478934D-03, 0.70217764D-03,
     *   0.67956600D-03, 0.65909547D-03, 0.63862489D-03, 0.61815436D-03,
     *   0.59768383D-03, 0.57926733D-03, 0.56085089D-03, 0.54243440D-03,
     *   0.52401790D-03, 0.50740421D-03, 0.49079047D-03, 0.47417678D-03,
     *   0.45756306D-03, 0.44261871D-03, 0.42767439D-03, 0.41273003D-03,
     *   0.39778568D-03, 0.38442930D-03, 0.37107288D-03, 0.35771649D-03/
      DATA (D1024(K), K = 889, 962) / 0.34436010D-03, 0.33250457D-03,
     *   0.32064907D-03, 0.30879356D-03, 0.29693806D-03, 0.28636723D-03,
     *   0.27579640D-03, 0.26522556D-03, 0.25465473D-03, 0.24532925D-03,
     *   0.23600379D-03, 0.22667831D-03, 0.21735285D-03, 0.20914426D-03,
     *   0.20093568D-03, 0.19272711D-03, 0.18451853D-03, 0.17734332D-03,
     *   0.17016809D-03, 0.16299287D-03, 0.15581764D-03, 0.14954100D-03,
     *   0.14326435D-03, 0.13698770D-03, 0.13071104D-03, 0.12528803D-03,
     *   0.11986502D-03, 0.11444201D-03, 0.10901900D-03, 0.10432608D-03,
     *   0.99633158D-04, 0.94940231D-04, 0.90247311D-04, 0.86228320D-04,
     *   0.82209321D-04, 0.78190329D-04, 0.74171337D-04, 0.70739217D-04,
     *   0.67307104D-04, 0.63874984D-04, 0.60442871D-04, 0.57536559D-04,
     *   0.54630247D-04, 0.51723935D-04, 0.48817623D-04, 0.46382356D-04,
     *   0.43947090D-04, 0.41511827D-04, 0.39076560D-04, 0.37041442D-04,
     *   0.35006320D-04, 0.32971198D-04, 0.30936080D-04, 0.29263545D-04,
     *   0.27591012D-04, 0.25918478D-04, 0.24245945D-04, 0.22869659D-04,
     *   0.21493372D-04, 0.20117086D-04, 0.18740800D-04, 0.17632330D-04,
     *   0.16523860D-04, 0.15415389D-04, 0.14306918D-04, 0.13415018D-04,
     *   0.12523117D-04, 0.11631216D-04, 0.10739315D-04, 0.10035552D-04,
     *   0.93317894D-05, 0.86280270D-05, 0.79242636D-05, 0.73749429D-05/
      DATA (D1024(K), K = 963,1024) / 0.68256218D-05, 0.62763006D-05,
     *   0.57269795D-05, 0.53068279D-05, 0.48866764D-05, 0.44665244D-05,
     *   0.40463729D-05, 0.37308203D-05, 0.34152679D-05, 0.30997153D-05,
     *   0.27841629D-05, 0.25523248D-05, 0.23204868D-05, 0.20886487D-05,
     *   0.18568106D-05, 0.16914878D-05, 0.15261650D-05, 0.13608421D-05,
     *   0.11955193D-05, 0.10812674D-05, 0.96701569D-06, 0.85276395D-06,
     *   0.73851220D-06, 0.66243211D-06, 0.58635197D-06, 0.51027189D-06,
     *   0.43419180D-06, 0.38575328D-06, 0.33731473D-06, 0.28887621D-06,
     *   0.24043766D-06, 0.21112884D-06, 0.18182001D-06, 0.15251119D-06,
     *   0.12320237D-06, 0.10666131D-06, 0.90120253D-07, 0.73579187D-07,
     *   0.57038132D-07, 0.48504351D-07, 0.39970569D-07, 0.31436787D-07,
     *   0.22903004D-07, 0.19052930D-07, 0.15202856D-07, 0.11352782D-07,
     *   0.75027078D-08, 0.60712706D-08, 0.46398325D-08, 0.32083949D-08,
     *   0.17769572D-08, 0.13882479D-08, 0.99953845D-09, 0.61082905D-09,
     *   0.22211966D-09, 0.16658974D-09, 0.11105983D-09, 0.55529914D-10,
     *   0.00000000D+00, 0.00000000D+00, 0.00000000D+00, 0.00000000D+00/
      DATA (D512(K), K = 1, 74) / 0.10000000D+01, 0.99977738D+00,
     *   0.99955350D+00, 0.99932396D+00, 0.99907887D+00, 0.99882150D+00,
     *   0.99851823D+00, 0.99815977D+00, 0.99778670D+00, 0.99737889D+00,
     *   0.99696177D+00, 0.99653655D+00, 0.99598241D+00, 0.99532211D+00,
     *   0.99462718D+00, 0.99386555D+00, 0.99309671D+00, 0.99224967D+00,
     *   0.99135005D+00, 0.99043524D+00, 0.98946905D+00, 0.98848206D+00,
     *   0.98748195D+00, 0.98643523D+00, 0.98527324D+00, 0.98400444D+00,
     *   0.98271757D+00, 0.98137426D+00, 0.98000455D+00, 0.97859663D+00,
     *   0.97717601D+00, 0.97565168D+00, 0.97408158D+00, 0.97250205D+00,
     *   0.97089565D+00, 0.96926302D+00, 0.96752203D+00, 0.96574515D+00,
     *   0.96395171D+00, 0.96209562D+00, 0.96016759D+00, 0.95822763D+00,
     *   0.95622700D+00, 0.95413423D+00, 0.95200968D+00, 0.94986582D+00,
     *   0.94770950D+00, 0.94550860D+00, 0.94325340D+00, 0.94095528D+00,
     *   0.93859607D+00, 0.93622458D+00, 0.93384284D+00, 0.93140858D+00,
     *   0.92888814D+00, 0.92629153D+00, 0.92366791D+00, 0.92103875D+00,
     *   0.91836131D+00, 0.91562372D+00, 0.91287416D+00, 0.91010678D+00,
     *   0.90732265D+00, 0.90450472D+00, 0.90166128D+00, 0.89878333D+00,
     *   0.89577246D+00, 0.89273822D+00, 0.88969934D+00, 0.88660657D+00,
     *   0.88349783D+00, 0.88033819D+00, 0.87716472D+00, 0.87396377D+00/
      DATA (D512(K), K = 75, 148) / 0.87070507D+00, 0.86743820D+00,
     *   0.86415416D+00, 0.86081731D+00, 0.85742521D+00, 0.85399401D+00,
     *   0.85051143D+00, 0.84702367D+00, 0.84351701D+00, 0.84002274D+00,
     *   0.83650905D+00, 0.83292890D+00, 0.82933760D+00, 0.82574326D+00,
     *   0.82211334D+00, 0.81842262D+00, 0.81470394D+00, 0.81093401D+00,
     *   0.80714697D+00, 0.80334693D+00, 0.79953015D+00, 0.79570568D+00,
     *   0.79183626D+00, 0.78789949D+00, 0.78395820D+00, 0.78005052D+00,
     *   0.77612627D+00, 0.77216434D+00, 0.76815683D+00, 0.76414067D+00,
     *   0.76010305D+00, 0.75604302D+00, 0.75200391D+00, 0.74792558D+00,
     *   0.74379951D+00, 0.73966086D+00, 0.73551631D+00, 0.73134869D+00,
     *   0.72716713D+00, 0.72298020D+00, 0.71878481D+00, 0.71456712D+00,
     *   0.71033853D+00, 0.70610362D+00, 0.70184058D+00, 0.69754094D+00,
     *   0.69323736D+00, 0.68891102D+00, 0.68461311D+00, 0.68030405D+00,
     *   0.67595798D+00, 0.67165273D+00, 0.66732794D+00, 0.66298646D+00,
     *   0.65863591D+00, 0.65427738D+00, 0.64989108D+00, 0.64548045D+00,
     *   0.64106584D+00, 0.63663942D+00, 0.63219613D+00, 0.62774175D+00,
     *   0.62330812D+00, 0.61890966D+00, 0.61452055D+00, 0.61012667D+00,
     *   0.60572344D+00, 0.60130686D+00, 0.59686816D+00, 0.59242833D+00,
     *   0.58797306D+00, 0.58350313D+00, 0.57903087D+00, 0.57453597D+00/
      DATA (D512(K), K = 149, 222) / 0.57012820D+00, 0.56570947D+00,
     *   0.56127709D+00, 0.55683422D+00, 0.55243671D+00, 0.54802883D+00,
     *   0.54360449D+00, 0.53917915D+00, 0.53476709D+00, 0.53034174D+00,
     *   0.52590686D+00, 0.52146965D+00, 0.51707631D+00, 0.51268637D+00,
     *   0.50829428D+00, 0.50389755D+00, 0.49954182D+00, 0.49516991D+00,
     *   0.49082050D+00, 0.48648944D+00, 0.48215082D+00, 0.47780836D+00,
     *   0.47345623D+00, 0.46914870D+00, 0.46485463D+00, 0.46055979D+00,
     *   0.45625556D+00, 0.45194918D+00, 0.44768095D+00, 0.44341093D+00,
     *   0.43920791D+00, 0.43502033D+00, 0.43083081D+00, 0.42663369D+00,
     *   0.42243624D+00, 0.41826010D+00, 0.41409963D+00, 0.40993819D+00,
     *   0.40577307D+00, 0.40164965D+00, 0.39752257D+00, 0.39341784D+00,
     *   0.38940167D+00, 0.38538477D+00, 0.38136429D+00, 0.37734050D+00,
     *   0.37331605D+00, 0.36935750D+00, 0.36539841D+00, 0.36143604D+00,
     *   0.35747191D+00, 0.35350606D+00, 0.34957314D+00, 0.34570768D+00,
     *   0.34188676D+00, 0.33807591D+00, 0.33426353D+00, 0.33045116D+00,
     *   0.32669497D+00, 0.32293731D+00, 0.31917894D+00, 0.31545442D+00,
     *   0.31172848D+00, 0.30802485D+00, 0.30434352D+00, 0.30071911D+00,
     *   0.29714006D+00, 0.29356030D+00, 0.28999168D+00, 0.28644541D+00,
     *   0.28292179D+00, 0.27939767D+00, 0.27590773D+00, 0.27244046D+00/
      DATA (D512(K), K = 223, 296) / 0.26899600D+00, 0.26556277D+00,
     *   0.26214099D+00, 0.25878814D+00, 0.25546977D+00, 0.25215718D+00,
     *   0.24886762D+00, 0.24559534D+00, 0.24232307D+00, 0.23907959D+00,
     *   0.23587069D+00, 0.23269060D+00, 0.22953354D+00, 0.22638226D+00,
     *   0.22328857D+00, 0.22021793D+00, 0.21717609D+00, 0.21415731D+00,
     *   0.21114428D+00, 0.20813125D+00, 0.20515279D+00, 0.20221466D+00,
     *   0.19932261D+00, 0.19644496D+00, 0.19357020D+00, 0.19070984D+00,
     *   0.18790710D+00, 0.18515332D+00, 0.18240531D+00, 0.17966017D+00,
     *   0.17694095D+00, 0.17423326D+00, 0.17155725D+00, 0.16893886D+00,
     *   0.16634062D+00, 0.16375536D+00, 0.16117728D+00, 0.15862370D+00,
     *   0.15614069D+00, 0.15366487D+00, 0.15120779D+00, 0.14878096D+00,
     *   0.14635411D+00, 0.14394023D+00, 0.14159693D+00, 0.13925435D+00,
     *   0.13695568D+00, 0.13467287D+00, 0.13239941D+00, 0.13016124D+00,
     *   0.12795548D+00, 0.12577349D+00, 0.12362966D+00, 0.12148907D+00,
     *   0.11934920D+00, 0.11726442D+00, 0.11519171D+00, 0.11316255D+00,
     *   0.11115249D+00, 0.10915565D+00, 0.10717201D+00, 0.10522455D+00,
     *   0.10330458D+00, 0.10142358D+00, 0.99564202D-01, 0.97704820D-01,
     *   0.95867045D-01, 0.94042234D-01, 0.92267111D-01, 0.90524398D-01,
     *   0.88788882D-01, 0.87074250D-01, 0.85377619D-01, 0.83696112D-01/
      DATA (D512(K), K = 297, 370) / 0.82062855D-01, 0.80454804D-01,
     *   0.78857191D-01, 0.77270389D-01, 0.75694017D-01, 0.74171484D-01,
     *   0.72670907D-01, 0.71176454D-01, 0.69709644D-01, 0.68258889D-01,
     *   0.66820569D-01, 0.65420516D-01, 0.64045049D-01, 0.62678955D-01,
     *   0.61335195D-01, 0.59996471D-01, 0.58703117D-01, 0.57429202D-01,
     *   0.56165732D-01, 0.54921709D-01, 0.53693883D-01, 0.52486766D-01,
     *   0.51310252D-01, 0.50144181D-01, 0.48996381D-01, 0.47875453D-01,
     *   0.46760462D-01, 0.45670804D-01, 0.44603549D-01, 0.43552876D-01,
     *   0.42518768D-01, 0.41501224D-01, 0.40502764D-01, 0.39522305D-01,
     *   0.38552288D-01, 0.37607297D-01, 0.36683548D-01, 0.35766643D-01,
     *   0.34870170D-01, 0.33990484D-01, 0.33133302D-01, 0.32281287D-01,
     *   0.31451672D-01, 0.30641526D-01, 0.29840380D-01, 0.29052917D-01,
     *   0.28285978D-01, 0.27533980D-01, 0.26794586D-01, 0.26073555D-01,
     *   0.25361435D-01, 0.24668986D-01, 0.23987517D-01, 0.23322731D-01,
     *   0.22671707D-01, 0.22031510D-01, 0.21406077D-01, 0.20797927D-01,
     *   0.20196617D-01, 0.19610250D-01, 0.19041527D-01, 0.18478205D-01,
     *   0.17930275D-01, 0.17399134D-01, 0.16875373D-01, 0.16362539D-01,
     *   0.15863463D-01, 0.15375935D-01, 0.14902448D-01, 0.14435084D-01,
     *   0.13981581D-01, 0.13538880D-01, 0.13103741D-01, 0.12683995D-01/
      DATA (D512(K), K = 371, 444) / 0.12277076D-01, 0.11873038D-01,
     *   0.11479925D-01, 0.11100391D-01, 0.10728353D-01, 0.10367298D-01,
     *   0.10015244D-01, 0.96712457D-02, 0.93379831D-02, 0.90094004D-02,
     *   0.86947428D-02, 0.83885845D-02, 0.80881547D-02, 0.77957590D-02,
     *   0.75140754D-02, 0.72377645D-02, 0.69703134D-02, 0.67111561D-02,
     *   0.64578950D-02, 0.62153684D-02, 0.59753624D-02, 0.57456801D-02,
     *   0.55223368D-02, 0.53054420D-02, 0.50947815D-02, 0.48912321D-02,
     *   0.46944954D-02, 0.45026578D-02, 0.43176743D-02, 0.41382266D-02,
     *   0.39659129D-02, 0.37971998D-02, 0.36355697D-02, 0.34788386D-02,
     *   0.33274761D-02, 0.31816270D-02, 0.30396488D-02, 0.29043036D-02,
     *   0.27722369D-02, 0.26457638D-02, 0.25232066D-02, 0.24054425D-02,
     *   0.22920896D-02, 0.21828490D-02, 0.20776072D-02, 0.19760688D-02,
     *   0.18797063D-02, 0.17851666D-02, 0.16961629D-02, 0.16096516D-02,
     *   0.15267788D-02, 0.14474519D-02, 0.13711518D-02, 0.12984973D-02,
     *   0.12281467D-02, 0.11613821D-02, 0.10973691D-02, 0.10366503D-02,
     *   0.97744691D-03, 0.92180556D-03, 0.86860306D-03, 0.81750122D-03,
     *   0.76933118D-03, 0.72281243D-03, 0.67903567D-03, 0.63703174D-03,
     *   0.59723324D-03, 0.55942358D-03, 0.52353449D-03, 0.48940704D-03,
     *   0.45711084D-03, 0.42661146D-03, 0.39752494D-03, 0.37028373D-03/
      DATA (D512(K), K = 445, 512) / 0.34433370D-03, 0.31997793D-03,
     *   0.29699001D-03, 0.27523981D-03, 0.25485954D-03, 0.23571911D-03,
     *   0.21767645D-03, 0.20069008D-03, 0.18489467D-03, 0.17002369D-03,
     *   0.15618613D-03, 0.14320549D-03, 0.13110075D-03, 0.11985292D-03,
     *   0.10935723D-03, 0.99634053D-04, 0.90578615D-04, 0.82212719D-04,
     *   0.74453026D-04, 0.67321693D-04, 0.60704082D-04, 0.54652945D-04,
     *   0.49071929D-04, 0.43953656D-04, 0.39292143D-04, 0.35015662D-04,
     *   0.31128609D-04, 0.27584741D-04, 0.24390392D-04, 0.21472595D-04,
     *   0.18849287D-04, 0.16494092D-04, 0.14379236D-04, 0.12484496D-04,
     *   0.10795986D-04, 0.93021017D-05, 0.79736565D-05, 0.68043232D-05,
     *   0.57764310D-05, 0.48779375D-05, 0.40919645D-05, 0.34128861D-05,
     *   0.28252305D-05, 0.23219652D-05, 0.18921897D-05, 0.15282563D-05,
     *   0.12233083D-05, 0.96846713D-06, 0.75902960D-06, 0.58668871D-06,
     *   0.44788416D-06, 0.33619881D-06, 0.24807244D-06, 0.17928552D-06,
     *   0.12667343D-06, 0.87159400D-07, 0.58128244D-07, 0.37426236D-07,
     *   0.23119437D-07, 0.13592559D-07, 0.75270030D-08, 0.38569024D-08,
     *   0.17856030D-08, 0.71698825D-09, 0.23487548D-09, 0.55628401D-10,
     *   0.69535501D-11, 0.00000000D+00/
      DATA (D256(K), K = 1, 74) / 0.10000000D+01, 0.99955386D+00,
     *   0.99908137D+00, 0.99852824D+00, 0.99779707D+00, 0.99697769D+00,
     *   0.99595129D+00, 0.99462312D+00, 0.99309504D+00, 0.99134922D+00,
     *   0.98947334D+00, 0.98748273D+00, 0.98528582D+00, 0.98273510D+00,
     *   0.98003578D+00, 0.97720850D+00, 0.97410303D+00, 0.97092408D+00,
     *   0.96751106D+00, 0.96394664D+00, 0.96021539D+00, 0.95628262D+00,
     *   0.95204711D+00, 0.94774687D+00, 0.94330484D+00, 0.93860388D+00,
     *   0.93385804D+00, 0.92893726D+00, 0.92373508D+00, 0.91841501D+00,
     *   0.91293347D+00, 0.90740514D+00, 0.90173596D+00, 0.89584702D+00,
     *   0.88978380D+00, 0.88358128D+00, 0.87726057D+00, 0.87076688D+00,
     *   0.86421919D+00, 0.85754800D+00, 0.85061705D+00, 0.84362918D+00,
     *   0.83662719D+00, 0.82947183D+00, 0.82224536D+00, 0.81482625D+00,
     *   0.80727124D+00, 0.79965651D+00, 0.79194707D+00, 0.78408581D+00,
     *   0.77625829D+00, 0.76831162D+00, 0.76025850D+00, 0.75215048D+00,
     *   0.74396092D+00, 0.73569107D+00, 0.72734642D+00, 0.71897489D+00,
     *   0.71053630D+00, 0.70202893D+00, 0.69343877D+00, 0.68476939D+00,
     *   0.67614055D+00, 0.66750801D+00, 0.65882319D+00, 0.65011293D+00,
     *   0.64130014D+00, 0.63242978D+00, 0.62353259D+00, 0.61472392D+00,
     *   0.60593307D+00, 0.59707135D+00, 0.58819962D+00, 0.57927078D+00/
      DATA (D256(K), K = 75, 148) / 0.57037872D+00, 0.56155264D+00,
     *   0.55268121D+00, 0.54387128D+00, 0.53506279D+00, 0.52620882D+00,
     *   0.51734555D+00, 0.50857693D+00, 0.49978894D+00, 0.49105951D+00,
     *   0.48240915D+00, 0.47373194D+00, 0.46517056D+00, 0.45658886D+00,
     *   0.44798702D+00, 0.43950382D+00, 0.43113959D+00, 0.42275953D+00,
     *   0.41441873D+00, 0.40610895D+00, 0.39787516D+00, 0.38967878D+00,
     *   0.38165778D+00, 0.37362313D+00, 0.36571896D+00, 0.35780761D+00,
     *   0.34991249D+00, 0.34219509D+00, 0.33458674D+00, 0.32699850D+00,
     *   0.31949651D+00, 0.31206068D+00, 0.30466652D+00, 0.29743055D+00,
     *   0.29030669D+00, 0.28322667D+00, 0.27621388D+00, 0.26929164D+00,
     *   0.26246047D+00, 0.25576669D+00, 0.24915323D+00, 0.24262027D+00,
     *   0.23614483D+00, 0.22979589D+00, 0.22355048D+00, 0.21743158D+00,
     *   0.21141620D+00, 0.20540081D+00, 0.19958097D+00, 0.19384162D+00,
     *   0.18813100D+00, 0.18263321D+00, 0.17716990D+00, 0.17176986D+00,
     *   0.16654809D+00, 0.16138959D+00, 0.15634035D+00, 0.15140037D+00,
     *   0.14655529D+00, 0.14178497D+00, 0.13713253D+00, 0.13257642D+00,
     *   0.12810946D+00, 0.12377763D+00, 0.11950547D+00, 0.11534438D+00,
     *   0.11129399D+00, 0.10730784D+00, 0.10343158D+00, 0.99676274D-01,
     *   0.95987104D-01, 0.92366949D-01, 0.88887691D-01, 0.85487500D-01/
      DATA (D256(K), K = 149, 222) / 0.82153454D-01, 0.78943044D-01,
     *   0.75775050D-01, 0.72746865D-01, 0.69786265D-01, 0.66889904D-01,
     *   0.64117797D-01, 0.61390460D-01, 0.58763761D-01, 0.56220450D-01,
     *   0.53748306D-01, 0.51361345D-01, 0.49044833D-01, 0.46806946D-01,
     *   0.44642989D-01, 0.42556871D-01, 0.40548388D-01, 0.38590945D-01,
     *   0.36715813D-01, 0.34908250D-01, 0.33169247D-01, 0.31479735D-01,
     *   0.29870939D-01, 0.28318929D-01, 0.26823349D-01, 0.25392469D-01,
     *   0.24015769D-01, 0.22700062D-01, 0.21433439D-01, 0.20223605D-01,
     *   0.19067327D-01, 0.17954178D-01, 0.16900966D-01, 0.15885739D-01,
     *   0.14926068D-01, 0.14003417D-01, 0.13123897D-01, 0.12297124D-01,
     *   0.11498632D-01, 0.10745810D-01, 0.10032526D-01, 0.93517257D-02,
     *   0.87095071D-02, 0.80990186D-02, 0.75260461D-02, 0.69801537D-02,
     *   0.64670709D-02, 0.59841345D-02, 0.55295373D-02, 0.51017734D-02,
     *   0.47003711D-02, 0.43227924D-02, 0.39697895D-02, 0.36395539D-02,
     *   0.33302663D-02, 0.30419603D-02, 0.27742654D-02, 0.25250022D-02,
     *   0.22938452D-02, 0.20786268D-02, 0.18809414D-02, 0.16971391D-02,
     *   0.15278374D-02, 0.13720929D-02, 0.12291698D-02, 0.10985852D-02,
     *   0.97819383D-03, 0.86932653D-03, 0.77001215D-03, 0.67956554D-03,
     *   0.59768336D-03, 0.52401755D-03, 0.45756274D-03, 0.39778539D-03/
      DATA (D256(K), K = 223, 256) / 0.34435984D-03, 0.29693785D-03,
     *   0.25465456D-03, 0.21735269D-03, 0.18451840D-03, 0.15581754D-03,
     *   0.13071095D-03, 0.10901893D-03, 0.90247246D-04, 0.74171279D-04,
     *   0.60442828D-04, 0.48817587D-04, 0.39076534D-04, 0.30936058D-04,
     *   0.24245928D-04, 0.18740786D-04, 0.14306908D-04, 0.10739307D-04,
     *   0.79242582D-05, 0.57269754D-05, 0.40463701D-05, 0.27841609D-05,
     *   0.18568093D-05, 0.11955184D-05, 0.73851163D-06, 0.43419149D-06,
     *   0.24043749D-06, 0.12320228D-06, 0.57038090D-07, 0.22902988D-07,
     *   0.75027025D-08, 0.17769559D-08, 0.22211949D-09, 0.00000000D+00/
      DATA (D128(K), K = 1, 74) / 0.10000000D+01, 0.99908262D+00,
     *   0.99779850D+00, 0.99604803D+00, 0.99306059D+00, 0.98948598D+00,
     *   0.98537904D+00, 0.98006076D+00, 0.97409171D+00, 0.96764272D+00,
     *   0.96027130D+00, 0.95207429D+00, 0.94344133D+00, 0.93400246D+00,
     *   0.92376596D+00, 0.91305602D+00, 0.90183997D+00, 0.88981980D+00,
     *   0.87741667D+00, 0.86442417D+00, 0.85070693D+00, 0.83670962D+00,
     *   0.82239252D+00, 0.80744815D+00, 0.79214329D+00, 0.77641779D+00,
     *   0.76044500D+00, 0.74410719D+00, 0.72753996D+00, 0.71077299D+00,
     *   0.69369149D+00, 0.67633677D+00, 0.65905917D+00, 0.64151472D+00,
     *   0.62379038D+00, 0.60619074D+00, 0.58850855D+00, 0.57060063D+00,
     *   0.55290914D+00, 0.53524989D+00, 0.51757151D+00, 0.50004065D+00,
     *   0.48269126D+00, 0.46533415D+00, 0.44817048D+00, 0.43138909D+00,
     *   0.41465452D+00, 0.39804167D+00, 0.38194516D+00, 0.36589819D+00,
     *   0.35009879D+00, 0.33487153D+00, 0.31971887D+00, 0.30487317D+00,
     *   0.29061267D+00, 0.27648199D+00, 0.26266778D+00, 0.24940275D+00,
     *   0.23645900D+00, 0.22379066D+00, 0.21167313D+00, 0.19985393D+00,
     *   0.18840194D+00, 0.17743188D+00, 0.16684051D+00, 0.15659338D+00,
     *   0.14680526D+00, 0.13742448D+00, 0.12837936D+00, 0.11978175D+00,
     *   0.11157072D+00, 0.10368582D+00, 0.96261524D-01, 0.89152798D-01/
      DATA (D128(K), K = 75, 128) / 0.82414135D-01, 0.76054148D-01,
     *   0.70046298D-01, 0.64370319D-01, 0.59008654D-01, 0.54002706D-01,
     *   0.49285788D-01, 0.44886403D-01, 0.40775500D-01, 0.36930677D-01,
     *   0.33380438D-01, 0.30061310D-01, 0.27002519D-01, 0.24180938D-01,
     *   0.21584731D-01, 0.19202963D-01, 0.17018240D-01, 0.15033076D-01,
     *   0.13220751D-01, 0.11581088D-01, 0.10104765D-01, 0.87710721D-02,
     *   0.75826081D-02, 0.65150796D-02, 0.55715344D-02, 0.47341324D-02,
     *   0.39989287D-02, 0.33545389D-02, 0.27939701D-02, 0.23090639D-02,
     *   0.18920213D-02, 0.15360290D-02, 0.12354840D-02, 0.98204915D-03,
     *   0.77204866D-03, 0.59790740D-03, 0.45675662D-03, 0.34285881D-03,
     *   0.25298671D-03, 0.18283712D-03, 0.12918278D-03, 0.88886001D-04,
     *   0.59279748D-04, 0.38167640D-04, 0.23577428D-04, 0.13861824D-04,
     *   0.76761107D-05, 0.39333067D-05, 0.18209753D-05, 0.73119162D-06,
     *   0.23952828D-06, 0.56730382D-07, 0.70912978D-08, 0.00000000D+00/
      DATA (D64(K), K = 1, 64) / 0.10000000D+01, 0.99779868D+00,
     *   0.99312079D+00, 0.98533720D+00, 0.97419792D+00, 0.96029246D+00,
     *   0.94330323D+00, 0.92388147D+00, 0.90191746D+00, 0.87733752D+00,
     *   0.85073709D+00, 0.82251847D+00, 0.79206163D+00, 0.76052654D+00,
     *   0.72759676D+00, 0.69365513D+00, 0.65930039D+00, 0.62384278D+00,
     *   0.58849496D+00, 0.55311674D+00, 0.51770538D+00, 0.48275045D+00,
     *   0.44834298D+00, 0.41472852D+00, 0.38200819D+00, 0.35024267D+00,
     *   0.31975839D+00, 0.29068971D+00, 0.26269138D+00, 0.23643655D+00,
     *   0.21166086D+00, 0.18841054D+00, 0.16680114D+00, 0.14676334D+00,
     *   0.12836067D+00, 0.11149929D+00, 0.96176259D-01, 0.82326598D-01,
     *   0.69948867D-01, 0.58872603D-01, 0.49152710D-01, 0.40618733D-01,
     *   0.33227336D-01, 0.26858632D-01, 0.21444725D-01, 0.16884508D-01,
     *   0.13101419D-01, 0.99950684D-02, 0.74867313D-02, 0.54947957D-02,
     *   0.39398149D-02, 0.27510091D-02, 0.18619326D-02, 0.12137230D-02,
     *   0.75654552D-03, 0.44670494D-03, 0.24736693D-03, 0.12675297D-03,
     *   0.58681933D-04, 0.23563054D-04, 0.77189316D-05, 0.18281679D-05,
     *   0.22852099D-06, 0.00000000D+00/
C----------------------------------------------------------------------
      IRET = 0
C
      INTBIT = ABS (DBITS)
      IBIT = MIN (INTBIT + 1, NFFT)
      JBIT = MIN (IBIT+1, NFFT)
      DSLOPE = 0.0
      DOFFST = 1.0D0
C                                       Case weighting_fn of:
C                                       HANNING:
      IF (LFUNC(:4).EQ.'HANN') THEN
C                                       Case FFT_size of:
C                                       2048:
         IF (NFFT.EQ.2048) THEN
            DSLOPE = D2048(JBIT) - D2048(IBIT)
            DOFFST = D2048(IBIT)
C                                       1024:
         ELSE IF (NFFT.EQ.1024) THEN
            DSLOPE = D1024(JBIT) - D1024(IBIT)
            DOFFST = D1024(IBIT)
C                                       512:
         ELSE IF (NFFT.EQ.512) THEN
            DSLOPE = D512(JBIT) - D512(IBIT)
            DOFFST = D512(IBIT)
C                                       256:
         ELSE IF (NFFT.EQ.256) THEN
            DSLOPE = D256(JBIT) - D256(IBIT)
            DOFFST = D256(IBIT)
C                                       128:
         ELSE IF (NFFT.EQ.128) THEN
            DSLOPE = D128(JBIT) - D128(IBIT)
            DOFFST = D128(IBIT)
C                                       64:
         ELSE IF (NFFT.EQ.64) THEN
            DSLOPE = D64(JBIT) - D64(IBIT)
            DOFFST = D64(IBIT)
C                                       error
         ELSE
            IRET = 1
            DOFFST = 1.0D0
            DSLOPE = 0.0D0
            END IF
C                                       Linear interpolation
         DFACT = (ABS (DBITS) - (IBIT - 1)) * DSLOPE + DOFFST
C                                       UNIFORM:
      ELSE IF (LFUNC(:4).EQ.'UNIF') THEN
         DFRAC = ABS (DBITS) / DBLE (NFFT)
         DFACT = 1.0D0 - DFRAC
C                                       bad type
      ELSE
         IRET = 1
         DFACT = 1.0D0
         END IF
C                                       Exit
999   RETURN
      END
