      SUBROUTINE PLTVSZ (VPCORN, BLC, TRC, CATR, VBLC, VTRC, VASEC)
C-----------------------------------------------------------------------
C! Find size of box for polarization vector plot
C# Map Plot
C-----------------------------------------------------------------------
C;  Copyright (C) 2019, 2023
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PLTVSZ figures out the size and scale of the polarization vector
C   Inputs:
C      VPCORN   I        Code indicating where to put the plot
C                           1: lower left-hand corner
C                           2: lower right-hand corner
C                           3: upper left-hand corner
C                           4: upper right-hand corner
C      CATR     R(256)   Map header.
C   Output:
C      VBLC     I(2)     vector box BLC
C      VTRC     I(2)     Vector box TRC
C      IERR     I        Error code. 0: success,
C                            -1: HPBW not defined
C                            -2: plot too big
C-----------------------------------------------------------------------
      INTEGER   VBLC(2), VTRC(2), VPCORN
      REAL      CATR(256), BLC(7), TRC(7), VASEC
C
      REAL     X, X0, XM, Y, DX, DY, Y0, YM, YC(24)
      INTEGER  I, K
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DLOC.INC'
      DATA YC /0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5,
     *   1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 500.0, 1000.,
     *   2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
      VBLC(1) = 0.0
      VTRC(1) = 0.0
      VBLC(2) = 0.0
      VTRC(2) = 0.0
      IF (AXTYP(LOCNUM).NE.1) GO TO 999
      IF ((LABTYP(LOCNUM).NE.56) .AND. (LABTYP(LOCNUM).NE.65)) GO TO 999
C
      X = (TRC(1) - BLC(1)) * ABS (CATR(KRCIC)) * 3600.0
      DO 10 I = 1,24
         K = X / YC(25-I)
         IF ((K.GE.9.0) .AND. (K.LE.18.0)) THEN
            Y = YC(25-I)
            GO TO 30
            END IF
 10      CONTINUE
      DO 20 I = 1,24
         K = X / YC(25-I)
         IF ((K.GE.7.0) .AND. (K.LE.25.0)) THEN
            Y = YC(25-I)
            GO TO 30
            END IF
 20      CONTINUE
 30   VASEC = Y
C                                       Compute scaling
      DX = 1.0
      DY = 1.0
      IF (CATR(KRCIC).NE.0.0) DX = 1.0 / (ABS(CATR(KRCIC)) * 3600.)
      IF (CATR(KRCIC+1).NE.0.0) DY = 1.0 / (ABS(CATR(KRCIC+1)) * 3600.)
      XM = Y * DX
      YM = Y * DY
      IF (VPCORN.EQ.1) THEN
         X0 = BLC(1) + XM/2.0
         Y0 = BLC(2) + YM/2.0
      ELSE IF (VPCORN.EQ.2) THEN
         X0 = TRC(1) - 2.5 * XM
         Y0 = BLC(2) + YM/2.0
      ELSE IF (VPCORN.EQ.3) THEN
         X0 = TRC(1) - 2.5 * XM
         Y0 = TRC(2) - 1.5 * YM
      ELSE IF (VPCORN.EQ.4) THEN
         X0 = BLC(1) + XM/2.0
         Y0 = TRC(2) - 1.5 * YM
         END IF
      IF ((X0.LT.BLC(1)) .OR. (X0+2.*XM.GT.TRC(1)) .OR.
     *   (Y0.LT.BLC(2)) .OR. (Y0+YM.GT.TRC(2))) GO TO 999
C                                       Draw a box around the beam
      VBLC(1) = X0 + 0.02
      VTRC(1) = X0 + 2.0 * XM
      VBLC(2) = Y0 + 0.02
      VTRC(2) = Y0 + YM + 0.98
C
 999  RETURN
      END
