      SUBROUTINE PPINI (OPCODE, BUFFER, DISK, CNO, VER, CATBLK, LUN,
     *   IPPRNO, PPKOLS, PPNUMV, NUMIF, NUMFRQ, BIF, BCHAN, PPOL, IERR)
C-----------------------------------------------------------------------
C! Create/open/initialize R-L or X-Y phase difference (PP) table
C# EXT-util Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2019, 2021-2022, 2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Creates and initializes phase difference (PP) extension tables.
C   Inputs:
C      OPCODE   C*4      Operation code:
C                        'WRIT' = create/init for write or read
C                        'READ' = open for read only
C      DISK     I        Disk to use.
C      CNO      I        Catalog slot number
C      LUN      I        Logical unit number to use
C   Input/output
C      VER      I        PP file version
C      CATBLK   I(256)   Catalog header block.
C   Input (create) / output (pre-existing)
C      NUMIF    I        Number of IFs
C      NUMFRQ   I        Number of frequency channels
C      BIF      I        First IF
C      BCHAN    I        Start channel number
C      PPOL     I        0 unknown, 1 -> RL, 2 -> VH
C   Output:
C      BUFFER   I(512)   I/O buffer and related storage, also defines
C                        file if open.
C      IPPRNO   I        Next scan number, start of the file if 'READ',
C                        the last+1 if WRITE
C      PPKOLS   I(MAXPPC)   The column pointer array in order:
C                        SUBARRAY, FREQ. ID,
C                        Phase(NUMFRQ,NUMIF)
C      PPNUMV   I(MAXPPC)   Element count in each column.
C      IERR     I        Return error code, 0=>OK, else TABINI or TABIO
C                        error.
C-----------------------------------------------------------------------
      INTEGER   MAXPPC
      PARAMETER (MAXPPC = 5)
C
      INCLUDE 'INCS:PUVD.INC'
      CHARACTER OPCODE*4
      INTEGER   BUFFER(*), DISK, CNO, VER, CATBLK(256), LUN, IPPRNO,
     *   PPKOLS(MAXPPC), PPNUMV(MAXPPC), NUMIF, NUMFRQ, BIF, BCHAN,
     *   PPOL, IERR
C
      HOLLERITH HOLTMP(6)
      CHARACTER TTITLE*56, TITLE(MAXPPC)*24, UNITS(MAXPPC)*8, KEYW(5)*8
      INTEGER   NKEY, NREC, DATP(128,2), NCOL, NTT, DTYP(MAXPPC), NDATA,
     *   KLOCS(5), KEYVAL(5), KEYTYP(5), IPOINT, MSGSAV, I, NC, JERR,
     *   ITRIM, ITEMP(6)
      REAL      KEYVAR(12)
      LOGICAL   DOREAD, NEWFIL
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      EQUIVALENCE (KEYVAL, KEYVAR), (HOLTMP, ITEMP)
      DATA NTT /56/
      DATA TTITLE /'AIPS UV DATA FILE PHASE DIFFERENCE TABLE '/
      DATA DTYP /12, 14, 14, 2, 2/
      DATA TITLE /'TIME', 'SUBARRAY ', 'FREQ ID ', 'PHASE DIFF',
     *   'PHASE RMS'/
      DATA KEYW /'NO_IF', 'NO_CHAN', 'BIF', 'BCHAN', 'PP POL'/
      DATA UNITS /'DAYS', ' ', ' ', 2*'DEGREES'/
C-----------------------------------------------------------------------
C                                       Check OPCODE
      DOREAD = OPCODE.EQ.'READ'
C                                       Open file
      NREC = 1
      NKEY = 5
      NDATA = MAXPPC
      CALL FILL (NDATA, 0, PPKOLS)
      CALL FILL (NDATA, 0, PPNUMV)
C                                       Fill in types
      IF (.NOT.DOREAD) THEN
         NCOL = NDATA
         CALL COPY (NDATA, DTYP, DATP(1,2))
C                                       Chan. shift type
         DATP(4,2) = DTYP(4) + 10*NUMIF*NUMFRQ
         DATP(5,2) = DTYP(5) + 10*NUMIF*NUMFRQ
      ELSE
         NCOL = 0
         END IF
C                                       Create/open file
      CALL TABINI (OPCODE, 'PP', DISK, CNO, VER, CATBLK, LUN, NKEY,
     *   NREC, NCOL, DATP, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR (OPCODE, 'TABINI', 'PPINI', IERR)
         GO TO 990
         END IF
      NEWFIL = IERR.LT.0
      MSGSAV = MSGSUP
C                                       Get number of scans
      IPPRNO = BUFFER(5) + 1
      IF (DOREAD) IPPRNO = 1
      NKEY = 5
C                                       File created, initialize
      IF (NEWFIL) THEN
C                                       Col. labels.
         DO 10 I = 1,NCOL
            CALL CHR2H (24, TITLE(I), 1, ITEMP)
            CALL TABIO ('WRIT', 3, I, ITEMP, BUFFER, IERR)
            IF (IERR.GT.0) THEN
               CALL TABERR ('WRIT', 'TABIO', 'PPINI', IERR)
               GO TO 990
               END IF
C                                       Units
            CALL CHR2H (8, UNITS(I), 1, ITEMP)
            CALL TABIO ('WRIT', 4, I, ITEMP, BUFFER, IERR)
            IF (IERR.GT.0) THEN
               CALL TABERR ('WRIT', 'TABIO', 'PPINI', IERR)
               GO TO 990
               END IF
 10         CONTINUE
C                                       Fill in Table title
         CALL CHR2H (NTT, TTITLE, 1, BUFFER(101))
C                                       Set keyword values
C                                       No. IFs
         KLOCS(1) = 1
         KEYTYP(1) = 4
         KEYVAL(1) = NUMIF
C                                       No. channels
         KLOCS(2) = 2
         KEYTYP(2) = 4
         KEYVAL(2) = NUMFRQ
C                                       start IF
         KLOCS(3) = 3
         KEYTYP(3) = 4
         KEYVAL(3) = BIF
C                                       Start channel
         KLOCS(4) = 4
         KEYTYP(4) = 4
         KEYVAL(4) = BCHAN
C                                       Polarization code
         KLOCS(5) = 5
         KEYTYP(5) = 4
         KEYVAL(5) = PPOL
C                                       Only write if just created.
         CALL TABKEY ('WRIT', KEYW, NKEY, BUFFER, KLOCS, KEYVAL, KEYTYP,
     *      IERR)
         IF ((IERR.GE.1) .AND. (IERR.LE.20)) THEN
            CALL TABERR ('WRIT', 'TABKEY', 'PPINI', IERR)
            GO TO 990
            END IF
C                                       Read keywords
      ELSE
         MSGSUP = 32000
         CALL TABKEY ('READ', KEYW, NKEY, BUFFER, KLOCS, KEYVAL, KEYTYP,
     *      IERR)
         MSGSUP = MSGSAV
         IF ((IERR.GE.1) .AND. (IERR.LE.20)) THEN
            CALL TABERR ('READ', 'TABKEY', 'PPINI', IERR)
            GO TO 990
            END IF
C                                       Retrieve keyword values
C                                       No. IFs
         IPOINT = KLOCS(1)
         IF (IPOINT.GT.0) NUMIF = KEYVAL(IPOINT)
C                                       No. channels
         IPOINT = KLOCS(2)
         IF (IPOINT.GT.0) NUMFRQ = KEYVAL(IPOINT)
C                                       First IF
         IPOINT = KLOCS(3)
         IF (IPOINT.GT.0) BIF = KEYVAL(IPOINT)
C                                       First channel
         IPOINT = KLOCS(4)
         IF (IPOINT.GT.0) BCHAN = KEYVAL(IPOINT)
C                                       Polarization
         PPOL = 0
         IPOINT = KLOCS(5)
         IF (IPOINT.GT.0) PPOL = KEYVAL(IPOINT)
         END IF
      IERR = 0
C                                      Get array indices
C                                      Cover your ass from FNDCOL -
C                                      close to flush the buffers and
C                                      then reopen.
      CALL TABIO ('CLOS', 0, IPOINT, KEYVAL, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR ('CLOS', 'TABIO', 'PPINI', IERR)
         GO TO 990
         END IF
      NKEY = 0
      CALL TABINI (OPCODE, 'PP', DISK, CNO, VER, CATBLK, LUN, NKEY,
     *   NREC, NCOL, DATP, BUFFER, IERR)
      IF (IERR.GT.0) THEN
         CALL TABERR (OPCODE, 'TABINI', 'PPINI', IERR)
         GO TO 990
         END IF
      CALL FNDCOL (NDATA, TITLE, 24, .TRUE., BUFFER, PPKOLS, JERR)
C                                      Get array indices and no. values
      DO 150 I = 1,NDATA
         IPOINT = PPKOLS(I)
         IF (IPOINT.GT.0) THEN
            PPKOLS(I) = DATP(IPOINT,1)
            PPNUMV(I) = DATP(IPOINT,2) / 10
            IF (PPNUMV(I).LE.0) THEN
               NC = ITRIM (TITLE(I))
               WRITE (MSGTXT,1100) TITLE(I)(:NC)
               CALL MSGWRT (6)
               END IF
         ELSE
            PPKOLS(I) = -1
            PPNUMV(I) = 0
            NC = ITRIM (TITLE(I))
            WRITE (MSGTXT,1101) TITLE(I)(:NC)
            CALL MSGWRT (6)
            END IF
 150     CONTINUE
      GO TO 999
C                                       Error
 990  WRITE (MSGTXT,1990) OPCODE
      CALL MSGWRT (7)
C
 999  RETURN
C-----------------------------------------------------------------------
 1100 FORMAT ('PPINI: ''',A,''' COLUMN HAS NO VALUES')
 1101 FORMAT ('PPINI: ''',A,''' COLUMN NOT FOUND')
 1990 FORMAT ('PPINI: ERROR INITIALIZING PP TABLE FOR ',A)
      END
