      SUBROUTINE REFSET (IS, JS, LCHAN, NUMBL, MAXTEL, MAXPOL, MAXIFS,
     *   SPCWT, REFANT)
C-----------------------------------------------------------------------
C! Finds a reference antenna from all channels, IFs, antennas
C# UV UV-util Calibration
C-----------------------------------------------------------------------
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Look over all channels to find antenna with max weight
C   Inputs:
C      IS       I(*)   First ant. of baseline numbers
C      JS       I(*)   2nd ant. of baseline numbers
C      LCHAN    I      Maximum number of frequency channels.
C      NUMBL    I      Maximum number of baselines
C      MAXTEL   I      Maximum number of antennas
C      MAXPOL   I      Maximum number polarizations
C      MAXIFS   I      Maximum number polarizations
C      SPCWT    R(*)   Weights (LCHAN,NUMBL,MAXPOL,*),
C   Output
C      REFANT   I      reference antenna suggestion
C-----------------------------------------------------------------------
      INTEGER   IS(*), JS(*), LCHAN, NUMBL, MAXTEL, MAXPOL, MAXIFS,
     *   REFANT
      REAL      SPCWT(LCHAN,NUMBL,MAXPOL,*)
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   I, J, K, IC, IP, IIF
      DOUBLE PRECISION SWT(MAXANT), WT
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       sum weights
      CALL DFILL (MAXANT, 0.0D0, SWT)
      DO 100 K = 1,NUMBL
         I = IS(K)
         J = JS(K)
         DO 90 IIF = 1,MAXIFS
            DO 80 IP = 1,MAXPOL
               DO 70 IC = 1,LCHAN
                  WT = SPCWT(IC,K,IP,IIF)
                  IF (WT.GT.0.0D0) THEN
                     SWT(I) = SWT(I) + WT
                     SWT(J) = SWT(J) + WT
                     END IF
 70               CONTINUE
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
C                                       find max
      I = 1
      WT = 0
      DO 120 K = 1,MAXTEL
         IF (SWT(K).GT.WT) THEN
            WT = SWT(K)
            I = K
            END IF
 120     CONTINUE
C
      IF (WT.GT.0.0D0) THEN
         REFANT = I
         WRITE (MSGTXT,1120) REFANT
         CALL MSGWRT (2)
      ELSE
         MSGTXT = 'REFSET FOUND NO VALID DATA'
         CALL MSGWRT (6)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1120 FORMAT ('REFSET set the REFANT to',I4)
      END
