      SUBROUTINE TABTE (OPCODE, BUFFER, ITERNO, TEKOLS, TENUMV, TIME,
     *   SOURCE, ANTEN, HA, AZ, ZA, AZION, ZAION, DLON, DLAT, B,
     *   TEPATH, MAG, TEC, IFR, DISP, IERR)
C-----------------------------------------------------------------------
C! Does I/O to TECOR details table
C# EXT-util UV Calibration Spectral
C-----------------------------------------------------------------------
C;  Copyright (C) 2023-2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Does I/O to phase difference (TE) extention tables. Used after
C   setup by TEINI.
C   Inputs:
C      OPCODE   C*4      Operation code:
C                        'READ' = read entry from table.
C                        'WRIT' = write entry in table.
C                        'CLOS' = close file, flush on write
C      BUFFER   I(512)   I/O buffer and related storage, also defines
C                        file if open. Should have been returned by
C                        TEINI or TABINI.
C      ITERNO   I        Next entry number to read or write.
C      TEKOLS   I(MAXTEC) The column pointer array in order,
C      TENUMV   I(MAXTEC) Element count in each column.
C   Input/output: (written to or read from baseline file)
C      TIME     D       Time (days)
C      SOURCE   I       Source number
C      ANTEN    I       Antenna number
C      HA       R       Hour angle degrees
C      AZ       R       Azimuth degrees
C      za       R       Zenith angle degrees
C      AZION    R       pierce point azimuth degrees
C      ZAION    R       pierce point zenith angle degrees
C      DLON     R       pierce point longitude offset degrees
C      DLAT     R       pierce point latitude offset degrees
C      B        R(3)    Magnetic field vector (gauss),
C                         (1) = positive away from earth center,
C                         (2) = positive east,
C                         (3) = positive north.
C      TEPATH   R       Electrons/meter^2 / 10^16 toward source
C      MAG      R       Earth magnetic field in direction of source
C      TEC      R       Electrons/meter^2 / 10^16 vertical
C      IFR      R       Ionospheric rotation measure radians/meter^2
C      DISP     R(2)       Dispersive delay seconds/meter^2
C   Output:
C      ITERNO    I      Next solution number.
C      IERR      I      Error code, 0=>OK else TABIO error.
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   XTERSZ, MAXTEC
      PARAMETER (XTERSZ = 20)
      PARAMETER (MAXTEC = 16)
C
      CHARACTER OPCODE*4
      DOUBLE PRECISION TIME
      INTEGER   BUFFER(*), ITERNO, TEKOLS(MAXTEC), TENUMV(MAXTEC),
     *   SOURCE, ANTEN, IERR
      REAL      HA, AZ, ZA, AZION, ZAION, DLON, DLAT, B(3), TEPATH,
     *   MAG, TEC, IFR, DISP(2)
C
      INTEGER   RECI(XTERSZ)
      REAL      RECORD(XTERSZ)
      DOUBLE PRECISION RECD(XTERSZ/2)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      SAVE RECORD
      EQUIVALENCE (RECD, RECORD, RECI)
C-----------------------------------------------------------------------
C                                       Close
      IF (OPCODE.EQ.'CLOS') THEN
         CALL TABIO ('CLOS', 0, ITERNO, RECORD, BUFFER, IERR)
         IF (IERR.GT.0) GO TO 980
         GO TO 999
         END IF
C                                       If write fill RECORD
      IF (OPCODE.NE.'READ') THEN
         RECD(TEKOLS(1)) = TIME
         RECI(TEKOLS(2)) = SOURCE
         RECI(TEKOLS(3)) = ANTEN
         RECORD(TEKOLS(4)) = HA
         RECORD(TEKOLS(5)) = AZ
         RECORD(TEKOLS(6)) = ZA
         RECORD(TEKOLS(7)) = AZION
         RECORD(TEKOLS(8)) = ZAION
         RECORD(TEKOLS(9)) = DLON
         RECORD(TEKOLS(10)) = DLAT
         CALL RCOPY (3, B, RECORD(TEKOLS(11)))
         RECORD(TEKOLS(12)) = TEPATH
         RECORD(TEKOLS(13)) = MAG
         RECORD(TEKOLS(14)) = TEC
         RECORD(TEKOLS(15)) = IFR
         IF (TEKOLS(16).GT.0) CALL RCOPY (2, DISP, RECORD(TEKOLS(16)))
         END IF
C                                       Process record.
      CALL TABIO (OPCODE, 0, ITERNO, RECORD, BUFFER, IERR)
      ITERNO = ITERNO + 1
      IF (IERR.GT.0) GO TO 980
C                                       If READ pick data from RECORD.
      IF (OPCODE.EQ.'READ') THEN
         TIME   = RECD(TEKOLS(1))
         SOURCE = RECI(TEKOLS(2))
         ANTEN  = RECI(TEKOLS(3))
         HA     = RECORD(TEKOLS(4))
         AZ     = RECORD(TEKOLS(5))
         ZA     = RECORD(TEKOLS(6))
         AZION  = RECORD(TEKOLS(7))
         ZAION  = RECORD(TEKOLS(8))
         DLON   = RECORD(TEKOLS(9))
         DLAT   = RECORD(TEKOLS(10))
         CALL RCOPY (3, RECORD(TEKOLS(11)), B)
         TEPATH = RECORD(TEKOLS(12))
         MAG    = RECORD(TEKOLS(13))
         TEC    = RECORD(TEKOLS(14))
         IFR    = RECORD(TEKOLS(15))
         CALL RFILL (2, 0.0, DISP)
         IF (TEKOLS(16).GT.0) CALL RCOPY (2, RECORD(TEKOLS(16)), DISP)
         END IF
      GO TO 999
C                                       Error
 980  WRITE (MSGTXT,1980) IERR
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1980 FORMAT ('TABTE: TABIO ERROR',I3)
      END
