      SUBROUTINE XYZ2LL (XA, YA, ZA, GEOLON, GEOLAT, ELEV)
C-----------------------------------------------------------------------
C! Converts X,Y,Z antenna location to geodetic longitude, latitude
C# EXT-appl UV
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   XYZ2LL computes geodetic longitude and latitude from XYZ of antenna
C   Inputs
C      XA       D   Antenna X in meters
C      YA       D   Antenna Y in meters
C      ZA       D   Antenna Z in meters
C   Outputs
C      GEOLON   D   Geodetic longitude (radians)
C      GEOLAT   D   Geodetic latitude (radians)
C      ELEV     D   Elevation meters
C-----------------------------------------------------------------------
      DOUBLE PRECISION XA, YA, ZA, GEOLON, GEOLAT
      REAL      ELEV
C
      DOUBLE PRECISION R, E, P, TH, SINTH, COSTH, RSQ, ESQ, BSQ, EP, B,
     *   D1, D2, SINLA, N
      DATA R /6378137D0/
      DATA E /8.1819190842622e-2/
C-----------------------------------------------------------------------
      RSQ = R * R
      ESQ = E * E
      BSQ = RSQ * (1.0D0 - ESQ)
      EP  = SQRT (RSQ/BSQ - 1.0D0)
      B   = SQRT (BSQ)
C
      P = SQRT (XA*XA + YA*YA)
      TH = ATAN2 (R*ZA, B*P)
      SINTH = SIN (TH)
      COSTH = COS (TH)
      GEOLON = ATAN2 (YA, XA)
C
      D1 = ZA + EP*EP*B*SINTH*SINTH*SINTH
      D2 = P - ESQ * R * COSTH*COSTH*COSTH
      GEOLAT = ATAN2 (D1, D2)
C
      SINLA = SIN (GEOLAT)
      N = R / SQRT (1.0D0 - ESQ*SINLA*SINLA)
      ELEV = P / COS(GEOLAT) - N
C
 999  RETURN
      END
