      SUBROUTINE SWFOUR (X, GAMMA, ISIGN, WORK)
C-----------------------------------------------------------------------
C! Convex Pseudo AP routine: FFT routine.
C# AP-FFT
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C   The following is an implementation of the Singleton, constant
C   geometry fft.
C   Note: this fft is compatible with the fft call on the FPS-120B
C   Note: PREFFT must be called before SWFOUR with GAMMA as least as
C   large as the GAMMA used here to initilize the tables used.
C   Inputs:
C      X      C(*)     The input signal to be transformed.
C      GAMMA  I        Log2 the number of points in X (N = 2**GAMMA).
C                      The maximum value for GAMMA is 12 (i.e., GMAX)
C      ISIGN  I        1 if forward fft and -1 if inverse fft.
C                      Inverse fft results will NOT be normalized by
C                      1/N.
C      WORK   C(*)     Work array the same size as X
C   Outputs:
C      X      C(*)     The result in normal order.
C      WORK   C(*)     Work array the same size as X
C   Common tables /REV/:
C      WMAX,  BMAX   PARAMETERs
C      WREAL  R(WMAX)   Array of coefficients generated by PREFFT.
C      WIMAG  R(WMAX)   Array of coefficients generated by PREFFT.
C      BITREV I(WMAX)   Array generated by PREFFT containing indices
C                      to bit reverse the output vector.
C   Note: WMAX and BMAX are good for up to 4096 FFTs
C   Provided by Steve Wallach of Convex
C-----------------------------------------------------------------------
C                                       Declare arguments & parameters
      COMPLEX   X(4096), WORK(4096)
      INTEGER   GAMMA, ISIGN, GMAX, BMAX, WMAX
C                                       Set maximum FFT size to 4096
C                                       or GAMMA = 12 (i.e., 2**GAMMA)
      PARAMETER (GMAX=12)
C                                       Set BMAX as BTABL2(GMAX+1)
C                                       and WMAX as BTABL(GMAX+1)
C                                       (see PREFFT DATA statements)
      PARAMETER (BMAX=8190)
      PARAMETER (WMAX=37768)
C                                       Declare local variables
      INTEGER   BASE, IPASS, N, LN2, J, I
      REAL      TR, TI, ONEOVN
      COMPLEX   C(4096)
C                                       /REV/ declarations
      INTEGER   BITREV(BMAX)
      REAL      WREAL(WMAX), WIMAG(WMAX)
      INTEGER   BTABL(14), BTABL2(14), IFIRST, GTABL(14), GLAST
C                                       /REV/ common
      COMMON /REV/ BITREV, WREAL, WIMAG, BTABL, BTABL2, IFIRST,
     *   GTABL, GLAST
C-----------------------------------------------------------------------
C                                       Sanity tests
C      IF ((GAMMA.LT.1).OR.(GAMMA.GT.GMAX)) THEN
C         PRINT *,'SWFOUR: GAMMA = ',GAMMA,' OUT OF RANGE'
C         STOP
C         END IF
C      IF ((ISIGN.NE.1).AND.(ISIGN.NE.-1)) THEN
C         PRINT *,'SWFOUR: ISIGN = ',ISIGN,' OUT OF RANGE'
C         STOP
C         END IF
C                                       BTABL contains the offset into
C                                       the coefficient table for the
C                                       coefficients of the 2**GAMMA
C                                       FFT
      BASE = BTABL(GAMMA)
      N = GTABL(GAMMA)
      LN2 = N/2
      IPASS = 1
      J = 1
C                                       Special case for the first two
C                                       passes
C
C                                       In the first pass, the
C                                       coefficients of W are +1
C
C                                       The first two passes are common
C                                       for forward and reverse, then
C                                       the algorithm splits into two
C                                       parts
C
C                                       First pass
      DO I = 1,LN2
         WORK(J) = X(I) + X(LN2+I)
         WORK(J+1) = X(I) - X(LN2+I)
         J = J+2
         END DO
C                                       In the second pass, the
C                                       coefficients are W0 = (1,0)
C
C                                       The second half coefficients are
C                                       W(ORDER/4) = (0,-1)
      IF (GAMMA.EQ.1) GO TO 110
         J = 1
         DO I = 1,LN2,2
            X(J) = WORK(I) + WORK(LN2+I)
            X(J+1) = WORK(I) -WORK(LN2+I)
            J = J+4
            END DO
         J = 3
C                                       ISIGN = +1 => foward
C                                       ISIGN = -1 => backward
      IF (ISIGN.EQ.-1) GO TO 50
         DO I = 2,LN2,2
            X(J) = WORK(I) +(0,-1)*WORK(LN2+I)
            X(J+1) = WORK(I) -(0,-1)*WORK(LN2+I)
            J = J+4
            END DO
         IPASS = IPASS +1
C                                       Now the general FFT for even and
C                                       odd passes
C
C                                       Odd pass
         IF (GAMMA .EQ. 2)  GOTO 100
 20         J = 1
            DO I = 1,LN2
               TR = REAL (X(LN2+I)) * WREAL(BASE+I) -
     *              AIMAG(X(LN2+I)) * WIMAG(BASE+I)
               TI = AIMAG(X(LN2+I)) * WREAL(BASE+I) +
     *              REAL (X(LN2+I)) * WIMAG(BASE+I)
               WORK(J) = CMPLX(REAL(X(I))+TR,AIMAG(X(I))+TI)
               WORK(J+1) = CMPLX(REAL(X(I))-TR,AIMAG(X(I))-TI)
               J = J + 2
               END DO
            IPASS = IPASS + 1
C                                       Finished?
            IF (IPASS.EQ.GAMMA) GO TO 111
               BASE = BASE + LN2
               J = 1
               DO I = 1,LN2
                  TR = REAL (WORK(LN2+I)) * WREAL(BASE+I) -
     *                 AIMAG(WORK(LN2+I)) * WIMAG(BASE+I)
                  TI = AIMAG(WORK(LN2+I)) * WREAL(BASE+I) +
     *                 REAL (WORK(LN2+I)) * WIMAG(BASE+I)
                  X(J) = CMPLX(REAL(WORK(I))+TR,AIMAG(WORK(I))+TI)
                  X(J+1) = CMPLX(REAL(WORK(I))-TR,AIMAG(WORK(I))-TI)
                  J = J + 2
                  END DO
               IPASS = IPASS + 1
C                                       Finished?
               IF (IPASS.EQ.GAMMA) GO TO 101
                  BASE = BASE +LN2
                  GO TO 20
 101           DO I = 1,N
                  WORK(I) = X(I)
                  END DO
C                                       Finished
 111        BASE = BTABL2(GAMMA)
            DO I = 1,N
               X(BITREV(I+BASE)) = WORK(I)
               END DO
            GO TO 999
C                                       Backward transform from this
C                                       point on
C
C                                       Second half on second pass
 50   DO I = 2,LN2,2
         X(J) = WORK(I) -(0,-1)*WORK(LN2+I)
         X(J+1) = WORK(I) +(0,-1)*WORK(LN2+I)
         J = J + 4
         END DO
C                                       Finished?
      IF(GAMMA.EQ.2) GO TO 100
         IPASS = IPASS+1
 200     J = 1
         DO I = 1,LN2
            TR = REAL (X(LN2+I)) * WREAL(BASE+I) +
     *           AIMAG(X(LN2+I)) * WIMAG(BASE+I)
            TI = AIMAG(X(LN2+I)) * WREAL(BASE+I) -
     *           REAL (X(LN2+I)) * WIMAG(BASE+I)
            WORK(J) = CMPLX(REAL(X(I))+TR,AIMAG(X(I))+TI)
            WORK(J+1) = CMPLX(REAL(X(I))-TR,AIMAG(X(I))-TI)
            J = J + 2
            END DO
         IPASS = IPASS+1
C                                       Finished?
         IF (IPASS.EQ.GAMMA) GO TO 110
            BASE = BASE +LN2
            J = 1
            DO I = 1,LN2
               TR = REAL (WORK(LN2+I)) * WREAL(BASE+I) +
     *              AIMAG(WORK(LN2+I)) * WIMAG(BASE+I)
               TI = AIMAG(WORK(LN2+I)) * WREAL(BASE+I) -
     *              REAL(WORK(LN2+I)) * WIMAG(BASE+I)
               X(J) = CMPLX(REAL(WORK(I))+TR,AIMAG(WORK(I))+TI)
               X(J+1) = CMPLX(REAL(WORK(I))-TR,AIMAG(WORK(I))-TI)
               J = J + 2
               END DO
            IPASS = IPASS +1
C                                       Finished?
            IF (IPASS.EQ.GAMMA) GO TO 100
               BASE = BASE + LN2
               GO TO 200
C                                       Even power FFT with bit-reversed
C                                       order result in TEMP2 array
C
C                                       Result is re-ordered back into X
C                                       array and normalized if inverse
C                                       transform
 100        DO I = 1,N
               WORK(I) = X(I)
               END DO
C                                       Odd power FFT with bit-reversed
C                                       order result in TEMP1 array
C
C                                       Result is re-ordered back to X
C                                       array and normalized if inverse
C                                       transform
 110     BASE = BTABL2(GAMMA)
C                                       In AIPS, inverse transform
C                                       normalization is done elsewhere
C         ONEOVN = 1.0 / FLOAT(N)
         DO I = 1,N
C            X(BITREV(I+BASE)) = ONEOVN*WORK(I)
            X(BITREV(I+BASE)) = WORK(I)
            END DO
C
 999  RETURN
      END
