@PROCESS VECTOR DIR('@DIR')
      SUBROUTINE QRECT1 (A, I, C, K, N)
C-----------------------------------------------------------------------
C! Pseudo AP routine: Vector angle to sine and cosine conversion.
C# AP-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 1995
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C-----------------------------------------------------------------------
C   Vector polar to sine and cosine calculation:
C       C(mK)   = COS (A(mI+1))
C       C(mK+1) = SIN (A(mI+1)) for m = 0 to N-1
C   Inputs:
C      A  I  Source vector base address
C      I  I  A address increment (normally 2 * integer)
C      C  I  Destination vector base address
C      K  I  C address increment (normally 2 * integer)
C      N  I  Element count
C-----------------------------------------------------------------------
      INTEGER   A, I, C, K, N
      INTEGER   JA, JC, LOOP
      REAL      CSER, SSER
      INCLUDE 'INCS:DAPC.INC'
C-----------------------------------------------------------------------
      IF (N.GT.0) THEN
C                                       Addresses 1-rel + angle in
C                                       second arg for QRECT compatable
         JA = A + 2
         JC = C + 1
C                                       Loop
C@DIR IGNORE RECRDEPS(APCORE)
         DO 100 LOOP = 1,N
C                                       get cos and sin of phase
            CSER = COS(APCORE(JA))
            SSER = SIN(APCORE(JA))
C                                       X=cos and Y=sin
            APCORE(JC+1) = SSER
            APCORE(JC)   = CSER
            JA = JA + I
            JC = JC + K
 100        CONTINUE
C                                       end if elements in array
         END IF
C
 999  RETURN
      END
