      SUBROUTINE QSEARC (APCORE, NF, NT, MF, MT, ND, NR, APIAD, APINTR,
     *   APFIN)
C-----------------------------------------------------------------------
C! Pseudo AP routine: VLBI fringe search with FFT.
C# AP-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 1995, 2000, 2006, 2019
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Pseudo-AP version
C   QSEARC is a routine to do a gridded fringe search by means of
C   padded FFTs.  The number (size) of the FFTs is NF (MT) +
C   NR (MF).
C   Inputs:
C      NF       I  No. frequency channels.
C      NT       I  No. time points.
C      MF       I  No. points for freq. FFT.
C      MT       I  No. points for time FFT.
C      ND       I  No. delay channels to search.
C      NR       I  No. rate channels to search.
C      APIAD    I   Base address input data: 2 * NT * NF words used
C      APINTR   I   Base address work area: 2 * NF * NR used
C      APFIN    I   Base address work areas: 2 * NR * ND + max(MT,MF)
C   Output: (in AP memory)
C      0 => 1 dim. array index for peak.
C      1 => peak amplitude
C      2 => peak phase.
C-----------------------------------------------------------------------
      DOUBLE PRECISION APCORE(*)
      INTEGER   NF, NT, MF, MT, ND, NR, APIAD, APINTR, APFIN
C
      INTEGER   INTER, FINAL, FFT, LOC1, MF2, MT2, COUNT, NN, DDATA,
     *   NR2, ND2, NT2, LOOP, PEAK, FFT2, ITEMP
      LONGINT   LTEMP
      DOUBLE PRECISION DTEMP
      EQUIVALENCE (DTEMP, LTEMP)
      INCLUDE 'INCS:DAPC.INC'
C-----------------------------------------------------------------------
C                                        Set pointers.
      MF2 = MF * 2
      MT2 = MT * 2
      NT2 = NT * 2
      NR2 = NR * 2
      ND2 = ND * 2
      DDATA = APIAD
      INTER = APINTR
      FINAL = APFIN
      FFT = FINAL + (NR * ND2)
      FFT2 = FFT + MT2 - NR + 1
      NN = NR * ND
      COUNT = NF
      LOC1 = INTER
C                                        Do first XFORM,
C                                        First rotate phase.
      DO 100 LOOP = 1,COUNT
         CALL QVCLR (APCORE, FFT, 1, MT2)
         CALL QVMOV (APCORE, DDATA, 1, FFT, 1, NT2)
C                                        Do time FFT.
         CALL QCFFT (APCORE, FFT, MT, -1)
C                                         Save first half
         ITEMP = NR / 2 + 1
         CALL QCVMOV (APCORE, FFT, 2, LOC1, 2, ITEMP)
C                                         Save second half
         LOC1 = LOC1 + ITEMP * 2
         ITEMP = NR / 2
         IF (ITEMP.GT.0) CALL QCVMOV (APCORE, FFT2, 2, LOC1, 2, ITEMP)
C                                        Update data pointer.
         DDATA = DDATA + NT2
C                                        Update result pointer.
         LOC1 = LOC1 + ITEMP * 2
 100     CONTINUE
C                                         Second transform loop.
      COUNT = NR
      LOC1 = FINAL
      FFT2 = FFT + MF2 - ND + 1
      DO 200 LOOP = 1,COUNT
         CALL QVCLR (APCORE, FFT, 1, MF2)
C                                         Move to FFT work space.
         CALL QCVMOV (APCORE, INTER, NR2, FFT, 2, NF)
C                                         Freq. FFT.
         CALL QCFFT (APCORE, FFT, MF, -1)
C                                         Save first half
         ITEMP = ND / 2 + 1
         CALL QCVMOV (APCORE, FFT, 2, LOC1, 2, ITEMP)
C                                         Save second half
         LOC1 = LOC1 + ITEMP * 2
         ITEMP = ND / 2
         IF (ITEMP.GT.0) CALL QCVMOV (APCORE, FFT2, 2, LOC1, 2, ITEMP)
C                                         Update output pointer.
         LOC1 = LOC1 + ITEMP * 2
C                                         Update input pointer.
         INTER = INTER + 2
 200     CONTINUE
C                                         Find max amp.
      CALL QCVMMA (APCORE, FINAL, 2, 0, NN)
      PEAK = SPAD(15)
C                                         Save index in AP LOC 0 I
      LTEMP = SPAD(15)
      APCORE(PSAPOF) = DTEMP
C                                         Polar conversion.
      PEAK = (PEAK * 2) - 2
      LOC1 = FINAL + PEAK
      CALL QPOLAR (APCORE, LOC1, 2, 1, 2, 1)
C
 999  RETURN
      END
