      SUBROUTINE YDIE
C-----------------------------------------------------------------------
C! Have TV turn itself off
C# Y1 TV-basic
C-----------------------------------------------------------------------
C;  Copyright (C) 1998
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   YDIE informs the TV device or server to shut down.
C
C   This routine assumes that the TV device has already been closed in
C   the normal way (TVCLOS) and simply does the minimum to open
C   communication, send the die signal, and close the communication.
C
C   Screen server version: sends in parameter to SSS, XVSS, XAS
C-----------------------------------------------------------------------
C
      INTEGER   NWSD, OPCODE, DAT(4), DUMMY, IERR
      INCLUDE 'INCS:DTVD.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
      TVLUN = 9
      CALL ZSSSOP (TVLUN, TVIND, IERR)
      IF (IERR.NE.0) THEN
         MSGTXT = 'YDIE: ERROR OPENING TV'
         CALL MSGWRT (6)
      ELSE
         OPCODE = 18
         CALL FILL (4, 0, DAT)
         CALL ZSSSXF (OPCODE, DAT, 0, DUMMY, NWSD, IERR)
         IF (IERR.NE.0) THEN
            MSGTXT = 'YDIE: ERROR ORDERING TV TO DIE'
            CALL MSGWRT (6)
            END IF
         CALL ZSSSCL (TVLUN, TVIND, IERR)
         IF (IERR.NE.0) THEN
            MSGTXT = 'YDIE: ERROR CLOSING TV'
            CALL MSGWRT (6)
            END IF
         END IF
C
 999  RETURN
      END
