LOCAL INCLUDE 'PLRFI.INC'
C                                       Local include for PLRFI
      INCLUDE 'INCS:ZPBUFSZ.INC'
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   ANTMAX, MXF
      PARAMETER (ANTMAX = 50)
      PARAMETER (MXF = 100)
C
      HOLLERITH XNAMEI(3), XCLAIN(2), XINFIL(12)
      REAL      XSIN, XDISIN, XANT(50), XBIF, XEIF, XBCHAN, XECHAN,
     *   XSMOTH(3), XBCNT, XECNT, XPIXR(2), APARM(10), DOIFS, FACTOR,
     *   XDOTV, XLABEL, XGRCH, XNPLOT, XYRATO, BADD(10)
      REAL      CATOR(256), PMEAN(MAXCIF,ANTMAX), PMAX(MAXCIF,ANTMAX),
     *   PMIN(MAXCIF,ANTMAX), RMEAN(MAXCIF,ANTMAX), RMAX(MAXCIF,ANTMAX),
     *   RMIN(MAXCIF,ANTMAX), MMEAN(MAXCIF,ANTMAX), MMAX(MAXCIF,ANTMAX),
     *   MMIN(MAXCIF,ANTMAX)
      HOLLERITH CATOH(256)
      LOGICAL   GOTANT(ANTMAX), WANANT(ANTMAX), NEWFMT
      INTEGER   SEQIN, DISKIN, JBUFSZ, ILOCWT, CATOLD(256), INCSI,
     *   INCFI, INCIFI, OLDCNO, NSAMP, GRCHAN, NPARM, NVAL, NFREQ,
     *   NIF, BIF, EIF, BCHAN, ECHAN, NOFILE, TNIF, PLNIF(MAXIF*MXF),
     *   BCOUNT, ECOUNT, NPLOTS, NXP, NYP, SCRBUF(256)
      DOUBLE PRECISION CATOD(128), FREQS(MAXCIF,ANTMAX), FRQMAX
      CHARACTER NAMEIN*12, CLAIN*6, LTITLE*80, INFILE(MXF)*48,
     *   ANTDAT(ANTMAX)*8, ANTNAM(ANTMAX)*8, CINFIL*48, STOKES*4
      EQUIVALENCE (CATOD, CATOH, CATOR, CATOLD)
      COMMON /INPARM/ XNAMEI, XCLAIN, XSIN, XDISIN, XANT, XBIF, XEIF,
     *   XBCHAN, XECHAN, XSMOTH, XINFIL, XBCNT, XECNT, XPIXR, APARM,
     *   DOIFS, FACTOR, XDOTV, XLABEL, XGRCH, XNPLOT, XYRATO, BADD
      COMMON /PLRFIV/ CATOLD, FREQS, FRQMAX, SEQIN, DISKIN, ILOCWT,
     *   INCSI, INCFI, INCIFI, OLDCNO, NSAMP, GRCHAN, NPARM, NVAL,
     *   NFREQ, NIF, GOTANT, WANANT, BIF, EIF, BCHAN, ECHAN, NOFILE,
     *   TNIF, PLNIF, BCOUNT, ECOUNT, NEWFMT, NPLOTS, NXP, NYP
      COMMON /ANSWER/ PMEAN, PMIN, PMAX, RMEAN, RMIN, RMAX, MMEAN, MMIN,
     *   MMAX
      COMMON /CHARPM/ LTITLE, NAMEIN, CLAIN, INFILE, ANTDAT, ANTNAM,
     *   CINFIL, STOKES
      COMMON /BUFRS/ SCRBUF, JBUFSZ
      INCLUDE 'INCS:DCAT.INC'
C                                       End local include for PLRFI
LOCAL END
      PROGRAM PLRFI
C-----------------------------------------------------------------------
C! Plots statistics of selected autocorrelation data from VBRFI output
C# UV UV-util Calibration Plot Hardcopy
C-----------------------------------------------------------------------
C;  Copyright (C) 2021-2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PLRFI plots statistics from a sample of uv data
C   Inputs:
C      AIPS adverb  Prg. name.          Description.
C      INNAME         NAMEIN        Name of input UV data.
C      INCLASS        CLAIN         Class of input UV data.
C      INSEQ          SEQIN         Seq. of input UV data.
C      INDISK         DISKIN        Disk number of input VU data.
C   full set of calibration adverbs
C      OPTYPE         OPTYPE        Type of data to process
C      SOLINT         SOLINT        Averaging time (min)
C-----------------------------------------------------------------------
      CHARACTER PRGM*6
      INTEGER   IRET, JA, IP, IM, IROUND, MAXIP, LX, LY, I
      INCLUDE 'PLRFI.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA PRGM /'PLRFI '/
C-----------------------------------------------------------------------
C                                       Get input parameters and
C                                       create output file if nec.
      CALL PLRFII (PRGM, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       read data
      CALL PLRFIR (NFREQ, NIF, IRET)
      IF (IRET.NE.0) GO TO 990
C                                       smooth?
      IM = IROUND (XSMOTH(1))
      IF (IM.GT.0) CALL PLRFIS
C                                       Plot mean, std spectra
      MAXIP = 0
      I = 0
      DO 10 JA = 1,4
         IF (APARM(5+JA).LE.0.0) THEN
            MAXIP = JA
            I = I + 1
            END IF
 10      CONTINUE
      IM = 0
      DO 20 JA = 1,ANTMAX
         IF (GOTANT(JA)) IM = IM + I
 20      CONTINUE
      LX = 0
      LY = 1
      I = 0
      DO 30 JA = 1,ANTMAX
         IF ((GOTANT(JA)) .AND. (DOIFS.LE.0.0)) THEN
            IP = 1
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIP (IP, LX, LY, PMEAN(1,JA), MMEAN(1,JA),
     *            RMEAN(1,JA), JA, IRET)
               END IF
            IP = 2
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIP (IP, LX, LY, PMEAN(1,JA), PMIN(1,JA),
     *            PMAX(1,JA), JA, IRET)
               END IF
            IP = 3
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIP (IP, LX, LY, RMEAN(1,JA), RMIN(1,JA),
     *            RMAX(1,JA), JA, IRET)
               END IF
            IP = 4
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIP (IP, LX, LY, MMEAN(1,JA), MMIN(1,JA),
     *            MMAX(1,JA), JA, IRET)
               END IF
         ELSE IF (GOTANT(JA)) THEN
            IP = 1
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIQ (IP, LX, LY, PMEAN(1,JA), MMEAN(1,JA),
     *            RMEAN(1,JA), JA, IRET)
               END IF
            IP = 2
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIQ (IP, LX, LY, PMEAN(1,JA), PMIN(1,JA),
     *            PMAX(1,JA), JA, IRET)
               END IF
            IP = 3
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIQ (IP, LX, LY, RMEAN(1,JA), RMIN(1,JA),
     *            RMAX(1,JA), JA, IRET)
               END IF
            IP = 4
            IF ((IRET.EQ.0) .AND. (APARM(5+IP).LE.0.0)) THEN
               I = I + 1
               IF (MOD(I-1,NPLOTS).EQ.0) THEN
                  LX = 1
                  LY = 1
               ELSE
                  LX = LX + 1
                  IF (LX.GT.NXP) THEN
                     LX = 1
                     LY = LY + 1
                     IF (LY.GT.NYP) LY = 1
                     END IF
                  END IF
               IF (I.EQ.IM) IP = -IP
               CALL PLRFIQ (IP, LX, LY, MMEAN(1,JA), MMIN(1,JA),
     *            MMAX(1,JA), JA, IRET)
               END IF
            END IF
 30      CONTINUE
C                                       Close down files, etc.
 990  IRET = MAX (0, IRET)
      CALL DIE (IRET, SCRBUF)
C
 999  STOP
      END
      SUBROUTINE PLRFII (PRGN, JERR)
C-----------------------------------------------------------------------
C   PLRFII gets input parameters for PLRFI
C   Inputs:
C      PRGN    C*6  Program name
C   Output:
C      JERR    I    Error code: 0 => ok
C                                5 => catalog troubles
C                                8 => can't start
C   Output in common:
C   Commons: /INPARM/ all input adverbs in order given by INPUTS
C                     file
C            /MAPHDR/ output file catalog header
C-----------------------------------------------------------------------
      INTEGER   JERR
      CHARACTER PRGN*6
C
      CHARACTER STAT*4, PTYPE*2
      INTEGER   IROUND, IERR, I, J, ANTENS(50)
      LOGICAL   WASNEG
      INCLUDE 'PLRFI.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
C                                       Init for AIPS, disks, ...
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
      JBUFSZ = UVBFSS * 2
C                                       Initialize /CFILES/
      NSCR = 0
      NCFILE = 0
      JERR = 0
      CALL LFILL (ANTMAX, .FALSE., GOTANT)
C                                       Get input parameters.
      NPARM = 107
      CALL GTPARM (PRGN, NPARM, RQUICK, XNAMEI, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         RQUICK = .TRUE.
         JERR = 8
         IF (IERR.EQ.1) GO TO 999
            WRITE (MSGTXT,1000) IERR, 'OBTAINING INPUT PARAMETERS'
            CALL MSGWRT (8)
         END IF
C                                       Restart AIPS
      IF (RQUICK) CALL RELPOP (JERR, SCRBUF, IERR)
      IF (JERR.NE.0) GO TO 999
      JERR = 5
C                                       Crunch input parameters.
      CALL H2CHR (12, 1, XNAMEI, NAMEIN)
      CALL H2CHR (6, 1, XCLAIN, CLAIN)
      CALL H2CHR (48, 1, XINFIL, CINFIL)
      BCOUNT = XBCNT + 0.1
      ECOUNT = XECNT + 0.1
      BCOUNT = MAX (1, BCOUNT)
      ECOUNT = MAX (ECOUNT, BCOUNT)
      XBCNT = BCOUNT
      XECNT = ECOUNT
      NOFILE = ECOUNT - BCOUNT + 1
      DO 5 I = 1,10
         IBAD(I) = IROUND (BADD(I))
 5       CONTINUE
      WASNEG = .FALSE.
      J = 0
      DO 20 I = 1,50
         ANTENS(I) = IROUND (XANT(I))
         IF (ANTENS(I).LT.0) THEN
            WASNEG = .TRUE.
            ANTENS(I) = -ANTENS(I)
            END IF
         IF (ANTENS(I).NE.0) J = J + 1
 20      CONTINUE
      CALL RFILL (43, 0.0, XANT(8))
      CALL CHR2H (6, TSKNAM, 1, XANT(5))
      CALL LFILL (ANTMAX, .TRUE., WANANT)
      IF (WASNEG) THEN
         DO 25 I = 1,50
            IF (ANTENS(I).GT.0) WANANT(ANTENS(I)) = .FALSE.
 25         CONTINUE
      ELSE IF (J.GT.0) THEN
         CALL LFILL (ANTMAX, .FALSE., WANANT)
         DO 30 I = 1,50
            IF (ANTENS(I).GT.0) WANANT(ANTENS(I)) = .TRUE.
 30         CONTINUE
         END IF
      SEQIN = IROUND (XSIN)
      DISKIN = IROUND (XDISIN)
      IF (ABS(FACTOR).LE.0.01) THEN
         IF (FACTOR.GE.0.0) FACTOR = 1.0
         IF (FACTOR.LT.0.0) FACTOR = -1.0
         END IF
      NPLOTS = XNPLOT + 0.5
      NPLOTS = MAX (1, MIN (9, NPLOTS))
      NYP = SQRT (REAL(NPLOTS))
      IF (NYP*NYP.LT.NPLOTS) NYP = NYP + 1
      NXP = NPLOTS / NYP
      IF (NXP*NYP.LT.NPLOTS) NXP = NXP + 1
      GRCHAN = 0
C                                       Get CATBLK from old file.
      OLDCNO = 1
      PTYPE = 'UV'
      CALL CATDIR ('SRCH', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, STAT, SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLAIN, SEQIN, DISKIN,
     *      NLUSER
         GO TO 990
         END IF
      CALL CATIO ('READ', DISKIN, OLDCNO, CATBLK, 'REST', SCRBUF, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1040) IERR
         GO TO 990
         END IF
C                                       Save input CATBLK
      CALL COPY (256, CATBLK, CATOLD)
C                                       Channel selection?
      BIF = IROUND (XBIF)
      EIF = IROUND (XEIF)
      BIF = MIN (MAX (1, BIF), MAXIF)
      IF (EIF.LT.BIF) EIF = MAXIF
      NIF = EIF - BIF + 1
      NFREQ = MAXCHA
      BCHAN = IROUND (XBCHAN)
      ECHAN = IROUND (XECHAN)
      IF ((BCHAN.LE.0) .OR. (BCHAN.GT.NFREQ)) BCHAN = 1
      IF ((ECHAN.LE.0) .OR. (ECHAN.GT.NFREQ)) ECHAN = NFREQ
      IF (BCHAN.GT.ECHAN) THEN
         MSGTXT = 'INVALID BCHAN AND ECHAN'
         CALL MSGWRT (6)
         JERR = 1
         GO TO 990
         END IF
      NFREQ = ECHAN - BCHAN + 1
C                                        Fill defaults for plots
      XBCHAN = BCHAN
      XECHAN = ECHAN
      XBIF = BIF
      XEIF = EIF
C                                        Put input file in READ
      PTYPE = 'UV'
      CALL CATDIR ('CSTA', DISKIN, OLDCNO, NAMEIN, CLAIN, SEQIN,
     *   PTYPE, NLUSER, 'READ', SCRBUF, IERR)
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = DISKIN
      FCNO(NCFILE) = OLDCNO
      FRW(NCFILE) = 0
      JERR = 0
C                                       init answers
      I = ANTMAX * MAXCIF
      CALL RFILL (I, FBLANK, PMEAN)
      CALL RFILL (I, FBLANK, PMIN)
      CALL RFILL (I, FBLANK, PMAX)
      CALL RFILL (I, FBLANK, RMEAN)
      CALL RFILL (I, FBLANK, RMIN)
      CALL RFILL (I, FBLANK, RMAX)
      CALL RFILL (I, FBLANK, MMEAN)
      CALL RFILL (I, FBLANK, MMIN)
      CALL RFILL (I, FBLANK, MMAX)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLRFII: ERROR',I3,' ON ',A)
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
 1040 FORMAT ('ERROR',I3,' COPYING CATBLK ')
      END
      SUBROUTINE PLRFIR (NC, NI, IRET)
C-----------------------------------------------------------------------
C   PLRFIR reads the text data and prepares a list of values by antenna
C   Output:
C      NC      I      Number spectral channels
C      NI      I      Number IFs
C   Output:
C      IRET    I      Return code, 0 => OK, otherwise abort.
C-----------------------------------------------------------------------
      INTEGER   NC, NI, IRET
C
      INTEGER   INDEX, TXLUN, TXIND, J, IP, LANT, LCH, LIF, LP, JTRIM,
     *   IFIL
      INCLUDE 'PLRFI.INC'
      CHARACTER INLINE*256, DATE*8, STN*8
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      DATA TXLUN /3/
C-----------------------------------------------------------------------
      CALL DFILL (MAXCIF*ANTMAX, 0.0D0, FREQS)
      FRQMAX = 0.0D0
C                                       find actual values
      CALL PLRFIF (IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING ACTUAL ECHAN, EIF'
         GO TO 990
         END IF
      DO 100 IFIL = 1,NOFILE
         CALL ZTXOPN ('READ', TXLUN, TXIND, INFILE(IFIL), .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'RE-OPEN INPUT TEXT FILE'
            GO TO 990
            END IF
         LANT = 0
C                                       read the data
 20      CALL ZTXIO ('READ', TXLUN, TXIND, INLINE, IRET)
         IF (IRET.EQ.2) THEN
            IRET = 0
            GO TO 90
         ELSE IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING TEXT FILE'
            GO TO 990
         ELSE IF ((INLINE(:11).EQ.'*** DATEOBS') .OR.
     *      (INLINE(:12).EQ.'**** DATEOBS')) THEN
            NEWFMT = INLINE(4:4).EQ.'*'
            IP = INDEX (INLINE, '''')
            DATE = INLINE(IP+1:IP+8)
            IP = INDEX (INLINE, 'ANTENNA=')
            LP = IP+8
            CALL GETNUM (INLINE, 256, LP, XX)
            LANT = XX + 0.1
            IF ((LANT.LT.1) .OR.(LANT.GT.ANTMAX)) THEN
               WRITE (MSGTXT,1020) LANT, ANTMAX
               CALL MSGWRT (7)
               LANT = 0
               GO TO 20
               END IF
            IF (.NOT.WANANT(LANT)) THEN
               LANT = 0
               GO TO 20
               END IF
            IP = INDEX (INLINE, 'STATION')
            IP = IP + 7
            LP = INDEX (INLINE(IP:), '''')
            LP = LP + IP
            IP = INDEX (INLINE(LP:), '''')
            STN = INLINE(LP:LP+IP)
            LP = JTRIM(STN)
            IF (STN(LP:LP).EQ.'''') STN(LP:) = ' '
            ANTDAT(LANT) = DATE
            ANTNAM(LANT) = STN
            IP = INDEX (INLINE, 'STOKES')
            IP = IP + 6
            LP = INDEX (INLINE(IP:), '''')
            LP = LP + IP
            IP = INDEX (INLINE(LP:), '''')
            IP = MIN (3, IP)
            STOKES = INLINE(LP:LP+IP)
            LP = JTRIM(STOKES)
            IF (STOKES(LP:LP).EQ.'''') STOKES(LP:) = ' '
C                                       data row
         ELSE IF ((INLINE(:1).EQ.' ') .AND. (LANT.GT.0)) THEN
            LP = 1
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            LIF = XX + 0.1
            IF ((LIF.LT.BIF) .OR. (LIF.GT.EIF)) GO TO 20
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            LCH = XX + 0.1
            IF ((LCH.LT.BCHAN) .OR. (LCH.GT.ECHAN)) GO TO 20
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) GO TO 20
            GOTANT(LANT) = .TRUE.
            J = (LIF - BIF) * NFREQ + (LCH - BCHAN) + 1 +
     *         (IFIL-1) * NFREQ * NIF
            FREQS(J,LANT) = XX
            FRQMAX = MAX (FRQMAX, XX)
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMEAN(J,LANT) = FBLANK
            ELSE
               PMEAN(J,LANT) = XX
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMIN(J,LANT) = FBLANK
            ELSE
               PMIN(J,LANT) = XX
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               PMAX(J,LANT) = FBLANK
            ELSE
               PMAX(J,LANT) = XX
               END IF
            IF (NEWFMT) THEN
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMEAN(J,LANT) = FBLANK
               ELSE
                  RMEAN(J,LANT) = XX
                  END IF
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMIN(J,LANT) = FBLANK
               ELSE
                  RMIN(J,LANT) = XX
                  END IF
               CALL GETNUM (INLINE, 256, LP, XX)
               IF (XX.EQ.DBLANK) THEN
                  RMAX(J,LANT) = FBLANK
               ELSE
                  RMAX(J,LANT) = XX
                  END IF
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMEAN(J,LANT) = FBLANK
            ELSE
               MMEAN(J,LANT) = XX / 1.D3
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMIN(J,LANT) = FBLANK
            ELSE
               MMIN(J,LANT) = XX / 1.D3
               END IF
            CALL GETNUM (INLINE, 256, LP, XX)
            IF (XX.EQ.DBLANK) THEN
               MMAX(J,LANT) = FBLANK
            ELSE
               MMAX(J,LANT) = XX / 1.D3
               END IF
            END IF
         GO TO 20
C                                       close
 90      CALL ZTXCLS (TXLUN, TXIND, J)
 100     CONTINUE
      IF (.NOT.NEWFMT) THEN
         APARM(6) = 1.0
         APARM(8) = 1.0
         END IF
      GO TO 999
C                                       Error
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLRFIR: ERROR',I3,' ON ',A)
 1020 FORMAT ('PLRFIR: ANTENNA',I4,' OUTSIDE RANGE 1 -',I4)
      END
      SUBROUTINE PLRFIF (IRET)
C-----------------------------------------------------------------------
C   Finds actual EIF, ECHAN
C   Output:
C      IRET    I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'PLRFI.INC'
      INTEGER   MIF(MXF), MCHAN(MXF), LIF, LCHAN, LP, LLIM, JTRIM,
     *   NCHAN(MXF), NI(MXF), IFIL, TXLUN, TXIND, I, J, IOFF, NC,
     *   MSGSAV
      CHARACTER INLINE*256
      DOUBLE PRECISION XX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA TXLUN /3/
C-----------------------------------------------------------------------
      CALL FILL (MXF, 0, MIF)
      CALL FILL (MXF, 0, MCHAN)
      CALL FILL (MXF, MAXCHA, NCHAN)
      CALL FILL (MXF, MAXIF, NI)
C                                       Prepare file names
      NC = JTRIM (CINFIL)
      INFILE(1) = CINFIL
      MSGSAV = MSGSUP
      MSGSUP = 32000
      CALL ZTXOPN ('QRED', TXLUN, TXIND, INFILE(1), .TRUE., IRET)
      MSGSUP = MSGSAV
      IF (IRET.NE.0) THEN
         IFIL = BCOUNT
         IF (IFIL.LT.10) THEN
            WRITE (INFILE(1),1010) CINFIL(:NC), IFIL
         ELSE
            WRITE (INFILE(1),1011) CINFIL(:NC), IFIL
            END IF
         CALL ZTXOPN ('QRED', TXLUN, TXIND, INFILE(1), .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPEN INPUT TEXT FILE', BCOUNT
            GO TO 990
            END IF
         END IF
      CALL ZTXCLS (TXLUN, TXIND, IRET)
      DO 10 I = 2,NOFILE
         IFIL = I + BCOUNT - 1
         IF (IFIL.LT.10) THEN
            WRITE (INFILE(I),1010) CINFIL(:NC), IFIL
         ELSE
            WRITE (INFILE(I),1011) CINFIL(:NC), IFIL
            END IF
 10      CONTINUE
C                                       loop over files
      DO 100 IFIL = 1,NOFILE
C                                       open input file
         CALL ZTXOPN ('READ', TXLUN, TXIND, INFILE(IFIL), .TRUE., IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPEN INPUT TEXT FILE',
     *         IFIL+BCOUNT-1
            GO TO 990
            END IF

C                                       read a line
 50      CALL ZTXIO ('READ', TXLUN, TXIND, INLINE, IRET)
         IF (IRET.EQ.2) THEN
            GO TO 90
         ELSE IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READ TEXT FILE', IFIL
            GO TO 990
         ELSE IF (INLINE(:1).EQ.' ') THEN
            LLIM = JTRIM (INLINE)
            LP = 1
            CALL GETNUM (INLINE, LLIM, LP, XX)
            IF ((XX.EQ.DBLANK) .OR. (XX.LE.0.0D0)) GO TO 50
            LIF = XX + 0.01D0
            CALL GETNUM (INLINE, LLIM, LP, XX)
            IF ((XX.EQ.DBLANK) .OR. (XX.LE.0.0D0)) GO TO 50
            LCHAN = XX + 0.01D0
            MIF(IFIL) = MAX (MIF(IFIL), LIF)
            NI(IFIL) = MIN (NI(IFIL), LIF)
            MCHAN(IFIL) = MAX (MCHAN(IFIL), LCHAN)
            NCHAN(IFIL) = MIN (NCHAN(IFIL), LCHAN)
            END IF
         GO TO 50
C                                       close file
 90      CALL ZTXCLS (TXLUN, TXIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'CLOSING TEXT FILE', IFIL
            GO TO 990
            END IF
 100     CONTINUE
C                                       find max and min
      DO 110 IFIL = 2,NOFILE
         MCHAN(1) = MAX (MCHAN(1), MCHAN(IFIL))
         NCHAN(1) = MIN (NCHAN(1), NCHAN(IFIL))
         MIF(1) = MAX (MIF(1), MIF(IFIL))
         NI(1) = MIN (NI(1), NI(IFIL))
 110     CONTINUE
C                                       final answer
      ECHAN = MIN (ECHAN, MCHAN(1))
      BCHAN = MAX (BCHAN, NCHAN(1))
      EIF = MIN (EIF, MIF(1))
      BIF = MAX (BIF, NI(1))
      NFREQ = ECHAN - BCHAN + 1
      NIF = EIF - BIF + 1
      TNIF = NIF * NOFILE
      XEIF = EIF
      XBIF = BIF
      XBCHAN = BCHAN
      XECHAN = ECHAN
      J = 0
      DO 120 IFIL = 1,NOFILE
         IOFF = (IFIL-1) * MIF(1)
         DO 115 I = BIF,EIF
            J = J + 1
            PLNIF(J) = I + IOFF
 115        CONTINUE
 120     CONTINUE
      IRET = 0
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLRFIF: ERROR',I4,' ON ',A,' FILE',I2)
 1010 FORMAT (A,I1)
 1011 FORMAT (A,I2)
      END
      SUBROUTINE PLRFIS
C-----------------------------------------------------------------------
C   smooths the spectra
C-----------------------------------------------------------------------
C
      INCLUDE 'PLRFI.INC'
      INTEGER   I, N, LSPECT, IROUND, IT, SUPRAD, LT, DOSMTH, JA
      REAL      FX, X, W, WIDTHS(4), SUPS(4), SMTAB(MAXSMO)
C
      INCLUDE 'INCS:DMSG.INC'
      DATA WIDTHS /4.0, 2.0, 2.0, 3.0/
      DATA SUPS /1.0, 3.0, 1.0, 4.0/
C-----------------------------------------------------------------------
      IT = IROUND (XSMOTH(1))
      IF (IT.LE.0) GO TO 999
      IF (IT.GT.8) IT = 1
      DOSMTH = (IT + 3) / 4
      LT = MOD (IT-1, 4) + 1
C                                       Convolution: parms & tables
      XSMOTH(1) = IT
      LSPECT = MAX (12, NFREQ)
      IF ((XSMOTH(2).LT.0.5) .OR. (XSMOTH(2).GT.LSPECT/3.))
     *   XSMOTH(2) = WIDTHS(LT)
      IF ((XSMOTH(3).GT.4.*SUPS(LT)*XSMOTH(2)) .OR.
     *   (XSMOTH(3).LT.XSMOTH(2)))XSMOTH(3) = SUPS(LT) * XSMOTH(2)
      SUPRAD = XSMOTH(3) / 2.0 + 0.1
      IF (SUPRAD+1.GT.MAXSMO) THEN
         SUPRAD = MAXSMO - 1
         XSMOTH(2) = (2. * SUPRAD) / SUPS(LT)
         END IF
      XSMOTH(3) = 2.0 * SUPRAD + 1.0
      CALL RFILL (MAXSMO, 0.0, SMTAB)
      N = 1 + SUPRAD
      FX = 2.0 / XSMOTH(2)
      SMTAB(1) = 1.0
C                                       Compute look-up tables
      W = SMTAB(1)
C                                       Hanning smooth
      IF (LT.EQ.1) THEN
         DO 20 I = 2,N
            X = I - 1.0
            SMTAB(I) = MAX (0.0, 1.0-FX*X)
            W = W + 2 * SMTAB(I)
 20         CONTINUE
C                                       Gaussian smooth
      ELSE IF (LT.EQ.2) THEN
         FX = -LOG(2.0) * FX * FX
         DO 30 I = 2,N
            X = I - 1.0
            SMTAB(I) = EXP (FX * X * X)
            W = W + 2 * SMTAB(I)
 30         CONTINUE
C                                       Boxcar smooth
      ELSE IF (LT.EQ.3) THEN
         N = IROUND (XSMOTH(2))
         XSMOTH(2) = N
         CALL RFILL (N, 1.0, SMTAB)
         W = N
         I = (N - 1) / 2
         I = N - 1 - I
C                                      Sinc smooth
      ELSE IF (LT.EQ.4) THEN
         FX = 3.14159 * FX
         DO 50 I = 2,N
            X = (I - 1.0) * FX
            SMTAB(I) = SIN(X) / X
            W = W + 2 * SMTAB(I)
 50         CONTINUE
         END IF
C                                       Normalize integral
      IF (W.LE.0.0) W = 1.0
      DO 70 I = 1,N
         SMTAB(I) = SMTAB(I) / W
 70      CONTINUE
C                                       now apply it
      DO 100 JA = 1,ANTMAX
         IF (GOTANT(JA)) THEN
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, PMEAN(1,JA))
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, PMIN(1,JA))
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, PMAX(1,JA))
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, MMEAN(1,JA))
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, MMIN(1,JA))
            CALL SMTHIT (NFREQ, TNIF, XSMOTH, SMTAB, MMAX(1,JA))
            END IF
 100     CONTINUE
C
 999  RETURN
      END
      SUBROUTINE SMTHIT (NCHAN, NIF, SMOOTH, SMTAB, SP)
C-----------------------------------------------------------------------
C   actually smooths a spectrum
C   Inputs:
C      NFREQ    I      Number spectral channels/IF
C      NIF      I      Number IFs
C      SMOOTH   R(3)   Smooth parameters
C      SMTAB    R(*)   Smoothing function
C   In/out
C      SP       R(*)   Data in, smoothed data out
C-----------------------------------------------------------------------
      INTEGER   NCHAN, NIF
      REAL      SMOOTH(3), SMTAB(*), SP(*)
C
      INCLUDE 'INCS:PUVD.INC'
      REAL      TEMP(MAXCHA)
      INTEGER   J, J1, J2, L, IOFF, IIF, IFRQ, SUPRL, SUPRH
      REAL      P, R, W
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      SUPRL = (SMOOTH(3) - 0.9) / 2.0
      SUPRH = (SMOOTH(3) - 0.9) / 2.0
      IF ((SMOOTH(1).EQ.3.0) .OR. (SMOOTH(1).EQ.7.0)) THEN
         J = SMOOTH(2) + 0.1
         J1 = (J - 1) / 2
         SUPRL = J1
         J2 = J - 1 - J1
         SUPRH = J2
         END IF
C                                       loop over IFs
      DO 100 IIF = 1,NIF
         IOFF = (IIF - 1) * NCHAN
         CALL RCOPY (NCHAN, SP(IOFF+1), TEMP)
         DO 30 IFRQ = 1,NCHAN
            IF (TEMP(IFRQ).NE.FBLANK) THEN
               J1 = MAX (IFRQ - SUPRL, 1)
               J2 = MIN (IFRQ + SUPRH, NCHAN)
               P = 0.0
               R = 0.0
               DO 20 J = J1,J2
                  IF (TEMP(J).NE.FBLANK) THEN
                     L = ABS(IFRQ-J) + 1
                     W = SMTAB(L)
                     P = W * TEMP(J) + P
                     R = W + R
                     END IF
 20               CONTINUE
               IF (R.GT.0.0) THEN
                  SP(IOFF+IFRQ) = P / R
               ELSE
                  SP(IOFF+IFRQ) = FBLANK
                  END IF
               END IF
 30         CONTINUE
 100     CONTINUE
C
 999  RETURN
      END
      SUBROUTINE PLRFIP (KTYPE, LPX, LPY, SP, SN, SX, JANT, IRET)
C-----------------------------------------------------------------------
C    PLRFIP plots the the mean and std spectra
C    Inputs:
C       KTYPE    I       1 all 3, 2 mean, 3 std, 4 std/mean, <0 last
C       LPX      I       X panel number (1 to NXP)  left to right
C       LPY      I       Y panel number (1 to NYP)  top to bottom
C       SP       R(*)    spectrum mean to plot
C       SN       R(*)    spectrum min to plot
C       SX       R(*)    spectrum max to plot
C    Outputs:
C       IRET     I       > 0 => plot failure
C-----------------------------------------------------------------------
      INTEGER   KTYPE, LPX, LPY, JANT, IRET
      REAL      SP(*), SN(*), SX(*)
C
      INCLUDE 'PLRFI.INC'
      INTEGER   I, PLUN, PLBUFF(256), IVER, TVCHN, TVCORN(4), IDEPTH(5),
     *   J, LTYPE, LABEL, PIND, IROUND, NC, NI, JC, JI, NOFF(MAXIF*MXF),
     *   INCHAR, ITYPE, PLTYIN, PLTXIN, PLTYOF, PLTXOF
      LOGICAL   DOTV, GOOD, FIRST, DOSP, DOPLT(3)
      CHARACTER PFILE*48, CHT12*12, CHT6*6, CHTY*2, MSGBUF*24
      REAL      YMAX, YMIN, BLC(2), TRC(2), CH(4), X, FAC, DX, DY, XMIN,
     *   XMAX, LOCRAN(2), XYRAT, Y, XPSAVE(2), APSAVE(4), YP, SPDIFF,
     *   SPMEAN, NSP, XBLC(2), XTRC(2), XSC
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DDCH.INC'
      SAVE FIRST
      DATA TVCHN, TVCORN, IDEPTH /1, 4*0, 5*1/
      DATA FIRST /.TRUE./
C-----------------------------------------------------------------------
      I = APARM(10) + 0.1
      DOPLT(1) = MOD(I,2).EQ.0 .OR. (ABS(KTYPE).EQ.1)
      I = I/2
      DOPLT(2) = MOD(I,2).EQ.0
      I = I/2
      DOPLT(3) = MOD(I,2).EQ.0
      DOTV = XDOTV.GT.0.0
      CALL RCOPY (2, XPIXR, XPSAVE)
      CALL RCOPY (4, APARM, APSAVE)
      GRCHAN = XGRCH + 0.1
      ITYPE = ABS (KTYPE)
C                                       for EXTLIST
      XANT(1) = JANT
      XANT(2) = ITYPE
      CALL CHR2H (8, ANTNAM(JANT), 1, XANT(3))
      CALL CHR2H (4, STOKES, 1, XANT(7))
C                                       Y scale
      YMAX = -1.E10
      YMIN = -YMAX
      NC = (ECHAN - BCHAN + 1)
      NI = (EIF - BIF + 1) * NOFILE
      JC = NC * NI
      SPMEAN = 0.0
      NSP = 0.0
      SPDIFF = 0.0
      DO 10 I = 1,JC
         IF (SP(I).NE.FBLANK) THEN
            YMIN = MIN (YMIN, SP(I))
            YMAX = MAX (YMAX, SP(I))
            IF (SN(I).NE.FBLANK) YMIN = MIN (YMIN, SN(I))
            IF (SX(I).NE.FBLANK) YMAX = MAX (YMAX, SX(I))
            IF ((SN(I).NE.FBLANK) .AND. (SX(I).NE.FBLANK)) THEN
               SPDIFF = MAX (SPDIFF, ABS(2*SP(I)-SX(I)-SN(I)))
               SPMEAN = SPMEAN + SP(I)
               NSP = NSP + 1.
               END IF
            END IF
 10      CONTINUE
      IF (NSP.GT.0) SPMEAN = SPMEAN / NSP
      DOSP = SPDIFF.GT.SPMEAN/500.0
      DOSP = DOSP .OR. (SPDIFF.LT.1.E-6) .OR. (ITYPE.EQ.1)
      IF (ITYPE.LE.2) THEN
         IF (XPIXR(2).GT.XPIXR(1)) THEN
            YMAX = XPIXR(2)
            YMIN = XPIXR(1)
         ELSE IF (XPIXR(2).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
      ELSE IF (ITYPE.EQ.3) THEN
         IF (APARM(2).GT.APARM(1)) THEN
            YMAX = APARM(2)
            YMIN = APARM(1)
         ELSE IF (APARM(2).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
      ELSE
         IF (APARM(4).GT.APARM(3)) THEN
            YMAX = APARM(4)
            YMIN = APARM(3)
         ELSE IF (APARM(4).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
         END IF
      IF (ITYPE.LE.2) THEN
         XPIXR(2) = YMAX + 0.04 * (YMAX - YMIN)
         XPIXR(1) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = XPIXR(2)
         YMIN = XPIXR(1)
      ELSE IF (ITYPE.EQ.3) THEN
         APARM(2) = YMAX + 0.04 * (YMAX - YMIN)
         APARM(1) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = APARM(2)
         YMIN = APARM(1)
      ELSE
         APARM(4) = YMAX + 0.04 * (YMAX - YMIN)
         APARM(3) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = APARM(4)
         YMIN = APARM(3)
         END IF
      XMIN = 0.0
      XMAX = (NC + 1) * NI
C                                       Add plot file to the image
C                                       catalog header.
      IF ((.NOT.DOTV) .AND. (LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CHT12 = ' '
         CHT6 = ' '
         CHTY = ' '
         IVER = 0
         IF (FIRST) THEN
            CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12, CHT6, 0, CHTY,
     *         0, 'CLRD', PLBUFF, IRET)
            IF (IRET.EQ.0) CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12,
     *         CHT6, 0, CHTY, 0, 'WRIT', PLBUFF, IRET)
            FRW(NCFILE) = 1
            FIRST = .FALSE.
            END IF
         CALL MADDEX ('PL', DISKIN, OLDCNO, CATOLD, PLBUFF, .TRUE.,
     *      'WRIT', IVER, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'PLHGM: ERROR UPDATING CATALOGUE HEADER.'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         END IF
C                                       Open the PLot file.
      IF ((LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CALL ZPHFIL ('PL', DISKIN, OLDCNO, IVER, PFILE, IRET)
         CALL GINIT (DISKIN, OLDCNO, PFILE, 0, 74, NPARM, XNAMEI, DOTV,
     *      TVCHN, GRCHAN, TVCORN, CATOLD, PLBUFF, PLUN, PIND, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'PLRFIP: ERROR OPENING PLOT FILE.'
            CALL MSGWRT (8)
            IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT',
     *         CATOLD, PLBUFF, IVER, I)
            GO TO 999
            END IF
         END IF
C                                       Set character offsets.
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS (LABEL), 100)
      LOCRAN(2) = YMAX
      LOCRAN(1) = YMIN
      CALL GTICNT (LABEL, LOCRAN, I)
      CALL RFILL (4, 0.5, CH)
      IF (LTYPE.EQ.2) CH(1) = 3.5
      IF (LTYPE.GT.2) CH(1) = I + 4.0
      IF (LTYPE.GT.1) CH(2) = 2.0
      IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CH(2) = CH(2) + 1.333
         CH(4) = 2.0
         IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
         END IF
C                                       Set BLC, TRC, XYRATO.
      PLTXIN = 1000.0 / (NXP - 0.25)
      PLTYIN = 1000.0 / (NYP - 0.10)
      PLTXOF = NXP * PLTXIN - 1000.
      PLTYOF = NYP * PLTYIN - 1000.
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      IF ((DOTV) .AND. (XYRATO.LE.0.0)) THEN
         DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) + CH(3))
         DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) + CH(4))
         XYRATO = 1.0
         IF (DY.GT.0.0) XYRATO = DX / DY
      ELSE
         IF (XYRATO.LE.0.0) XYRATO = 1.4
         END IF
      XYRAT = (TRC(1) - BLC(1)) / (TRC(2) - BLC(2))
      XYRAT = XYRATO / XYRAT
C                                       sub window parms
      XBLC(1) = BLC(1) + (LPX-1) * PLTXIN
      XTRC(1) = XBLC(1) + PLTXIN - 1.0 - PLTXOF
      XBLC(2) = BLC(2) + (NYP-LPY) * PLTYIN
      XTRC(2) = XBLC(2) + PLTYIN - 1.0 - PLTYOF
C                                       Initialize for line drawing
      IF ((LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CALL GINITL (BLC, TRC, XYRAT, CH, IDEPTH, PLBUFF, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'DRWHGM: ERROR INITIALIZING FOR LINE DRAWING.'
            GO TO 950
            END IF
         END IF
      IF (GRCHAN.GT.0) THEN
         CALL GLTYPE (GRCHAN, PLBUFF, IRET)
      ELSE
         CALL GLTYPE (1, PLBUFF, IRET)
         END IF
      IF (IRET.NE.0) GO TO 920
C                                       Draw borders.
      CALL GPOS (XBLC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 910
      CALL GVEC (XTRC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XTRC(1), XTRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XTRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
C                                       dividers
      XSC = (XTRC(1) - XBLC(1)) / (NI * (NC+1.0))
      DO 25 I = 1,NI-1
         X = I * (NC + 1.0) * XSC + XBLC(1)
         CALL GPOS (X, XTRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL GVEC (X, XBLC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
 25      CONTINUE
C                                       Labeling.
      CALL RMSLAB (ITYPE, XBLC, XTRC, FAC, XMIN, XMAX, YMIN, YMAX, NC,
     *   NI, BCHAN, PLNIF, IVER, LABEL, CATOLD, JANT, ANTNAM(JANT),
     *   STOKES, FREQS(1,JANT), FRQMAX, APARM(5), LPX, LPY, NYP,
     *   PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       zero all plot channels
      XSC = (XTRC(1) - XBLC(1)) / (NI * (NC+1.0))
      DO 26 I = 4,2,-1
         CALL GLTYPE (I, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
 26      CONTINUE
C                                       Draw the data
      CALL FILL (NI, 0, NOFF)
      IF ((FACTOR.LT.0.0) .AND. (DOSP) .AND. (DOPLT(1))) THEN
         I = 0
         J = 0
         DX = 0.5 * ABS(FACTOR)
         DY = 0.5 * (XTRC(2) - XBLC(2)) / ((NC + 1.0)* NI) * ABS(FACTOR)
         CALL GPOS (X, 1.0, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 910
         DO 40 JI = 1,NI
            DO 30 JC = 1,NC
               I = I + 1
               X = I * XSC + XBLC(1)
               J = J + 1
               IF (SP(J).NE.FBLANK) THEN
                  Y = (SP(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  CALL GPOS (X-DX, Y+DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 910
                  CALL GVEC (X+DX, Y-DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 920
                  CALL GPOS (X+DX, Y+DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 910
                  CALL GVEC (X-DX, Y-DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 920
                  END IF
  30           CONTINUE
            I = I + 1
  40        CONTINUE
      ELSE IF ((DOSP) .AND. (DOPLT(1))) THEN
         I = 0
         J = 0
         DO 50 JI = 1,NI
            GOOD = .FALSE.
            DO 45 JC = 1,NC
               I = I + 1
               X = I * XSC + XBLC(1)
               J = J + 1
               IF (SP(J).NE.FBLANK) THEN
                  Y = (SP(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 45            CONTINUE
            I = I + 1
 50         CONTINUE
         END IF
C                                       if max=min do not plot
      IF ((SPDIFF.GE.1.E-6) .AND. (DOPLT(2))) THEN
         IF (GRCHAN.EQ.0) CALL GLTYPE (4, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
         I = 0
         J = 0
         DO 60 JI = 1,NI
            GOOD = .FALSE.
            DO 55 JC = 1,NC
               I = I + 1
               X = I * XSC + XBLC(1)
               J = J + 1
               IF (SN(J).NE.FBLANK) THEN
                  Y = (SN(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 55            CONTINUE
            I = I + 1
 60         CONTINUE
         END IF
      IF ((SPDIFF.GE.1.E-6) .AND. (DOPLT(3))) THEN
         IF (GRCHAN.EQ.0) CALL GLTYPE (3, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
         I = 0
         J = 0
         DO 70 JI = 1,NI
            GOOD = .FALSE.
            DO 65 JC = 1,NC
               I = I + 1
               X = I * XSC + XBLC(1)
               J = J + 1
               IF (SX(J).NE.FBLANK) THEN
                  YP = (XTRC(2) + XBLC(2)) / 2.0
                  IF (SP(J).NE.FBLANK) YP = (SP(J) - YMIN) / (YMAX -
     *               YMIN) * (XTRC(2)-XBLC(2)) + XBLC(2)
                  Y = (SX(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     IF ((YP.GT.XBLC(2)) .AND. (YP.LT.XTRC(2))) NOFF(JI)
     *                  = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 65            CONTINUE
            I = I + 1
 70         CONTINUE
         END IF
      DO 80 JI = 1,NI
         WRITE (MSGTXT,1065) JI+BIF-1, NOFF(JI)
         IF (NOFF(JI).GT.0) THEN
            CALL MSGWRT (3)
            WRITE (MSGBUF,1060) NOFF(JI)
            CALL CHTRIM (MSGBUF, 8, MSGBUF, INCHAR)
            IF (GRCHAN.EQ.0) CALL GLTYPE (1, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 920
            IF (DOTV) THEN
               CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
            IF (NI.LE.16) THEN
               X = (JI-1) * (NC + 1.0)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GOTO 910
               CALL GICHAR (1, INCHAR, 0, 4.0, -3.5, MSGBUF, PLBUFF,
     *            IRET)
               IF (IRET.NE.0) GO TO 920
               X = JI * (NC + 1.0)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 910
               DX = -4 - INCHAR
               CALL GICHAR (1, INCHAR, 0, DX, -3.5, MSGBUF, PLBUFF,
     *            IRET)
               IF (IRET.NE.0) GO TO 920
            ELSE
               X = (JI-0.5) * (NC + 1.0)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GICHAR (1, INCHAR, 0, -INCHAR/2.0, -3.5, MSGBUF,
     *            PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
            END IF
 80      CONTINUE
      IF (((LPY-1)*NXP + LPX.EQ.NPLOTS) .OR. (KTYPE.LT.0)) THEN
         WRITE (MSGTXT,1070) IVER
         IF (.NOT.DOTV) CALL MSGWRT (3)
         GPHPAG = KTYPE.GT.0
         CALL GFINIS (PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         END IF
      CALL RCOPY (2, XPSAVE, XPIXR)
      CALL RCOPY (4, APSAVE, APARM)
      GO TO 999
C                                       Error return from GPOS.
 910  MSGTXT = 'PLRFIP: PLOT ERROR OCCURRED WHILE MOVING TO A POINT.'
      GO TO 940
C                                       Error return from GVEC.
 920  MSGTXT = 'PLRFIP: PLOT ERROR OCCURRED WHILE DRAWING A LINE.'
 940  CALL MSGWRT (8)
C                                       Destroy the PLot file on error.
 950  IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) IVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN, PFILE, I)
         CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT', CATOLD, PLBUFF,
     *      IVER, I)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1060 FORMAT (I8)
 1065 FORMAT ('IF',I3,I7,' points off the plot')
 1070 FORMAT ('Created plot file version',I4)
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
      SUBROUTINE DIDDLE (SP, SN, SX, YMIN, YMAX)
C-----------------------------------------------------------------------
C   DIDDLE tries to find a revised YMAX s.t. the display range shows
C   most but not all points
C   Inputs:
C       SP       R(*)    spectrum mean to plot
C       SN       R(*)    spectrum min to plot
C       SX       R(*)    spectrum max to plot
C       YMIN     R       Low plot range
C   In/out:
C       YMAX     R       High plot range: in actual extreme, out revised
C-----------------------------------------------------------------------
      REAL      SP(*), SN(*), SX(*), YMIN, YMAX
C
      INCLUDE 'PLRFI.INC'
      INTEGER   NST
      PARAMETER (NST=500)
C
      INTEGER   I, NOUT(NST), J, NC, NI, JC, NTOT
      REAL      YMAXIN, YX(NST)
      INCLUDE 'INCS:DDCH.INC'
C-----------------------------------------------------------------------
      YMAXIN = YMAX
      YMAXIN = MIN (1.E6, YMAXIN)
      DO 10 I = 1,NST
         YX(I) = YMAXIN * I / REAL (NST)
 10      CONTINUE
      CALL FILL (NST, 0, NOUT)
      NTOT = 0
      NC = (ECHAN - BCHAN + 1)
      NI = (EIF - BIF + 1) * NOFILE
      JC = NC * NI
      DO 40 I = 1,JC
         IF ((SP(I).NE.FBLANK) .AND. (SX(I).NE.FBLANK)) THEN
            NTOT = NTOT + 1
            DO 20 J = 1,NST
               IF ((SP(I).GT.YX(J)) .OR. (SX(I).GT.YX(J))) NOUT(J) =
     *            NOUT(J) + 1
 20            CONTINUE
            END IF
 40      CONTINUE
      I = NST
      DO 50 J = NST,1,-1
         YX(J) = REAL (NOUT(J)) / REAL (NTOT)
         IF (YX(J).LT.0.05) I = J
 50      CONTINUE
      YMAX = YMAXIN * I / REAL (NST)
C
 999  RETURN
      END
      SUBROUTINE RMSLAB (ITY, BLC, TRC, FAC, XMIN, XMAX, YMIN, YMAX,
     *   NC, NI, LBCHAN, PLNIF, IVER, LABEL, CATOLD, JANT, STN, STOKES,
     *   FREQS, FRQMAX, FRQLAB, LPX, LPY, NYP, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   Write labeling for PLRFI plots
C   Inputs:
C      ITY     I        Plot type: 1 all 3, 2 for mean, 3 std,
C                          4 std/mean
C      BLC     R(2)     bottom left corner of plot.
C      TRC     R(2)     top right hand corner of plot.
C      FAC     R        FAC*XYRATO = real XYRATIO.
C      IVER    I        plot file version number
C      LABEL   I        labeling type
C   In/out:
C      PLBUFF   I(256)   I/O buffer for plot file.
C   Output:
C      IRET    I        error code returned from GVEC.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2), FAC, XMIN, XMAX, YMIN, YMAX, FRQLAB
      DOUBLE PRECISION FREQS(*), FRQMAX
      INTEGER   ITY, NC, NI, LBCHAN, PLNIF(*), IVER, LABEL, CATOLD(256),
     *   JANT, LPX, LPY, NYP, PLBUFF(256), IRET
      CHARACTER STN*(*), STOKES*(*)
C
      CHARACTER PREFIX(2)*5, TIME*8, DATE*12, NAMSTR*18, MSGBUF*80
      LOGICAL   PFLAG
      REAL      XINTER(24), DCX, DCY, XNOINT, DIST, ODIST, TICSCL, XVAL,
     *   YTICEL, YTICER, YPOS, TICLEN, XINT, X, DCXM, XDIST, DEGL, DEGU,
     *   GBLC, GTRC, DEG
      INTEGER   INOINT, INCHAR, I, IXO, IANGL, IT(3), ID(3), ITMP, JT,
     *   LTYPE, LECHAN, JTRIM, IOFF, IDUM(5), KT, IDEPTH(5)
      HOLLERITH HDUM(5)
      EQUIVALENCE (IDUM, HDUM)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DLOC.INC'
      DATA TICSCL /70.0/
      DATA XINTER /.001, .002, .005, .01, .02, .05, .1, .2, .5,
     *   1., 2., 5., 10., 20., 50., 100., 200., 500.,
     *   1000., 2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
C                                        Set up the location common
C                                        for tick marks etc.
      CALL FILL (5, 1, IDEPTH)
      LOCNUM = 1
      CALL SETLOC (IDEPTH, .FALSE.)
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      AXFUNC(1,LOCNUM) = 0
      AXFUNC(2,LOCNUM) = 0
      CPREF(1,LOCNUM) = ' '
      CPREF(2,LOCNUM) = ' '
      LTYPE = MOD (ABS(LABEL), 100)
      IF (LTYPE.LE.1) GO TO 999
      LECHAN = LBCHAN + NC - 1
C                                       Tic positions.
      TICLEN = (TRC(1) - BLC(1)) / TICSCL
      YTICEL = BLC(1) + TICLEN
      YTICER = TRC(1) - TICLEN
C                                       Find vertical interval value.
      DIST = YMAX - YMIN
      ODIST = DIST
      CALL METSCL (LABEL, DIST, PREFIX(2), PFLAG)
      IF (PFLAG) GO TO 110
      XDIST = DIST / ODIST
      GTRC = YMAX * XDIST
      GBLC = YMIN * XDIST
      XINT = 8.0
      DO 20 I = 1,24
         DEG = XINTER(I)
         DEGU = AINT (GTRC/DEG) * DEG
         IF (DEGU.GT.GTRC) DEGU = DEGU - DEG
         DEGL = AINT (GBLC/DEG) * DEG
         IF (DEGL.LT.GBLC) DEGL = DEGL + DEG
         XNOINT = AINT ((DEGU-DEGL)/DEG) + 1.0
         IF (XNOINT.LE.XINT) GO TO 30
 20      CONTINUE
      GO TO 110
C                                       Interval and no of inter found.
 30   XINT = DEG
      INOINT = XNOINT + 2.5
      ODIST = XDIST * YMIN
      XVAL = AINT (ODIST/XINT) * XINT
      IF (XVAL.GE.ODIST) XVAL = XVAL - XINT
      IXO = I
      DCXM = -0.5
C                                       Loop for all tics.
      DO 100 I = 1,INOINT
         XVAL = XVAL + XINT
         YPOS = XVAL / XDIST
         YPOS = (YPOS - YMIN) / (YMAX - YMIN) * (TRC(2)-BLC(2)) + BLC(2)
         IF (YPOS.GT.TRC(2)) GO TO 110
C                                       right hand tic.
         CALL GPOS (TRC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL GVEC (YTICER, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
C                                       Left hand tic.
         CALL GPOS (YTICEL, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL GVEC (BLC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
C                                       Write value.
         IF (LTYPE.GT.2) THEN
            WRITE (MSGBUF,1030) XVAL
            CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
            IF (IXO.GT.3) INCHAR = INCHAR - 1
            IF (IXO.GT.6) INCHAR = INCHAR - 1
            IF (IXO.GT.9) INCHAR = INCHAR - 2
            DCX = - INCHAR - 1.0
            DCY = -0.5
            DCXM = MIN (DCXM, DCX)
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 999
            END IF
 100     CONTINUE
C                                       RMS
 110  DCX = DCXM - 2.0
      YPOS = (TRC(2) + BLC(2)) / 2.0
      CALL GPOS (BLC(1), YPOS, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      IF (ITY.EQ.2) THEN
         MSGBUF = PREFIX(2) // ' Mean'
      ELSE IF (ITY.EQ.3) THEN
         MSGBUF = PREFIX(2) // ' RMS'
      ELSE IF (ITY.EQ.1) THEN
         MSGBUF = PREFIX(2) // ' All 3'
      ELSE
         MSGBUF = PREFIX(2) // ' ModIndx'
         END IF
      CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
      MSGBUF(INCHAR+2:) = 'AutoCorr'
      CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
      DCY = INCHAR / 2.0 - 1.0
      CALL GCHAR (INCHAR, 1, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Nchan, BIF, EIF
      IF ((LTYPE.LT.7) .AND. (LPY.EQ.NYP)) THEN
         MSGBUF = 'IF'
         DCY = -2.833 - 1.333
         IF (LTYPE.EQ.2) DCY = -2.833
         XDIST = (TRC(1) - BLC(1)) / NI
         INCHAR = 5
         IOFF = 1
         IF (NI.GT.16) THEN
            IOFF = 4
            INCHAR = 2
            END IF
         DO 120 I = 1,NI
            ITMP = PLNIF(I)
            WRITE (MSGBUF(4:),1110) ITMP
            X = (I - 0.5) * XDIST + BLC(1)
            CALL GPOS (X, BLC(2), PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 999
            DCX = -INCHAR/2.0
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF(IOFF:5), PLBUFF,
     *         IRET)
            IF (IRET.NE.0) GO TO 999
 120        CONTINUE
         END IF
C                                       Determine label range
      IF (FRQLAB.LE.0.0) THEN
         CALL FINLAB (BLC, TRC, NC, NI, FREQS, FRQMAX, LABEL, PLBUFF,
     *      IRET)
         MSGBUF = 'Frequency (GHz)'
         IF (FRQMAX.LT.1.0D0) MSGBUF = 'Frequency (GHz)'
      ELSE
         CALL PINLAB (BLC, TRC, LBCHAN, LECHAN, NI, LABEL, PLBUFF, IRET)
         MSGBUF = 'Spectral channels'
         END IF
      IF (IRET.NE.0) GO TO 999
C                                       Label with prefix
      DCY = -1.5
      IF (LTYPE.GT.2) DCY = -2.833
      X = (TRC(1) + BLC(1)) / 2.0
      CALL GPOS (X, BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      CALL CHTRIM (MSGBUF, 17, MSGBUF, INCHAR)
      DCX = 0.5 - INCHAR / 2.0
      CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      IF (LTYPE.GE.7) GO TO 999
C                                       which axis is which?
C                                       Source name, stokes, freq.
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      DCX = 0.0
      DCY = 0.5
      IANGL = 0
      JT = JTRIM (STN)
      KT = JTRIM (STOKES)
      WRITE (MSGBUF,1200) JANT, STN(:JT), STOKES(:KT)
      INCHAR = JTRIM (MSGBUF)
C                                       image name
      INCHAR = INCHAR + 1
      IF (INCHAR.GT.1) THEN
         MSGBUF(INCHAR:INCHAR+2) = ' __'
         INCHAR = INCHAR + 3
         END IF
      CALL COPY (5, CATOLD(KHIMN), IDUM)
      CALL H2CHR (12, KHIMNO, HDUM, NAMSTR(1:12))
      CALL H2CHR (6, KHIMCO, HDUM, NAMSTR(13:18))
      CALL NAMEST (NAMSTR, CATOLD(KIIMS), MSGBUF(INCHAR:), ITMP)
      CALL REFRMT (MSGBUF, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       time/date, version
      IF ((LABEL.GT.0) .AND. (LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL ZDATE (ID)
         CALL ZTIME (IT)
         CALL TIMDAT (IT, ID, TIME, DATE)
         WRITE (MSGBUF,1210) IVER, DATE, TIME
         CALL REFRMT (MSGBUF, '_', INCHAR)
         DCY = DCY + 1.333
         CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F14.3)
 1110 FORMAT (I2.2)
 1200 FORMAT ('Antenna',I3,1X,'''',A,'''',2x,'___Stokes ''',A,'''')
 1210 FORMAT ('Plot file version',I4,'__created ',A,A)
      END
      SUBROUTINE PINLAB (BLC, TRC, BC, EC, NG, ILTYPE, PLBUFF, IERR)
C-----------------------------------------------------------------------
C   To do X axis where we have multiple sub panels with integer counts
C   Inputs:
C      BLC      R(2)    X, Y pixels to form bottom left hand corner
C      TRC      R(2)    X, Y pixels to form the top right hand corner
C      BC       I       Begin count
C      EC       I       End count
C      NG       I       Number of such groups
C      ILTYPE   I       label type: 1 none, 2 no ticks, 3 RA/DEC
C                          4 center relative
C   In/out:
C      PLBUFF   I(256)  the updated graphics output buffer.
C      IERR     I       error indicator: 0 = No error.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2)
      INTEGER   BC, EC, NG, ILTYPE, PLBUFF(256), IERR
C
      INTEGER   NINTER
      PARAMETER (NINTER=15)
C
      INTEGER   INCHAR, LTYPE, I, XINTER(NINTER), XINT, DIST, NOINT,
     *   NINT, IG, XVAL, DEGL, DEGU, DEG
      REAL      DCX, DCY, XL, XI, XPOS, XSC
      CHARACTER SPRTXT*8
      INCLUDE 'INCS:DMSG.INC'
      DATA XINTER /1, 2, 5, 10, 20, 50, 100, 200, 500, 1000,
     *   2000, 5000, 10000, 20000, 50000/
C-----------------------------------------------------------------------
      LTYPE = MOD (ABS (ILTYPE), 100)
      IF (LTYPE.EQ.1) GO TO 999
C                                       tick marks
      XINT = 32 / NG
      XINT = MAX (3, MIN (16, XINT))
      DIST = EC - BC + 2
      DO 20 I = 1,NINTER
         DEG = XINTER(I)
         DEGU = (EC / DEG) * DEG
         IF (DEGU.GT.EC) DEGU = DEGU - DEG
         DEGL = (BC / DEG) * DEG
         IF (DEGL.LT.BC) DEGL = DEGL + DEG
         NOINT = (DEGU - DEGL) / DEG + 1
         IF (NOINT.LE.XINT) GO TO 30
 20      CONTINUE
      MSGTXT = 'PINLAB: TICK MARK ALGORITHM FAILED'
      CALL MSGWRT (6)
      IERR = 0
      GO TO 999
C                                       plot tick marks
 30   XINT = DEG
      NINT = (NOINT * NG) / 16
      NINT = MIN (NINT, NOINT)
      NINT = MAX (1, NINT)
      NOINT = NOINT + 2
      DCX = -0.5
      XL = DIST * NG + 1
      XL = (TRC(1) - BLC(1)) / XL
      XI = (TRC(2) - BLC(2)) / 25.
      DCY = -1.5
      XSC = (TRC(1) - BLC(1)) / (NG * DIST)
      DO 50 IG = 1,NG
         XVAL = (BC / XINT) * XINT
         IF (XVAL.GE.BC) XVAL = XVAL - XINT
         DO 40 I = 1,NOINT
            XVAL = XVAL + XINT
            IF ((XVAL.GE.BC) .AND. (XVAL.LE.EC)) THEN
               XPOS = (XVAL-BC+1 + (IG-1)*DIST) * XSC + BLC(1)
               CALL GPOS (XPOS, TRC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, TRC(2)-XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GPOS (XPOS, BLC(2)+XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, BLC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               IF ((LTYPE.GT.2) .AND. (MOD(I,NINT).EQ.0)) THEN
                  WRITE (SPRTXT,1030) XVAL
                  CALL CHTRIM (SPRTXT, 6, SPRTXT, INCHAR)
                  DCX = 0.5 - INCHAR
                  CALL GCHAR (INCHAR, 0, DCX, DCY, SPRTXT, PLBUFF, IERR)
                  IF (IERR.NE.0) GO TO 999
                  END IF
               END IF
 40         CONTINUE
 50      CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (I6)
      END
      SUBROUTINE FINLAB (BLC, TRC, NC, NG, FREQS, FRQMAX, ILTYPE,
     *   PLBUFF, IERR)
C-----------------------------------------------------------------------
C   To do X axis where we have multiple sub panels with integer counts
C   Inputs:
C      BLC      R(2)    X, Y pixels to form bottom left hand corner
C      TRC      R(2)    X, Y pixels to form the top right hand corner
C      BC       I       Begin count
C      EC       I       End count
C      NG       I       Number of such groups
C      ILTYPE   I       label type: 1 none, 2 no ticks, 3 RA/DEC
C                          4 center relative
C   In/out:
C      PLBUFF   I(256)  the updated graphics output buffer.
C      IERR     I       error indicator: 0 = No error.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2)
      INTEGER   NC, NG, ILTYPE, PLBUFF(256), IERR
      DOUBLE PRECISION FREQS(*), FRQMAX
C
      INTEGER   NINTER
      PARAMETER (NINTER=24)
C
      INCLUDE 'INCS:DCHND.INC'
      INTEGER   INCHAR, LTYPE, I, NOINT, NINT, MOINT, IIF, J, K, ITRY
      REAL      DCX, DCY, XI, XPOS, CDIST, DEG, DEGU, DEGL, XVAL, XINT,
     *   XINTER(NINTER), XSC
      DOUBLE PRECISION F1, F2, FSC
      CHARACTER SPRTXT*16
      INCLUDE 'INCS:DMSG.INC'
      DATA XINTER /0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5,
     *   1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000,
     *   20000, 50000/
C-----------------------------------------------------------------------
      LTYPE = MOD (ABS (ILTYPE), 100)
      IF (LTYPE.EQ.1) GO TO 999
      FSC = 1.0D0
      IF (FRQMAX.LT.1.0D0) FSC = 1.D3
C                                       tick marks
      F1 = 1.D15
      F2 = 0.0D0
      DO 15 IIF = 1,NG
         J = (IIF-1) * NC
         DO 10 K = 1,NC
            IF (FREQS(J+K).GT.0.0D0) THEN
               F1 = MIN (F1, FREQS(J+K))
               F2 = MAX (F2, FREQS(J+K))
               END IF
 10         CONTINUE
         IF (F2.GT.F1) GO TO 16
 15      CONTINUE
 16   XINT = 32 / NG
      XINT = MAX (3., MIN (16., XINT))
      F2 = F2 * FSC
      F1 = F1 * FSC
      DO 20 ITRY = 1,NINTER
         DEG = XINTER(ITRY)
         DEGU = AINT (F2/DEG) * DEG
         IF (DEGU.GT.F2) DEGU = DEGU - DEG
         DEGL = AINT (F1/DEG) * DEG
         IF (DEGL.LT.F1) DEGL = DEGL + DEG
         NOINT = (DEGU - DEGL) / DEG + 1.001
         IF (NOINT.LE.XINT) GO TO 30
 20      CONTINUE
      MSGTXT = 'FINLAB: TICK MARK ALGORITHM FAILED'
      CALL MSGWRT (6)
      IERR = 0
      GO TO 999
C                                       plot tick marks
 30   XINT = DEG
      NINT = (NOINT * NG) / 16
      NINT = MAX (1, MIN (NINT, NOINT))
      XI = (TRC(2) - BLC(2)) / 25.
      DCX = -0.5
      DCY = -1.5
      CDIST = NC-1
      XSC = (TRC(1) - BLC(1)) / NG
      DO 50 IIF = 1,NG
         J = (IIF-1) * NC
         F1 = 1.D15
         F2 = 0.0D0
         DO 25 K = 1,NC
            IF (FREQS(J+K).GT.0.0D0) THEN
               F1 = MIN (F1, FREQS(J+K))
               F2 = MAX (F2, FREQS(J+K))
               END IF
 25         CONTINUE
         F1 = F1 * FSC
         F2 = F2 * FSC
         DEGU = AINT (F2/DEG) * DEG
         IF (DEGU.GT.F2) DEGU = DEGU - DEG
         DEGL = AINT (F1/DEG) * DEG
         IF (DEGL.LT.F1) DEGL = DEGL + DEG
         NOINT = (DEGU - DEGL) / DEG + 1.001
         NINT = (NOINT * NG) / 16
         NINT = MAX (1, MIN (NINT, NOINT))
         MOINT = NOINT + 2
         XVAL = INT (F1/XINT) * XINT
         IF (XVAL.GE.F1) XVAL = XVAL - XINT
         DO 40 I = 1,MOINT
            XVAL = XVAL + XINT
            IF ((XVAL.GE.F1) .AND. (XVAL.LE.F2)) THEN
               XPOS = (XVAL-F1)/(F2-F1)*XSC + (IIF-1)*XSC + BLC(1)
               CALL GPOS (XPOS, TRC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, TRC(2)-XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GPOS (XPOS, BLC(2)+XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, BLC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               IF ((LTYPE.GT.2) .AND. (MOD(I,NINT).EQ.0)) THEN
                  WRITE (SPRTXT,1030) XVAL
                  CALL CHTRIM (SPRTXT, 10, SPRTXT, INCHAR)
                  IF (ITRY.GT.9) THEN
                     INCHAR = INCHAR - 4
                  ELSE IF (ITRY.GT.6) THEN
                     INCHAR = INCHAR - 2
                  ELSE IF (ITRY.GT.3) THEN
                     INCHAR = INCHAR - 1
                     END IF
                  DCX = 0.5 - INCHAR
                  CALL GCHAR (INCHAR, 0, DCX, DCY, SPRTXT, PLBUFF, IERR)
                  IF (IERR.NE.0) GO TO 999
                  END IF
               END IF
 40         CONTINUE
 50      CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F10.3)
      END
      SUBROUTINE PLRFIQ (KTYPE, LPX, LPY, SP, SN, SX, JANT, IRET)
C-----------------------------------------------------------------------
C    PLRFIQ plots the the mean and std spectra and not emphasize IFs
C    Inputs:
C       KTYPE    I       1 al 3, 2 mean, 3 std, 4 std/mean  <0 end
C       LPX      I       X panel number (1 to NXP)  left to right
C       LPY      I       Y panel number (1 to NYP)  top to bottom
C       SP       R(*)    spectrum mean to plot
C       SN       R(*)    spectrum min to plot
C       SX       R(*)    spectrum max to plot
C    Outputs:
C       IRET     I       > 0 => plot failure
C-----------------------------------------------------------------------
      INTEGER   KTYPE, LPX, LPY, JANT, IRET
      REAL      SP(*), SN(*), SX(*)
C
      INCLUDE 'PLRFI.INC'
      INTEGER   I, PLUN, PLBUFF(256), IVER, TVCHN, TVCORN(4), IDEPTH(5),
     *   J, LTYPE, LABEL, PIND, IROUND, NC, NI, JC, JI, NOFF(MAXIF*MXF),
     *   INCHAR, ITYPE, PLTYIN, PLTXIN, PLTYOF, PLTXOF
      LOGICAL   DOTV, GOOD, FIRST, DOSP, DOPLT(3)
      CHARACTER PFILE*48, CHT12*12, CHT6*6, CHTY*2, MSGBUF*24
      REAL      YMAX, YMIN, BLC(2), TRC(2), CH(4), X, FAC, DX, DY, XMIN,
     *   XMAX, LOCRAN(2), XYRAT, Y, XPSAVE(2), APSAVE(4), YP, SPDIFF,
     *   SPMEAN, NSP, XBLC(2), XTRC(2), XSC
      DOUBLE PRECISION FMIN, FMAX
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DDCH.INC'
      SAVE FIRST
      DATA TVCHN, TVCORN, IDEPTH /1, 4*0, 5*1/
      DATA FIRST /.TRUE./
C-----------------------------------------------------------------------
      I = APARM(10) + 0.1
      DOPLT(1) = MOD(I,2).EQ.0 .OR. (ABS(KTYPE).EQ.1)
      I = I/2
      DOPLT(2) = MOD(I,2).EQ.0
      I = I/2
      DOPLT(3) = MOD(I,2).EQ.0
      DOTV = XDOTV.GT.0.0
      CALL RCOPY (2, XPIXR, XPSAVE)
      CALL RCOPY (4, APARM, APSAVE)
      GRCHAN = XGRCH + 0.1
      ITYPE = ABS (KTYPE)
C                                       for EXTLIST
      XANT(1) = JANT
      XANT(2) = ITYPE
      CALL CHR2H (8, ANTNAM(JANT), 1, XANT(3))
C                                       Y scale
      YMAX = -1.E10
      YMIN = -YMAX
      NC = (ECHAN - BCHAN + 1)
      NI = (EIF - BIF + 1) * NOFILE
      JC = NC * NI
      SPMEAN = 0.0
      NSP = 0.0
      SPDIFF = 0.0
      FMIN = 1.D20
      FMAX = -FMIN
      DO 10 I = 1,JC
         IF (SP(I).NE.FBLANK) THEN
            FMIN = MIN (FMIN, FREQS(I,JANT))
            FMAX = MAX (FMAX, FREQS(I,JANT))
            YMIN = MIN (YMIN, SP(I))
            YMAX = MAX (YMAX, SP(I))
            IF (SN(I).NE.FBLANK) YMIN = MIN (YMIN, SN(I))
            IF (SX(I).NE.FBLANK) YMAX = MAX (YMAX, SX(I))
            IF ((SN(I).NE.FBLANK) .AND. (SX(I).NE.FBLANK)) THEN
               SPDIFF = MAX (SPDIFF, ABS(2*SP(I)-SX(I)-SN(I)))
               SPMEAN = SPMEAN + SP(I)
               NSP = NSP + 1.
               END IF
            END IF
 10      CONTINUE
      FMIN = FMIN - ABS (FREQS(2,JANT)-FREQS(1,JANT))
      FMAX = FMAX + ABS (FREQS(2,JANT)-FREQS(1,JANT))
      IF (NSP.GT.0) SPMEAN = SPMEAN / NSP
      DOSP = SPDIFF.GT.SPMEAN/500.0
      DOSP = DOSP .OR. (SPDIFF.LT.1.E-6)
      IF (ITYPE.LE.2) THEN
         IF (XPIXR(2).GT.XPIXR(1)) THEN
            YMAX = XPIXR(2)
            YMIN = XPIXR(1)
         ELSE IF (XPIXR(2).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
      ELSE IF (ITYPE.EQ.3) THEN
         IF (APARM(2).GT.APARM(1)) THEN
            YMAX = APARM(2)
            YMIN = APARM(1)
         ELSE IF (APARM(2).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
      ELSE
         IF (APARM(4).GT.APARM(3)) THEN
            YMAX = APARM(4)
            YMIN = APARM(3)
         ELSE IF (APARM(4).EQ.0.0) THEN
            CALL DIDDLE (SP, SN, SX, YMIN, YMAX)
            END IF
         END IF
      IF (ITYPE.LE.2) THEN
         XPIXR(2) = YMAX + 0.04 * (YMAX - YMIN)
         XPIXR(1) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = XPIXR(2)
         YMIN = XPIXR(1)
      ELSE IF (ITYPE.EQ.3) THEN
         APARM(2) = YMAX + 0.04 * (YMAX - YMIN)
         APARM(1) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = APARM(2)
         YMIN = APARM(1)
      ELSE
         APARM(4) = YMAX + 0.04 * (YMAX - YMIN)
         APARM(3) = YMIN - 0.04 * (YMAX - YMIN)
         YMAX = APARM(4)
         YMIN = APARM(3)
         END IF
      XMIN = FMIN
      XMAX = FMAX
C                                       Add plot file to the image
C                                       catalog header.
      IF ((.NOT.DOTV) .AND. (LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CHT12 = ' '
         CHT6 = ' '
         CHTY = ' '
         IVER = 0
         IF (FIRST) THEN
            CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12, CHT6, 0, CHTY,
     *         0, 'CLRD', PLBUFF, IRET)
            IF (IRET.EQ.0) CALL CATDIR ('CSTA', DISKIN, OLDCNO, CHT12,
     *         CHT6, 0, CHTY, 0, 'WRIT', PLBUFF, IRET)
            FRW(NCFILE) = 1
            FIRST = .FALSE.
            END IF
         CALL MADDEX ('PL', DISKIN, OLDCNO, CATOLD, PLBUFF, .TRUE.,
     *      'WRIT', IVER, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'PLHGM: ERROR UPDATING CATALOGUE HEADER.'
            CALL MSGWRT (8)
            GO TO 999
            END IF
         END IF
C                                       Open the PLot file.
      IF ((LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CALL ZPHFIL ('PL', DISKIN, OLDCNO, IVER, PFILE, IRET)
         CALL GINIT (DISKIN, OLDCNO, PFILE, 0, 74, NPARM, XNAMEI, DOTV,
     *     TVCHN, GRCHAN, TVCORN, CATOLD, PLBUFF, PLUN, PIND, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'PLRFIQ: ERROR OPENING PLOT FILE.'
            CALL MSGWRT (8)
            IF (.NOT.DOTV) CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT',
     *         CATOLD, PLBUFF, IVER, I)
            GO TO 999
            END IF
         END IF
C                                       Set character offsets.
      LABEL = IROUND (XLABEL)
      LTYPE = MOD (ABS (LABEL), 100)
      LOCRAN(2) = YMAX
      LOCRAN(1) = YMIN
      CALL GTICNT (LABEL, LOCRAN, I)
      CALL RFILL (4, 0.5, CH)
      IF (LTYPE.EQ.2) CH(1) = 3.5
      IF (LTYPE.GT.2) CH(1) = I + 4.0
      IF (LTYPE.GT.1) CH(2) = 2.0
      IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CH(4) = 2.0
         IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
         END IF
C                                       Set BLC, TRC, XYRATO.
      PLTXIN = 1000.0 / (NXP - 0.25)
      PLTYIN = 1000.0 / (NYP - 0.10)
      PLTXOF = NXP * PLTXIN - 1000.
      PLTYOF = NYP * PLTYIN - 1000.
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      IF ((DOTV) .AND. (XYRATO.LE.0.0)) THEN
         DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) + CH(3))
         DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) + CH(4))
         XYRATO = 1.0
         IF (DY.GT.0.0) XYRATO = DX / DY
      ELSE
         IF (XYRATO.LE.0.0) XYRATO = 1.4
         END IF
      XYRAT = (TRC(1) - BLC(1)) / (TRC(2) - BLC(2))
      XYRAT = XYRATO / XYRAT
C                                       sub window parms
      XBLC(1) = BLC(1) + (LPX-1) * PLTXIN
      XTRC(1) = XBLC(1) + PLTXIN - 1.0 - PLTXOF
      XBLC(2) = BLC(2) + (NYP-LPY) * PLTYIN
      XTRC(2) = XBLC(2) + PLTYIN - 1.0 - PLTYOF
C                                       Initialize for line drawing
      CALL GINITL (BLC, TRC, XYRAT, CH, IDEPTH, PLBUFF, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'DRWHGM: ERROR INITIALIZING FOR LINE DRAWING.'
         GO TO 950
         END IF
      IF (GRCHAN.GT.0) THEN
         CALL GLTYPE (GRCHAN, PLBUFF, IRET)
      ELSE
         CALL GLTYPE (1, PLBUFF, IRET)
         END IF
      IF (IRET.NE.0) GO TO 920
C                                       Draw borders.
      CALL GPOS (XBLC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 910
      CALL GVEC (XTRC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XTRC(1), XTRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XTRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XBLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 920
C                                       Labeling.
      CALL QMSLAB (ITYPE, XBLC, XTRC, FAC, XMIN, XMAX, YMIN, YMAX, NC,
     *   NI, BCHAN, PLNIF, IVER, LABEL, CATOLD, JANT, ANTNAM(JANT),
     *   STOKES, FMIN, FMAX, APARM(5), LPX, LPY, NYP, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       zero all plot channels
      DO 26 I = 4,2,-1
         CALL GLTYPE (I, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
 26      CONTINUE
C                                       Draw the data
      CALL FILL (NI, 0, NOFF)
      XSC = (XTRC(1) - XBLC(1)) / (NI * (NC+1.0))
      IF ((FACTOR.LT.0.0) .AND. (DOSP) .AND. (DOPLT(1))) THEN
         I = 0
         J = 0
         DX = 0.5 * ABS(FACTOR)
         DY = 0.5 * (XTRC(2) - XBLC(2)) / ((NC + 1.0)* NI) * ABS(FACTOR)
         CALL GPOS (X, 1.0, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 910
         DO 40 JI = 1,NI
            DO 30 JC = 1,NC
               J = J + 1
               X = (FREQS(J,JANT) - XMIN) / (XMAX - XMIN) *
     *            (XTRC(1)-XBLC(1)) + XBLC(1)
               IF ((X.LT.XBLC(1)) .OR. (X.GT. XTRC(1))) GO TO 30
               IF (SP(J).NE.FBLANK) THEN
                  Y = (SP(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  CALL GPOS (X-DX, Y+DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 910
                  CALL GVEC (X+DX, Y-DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 920
                  CALL GPOS (X+DX, Y+DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 910
                  CALL GVEC (X-DX, Y-DY, PLBUFF, IRET)
                  IF (IRET.NE.0) GO TO 920
                  END IF
  30           CONTINUE
  40        CONTINUE
      ELSE IF ((DOSP) .AND. (DOPLT(1))) THEN
         J = 0
         DO 50 JI = 1,NI
            GOOD = .FALSE.
            DO 45 JC = 1,NC
               J = J + 1
               X = (FREQS(J,JANT) - XMIN) / (XMAX - XMIN) *
     *            (XTRC(1)-XBLC(1)) + XBLC(1)
               IF ((X.LT.XBLC(1)) .OR. (X.GT. XTRC(1))) GO TO 45
               IF (SP(J).NE.FBLANK) THEN
                  Y = (SP(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 45            CONTINUE
 50         CONTINUE
         END IF
C                                       if max=min do not plot
      IF ((SPDIFF.GE.1.E-6) .AND. (DOPLT(2))) THEN
         IF (GRCHAN.EQ.0) CALL GLTYPE (4, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
         J = 0
         DO 60 JI = 1,NI
            GOOD = .FALSE.
            DO 55 JC = 1,NC
               J = J + 1
               X = (FREQS(J,JANT) - XMIN) / (XMAX - XMIN) *
     *            (XTRC(1)-XBLC(1)) + XBLC(1)
               IF ((X.LT.XBLC(1)) .OR. (X.GT. XTRC(1))) GO TO 55
               IF (SN(J).NE.FBLANK) THEN
                  Y = (SN(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     NOFF(JI) = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 55            CONTINUE
 60         CONTINUE
         END IF
      IF ((SPDIFF.GE.1.E-6) .AND. (DOPLT(3))) THEN
         IF (GRCHAN.EQ.0) CALL GLTYPE (3, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 920
         IF (DOTV) THEN
            CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
         J = 0
         DO 70 JI = 1,NI
            GOOD = .FALSE.
            DO 65 JC = 1,NC
               J = J + 1
               X = (FREQS(J,JANT) - XMIN) / (XMAX - XMIN) *
     *            (XTRC(1)-XBLC(1)) + XBLC(1)
               IF ((X.LT.XBLC(1)) .OR. (X.GT. XTRC(1))) GO TO 65
               IF (SX(J).NE.FBLANK) THEN
                  YP = (XTRC(2) + XBLC(2)) / 2.0
                  IF (SP(J).NE.FBLANK) YP = (SP(J) - YMIN) / (YMAX -
     *               YMIN) * (XTRC(2)-XBLC(2)) + XBLC(2)
                  Y = (SX(J) - YMIN) / (YMAX - YMIN) * (XTRC(2)-XBLC(2))
     *               + XBLC(2)
                  IF ((Y.LT.XBLC(2)) .OR. (Y.GT.XTRC(2))) THEN
                     IF ((YP.GT.XBLC(2)) .AND. (YP.LT.XTRC(2))) NOFF(JI)
     *                  = NOFF(JI) + 1
                     Y = MAX (XBLC(2), MIN (XTRC(2), Y))
                     END IF
                  IF (GOOD) THEN
                     CALL GVEC (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 920
                  ELSE
                     CALL GPOS (X, Y, PLBUFF, IRET)
                     IF (IRET.NE.0) GO TO 910
                     END IF
                  GOOD = .TRUE.
               ELSE
                  GOOD = .FALSE.
                  END IF
 65            CONTINUE
            I = I + 1
 70         CONTINUE
         END IF
      DO 80 JI = 1,NI
         WRITE (MSGTXT,1065) JI+BIF-1, NOFF(JI)
         IF (NOFF(JI).GT.0) THEN
            CALL MSGWRT (3)
            WRITE (MSGBUF,1060) NOFF(JI)
            CALL CHTRIM (MSGBUF, 8, MSGBUF, INCHAR)
            IF (GRCHAN.EQ.0) CALL GLTYPE (1, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 920
            IF (DOTV) THEN
               CALL GCINIT (GPHTVG(GPHLTY), 0, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
            IF (NI.LE.16) THEN
               X = (JI-1) * (NC + 1.0) * XSC + XBLC(1)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GOTO 910
               CALL GICHAR (1, INCHAR, 0, 4.0, -3.5, MSGBUF, PLBUFF,
     *            IRET)
               IF (IRET.NE.0) GO TO 920
               X = JI * (NC + 1.0) * XSC + XBLC(1)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 910
               DX = -4 - INCHAR
               CALL GICHAR (1, INCHAR, 0, DX, -3.5, MSGBUF, PLBUFF,
     *            IRET)
               IF (IRET.NE.0) GO TO 920
            ELSE
               X = (JI-0.5) * (NC + 1.0) * XSC + XBLC(1)
               CALL GPOS (X, XTRC(2), PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 910
               CALL GICHAR (1, INCHAR, 0, -INCHAR/2.0, -3.5, MSGBUF,
     *            PLBUFF, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
            END IF
 80      CONTINUE
      IF (((LPY-1)*NXP + LPX.EQ.NPLOTS) .OR. (KTYPE.LT.0)) THEN
         WRITE (MSGTXT,1070) IVER
         IF (.NOT.DOTV) CALL MSGWRT (3)
         GPHPAG = kTYPE.GT.0
         CALL GFINIS (PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 950
         END IF
      CALL RCOPY (2, XPSAVE, XPIXR)
      CALL RCOPY (4, APSAVE, APARM)
      GO TO 999
C                                       Error return from GPOS.
 910  MSGTXT = 'PLRFIQ: PLOT ERROR OCCURRED WHILE MOVING TO A POINT.'
      GO TO 940
C                                       Error return from GVEC.
 920  MSGTXT = 'PLRFIQ: PLOT ERROR OCCURRED WHILE DRAWING A LINE.'
 940  CALL MSGWRT (8)
C                                       Destroy the PLot file on error.
 950  IF (.NOT.DOTV) THEN
         WRITE (MSGTXT,1950) IVER
         CALL MSGWRT (8)
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (DISKIN, PFILE, I)
         CALL DELEXT ('PL', DISKIN, OLDCNO, 'WRIT', CATOLD, PLBUFF,
     *      IVER, I)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1060 FORMAT (I8)
 1065 FORMAT ('IF',I3,I7,' points off the plot')
 1070 FORMAT ('Created plot file version',I4)
 1950 FORMAT ('DESTROY PLOT VERSION',I4,' DUE TO ERRORS')
      END
      SUBROUTINE QMSLAB (ITY, BLC, TRC, FAC, XMIN, XMAX, YMIN, YMAX,
     *   NC, NI, LBCHAN, PLNIF, IVER, LABEL, CATOLD, JANT, STN, STOKES,
     *   FMIN, FMAX, FRQLAB, LPX, LPY, NYP, PLBUFF, IRET)
C-----------------------------------------------------------------------
C   Write labeling for PLRFI plots: non IF format
C   Inputs:
C      ITY     I        Plot type: 1 all 3, 2 for mean, 3 std,
C                          4 std/mean
C      BLC     R(2)     bottom left corner of plot.
C      TRC     R(2)     top right hand corner of plot.
C      FAC     R        FAC*XYRATO = real XYRATIO.
C      IVER    I        plot file version number
C      LABEL   I        labeling type
C   In/out:
C      PLBUFF   I(256)   I/O buffer for plot file.
C   Output:
C      IRET    I        error code returned from GVEC.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2), FAC, XMIN, XMAX, YMIN, YMAX, FRQLAB
      DOUBLE PRECISION FMIN, FMAX
      INTEGER   ITY, NC, NI, LBCHAN, PLNIF(*), IVER, LABEL, CATOLD(256),
     *   JANT, LPX, LPY, NYP, PLBUFF(256), IRET
      CHARACTER STN*(*), STOKES*(*)
C
      CHARACTER PREFIX(2)*5, TIME*8, DATE*12, NAMSTR*18, MSGBUF*80
      LOGICAL   PFLAG
      REAL      XINTER(24), DCX, DCY, XNOINT, DIST, ODIST, TICSCL, XVAL,
     *   YTICEL, YTICER, YPOS, TICLEN, XINT, X, DCXM, XDIST, DEGL, DEGU,
     *   GBLC, GTRC, DEG
      INTEGER   INOINT, INCHAR, I, IXO, IANGL, IT(3), ID(3), ITMP, JT,
     *   LTYPE, LECHAN, JTRIM, IDUM(5), KT, IDEPTH(5)
      HOLLERITH HDUM(5)
      EQUIVALENCE (IDUM, HDUM)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DLOC.INC'
      DATA TICSCL /70.0/
      DATA XINTER /.001, .002, .005, .01, .02, .05, .1, .2, .5,
     *   1., 2., 5., 10., 20., 50., 100., 200., 500.,
     *   1000., 2000., 5000., 10000., 20000., 50000./
C-----------------------------------------------------------------------
C                                        Set up the location common
C                                        for tick marks etc.
      CALL FILL (5, 1, IDEPTH)
      LOCNUM = 1
      CALL SETLOC (IDEPTH, .FALSE.)
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      AXFUNC(1,LOCNUM) = 0
      AXFUNC(2,LOCNUM) = 0
      CPREF(1,LOCNUM) = ' '
      CPREF(2,LOCNUM) = ' '
      LTYPE = MOD (ABS(LABEL), 100)
      IF (LTYPE.LE.1) GO TO 999
      LECHAN = LBCHAN + NC - 1
C                                       Tic positions.
      TICLEN = (TRC(1) - BLC(1)) / TICSCL
      YTICEL = BLC(1) + TICLEN
      YTICER = TRC(1) - TICLEN
C                                       Find vertical interval value.
      DIST = YMAX - YMIN
      ODIST = DIST
      CALL METSCL (LABEL, DIST, PREFIX(2), PFLAG)
      IF (PFLAG) GO TO 110
      XDIST = DIST / ODIST
      GTRC = YMAX * XDIST
      GBLC = YMIN * XDIST
      XINT = 8.0
      DO 20 I = 1,24
         DEG = XINTER(I)
         DEGU = AINT (GTRC/DEG) * DEG
         IF (DEGU.GT.GTRC) DEGU = DEGU - DEG
         DEGL = AINT (GBLC/DEG) * DEG
         IF (DEGL.LT.GBLC) DEGL = DEGL + DEG
         XNOINT = AINT ((DEGU-DEGL)/DEG) + 1.0
         IF (XNOINT.LE.XINT) GO TO 30
 20      CONTINUE
      GO TO 110
C                                       Interval and no of inter found.
 30   XINT = DEG
      INOINT = XNOINT + 2.5
      ODIST = XDIST * YMIN
      XVAL = AINT (ODIST/XINT) * XINT
      IF (XVAL.GE.ODIST) XVAL = XVAL - XINT
      IXO = I
      DCXM = -0.5
C                                       Loop for all tics.
      DO 100 I = 1,INOINT
         XVAL = XVAL + XINT
         YPOS = XVAL / XDIST
         YPOS = (YPOS - YMIN) / (YMAX - YMIN) * (TRC(2)-BLC(2)) + BLC(2)
         IF (YPOS.GT.TRC(2)) GO TO 110
C                                       right hand tic.
         CALL GPOS (TRC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL GVEC (YTICER, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
C                                       Left hand tic.
         CALL GPOS (YTICEL, YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL GVEC (BLC(1), YPOS, PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
C                                       Write value.
         IF (LTYPE.GT.2) THEN
            WRITE (MSGBUF,1030) XVAL
            CALL CHTRIM (MSGBUF, 14, MSGBUF, INCHAR)
            IF (IXO.GT.3) INCHAR = INCHAR - 1
            IF (IXO.GT.6) INCHAR = INCHAR - 1
            IF (IXO.GT.9) INCHAR = INCHAR - 2
            DCX = - INCHAR - 1.0
            DCY = -0.5
            DCXM = MIN (DCXM, DCX)
            CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
            IF (IRET.NE.0) GO TO 999
            END IF
 100     CONTINUE
C                                       RMS
 110  DCX = DCXM - 2.0
      YPOS = (TRC(2) + BLC(2)) / 2.0
      CALL GPOS (BLC(1), YPOS, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      IF (ITY.EQ.2) THEN
         MSGBUF = PREFIX(2) // ' Mean'
      ELSE IF (ITY.EQ.3) THEN
         MSGBUF = PREFIX(2) // ' RMS'
      ELSE IF (ITY.EQ.1) THEN
         MSGBUF = PREFIX(2) // ' All 3'
      ELSE
         MSGBUF = PREFIX(2) // ' ModIndx'
         END IF
      CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
      MSGBUF(INCHAR+2:) = 'AutoCorr'
      CALL CHTRIM (MSGBUF, 80, MSGBUF, INCHAR)
      DCY = INCHAR / 2.0 - 1.0
      CALL GCHAR (INCHAR, 1, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Determine label range
      IF (FRQLAB.LE.0.0) THEN
         CALL FINLAQ (BLC, TRC, FMIN, FMAX, LABEL, PLBUFF, IRET)
         MSGBUF = 'Frequency (GHz)'
         IF (FMAX.LT.1.0) MSGBUF = 'Frequency (MHz)'
      ELSE
         I = NC * NI
         CALL PINLAQ (BLC, TRC, LBCHAN, LECHAN, NI, LABEL, PLBUFF, IRET)
         MSGBUF = 'Spectral channels'
         END IF
      IF (IRET.NE.0) GO TO 999
C                                       Label with prefix
      DCY = -1.5
      IF (LTYPE.GT.2) DCY = -2.833
      X = (TRC(1) + BLC(1)) / 2.0
      CALL GPOS (X, BLC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      CALL CHTRIM (MSGBUF, 17, MSGBUF, INCHAR)
      DCX = 0.5 - INCHAR / 2.0
      CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      IF (LTYPE.GE.7) GO TO 999
C                                       which axis is which?
C                                       Source name, stokes, freq.
      CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
      DCX = 0.0
      DCY = 0.5
      IANGL = 0
      JT = JTRIM (STN)
      KT = JTRIM (STOKES)
      WRITE (MSGBUF,1200) JANT, STN(:JT), STOKES(:KT)
      INCHAR = JTRIM (MSGBUF)
C                                       image name
      INCHAR = INCHAR + 1
      IF (INCHAR.GT.1) THEN
         MSGBUF(INCHAR:INCHAR+2) = ' __'
         INCHAR = INCHAR + 3
         END IF
      CALL COPY (5, CATOLD(KHIMN), IDUM)
      CALL H2CHR (12, KHIMNO, HDUM, NAMSTR(1:12))
      CALL H2CHR (6, KHIMCO, HDUM, NAMSTR(13:18))
      CALL NAMEST (NAMSTR, CATOLD(KIIMS), MSGBUF(INCHAR:), ITMP)
      CALL REFRMT (MSGBUF, '_', INCHAR)
      CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       time/date, version
      IF ((LABEL.GT.0) .AND. (LPX.EQ.1) .AND. (LPY.EQ.1)) THEN
         CALL GPOS (BLC(1), TRC(2), PLBUFF, IRET)
         IF (IRET.NE.0) GO TO 999
         CALL ZDATE (ID)
         CALL ZTIME (IT)
         CALL TIMDAT (IT, ID, TIME, DATE)
         WRITE (MSGBUF,1210) IVER, DATE, TIME
         CALL REFRMT (MSGBUF, '_', INCHAR)
         DCY = DCY + 1.333
         CALL GCHAR (INCHAR, 0, DCX, DCY, MSGBUF, PLBUFF, IRET)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F14.3)
 1200 FORMAT ('Antenna',I3,1X,'''',A,'''',2x,'___Stokes ''',A,'''')
 1210 FORMAT ('Plot file version',I4,'__created ',A,A)
      END
      SUBROUTINE PINLAQ (BLC, TRC, BC, EC, NG, ILTYPE, PLBUFF, IERR)
C-----------------------------------------------------------------------
C   To do X axis where we have multiple sub panels with integer counts
C   Inputs:
C      BLC      R(2)    X, Y pixels to form bottom left hand corner
C      TRC      R(2)    X, Y pixels to form the top right hand corner
C      BC       I       Begin count
C      EC       I       End count
C      NG       I       numer groups
C      ILTYPE   I       label type: 1 none, 2 no ticks, 3 RA/DEC
C                          4 center relative
C   In/out:
C      PLBUFF   I(256)  the updated graphics output buffer.
C      IERR     I       error indicator: 0 = No error.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2)
      INTEGER   BC, EC, NG, ILTYPE, PLBUFF(256), IERR
C
      INTEGER   NINTER
      PARAMETER (NINTER=15)
C
      INTEGER   INCHAR, LTYPE, I, XINTER(NINTER), XINT, DIST, NOINT,
     *   NINT, XVAL, DEGL, DEGU, DEG, IG
      REAL      DCX, DCY, XL, XI, XPOS, XSC
      CHARACTER SPRTXT*8
      INCLUDE 'INCS:DMSG.INC'
      DATA XINTER /1, 2, 5, 10, 20, 50, 100, 200, 500, 1000,
     *   2000, 5000, 10000, 20000, 50000/
C-----------------------------------------------------------------------
      LTYPE = MOD (ABS (ILTYPE), 100)
      IF (LTYPE.EQ.1) GO TO 999
C                                       tick marks
      XINT = 32 / NG
      XINT = MAX (3, MIN (16, XINT))
      DIST = EC - BC + 3
      DO 20 I = 1,NINTER
         DEG = XINTER(I)
         DEGU = (EC / DEG) * DEG
         IF (DEGU.GT.EC) DEGU = DEGU - DEG
         DEGL = (BC / DEG) * DEG
         IF (DEGL.LT.BC) DEGL = DEGL + DEG
         NOINT = (DEGU - DEGL) / DEG + 1
         IF (NOINT.LE.XINT) GO TO 30
 20      CONTINUE
      MSGTXT = 'PINLAB: TICK MARK ALGORITHM FAILED'
      CALL MSGWRT (6)
      IERR = 0
      GO TO 999
C                                       plot tick marks
 30   XINT = DEG
      NINT = (NOINT * NG) / 16
      NINT = MAX (1, MIN (NINT, NOINT))
      NOINT = NOINT + 2
      DCX = -0.5
      XL = DIST * NG + 1
      XL = (TRC(1) - BLC(1)) / XL
      XI = (TRC(2) - BLC(2)) / 25.
      DCY = -1.5
      XSC = (TRC(1) - BLC(1)) / (NG * DIST)
      DO 50 IG = 1,NG
         XVAL = (BC / XINT) * XINT
         IF (XVAL.GE.BC) XVAL = XVAL - XINT
         DO 40 I = 1,NOINT
            XVAL = XVAL + XINT
            IF ((XVAL.GE.BC) .AND. (XVAL.LE.EC)) THEN
               XPOS = (XVAL-BC+1 + (IG-1)*DIST) * XSC + BLC(1)
               CALL GPOS (XPOS, TRC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, TRC(2)-XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GPOS (XPOS, BLC(2)+XI, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               CALL GVEC (XPOS, BLC(2), PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               IF ((LTYPE.GT.2) .AND. (MOD(I,NINT).EQ.0)) THEN
                  WRITE (SPRTXT,1030) XVAL
                  CALL CHTRIM (SPRTXT, 6, SPRTXT, INCHAR)
                  DCX = 0.5 - INCHAR
                  CALL GCHAR (INCHAR, 0, DCX, DCY, SPRTXT, PLBUFF, IERR)
                  IF (IERR.NE.0) GO TO 999
                  END IF
               END IF
 40         CONTINUE
 50      CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (I6)
      END
      SUBROUTINE FINLAQ (BLC, TRC, FMIN, FMAX, ILTYPE, PLBUFF, IERR)
C-----------------------------------------------------------------------
C   To do X axis where we have multiple sub panels with integer counts
C   Inputs:
C      BLC      R(2)    X, Y pixels to form bottom left hand corner
C      TRC      R(2)    X, Y pixels to form the top right hand corner
C      FMIN     D       Min frequency
C      FMAX     D       Min frequency
C      ILTYPE   I       label type: 1 none, 2 no ticks, 3 RA/DEC
C                          4 center relative
C   In/out:
C      PLBUFF   I(256)  the updated graphics output buffer.
C      IERR     I       error indicator: 0 = No error.
C-----------------------------------------------------------------------
      REAL      BLC(2), TRC(2)
      INTEGER   ILTYPE, PLBUFF(256), IERR
      DOUBLE PRECISION FMIN, FMAX
C
      INTEGER   NINTER
      PARAMETER (NINTER=24)
C
      INCLUDE 'INCS:DCHND.INC'
      INTEGER   INCHAR, LTYPE, I, NOINT, NINT, ITRY
      REAL      DCX, DCY, XI, XPOS, DEG, DEGU, DEGL, XVAL, XINT,
     *   XINTER(NINTER)
      DOUBLE PRECISION FN, FX
      CHARACTER SPRTXT*16
      INCLUDE 'INCS:DMSG.INC'
      DATA XINTER /0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5,
     *   1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000,
     *   20000, 50000/
C-----------------------------------------------------------------------
      LTYPE = MOD (ABS (ILTYPE), 100)
      IF (LTYPE.EQ.1) GO TO 999
C                                       tick marks
      IF (FMAX.LT.1.0D0) THEN
         FN = FMIN * 1000.0D0
         FX = FMAX * 1000.0D0
      ELSE
         FN = FMIN
         FX = FMAX
         END IF
      XINT = 32
      DO 20 ITRY = 1,NINTER
         DEG = XINTER(ITRY)
         DEGU = AINT (FX/DEG) * DEG
         IF (DEGU.GT.FX) DEGU = DEGU - DEG
         DEGL = AINT (FN/DEG) * DEG
         IF (DEGL.LT.FN) DEGL = DEGL + DEG
         NOINT = (DEGU - DEGL) / DEG + 1.001
         IF (NOINT.LE.XINT) GO TO 30
 20      CONTINUE
      MSGTXT = 'FINLAQ: TICK MARK ALGORITHM FAILED'
      CALL MSGWRT (6)
      IERR = 0
      GO TO 999
C                                       plot tick marks
 30   XINT = DEG
      NINT = NOINT
      XI = (TRC(2) - BLC(2)) / 35.
      DCX = -0.5
      DCY = -1.5
      XVAL = INT (FN/XINT) * XINT
      IF (XVAL.GE.FN) XVAL = XVAL - XINT
      DO 40 I = 1,NOINT
         XVAL = XVAL + XINT
         IF ((XVAL.GE.FN) .AND. (XVAL.LE.FX)) THEN
            XPOS = (XVAL-FN) / (FX-FN) * (TRC(1)-BLC(1)) + BLC(1)
            CALL GPOS (XPOS, TRC(2), PLBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GVEC (XPOS, TRC(2)-XI, PLBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GPOS (XPOS, BLC(2)+XI, PLBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GVEC (XPOS, BLC(2), PLBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            IF (LTYPE.GT.2) THEN
               WRITE (SPRTXT,1030) XVAL
               CALL CHTRIM (SPRTXT, 10, SPRTXT, INCHAR)
               IF (ITRY.GT.9) THEN
                  INCHAR = INCHAR - 4
               ELSE IF (ITRY.GT.6) THEN
                  INCHAR = INCHAR - 2
               ELSE IF (ITRY.GT.3) THEN
                  INCHAR = INCHAR - 1
                  END IF
               DCX = 0.5 - INCHAR
               CALL GCHAR (INCHAR, 0, DCX, DCY, SPRTXT, PLBUFF, IERR)
               IF (IERR.NE.0) GO TO 999
               END IF
            END IF
 40      CONTINUE
C
 999  RETURN
C-----------------------------------------------------------------------
 1030 FORMAT (F10.3)
      END
