LOCAL INCLUDE 'SYHIS.INC'
      INCLUDE 'INCS:PUVD.INC'
      HOLLERITH XNAMIN(3), XCLSIN(2), XSOUR(4,30), XCALC(1), XSTOK(1),
     *   XOPCOD(1), XXINTP(1), XOPTYP(1), XOUTPR(12), XFUNC(1)
      REAL      DSKIN, SEQIN, XINVER, XANT(50), XQUAL, XBAND, XFREQ,
     *   XFQID, XSUBA, XBIF, XEIF, XTIME(8), XFGVER, XNBOXS, APARM(10),
     *   BPARM(10), CUTOFF, XDOBLK, XNPLOT, DOPLOT, RPARM(30), XLTYPE,
     *   XDOTV, XGRCHN, BADD(10)
      COMMON /INPARM/ XNAMIN, XCLSIN, SEQIN, DSKIN, XINVER, XANT, XSOUR,
     *   XQUAL, XCALC, XSTOK, XBAND, XFREQ, XFQID, XSUBA, XBIF, XEIF,
     *   XTIME, XFGVER, XNBOXS, XOPCOD, APARM, XXINTP, BPARM, CUTOFF,
     *   XDOBLK, XOPTYP, XOUTPR, XNPLOT, DOPLOT, RPARM, XFUNC, XLTYPE,
     *   XDOTV, XGRCHN, BADD
      INTEGER   INDISK, INCNO, SYIVER, INSEQ, CDVER, DTYPE, NPARMS,
     *   LFGVER, SCRTCH(256), IPCNT, JP0, NPLOT, NXP, NYP, IRNO, POL1,
     *   POL2, SYOVER, LBIF, LEIF, PLOTOT, LRNO
      REAL      BTIME, ETIME
      LOGICAL   DOIT(3)
      CHARACTER NAMEIN*12, CLASIN*6, LPNAME*48, OPTYPE*4, OPCODE*4,
     *   FUNTYP*2, SRCS(1000)*16, CALIN*48, CALOUT*48, OUTPRT*48,
     *   INTPRM*4
C                                       Buffers and file info
      INTEGER   BUFFO(512), BUFFI(512), RECORD(XSYRSZ)
      REAL      RECR(XSYRSZ)
      DOUBLE PRECISION RECD(XSYRSZ/2)
      EQUIVALENCE (RECORD, RECR, RECD)
C
      COMMON /SYPARM/ RECD, BUFFI, BUFFO, SCRTCH, INDISK, INCNO, INSEQ,
     *   SYIVER, CDVER, DTYPE, NPARMS, BTIME, ETIME, LFGVER, IPCNT, JP0,
     *   IRNO, NPLOT, NXP, NYP, POL1, POL2, SYOVER, LBIF, LEIF, PLOTOT,
     *   DOIT, LRNO
      COMMON /PARMC/ NAMEIN, CLASIN, LPNAME, OPTYPE, OPCODE, CALIN,
     *   CALOUT, OUTPRT, INTPRM, FUNTYP, SRCS
      INCLUDE 'INCS:DMSG.INC'
LOCAL END
LOCAL INCLUDE 'SYHISUE.INC'
      INCLUDE 'INCS:PUVD.INC'
      DOUBLE PRECISION DDAVG(2,3,MAXIF,MAXANT), DDRMS(2,3,MAXIF,MAXANT),
     *   DDSUM(2,3,MAXIF,MAXANT), DDSUMS(2,3,MAXIF,MAXANT),
     *   DDCNT(2,3,MAXIF,MAXANT)
      REAL      TCAL(4,MAXIF,MAXANT)
      INTEGER   DDNIF, DDNANT, DDNPOL, NBOXS
      COMMON /DDVALS/ DDAVG, DDRMS, DDSUM, DDSUMS, DDCNT, TCAL, DDNIF,
     *   DDNANT, DDNPOL, NBOXS
LOCAL END
LOCAL INCLUDE 'REPSYTAB.INC'
      INCLUDE 'INCS:PUVD.INC'
C
      INTEGER   NRECSY, ISYRNO, SYKOLS(MAXSYC), SYNUMV(MAXSYC), LUNSY
      REAL      PDIFF(2,MAXIF), PSUM(2,MAXIF), PGAIN(2,MAXIF)
      COMMON /REPSYT/ NRECSY, ISYRNO, SYKOLS, SYNUMV, LUNSY, PDIFF,
     *   PSUM, PGAIN
LOCAL END
LOCAL INCLUDE 'GDATA.INC'
      DOUBLE PRECISION GDATA(1024)
      INTEGER   NITTER, ITTER
      COMMON /GDATAC/ GDATA, NITTER, ITTER
LOCAL END
LOCAL INCLUDE 'CLDATA.INC'
      INTEGER   MXTIME
      PARAMETER (MXTIME = 110000)
      REAL      WRKTIM(MXTIME), WORK1(MXTIME), WORK2(MXTIME),
     *   WORK3(MXTIME), WORK4(MXTIME), WORK5(MXTIME), WORK6(MXTIME),
     *   WORK7(MXTIME), WORK8(MXTIME), WORK9(MXTIME)
      INTEGER   WRKREC(MXTIME), WRKSRC(MXTIME), WRKTYP(MXTIME)
C                                       Align WRK* in memory
      COMMON /XXYYZZ/ WRKTIM, WORK1, WORK2, WORK3, WORK4, WORK5,
     *   WORK6, WORK7, WORK8, WORK9, WRKREC, WRKSRC, WRKTYP
LOCAL END
      PROGRAM SYHIS
C-----------------------------------------------------------------------
C! Task to plot statistics from SY table
C# EXT-util Utility
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   SYHIS will examine an EVLA SY (SysPower) table plus the CalDevice
C   CD table and computes statistics of the Pdif, Psum, or Tsys
C   values found on a per IF and per antenna basis.
C   Inputs:   (from AIPS)
C      INNAME    R(3)   name of primary file.
C      INCLASS   R(2)   class of primary file.
C      INSEQ     R      sequence number of primary file.
C      INDISK    R      disk volume number. 0 means try all.
C      INVERS    R      SY file version number
C      SOURCES   H(*)   Source names to include/exclude
C      QUAL      R      Source qualifier
C      CALCODE   H      Source cal code
C      SELBAND   R      Desired band
C      SELFREQ   R      Desired freqency
C      FREQID    R      Frequency ID number
C      SUBARRAY  R      subarray
C      TIMERANG  R(*)   time range
C      FLAGVER   R      flag version (-1 none)
C      OPTYPE    H      What to print (Pdif, Psum, Psys)
C      BADDISK   R(*)   Disks to avoid
C-----------------------------------------------------------------------
      CHARACTER PRGNAM*6
      INTEGER   IRET
C
      REAL      SYHIST(2)
      LONGINT   PSYHIS
      INTEGER   NWORDS, I
      CHARACTER SYFILE*48
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'SYHISUE.INC'
      DATA PRGNAM /'SYHIS'/
C-----------------------------------------------------------------------
C                                       start up
      CALL SYHISI (PRGNAM, IRET)
      IF (IRET.NE.0) GO TO 985
C                                       get statistics
      CALL SYHISD (IRET)
      IF (IRET.NE.0) GO TO 985
      NBOXS = XNBOXS + 0.1
      NBOXS = MAX (64, MIN (1024, NBOXS))
      NWORDS = ((NBOXS+8) * IRNO - 1) /1024 + 3
      CALL ZMEMRY ('GET ', TSKNAM, NWORDS, SYHIST, PSYHIS, IRET)
      IF (IRET.NE.0) THEN
         MSGTXT = 'CANNOT GET DYNAMIC MEMORY'
         GO TO 980
         END IF
      CALL SYHISX (NBOXS+8, SYHIST(1+PSYHIS), IRET)
      IF (IRET.NE.0) GO TO 990
      IF (DOIT(1)) THEN
         IF (OUTPRT.NE.' ') CALL SYHISO (NBOXS+8, SYHIST(1+PSYHIS))
         PLOTOT = 0
         IF (DOPLOT.GE.0.) CALL SYHISP (NBOXS+8, SYHIST(1+PSYHIS), IRET)
         IF (IRET.NE.0) GO TO 985
         END IF
      IF (.NOT.(DOIT(2) .OR. DOIT(3))) GO TO 990
      CALL SYHISC (NBOXS+8, SYHIST(1+PSYHIS), IRET)
      IF (IRET.NE.0) GO TO 985
      IF (DOIT(2)) THEN
         DOIT(1) = .FALSE.
         IF (OUTPRT.NE.' ') CALL SYHISO (NBOXS+8, SYHIST(1+PSYHIS))
         PLOTOT = 0
         IF (DOPLOT.GE.0.) CALL SYHISP (NBOXS+8, SYHIST(1+PSYHIS), IRET)
         IF (IRET.NE.0) GO TO 985
         END IF
      IF (DOIT(3)) THEN
         CALL SYHISS (IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SMOOTHING CLIPPED TABLE'
            DOIT(3) = .FALSE.
            GO TO 980
            END IF
         CALL SYHISH
         END IF
      GO TO 990
C
 980  CALL MSGWRT (8)
 985  DOIT(3) = .FALSE.
C                                       delete temporary SY
 990  IF ((.NOT.DOIT(3)) .AND. (SYOVER.GT.0)) THEN
         CALL ZPHFIL ('SY', INDISK, INCNO, SYOVER, SYFILE, I)
         CALL ZDESTR (INDISK, SYFILE, I)
         IF (I.NE.0) THEN
            WRITE (MSGTXT,1000) I, 'DELETING TEMPORARY SY TABLE'
            CALL MSGWRT (8)
            END IF
         CALL DELEXT ('SY', INDISK, INCNO, 'WRIT', CATBLK, BUFFI,
     *      SYOVER, I)
         IF (I.NE.0) THEN
            WRITE (MSGTXT,1000) I, 'REMOVING TEMP SY TABLE FROM HEADER'
            CALL MSGWRT (8)
            END IF
         END IF
      IRET = MAX (0, IRET)
      CALL DIE (IRET, SCRTCH)
C
 999  STOP
C-----------------------------------------------------------------------
 1000 FORMAT ('MAIN: ERROR',I4,' ON ',A)
      END
      SUBROUTINE SYHISI (PRGNAM, IRET)
C-----------------------------------------------------------------------
C   Inputs
C      PRGNAM   C*6   Task name
C   Outputs:
C      IRET     I     > 0 +> die on error
C-----------------------------------------------------------------------
      CHARACTER PRGNAM*(*)
      INTEGER   IRET
C
      INTEGER   NTYPE
      PARAMETER (NTYPE=3)
C
      INTEGER   IERR, I, IROUND, LUN, LUNTMP, SUBA, J, LUN2
      LOGICAL   MATCH
      CHARACTER TYPIN*2, STAT*4, TYPES(NTYPE)*4
      DOUBLE PRECISION CATD(128)
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:PFLG.INC'
      INCLUDE 'INCS:DFLG.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DSEL.INC'
      EQUIVALENCE (CATBLK, CATD)
      DATA TYPES /'PDIF', 'PSUM', 'PSYS'/
      DATA LUN, LUN2 /29, 31/
C-----------------------------------------------------------------------
C                                       Initialize the IO parameters.
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      CALL SELINI
C                                       get parameters, resume aips
      NPARMS = 280
      IRET = 0
      CALL GTPARM (PRGNAM, NPARMS, RQUICK, XNAMIN, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING ADVERBS'
         CALL MSGWRT (8)
         IRET = 8
         END IF
      IF (RQUICK) CALL RELPOP (IRET, SCRTCH, IERR)
      IF (IRET.NE.0) GO TO 990
      IRET = 8
C                                       interpret parameters
      CALL H2CHR (12, 1, XNAMIN, NAMEIN)
      CALL H2CHR (6, 1, XCLSIN, CLASIN)
      CALL H2CHR (2, 1, XFUNC, FUNTYP)
      CALL H2CHR (4, 1, XSTOK, STOKES)
      CALL H2CHR (48, 1, XOUTPR, OUTPRT)
      CALL H2CHR (4, 1, XXINTP, INTPRM)
      INSEQ = SEQIN + 0.1
      INDISK = DSKIN + 0.1
      SYIVER = XINVER + 0.1
      DO 5 I = 1,10
         IBAD(I) = IROUND(BADD(I))
 5       CONTINUE
      CALL H2CHR (4, 1, XCALC, SELCOD)
      DO 10 I = 1,30
         CALL H2CHR (16, 1, XSOUR(1,I), SOURCS(I))
 10      CONTINUE
      SELQUA = IROUND (XQUAL)
      SUBARR = IROUND (XSUBA)
      SUBARR = MAX (1, SUBARR)
      CALL H2CHR (4, 1, XOPTYP, OPTYPE)
      CALL H2CHR (4, 1, XOPCOD, OPCODE)
      DOIT(1) = .TRUE.
      DOIT(2) = .TRUE.
      DOIT(3) = .TRUE.
      IF (OPCODE.EQ.'RMS') THEN
         DOIT(2) = .FALSE.
         DOIT(3) = .FALSE.
      ELSE IF (OPCODE.EQ.'MWIN') THEN
         DOIT(1) = .FALSE.
         DOIT(3) = .FALSE.
      ELSE IF (OPCODE.EQ.'BOTH') THEN
         DOIT(3) = .FALSE.
         END IF
      DTYPE = 0
      DO 20 I = 1,NTYPE
         IF (OPTYPE.EQ.TYPES(I)) DTYPE = I
         IF (APARM(I).EQ.0.0) APARM(I) = 4.0
         APARM(I) = MAX (0.0, APARM(I))
         IF (APARM(3+I).EQ.0.0) APARM(3+I) = 3.0
         APARM(3+I) = MAX (0.0, APARM(3+I))
         IF (APARM(6+I).EQ.0.0) APARM(6+I) = 1.0
         APARM(6+I) = MAX (0.0, APARM(6+I))
 20      CONTINUE
      BTIME = ((XTIME(4)/60.+XTIME(3))/60.0 + XTIME(2))/24.0 + XTIME(1)
      ETIME = ((XTIME(8)/60.+XTIME(7))/60.0 + XTIME(6))/24.0 + XTIME(5)
      IF (BTIME.EQ.0.0) THEN
         BTIME = -1000.
         XTIME(1) = BTIME
         END IF
      IF (ETIME.EQ.0.0) THEN
         ETIME = 10000.
         XTIME(5) = ETIME
         END IF
      TSTART = BTIME
      TEND = ETIME
C                                       Get CATBLK from old file.
      INCNO = 1
      TYPIN = 'UV'
      CALL CATDIR ('SRCH', INDISK, INCNO, NAMEIN, CLASIN, INSEQ, TYPIN,
     *   NLUSER, STAT, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1030) IERR, NAMEIN, CLASIN, INSEQ, INDISK, NLUSER
         GO TO 990
         END IF
      STAT = 'WRIT'
      CALL CATIO ('READ', INDISK, INCNO, CATBLK, STAT, SCRTCH, IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING CATBLK'
         GO TO 990
         END IF
      NCFILE = 1
      FCNO(NCFILE) = INCNO
      FVOL(NCFILE) = INDISK
      FRW(NCFILE) = 0
      IF (STAT.EQ.'WRIT') FRW(NCFILE) = 1
      CALL UVPGET (IRET)
      CALL COPY (256, CATBLK, CATUV)
      CALL FNDEXT ('FG', CATBLK, I)
      LFGVER = IROUND (XFGVER)
      IF (I.LE.0) FGVER = 0
      LFGVER = MIN (LFGVER, I)
      JP0 = 0
      IF (ICOR0.EQ.-2) JP0 = 1
      IF (ICOR0.EQ.-5) JP0 = 2
      IF (ICOR0.EQ.-6) JP0 = 3
      IF (RPARM(1).LE.1.0) RPARM(1) = 4.0
      IF (RPARM(2).LE.1.0) RPARM(2) = 4.0
      IF (RPARM(3).LE.1.0) RPARM(3) = 4.0
C                                       Check antennas in SOUFIL
      CALL FILL (MAXANT, 0, ANTENS)
      DO 70 J = 1,50
         ANTENS(J) = IROUND (XANT(J))
 70      CONTINUE
C                                       Check polarization
      POL1 = 1
      POL2 = 2
      IF (CATBLK(KINAX+JLOCS).LT.2) POL2 = 1
      IF (POL2.EQ.2) THEN
         IF (CATD(KDCRV+JLOCS).EQ.-1.D0) THEN
            IF (STOKES(:1).EQ.'R') POL2 = 1
            IF (STOKES(:1).EQ.'L') POL1 = 2
         ELSE IF (CATD(KDCRV+JLOCS).EQ.-5.D0) THEN
            IF (STOKES(:1).EQ.'V') POL2 = 1
            IF (STOKES(:1).EQ.'H') POL1 = 2
            END IF
         END IF
C                                       Save relevant pointers for
C                                       flagging
      KLOCFQ = ILOCFQ
      KLOCIF = JLOCIF
      KLOCFY = JLOCF
      LRECIN = LREC
      CALL FNDEXT ('AN', CATBLK, I)
      IF ((SUBARR.GT.I) .OR. (SUBARR.LT.0)) SUBARR = 0
      IUDISK = INDISK
      IUCNO = INCNO
      IFLUN = 30
      KNCOR = NCOR
      KCOR0 = ICOR0
      KNCF = INCF / CATUV(KINAX)
      KNCIF = INCIF / CATUV(KINAX)
      KNCS = INCS / CATUV(KINAX)
      UBUFSZ = UVBFSL * 2
      BIF = XBIF + 0.1
      BIF = MAX (1, BIF)
      EIF = XEIF + 0.1
      IF (JLOCIF.GE.0) THEN
         BIF = MIN (BIF, CATUV(KINAX+JLOCIF))
         IF (EIF.LT.BIF) EIF = CATUV(KINAX+JLOCIF)
      ELSE
         BIF = 1
         EIF = 1
         END IF
      LBIF = BIF
      LEIF = EIF
C                                       DSEL common
      UNAME = NAMEIN
      UCLAS = CLASIN
      UDISK = INDISK
      IUDISK = INDISK
      USEQ = INSEQ
      IUSEQ = INSEQ
      IUCNO = INCNO
      IXLUN = LUNTMP (1)
      CALL SOUFIL (IERR)
      IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING SOURCE LIST'
         GO TO 990
         END IF
C                                       Freq id
      IF (XBAND.GT.0.0) SELBAN = XBAND
      IF (XFREQ.GT.0.0) SELFRQ = XFREQ
      FRQSEL = IROUND (XFQID)
      IF (FRQSEL.EQ.0) FRQSEL = -1
C                                       Find specified FQ id
      CALL FQMATC (INDISK, INCNO, CATBLK, LUN, SELBAN, SELFRQ, MATCH,
     *   FRQSEL, IERR)
      IF ((.NOT.MATCH) .OR. (IERR.NE.0)) THEN
         WRITE (MSGTXT,1000) IERR, 'GETTING DESIRED FREQID'
         GO TO 990
         END IF
C                                       version numbers
      CALL FNDEXT ('SY', CATBLK, I)
      IF ((SYIVER.LE.0) .OR. (SYIVER.GT.I)) SYIVER = I
      SYOVER = I + 1
      CALL FNDEXT ('CD', CATBLK, CDVER)
      IF ((SYIVER.LE.0) .OR. (CDVER.LE.0)) THEN
         MSGTXT = 'YOU MUST HAVE AN SY AND CD TABLE TO RUN THIS TASK'
         GO TO 990
         END IF
C                                       Copy SY table to manipulate
      IF (LFGVER.LE.0) THEN
         CALL TABCOP ('SY', SYIVER, SYOVER, LUN, LUN2, INDISK, INDISK,
     *      INCNO, INCNO, CATBLK, BUFFO, BUFFI, IRET)
         IF (IRET.NE.0) THEN
            SYOVER = 0
            WRITE (MSGTXT,1000) IRET, 'COPYING SY TABLE'
            GO TO 990
            END IF
C                                       copy and flag
      ELSE
         CALL SYFLAG (LUN, LUN2, IRET)
         IF (IRET.NE.0) THEN
            SYOVER = 0
            WRITE (MSGTXT,1000) IRET, 'COPYING WITH FLAGGING SY TABLE'
            GO TO 990
            END IF
         END IF
C                                       get Tcal values
      SUBA = SUBARR
      I = 1
      CALL GETCDS (INDISK, INCNO, CDVER, SUBA, I, CATBLK, TCAL, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'READING THE TCAL VALUES'
         GO TO 990
         END IF
C                                       open SY table to read
      LUNSY = 29
      CALL SYINI ('READ', BUFFI, INDISK, INCNO, SYOVER, CATBLK, LUNSY,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING OUTPUT SY TABLE FOR READ'
         GO TO 990
         END IF
      NRECSY = BUFFI(5)
C
 990  IF (IRET.NE.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISI: ERROR',I4,1X,A)
 1030 FORMAT ('ERROR',I3,' FINDING ',A12,'.',A6,'.',I4,' DISK=',
     *   I3,' USID=',I5)
      END
      SUBROUTINE SYHISD (IRET)
C-----------------------------------------------------------------------
C   SYHISD determines statistics of the SY table
C   Outputs:
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   SUBA, IREC, LL, SOURID, ANTNO, LIF, LP, I, CALTYP,
     *   IPASS, FREQID, ID
      REAL      TIMEI, TSYS, TC, X
      DOUBLE PRECISION TIME
      LOGICAL   WANT
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
C-----------------------------------------------------------------------
      IRNO = 0
      IREC = 2 * MAXIF * MAXANT * 3
      DDNIF = 0
      DDNANT = 0
      DDNPOL = 0
      CALL DFILL (IREC, 0.0D0, DDAVG)
      CALL DFILL (IREC, 1.0D9, DDRMS)
      CALL DFILL (IREC, 0.0D0, DDSUM)
      CALL DFILL (IREC, 0.0D0, DDSUMS)
      CALL DFILL (IREC, 0.0D0, DDCNT)
      IPASS = 0
C                                       read loop
 10   IPASS = IPASS + 1
      DO 50 IREC = 1,NRECSY
C                                       read
         ISYRNO = IREC
         CALL TABSY ('READ', BUFFI, ISYRNO, SYKOLS, SYNUMV, NUMPOL,
     *      NUMIF, TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID,
     *      PDIFF, PSUM, PGAIN, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING THE SY TABLE'
            GO TO 980
            END IF
C                                       include?
         WANT = IRET.EQ.0
         IF ((TIME.LT.BTIME) .OR. (TIME.GT.ETIME)) WANT = .FALSE.
         IF ((SOURID.GT.0) .AND. (NSOUWD.GT.0)) THEN
            WANT = .NOT.DOSWNT
            DO 15 I = 1,NSOUWD
               IF (SOUWAN(I).EQ.SOURID) WANT = DOSWNT
 15         CONTINUE
            END IF
         IF ((SUBA.GT.0) .AND. (SUBARR.GT.0) .AND. (SUBA.NE.SUBARR))
     *      WANT = .FALSE.
         IF ((FREQID.GT.0) .AND. (FRQSEL.GT.0) .AND. (FRQSEL.NE.FREQID))
     *      WANT = .FALSE.
         IF ((WANT) .AND. (NANTSL.GT.0)) THEN
            WANT = .NOT.DOAWNT
            DO 20 I = 1,NANTSL
               IF (ANTNO.EQ.ANTENS(I)) WANT=DOAWNT
 20         CONTINUE
            END IF
         IF (.NOT.WANT) GO TO 50
C                                       convert
         DO 40 LIF = LBIF,LEIF
            DO 30 LP = POL1,POL2
               IF (CALTYP.EQ.1) THEN
                  TC = TCAL(LP+2,LIF,ANTNO)
               ELSE
                  TC = TCAL(LP,LIF,ANTNO)
                  END IF
               IF ((TC.NE.FBLANK) .AND. (TC.GT.0.0) .AND.
     *            (PDIFF(LP,LIF).NE.FBLANK) .AND.
     *            (PSUM(LP,LIF).NE.FBLANK) .AND. (PDIFF(LP,LIF).GT.0.0)
     *               .AND. (PDIFF(LP,LIF).LT.PSUM(LP,LIF))) THEN
                  DO 25 ID = 1,3
                     IF (ID.EQ.1) THEN
                        TSYS = PDIFF(LP,LIF)
                     ELSE IF (ID.EQ.2) THEN
                        TSYS = PSUM(LP,LIF)
                     ELSE
                        TSYS = TC * PSUM(LP,LIF) / 2.0 / PDIFF(LP,LIF)
                        END IF
                     X = ABS (TSYS - DDAVG(LP,ID,LIF,ANTNO))
                     IF (X.LT.2.D0*DDRMS(LP,ID,LIF,ANTNO)) THEN
                        DDSUM(LP,ID,LIF,ANTNO) = DDSUM(LP,ID,LIF,ANTNO)
     *                     + TSYS
                        DDSUMS(LP,ID,LIF,ANTNO) =
     *                     DDSUMS(LP,ID,LIF,ANTNO) + TSYS*TSYS
                        DDCNT(LP,ID,LIF,ANTNO) = DDCNT(LP,ID,LIF,ANTNO)
     *                     + 1.0D0
                        END IF
 25                  CONTINUE
                  DDNIF = MAX (DDNIF, LIF)
                  DDNANT = MAX (DDNANT, ANTNO)
                  DDNPOL = MAX (DDNPOL, LP)
                  IRNO = IRNO + 1
                  END IF
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
      WRITE (MSGTXT,1050) IRNO, SYOVER
      IF (IPASS.EQ.10) CALL MSGWRT (3)
      IRNO = 0
      DO 80 ANTNO = 1,DDNANT
         DO 70 LIF = LBIF,LEIF
            DO 60 LP = POL1,POL2
               DO 55 ID = 1,3
                  LL = DDCNT(LP,ID,LIF,ANTNO) + 0.01
                  IF (LL.GT.0) THEN
                     DDAVG(LP,ID,LIF,ANTNO) = DDSUM(LP,ID,LIF,ANTNO)/LL
                     DDRMS(LP,ID,LIF,ANTNO) = DDSUMS(LP,ID,LIF,ANTNO) /
     *                  LL - DDAVG(LP,ID,LIF,ANTNO)**2
                     DDRMS(LP,ID,LIF,ANTNO) =
     *                  SQRT (MAX (0.D0, DDRMS(LP,ID,LIF,ANTNO)))
                     IRNO = IRNO + 1
                     END IF
 55               CONTINUE
 60            CONTINUE
 70         CONTINUE
 80      CONTINUE
      WRITE (MSGTXT,1080) IRNO, LBIF, LEIF, DDNANT
      IF (IPASS.EQ.10) CALL MSGWRT (3)
      IF (IPASS.LT.10) GO TO 10
      GO TO 999
C
 980  CALL MSGWRT (8)
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFI, BUFFI, IREC)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISD: ERROR',I4,1X,A)
 1050 FORMAT ('Used',I10,' samples (IF/pol/times) from SY version',I4)
 1080 FORMAT ('Found',I6,' histograms: IFs',I3,' -',I3,' antennas 1 -',
     *   I3)
      END
      SUBROUTINE SYHISX (NB, SYHIST, IRET)
C-----------------------------------------------------------------------
C   SYHISX fills the plot range into the start of the histograms
C   it then computes the histograms and fits a Gaussian to them
C   Inputs:
C      NB       I      Number boxes including pixrange, overflow
C   Outputs:
C      SYHIST   R(*)   Histogram (1,2) pixrange, (9,NB) histogram
C                      (3,4) basic avg, rms   (5,6) Gauss avg,rms
C                      (7,8) overflow
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   NB, IRET
      REAL      SYHIST(NB,*)
C
      INTEGER   M
      PARAMETER (M = 1024)
C
      INCLUDE 'INCS:PUVD.INC'
      INTEGER   SUBA, IREC, SOURID, ANTNO, LIF, LP, I, CALTYP, FREQID,
     *   WHICH, IB, IR, LD, LANT, LL, MP, LDFJAC, INFO, N, LWA, IPVT(3)
      DOUBLE PRECISION DMAX, FVEC(M), FJAC(3,3), WA(2*M), TOL, RINT,
     *   PARMS(3)
      EXTERNAL  XGFUNC
      REAL      TIMEI, TSYS, TC, X
      DOUBLE PRECISION TIME
      LOGICAL   WANT
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'GDATA.INC'
      DATA LWA /2048/
C-----------------------------------------------------------------------
C                                       histogram range, basic stats
      IR = 0
      DO 50 LANT = 1,DDNANT
         DO 40 LIF = LBIF,LEIF
            DO 30 LP = POL1,POL2
               DO 20 LD = 1,3
                  LL = DDCNT(LP,LD,LIF,LANT) + 0.1
                  IF (LL.GT.0) THEN
                     IR = IR + 1
                     CALL RFILL (NB, 0.0, SYHIST(1,IR))
                     SYHIST(3,IR) = DDAVG(LP,LD,LIF,LANT)
                     SYHIST(4,IR) = DDRMS(LP,LD,LIF,LANT)
                     I = 2*LD + 2
                     IF (RPARM(I+1).GT.RPARM(I)) THEN
                        SYHIST(1,IR) = RPARM(I)
                        SYHIST(2,IR) = RPARM(I+1)
                     ELSE
                        SYHIST(1,IR) = DDAVG(LP,LD,LIF,LANT) -
     *                     RPARM(LD) * DDRMS(LP,LD,LIF,LANT)
                        SYHIST(2,IR) = DDAVG(LP,LD,LIF,LANT) +
     *                     RPARM(LD)*DDRMS(LP,LD,LIF,LANT)
                        X = SYHIST(2,IR) - SYHIST(1,IR)
                        IF (X.LT.RPARM(9+LD)) THEN
                           X = (RPARM(9+LD) - X) / 2.0
                           SYHIST(1,IR) = SYHIST(1,IR) - X
                           SYHIST(2,IR) = SYHIST(2,IR) + X
                           END IF
                        END IF
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
C                                       histogram read loop
C                                       read loop
      DO 100 IREC = 1,NRECSY
C                                       read
         ISYRNO = IREC
         CALL TABSY ('READ', BUFFI, ISYRNO, SYKOLS, SYNUMV, NUMPOL,
     *      NUMIF, TIME, TIMEI, CALTYP, SOURID, ANTNO, SUBA, FREQID,
     *      PDIFF, PSUM, PGAIN, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING THE SY TABLE'
            GO TO 980
            END IF
C                                       include?
         WANT = IRET.EQ.0
         IF ((TIME.LT.BTIME) .OR. (TIME.GT.ETIME)) WANT = .FALSE.
         IF ((SOURID.GT.0) .AND. (NSOUWD.GT.0)) THEN
            WANT = .NOT.DOSWNT
            DO 60 I = 1,NSOUWD
               IF (SOUWAN(I).EQ.SOURID) WANT = DOSWNT
 60            CONTINUE
            END IF
         IF ((SUBA.GT.0) .AND. (SUBARR.GT.0) .AND. (SUBA.NE.SUBARR))
     *      WANT = .FALSE.
         IF ((FREQID.GT.0) .AND. (FRQSEL.GT.0) .AND. (FRQSEL.NE.FREQID))
     *      WANT = .FALSE.
         IF ((WANT) .AND. (NANTSL.GT.0)) THEN
            WANT = .NOT.DOAWNT
            DO 65 I = 1,NANTSL
               IF (ANTNO.EQ.ANTENS(I)) WANT=DOAWNT
 65            CONTINUE
            END IF
         IF (.NOT.WANT) GO TO 100
C                                       convert
         DO 90 LIF = LBIF,LEIF
            DO 80 LP = POL1,POL2
               DO 70 LD = 1,3
                  IF (CALTYP.EQ.1) THEN
                     TC = TCAL(LP+2,LIF,ANTNO)
                  ELSE
                     TC = TCAL(LP,LIF,ANTNO)
                     END IF
                  IF ((TC.NE.FBLANK) .AND. (TC.GT.0.0) .AND.
     *               (PDIFF(LP,LIF).NE.FBLANK) .AND.
     *                  (PSUM(LP,LIF).NE.FBLANK) .AND.
     *                  (PDIFF(LP,LIF).GT.0.0) .AND.
     *                  (PDIFF(LP,LIF).LT.PSUM(LP,LIF))) THEN
                        IR = WHICH (LP, LIF, LD, ANTNO)
                     IF (IR.GT.0) THEN
                        TSYS = TC * PSUM(LP,LIF) / 2.0 / PDIFF(LP,LIF)
                        IF (LD.EQ.1) TSYS = PDIFF(LP,LIF)
                        IF (LD.EQ.2) TSYS = PSUM(LP,LIF)
                        IB = (TSYS - SYHIST(1,IR)) * (NB-8) /
     *                     (SYHIST(2,IR)-SYHIST(1,IR)) + 8.9999
                        IF (IB.LT.8) IB = 7
                        IF (IB.GT.NB) IB = 8
                        SYHIST(IB,IR) = SYHIST(IB,IR) + 1.0
                        END IF
                     END IF
 70               CONTINUE
 80            CONTINUE
 90         CONTINUE
 100     CONTINUE
C
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFI, BUFFI, IR)
C                                       Gaussian fit
      IR = 0
      DO 150 LANT = 1,DDNANT
         DO 140 LIF = LBIF,LEIF
            DO 130 LP = POL1,POL2
               DO 120 LD = 1,3
                  LL = DDCNT(LP,LD,LIF,LANT) + 0.1
                  IF (LL.GT.0) THEN
                     IR = IR + 1
                     DMAX = -1.E6
                     MP = 0
                     DO 110 I = 9,NB
                        GDATA(I-8) = SYHIST(I,IR)
                        IF (DMAX.LT.GDATA(I-8)) THEN
                           MP = I - 8
                           DMAX = GDATA(I-8)
                           END IF
 110                    CONTINUE
                     RINT = (SYHIST(2,IR)-SYHIST(1,IR)) / (NB - 8)
                     PARMS(1) = DMAX
                     PARMS(2) = MP
                     PARMS(3) = SYHIST(4,IR) / RINT
                     N = 3
                     MP = NB - 8
                     LDFJAC = 3
                     TOL = 1.D-5
                     NITTER = 100
                     ITTER = 0
                     CALL LMSTR1 (XGFUNC, MP, N, PARMS, FVEC, FJAC,
     *                  LDFJAC, TOL, INFO, IPVT, WA, LWA)
                     IF ((INFO.GT.0) .AND. (INFO.LE.3)) THEN
                        SYHIST(5,IR) = (PARMS(2)-1.D0)*RINT +
     *                     SYHIST(1,IR)
                        SYHIST(6,IR) = PARMS(3) * RINT
                        END IF
                     END IF
 120              CONTINUE
 130           CONTINUE
 140        CONTINUE
 150     CONTINUE
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISX: ERROR',I4,' ON ',A)
      END
      INTEGER FUNCTION WHICH (IP, IIF, ID, IANT)
C-----------------------------------------------------------------------
      INTEGER   IP, IIF, ID, IANT
C
      INTEGER   LP, LIF, LANT, IR, LL, LD
      INCLUDE 'SYHIS.INC'
      INCLUDE 'SYHISUE.INC'
C-----------------------------------------------------------------------
      IR = 0
      WHICH = 0
      DO 50 LANT = 1,DDNANT
         DO 40 LIF = LBIF,LEIF
            DO 30 LP = POL1,POL2
               DO 20 LD = 1,3
                  LL = DDCNT(LP,LD,LIF,LANT) + 0.1
                  IF (LL.GT.0) THEN
                     IR = IR + 1
                     IF ((LP.EQ.IP) .AND. (IIF.EQ.LIF) .AND.
     *                  (IANT.EQ.LANT) .AND. (ID.EQ.LD)) THEN
                        WHICH = IR
                        END IF
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE XGFUNC (M, N, PARMS, FVEC, FJROW, IFLAG)
C-----------------------------------------------------------------------
C   This routine is called by the Argonne package to calculate the
C   difference between the current fit and the actual data OR the
C   Jacobian for this difference.
C     INPUTS:  M        I   Number of data points in slice (adj. array
C                           dim.).
C              N        I   No. of parameters (adj. array dim.;
C                           NGAUSS * 3)
C              PARMS    D(N)   parameters of gaussian components,
C                       GMAX(1), GPOS(1), GWIDTH(1), GMAX(2), ...
C              IFLAG    I   1=calculate difference for current guess.
C                           2=calculate jacobian for current guess.
C    COMMON:   GDATA
C              DATA     R(?)   Origional slice data points.
C              IDOPOS   I(4)   -1 means hold corresponding position
C                       parameter constant.
C              IDOMAX   I(4)   -1 means hold corresponding maximum
C                       amplitude parameter constant.
C              IDOWTH   I(4)   -1 means hold corresponding half
C                       width parameter constant.
C              ITTER    I   number of calls to evaluate FVEC.
C    OUTPUTS:  FVEC     D(M)   Slice data points minus data points
C                       evaluated for current guess.
C              FJROW    D(N)   Row (IFLAG - 1) of Jacobian.
C-----------------------------------------------------------------------
      INTEGER   N, M
      DOUBLE PRECISION PARMS(N), FVEC(M), FJROW(N), AMP, POS, SIG,
     *   EFACT, RES2, TSIG2, X, HALFAC
      INTEGER   IFLAG, IDATA
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'GDATA.INC'
      DATA HALFAC /0.5D0/
C-----------------------------------------------------------------------
C                                       Determine difference between
C                                       data and current fit.
      IF (IFLAG.LE.1) THEN
         ITTER = ITTER + 1
         IF (ITTER.GT.NITTER) THEN
            IFLAG = -1
         ELSE
            DO 20 IDATA = 1,M
               FVEC(IDATA) = GDATA(IDATA)
               IF (FVEC(IDATA).EQ.FBLANK) THEN
                  FVEC(IDATA) = 0.0D0
               ELSE
                  X = IDATA
                  AMP = PARMS(1)
                  IF (AMP.NE.0.0D0) THEN
                     POS = PARMS(2)
                     SIG = PARMS(3)
                     RES2 = (X - POS) / SIG
                     RES2 = HALFAC * RES2 * RES2
                     IF (RES2.LE.69.0D0) FVEC(IDATA) = FVEC(IDATA) -
     *                  AMP * EXP (-RES2)
                     END IF
                  END IF
   20          CONTINUE
            END IF
C                                       Calculate Jacobian.
      ELSE
         IDATA = IFLAG - 1
         X = IDATA
         FJROW(1) = 0.0D0
         FJROW(2) = 0.0D0
         FJROW(3) = 0.0D0
         AMP = PARMS(1)
         POS = PARMS(2)
         SIG = PARMS(3)
         RES2 = HALFAC * (X - POS) * (X - POS)
         TSIG2 = RES2 / (SIG * SIG)
         IF (TSIG2.LE.69.0D0) THEN
            EFACT = -EXP (-TSIG2)
            FJROW(1) = EFACT
            EFACT = 2.0D0 * EFACT * AMP / (SIG * SIG)
            FJROW(2) = HALFAC * EFACT * (X-POS)
            FJROW(3) = EFACT * RES2 / SIG
            END IF
         END IF
C
 999  RETURN
      END
      SUBROUTINE SYHISO (NB, SYHIST)
C-----------------------------------------------------------------------
C   SYHISO prints the means and rmses
C   Inputs:
C      NB       I      Number boxes including pixrange, overflow
C      SYHIST   R(*)   Histogram (3,4,5,6) means and rmses
C-----------------------------------------------------------------------
      INTEGER   NB
      REAL      SYHIST(NB,*)
C
      INTEGER   LP, LIF, LANT, IR, LL, TLUN, TIND, J, JTRIM, IRET,
     *   LD, LD1, LD2, JD, KD
      CHARACTER OUTLIN*132, TYPES(6)*4
      REAL      DBG(8)
      INCLUDE 'SYHIS.INC'
      INCLUDE 'SYHISUE.INC'
      DATA TYPES /'Pdif', 'Psum', 'Psys', 'Mdif', 'Msum', 'Msys'/
C-----------------------------------------------------------------------
      IF (DTYPE.GT.0) THEN
         LD1 = DTYPE
         LD2 = DTYPE
      ELSE
         LD1 = 1
         LD2 = 3
         END IF
      TLUN = 3
      CALL ZTXOPN ('WRIT', TLUN, TIND, OUTPRT, .TRUE., IRET)
      IF (IRET.NE.0) THEN
         TIND = 0
         WRITE (MSGTXT,1000) IRET, 'OPENING OUTPUT TEXT FILE'
         GO TO 980
         END IF
      DO 50 LD = LD1,LD2
         KD = LD + 3
         IF (DOIT(1)) KD = LD
         WRITE (OUTLIN,2000)
         J = JTRIM (OUTLIN)
         CALL ZTXIO ('WRIT', TLUN, TIND, OUTLIN(:J), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITE TEXT TITLE LINE'
            GO TO 980
            END IF
         IF (LD.EQ.1) THEN
            WRITE (OUTLIN,2001) TYPES(KD)
         ELSE IF (LD.EQ.2) THEN
            WRITE (OUTLIN,2002) TYPES(KD)
         ELSE
            WRITE (OUTLIN,2003) TYPES(KD)
            END IF
         J = JTRIM (OUTLIN)
         CALL ZTXIO ('WRIT', TLUN, TIND, OUTLIN(:J), IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITE TEXT TITLE LINE'
            GO TO 980
            END IF
         IR = 0
         DO 40 LANT = 1,DDNANT
            DO 30 LIF = LBIF,LEIF
               DO 20 LP = POL1,POL2
                  DO 10 JD = 1,3
                     LL = DDCNT(LP,JD,LIF,LANT) + 0.1
                     IF (LL.LE.0) THEN
                        WRITE (OUTLIN,2005) LANT, LIF, LP
                     ELSE
                        IR = IR + 1
                        CALL RCOPY (8, SYHIST(1,IR), DBG)
                        IF (JD.EQ.1) THEN
                           IF (SYHIST(6,IR).GT.0) THEN
                              WRITE (OUTLIN,2010) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,6)
                           ELSE
                              WRITE (OUTLIN,2011) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,4)
                              END IF
                        ELSE IF (JD.EQ.2) THEN
                           IF (SYHIST(6,IR).GT.0) THEN
                              WRITE (OUTLIN,2020) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,6)
                           ELSE
                              WRITE (OUTLIN,2021) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,4)
                           END IF
                        ELSE
                           IF (SYHIST(6,IR).GT.0) THEN
                              WRITE (OUTLIN,2030) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,6)
                           ELSE
                              WRITE (OUTLIN,2031) LANT, LIF, LP,
     *                           (SYHIST(J,IR), J = 3,4)
                              END IF
                           END IF
                        END IF
                     IF (JD.EQ.LD) THEN
                        J = JTRIM (OUTLIN)
                        CALL ZTXIO ('WRIT', TLUN, TIND, OUTLIN(:J),
     *                     IRET)
                        IF (IRET.NE.0) THEN
                           WRITE (MSGTXT,1000) IRET, 'WRITE TEXT FILE'
                           GO TO 980
                           END IF
                        END IF
 10                  CONTINUE
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
      GO TO 990
C
 980  CALL MSGWRT (7)
 990  IF (TIND.GT.0) CALL ZTXCLS (TLUN, TIND, J)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISO ERROR',I4,' ON ',A)
 2000 FORMAT (' Antenna   IF  Pol      Semi-robust           Gaussian')
 2001 FORMAT (2X,A,15X,'mean      rms',9X,'mean      rms')
 2002 FORMAT (2X,A,17X,'mean      rms',9X,'mean      rms')
 2003 FORMAT (2X,A,18X,'mean      rms',9X,'mean      rms')
 2005 FORMAT (I6,I7,I4,2X,2('   -------'),2X,2('   -------'))
 2010 FORMAT (I6,I7,I4,2X,2F10.5,2X,2F10.5)
 2011 FORMAT (I6,I7,I4,2X,2F10.5,2X,2('   -------'))
 2020 FORMAT (I6,I7,I4,2X,2F10.3,2X,2F10.3)
 2021 FORMAT (I6,I7,I4,2X,2F10.4,2X,2('   -------'))
 2030 FORMAT (I6,I7,I4,2X,2F10.2,2X,2F10.2)
 2031 FORMAT (I6,I7,I4,2X,2F10.2,2X,2('   -------'))
      END
      SUBROUTINE SYHISP (NB, SYHIST, IRET)
C-----------------------------------------------------------------------
C   SYHISP plots histograms of the SY table
C   Inputs:
C      NB       I      Number boxes incl pixrange, overflow
C      SYHIST   R(*)   Pixrange in 1,2, under, over flow, histogram
C   Outputs:
C      IRET     I      Error code
C-----------------------------------------------------------------------
      INTEGER   NB, IRET
      REAL      SYHIST(NB,*)
C
      INTEGER   LANT, LIF, LP, IR, LL, IPLOT, INX(16), INY(16), LNX,
     *   LNY, NOLAB(4,5), LD, LD1, LD2, JD
      LOGICAL   NOLABL
      INCLUDE 'SYHIS.INC'
      INCLUDE 'SYHISUE.INC'
C      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA INX /1, 2, 2, 2, 3, 3, 3, 3, 3, 7*4/
      DATA INY /1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4*4/
C-----------------------------------------------------------------------
      IF (DTYPE.GT.0) THEN
         LD1 = DTYPE
         LD2 = DTYPE
         LRNO = IRNO / 3
      ELSE
         LD1 = 1
         LD2 = 3
         LRNO = IRNO
         END IF
      IPLOT = 0
      NPLOT = XNPLOT + 0.1
      NPLOT = MAX (1, MIN (16, NPLOT))
      NXP = INX(NPLOT)
      NYP = INY(NPLOT)
      LNX = 1
      LNY = 1
      IR = 0
      CALL MARK (NXP, NYP, NPLOT, LRNO, IR, NOLAB)
      DO 50 LD = LD1,LD2
         IR = 0
         DO 40 LANT = 1,DDNANT
            DO 30 LIF = LBIF,LEIF
               DO 20 LP = POL1,POL2
                  DO 10 JD = 1,3
                     LL = DDCNT(LP,JD,LIF,LANT) + 0.1
                     IF (LL.GT.0) THEN
                        IR = IR + 1
                        IF (JD.EQ.LD) THEN
                           IPLOT = IPLOT + 1
                           IF (IPLOT.GT.NPLOT) THEN
                              IPLOT = 1
                              LNX = 1
                              LNY = 1
                              CALL MARK (NXP, NYP, NPLOT, LRNO, IR,
     *                           NOLAB)
                              END IF
                           NOLABL = NOLAB(LNX,LNY+1).LE.0
                           CALL PLOTIT (LANT, LIF, LD, LP, NB,
     *                        SYHIST(1,IR), IPLOT, LNX, LNY, NOLABL,
     *                        IRET)
                           IF (IRET.NE.0) GO TO 980
                           LNX = LNX + 1
                           IF (LNX.GT.NXP) THEN
                              LNX = 1
                              LNY = LNY + 1
                              IF (LNY.GT.NYP) LNY = 1
                              END IF
                           END IF
                        END IF
 10                  CONTINUE
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
      GO TO 999
C
 980  IRET = MAX (0, IRET)
      WRITE (MSGTXT,1980) IRET, LANT, LIF, LP, LD
      IF (IRET.NE.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1980 FORMAT ('ERROR',I4,' ANTENNA',I3,' IF',I3,' POLARIZATION',I2,
     *   'TYPE',I2)
      END
      SUBROUTINE MARK (NXP, NYP, NPLOT, IRNO, IR, NOLAB)
C-----------------------------------------------------------------------
C   MARK prepares an array to tell when a plot is the lowest on the
C   page.  If NOLAB(ix,iy+1) = 1, then panel ix,iy is lowest.
C   Inputs:
C      NXP     I      Number X panels
C      NyP     I      Number Y panels
C      NPLOT   I      Number panels per page
C      IRNO    I      Total number panels
C      IR      I      Current panel number
C   Output:
C      NOLAB   I(4,5) =0 means panel is being plotted, =1 not plotted
C-----------------------------------------------------------------------
      INTEGER   NXP, NYP, NPLOT, IRNO, IR, NOLAB(4,5)
C
      INTEGER   LNX, LNY, LP, TP, I
C-----------------------------------------------------------------------
      CALL FILL (20, 1, NOLAB)
      LP = MAX (1, IR)
      LNX = 0
      LNY = 1
      TP = MIN (NXP * NYP, NPLOT)
      TP = MIN (TP, IRNO-LP+1)
      DO 20 I = 1,TP
         LNX = LNX + 1
         IF (LNX.GT.NXP) THEN
            LNX = 1
            LNY = LNY + 1
            END IF
         NOLAB(LNX,LNY) = 0
 20      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE PLOTIT (LANT, LIF, LD, LP, NB, SYHIST, IPLOT, LPX, LPY,
     *   NOLABL, IRET)
C-----------------------------------------------------------------------
C   PLOTIT does the actual plotting
C   Inputs
C      LANT     I      Current antenna number
C      LIF      I      Current IF number
C      LD       I      Current data type
C      LP       I      Current polarization number
C      NB       I      Current polarization number
C      SYHIST   R(*)   Data: pixr, below, above, histogram
C      IPLOT    I      Plot number (1 - NPLOT)
C      LPX      I      X panel number
C      LPY      I      Y panel number
C   Output
C      IRET     I      Error code, -1 quit happily
C-----------------------------------------------------------------------
      INTEGER   LANT, LIF, LD, LP, NB, IPLOT, LPX,  LPY, IRET
      REAL      SYHIST(*)
      LOGICAL   NOLABL
C
      INTEGER   IBIN, IDEPTH(5), J, I, NCHAR, IT(3), ID(3), IDP3, KD,
     *   LTYPE, IROUND, LABEL, TVCHN, TVCORN(4), IVER, PLUN, PIND,
     *   ITEMP(2), GRCHN, PLTYIN, PLTXIN, PLTYOF, PLTXOF
      REAL      BLC(2), CH(4), RANGE(2), TRC(2), X, XSCALE, XYRATO, Y1,
     *   Y2, YSCALE, X2, DX, DY, DBG(512), XBLC(2), XTRC(2), XYRAT,
     *   YMAX, FAC, GSCALE, RSCALE
      LOGICAL   FLAG, DOTV
      CHARACTER STRING*80, ADATE*12, ATIME*8, UNITS(3)*8, PFILE*48,
     *   TYPES(6)*4
      INCLUDE 'SYHIS.INC'
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DTVC.INC'
      SAVE DOTV
      DATA TYPES /'Pdif', 'Psum', 'Psys', 'Mdif', 'Msum', 'Msys'/
      DATA UNITS /2*'Counts', 'Kelvin'/
C-----------------------------------------------------------------------
      PLOTOT = PLOTOT + 1
      I = MIN (512, NB)
      CALL RCOPY (I, SYHIST, DBG)
      IDP3 = IROUND (DOPLOT)
      IF (DOPLOT.GT.0.0) IDP3 = MAX (1, IDP3)
      IF (IPLOT.EQ.1) THEN
         DOTV = XDOTV.GT.0.0
         TVCHN = 1
         GRCHN = XGRCHN + 0.1
         CALL FILL (4, 0, TVCORN)
         IVER = 0
         IF (.NOT.DOTV) THEN
            CALL MADDEX ('PL', INDISK, INCNO, CATBLK, BUFFI, .TRUE.,
     *         'WRIT', IVER, IRET)
            IF (IRET.NE.0) THEN
               MSGTXT = 'PLHGM: ERROR UPDATING CATALOGUE HEADER.'
               CALL MSGWRT (8)
               GO TO 999
               END IF
            END IF
C                                       Open the PLot file.
         PLUN = 29
         CALL ZPHFIL ('PL', INDISK, INCNO, IVER, PFILE, IRET)
         CALL GINIT (INDISK, INCNO, PFILE, 0, 81, NPARMS, XNAMIN, DOTV,
     *      TVCHN, GRCHN, TVCORN, CATBLK, BUFFI, PLUN, PIND, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'OPENING PLOT FILE'
            GO TO 980
            END IF
         END IF
      LABEL = IROUND (XLTYPE)
      RANGE(1) = 1.E10
      RANGE(2) = -RANGE(1)
      YMAX = -1.E10
      DO 10 I = 9,NB
         YMAX = MAX (YMAX, SYHIST(I))
         IF (FUNTYP.EQ.'LG') THEN
            IF (SYHIST(I).LE.0.0) THEN
               SYHIST(I) = -0.3
            ELSE
               SYHIST(I) = LOG10 (SYHIST(I))
               END IF
            END IF
         RANGE(1) = MIN (RANGE(1), SYHIST(I))
         RANGE(2) = MAX (RANGE(2), SYHIST(I))
 10      CONTINUE
      X = RANGE(2) - RANGE(1)
      RANGE(1) = RANGE(1) - 0.03 * X
      RANGE(2) = RANGE(2) + 0.03 * X
C                                       Set BLC, TRC, XYRATO.
      CALL FILL (5, 1, IDEPTH)
      PLTXIN = 1000.0 / (NXP - 0.25)
      PLTYIN = 1000.0 / (NYP - 0.10)
      PLTXOF = NXP * PLTXIN - 1000.
      PLTYOF = NYP * PLTYIN - 1000.
      BLC(1) = 0.0
      BLC(2) = 0.0
      TRC(1) = 1000.0
      TRC(2) = 1000.0
      IF ((DOTV) .AND. (XYRATO.LE.0.0)) THEN
         DX = WINDTV(3) - WINDTV(1) + 1 - CSIZTV(1) * (CH(1) + CH(3))
         DY = WINDTV(4) - WINDTV(2) + 1 - CSIZTV(2) * (CH(2) + CH(4))
         XYRATO = 1.0
         IF (DY.GT.0.0) XYRATO = DX / DY
      ELSE
         IF (XYRATO.LE.0.0) XYRATO = 1.4
         END IF
      XYRAT = (TRC(1) - BLC(1)) / (TRC(2) - BLC(2))
      XYRAT = XYRATO / XYRAT
C                                       sub window parms
      XBLC(1) = BLC(1) + (LPX-1) * PLTXIN
      XTRC(1) = XBLC(1) + PLTXIN - 1.0 - PLTXOF
      XBLC(2) = BLC(2) + (NYP-LPY) * PLTYIN
      XTRC(2) = XBLC(2) + PLTYIN - 1.0 - PLTYOF
C                                       Set coordinate common
      LOCNUM = 1
      RPVAL(1,LOCNUM) = SYHIST(1)
      RPVAL(2,LOCNUM) = RANGE(1)
      RPLOC(1,LOCNUM) = XBLC(1)
      RPLOC(2,LOCNUM) = XBLC(2)
      AXINC(1,LOCNUM) = (SYHIST(2) - SYHIST(1)) / (XTRC(1)-XBLC(1))
      AXINC(2,LOCNUM) = (RANGE(2) - RANGE(1)) / (XTRC(2)-XBLC(2))
      ROT(LOCNUM) = 0.0
      NCHLAB(1,LOCNUM) = 0
      NCHLAB(2,LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      CORTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 4
      AXFUNC(1,LOCNUM) = 0
      AXFUNC(2,LOCNUM) = 0
      NCHLAB(1,LOCNUM) = 0
      NCHLAB(2,LOCNUM) = 0
      CTYP(1,LOCNUM) = UNITS(LD)
      IF (NOLABL) CTYP(1,LOCNUM) = ' '
      CTYP(2,LOCNUM) = 'Number'
      CPREF(2,LOCNUM) = ' '
      IF (FUNTYP.EQ.'LG') CPREF(2,LOCNUM) = 'Log10'
C                                       metric scaling
      Y1 = ABS (AXINC(1,LOCNUM) * (XTRC(1) - XBLC(1)))
      Y2 = Y1
      CALL METSCL (LABEL, Y2, CPREF(1,LOCNUM), FLAG)
      IF ((.NOT.FLAG) .AND. (Y1.NE.0.0)) THEN
         RSCALE = Y2 / Y1
         RPVAL(1,LOCNUM) = RPVAL(1,LOCNUM) * Y2 / Y1
         AXINC(1,LOCNUM) = AXINC(1,LOCNUM) * Y2 / Y1
      ELSE
         RSCALE = 1.0
         END IF
      IF (NOLABL) CPREF(1,LOCNUM) = '-1'
C                                       Set character offsets.
      IF (IPLOT.EQ.1) THEN
         LTYPE = MOD (ABS (LABEL), 100)
         CALL RFILL (4, 0.5, CH)
         CALL CHNTIC (BLC, TRC, J)
         IF (LTYPE.EQ.2) CH(1) = 2.5
         IF (LTYPE.GT.2) CH(1) = MAX (J,4) + 4.0
         IF (LTYPE.GT.1) CH(2) = 2.0
         IF (LTYPE.GT.2) CH(2) = CH(2) + 1.333
         IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
            CH(2) = CH(2) + 1.333
            CH(4) = 2.0
            IF (LABEL.GT.0) CH(4) = CH(4) + 1.333
            END IF
C                                       Initialize for line drawing
         CALL GINITL (BLC, TRC, XYRATO, CH, IDEPTH, BUFFI, IRET)
         IF (IRET.NE.0) THEN
            MSGTXT = 'DRWHGM: ERROR INITIALIZING FOR LINE DRAWING.'
            GO TO 980
            END IF
         IF (DOTV) THEN
            IF (MOD(IDP3,2).EQ.1) CALL GCINIT (GPHTVG(3), 0, IRET)
            IF (MOD(IDP3/2,2).EQ.1) CALL GCINIT (GPHTVG(4), 0, IRET)
            END IF
         END IF
      CALL GLTYPE (1, BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
C                                       Draw borders.
      CALL GPOS (XBLC(1), XBLC(2), BUFFI, IRET)
      IF (IRET.NE.0) GO TO 910
      CALL GVEC (XTRC(1), XBLC(2), BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XTRC(1), XTRC(2), BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XTRC(2), BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
      CALL GVEC (XBLC(1), XBLC(2), BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
C                                       Calculate range and scales.
      XSCALE = (XTRC(1)-XBLC(1)) / NBOXS
      YSCALE = (XTRC(2)-XBLC(2)) / (RANGE(2) - RANGE(1))
      GSCALE = (SYHIST(2) - SYHIST(1)) / NBOXS
C                                       Labeling: file ant if pol
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         DX = -11.
         DY = -3.
         NCHAR = 6
         WRITE (STRING,1015) 'Ant',LANT
         CALL GPOS (XTRC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         DY = DY - 1.333
         WRITE (STRING,1015) 'IF ',LIF
         CALL GPOS (XTRC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         DY = DY - 1.333
         WRITE (STRING,1015) 'Pol', LP
         CALL GPOS (XTRC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         END IF
C                                       Labeling: date
      IF ((LABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7) .AND.
     *   (IPLOT.EQ.1)) THEN
         CALL ZDATE (ID)
         CALL ZTIME (IT)
         CALL TIMDAT (IT, ID, ATIME, ADATE)
         WRITE (STRING,1010) IVER, ADATE, ATIME
         DY = 0.5
         DX = 0
         CALL REFRMT (STRING, '_', NCHAR)
         CALL GPOS (BLC(1), TRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         END IF
C                                       Labeling: bin stuff
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
C                                       samples outside
         ITEMP(1) = SYHIST(7) + 0.1
         ITEMP(2) = SYHIST(8) + 0.1
         DX = 4
         DY = -3
         KD = LD + 3
         IF (DOIT(1)) KD = LD
         STRING = TYPES(KD)
         NCHAR = 4
         CALL GPOS (XBLC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         DY = DY - 1.333
         WRITE (STRING,1013) 'Below', ITEMP(1)
         CALL GPOS (XBLC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL REFRMT (STRING, '_', NCHAR)
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         DY = DY - 1.333
         WRITE (STRING,1013) 'Above', ITEMP(2)
         CALL GPOS (XBLC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL REFRMT (STRING, '_', NCHAR)
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         END IF
C                                       tick marks, labels, ...
      CALL CLAB1 (XBLC, XTRC, CH, LABEL, XYRATO, .FALSE., BUFFI, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'DRAWING TICKS'
         GO TO 980
         END IF
C                                       Draw the histogram
      CALL GLTYPE (2, BUFFI, IRET)
      IF (IRET.NE.0) GO TO 920
      X = 1.0 + XBLC(1)
      Y1 = 1.0 + XBLC(2)
      CALL GPOS (X, Y1, BUFFI, IRET)
      IF (IRET.NE.0) GO TO 910
      DO 30 IBIN = 1,NBOXS
         Y1 = SYHIST(IBIN+8)
         Y1 = (Y1 - RANGE(1)) * YSCALE + 1.0 + XBLC(2)
         CALL GVEC (X, Y1, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 920
         X2 = X + XSCALE
         CALL GVEC (X2, Y1, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 920
         X = X2
         IF (IBIN.EQ.NBOXS) THEN
            Y1 = 1.0 + XBLC(2)
            CALL GVEC (X, Y1, BUFFI, IRET)
            IF (IRET.NE.0) GO TO 920
            END IF
 30      CONTINUE
      IF ((MOD(IDP3,2).EQ.1) .AND. (SYHIST(4).GT.0.0)) THEN
         CALL GLTYPE (3, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 920
         FAC = -1.0 / (2.0 * (SYHIST(4) ** 2))
         DX = -11.
         DY = -7.0
         X = SYHIST(4) * RSCALE
         WRITE (STRING,1040) X
         CALL REFRMT (STRING, '_', NCHAR)
         CALL GPOS (XTRC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         X = 1.0 + XBLC(1) + XSCALE/2.0
         Y1 = 1.0 + XBLC(2)
         CALL GPOS (X, Y1, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         DO 40 IBIN = 1,NBOXS
            X2 = (IBIN-1.0)*GSCALE + SYHIST(1)
            Y1 = YMAX * EXP (FAC*((X2-SYHIST(3))**2))
            IF (FUNTYP.EQ.'LG') then
               IF (Y1.LE.0.0) THEN
                  Y1 = -0.3
               ELSE
                  Y1 = MAX (-0.3, LOG10(Y1))
                  END IF
               END IF
            Y1 = (Y1 - RANGE(1)) * YSCALE + 1.0 + XBLC(2)
            CALL GVEC (X, Y1, BUFFI, IRET)
            IF (IRET.NE.0) GO TO 920
            X = X + XSCALE
            IF (IBIN.EQ.NBOXS) THEN
               Y1 = 1.0 + XBLC(2)
               CALL GVEC (X, Y1, BUFFI, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
 40         CONTINUE
         END IF
      IF ((MOD(IDP3/2,2).EQ.1) .AND. (SYHIST(6).GT.0.0)) THEN
         FAC = -1.0 / (2.0 * (SYHIST(6) ** 2))
         CALL GLTYPE (4, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 920
         DX = 4.
         DY = -7.0
         X = SYHIST(6) * RSCALE
         WRITE (STRING,1040) X
         CALL REFRMT (STRING, '_', NCHAR)
         CALL GPOS (XBLC(1), XTRC(2), BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         CALL GCHAR (NCHAR, 0, DX, DY, STRING, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 930
         X = 1.0 + XBLC(1) + XSCALE/2.0
         Y1 = 1.0 + XBLC(2)
         CALL GPOS (X, Y1, BUFFI, IRET)
         IF (IRET.NE.0) GO TO 910
         DO 50 IBIN = 1,NBOXS
            X2 = (IBIN-1.0)*GSCALE + SYHIST(1)
            Y1 = YMAX * EXP (FAC*((X2-SYHIST(5))**2))
            IF (FUNTYP.EQ.'LG') THEN
               IF (Y1.LE.0.0) THEN
                  Y1 = -0.3
               ELSE
                  Y1 = MAX (-0.3, LOG10(Y1))
                  END IF
               END IF
            Y1 = (Y1 - RANGE(1)) * YSCALE + 1.0 + XBLC(2)
            CALL GVEC (X, Y1, BUFFI, IRET)
            IF (IRET.NE.0) GO TO 920
            X = X + XSCALE
            IF (IBIN.EQ.NBOXS) THEN
               Y1 = 1.0 + XBLC(2)
               CALL GVEC (X, Y1, BUFFI, IRET)
               IF (IRET.NE.0) GO TO 920
               END IF
 50         CONTINUE
         END IF
      IF ((IPLOT.EQ.NPLOT) .OR. (PLOTOT.EQ.LRNO)) THEN
         WRITE (MSGTXT,1030) IVER
         IF (.NOT.DOTV) CALL MSGWRT (3)
         GPHPAG = (IPLOT.EQ.NPLOT) .AND. (PLOTOT.LT.LRNO)
         GPHPAG = GPHPAG .OR. (DOIT(1) .AND. DOIT(2))
         CALL GFINIS (BUFFI, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINISHING THE PLOT'
            GO TO 980
            END IF
         END IF
      GO TO 999
C                                       Error return from GPOS.
 910  WRITE (MSGTXT,1000) IRET, 'MOVING TO A POINT'
      GO TO 980
C                                       Error return from GVEC.
 920  WRITE (MSGTXT,1000) IRET, 'DRAWING A LINE'
      GO TO 980
C                                       error return from GCHAR
 930  WRITE (MSGTXT,1000) IRET, 'DRAWING CHARACTERS'
C
 980  CALL MSGWRT (8)
      IF (.NOT.DOTV) THEN
         CALL ZCLOSE (PLUN, PIND, I)
         CALL ZDESTR (INDISK, PFILE, I)
         CALL DELEXT ('PL', INDISK, INCNO, 'WRIT', CATBLK, BUFFI, IVER,
     *      I)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLOTIT ERROR',I4,' ON ',A)
 1010 FORMAT ('PLot file version',I4,'__created ',A12,A8)
 1013 FORMAT (A5,I6)
 1015 FORMAT (A3,I3)
 1030 FORMAT ('Created plot file version',I4)
 1040 FORMAT ('RMS ',F6.2)
      END
      SUBROUTINE SYFLAG (LUNI, LUNO, IRET)
C-----------------------------------------------------------------------
C   TVFLAG copies the SY table applying flags to it
C   Inputs:
C      LUNI   I   LUN to use on read
C      LUNO   I   LUN to use on write
C   Outputs:
C      IRET   I   > 0 => quit
C-----------------------------------------------------------------------
      INTEGER   LUNI, LUNO, IRET
C
      INCLUDE 'SYHIS.INC'
      INTEGER   IERR, TIMKOL, SOUKOL, ANTKOL, SUBKOL, FRQKOL, PS1KOL,
     *   TS1KOL, PS2KOL, PD2KOL, NKEY, KEY(2,2), KEYSUB(2,2), NUMAN,
     *   ISYRNI, FREQID,
     *   NUMREC, IRCODE, PARTFL, FULLFL, NDROP, I, LIMIT, FSOUR, FSUBA,
     *   FFREQI, FANTS(2), FIFS(2), FCHANS(2), IFLAG, IT, TYTIM, TYANT,
     *   NFGREC, FGLUN, PG1KOL, PG2KOL, KOLS(2)
      LOGICAL   TABLE, EXIST, FITASC, PFLAGS(4), WAS1
      REAL      FKEY(2,2), FTIMER(2), TIME
      CHARACTER COLHED(2)*24, REASON*24
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:PFLG.INC'
      INCLUDE 'INCS:DFLG.INC'
C      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
c      INCLUDE 'INCS:PTYTAB.INC'
      DATA FKEY /1.0, 0.0, 1.0, 0.0/
      DATA KEYSUB /4*1/
      DATA COLHED /'TIME ', 'ANTENNA NO. '/
      DATA IRCODE /0/
C-----------------------------------------------------------------------
      FGLUN = 30
C                                       do not overwrite
      CALL ISTAB ('SY', INDISK, INCNO, SYOVER, LUNO, BUFFI, TABLE,
     *   EXIST, FITASC, IERR)
      IF ((EXIST) .OR. (IERR.NE.0)) THEN
         IRET = 1
         MSGTXT = 'CANNOT OVERWRITE A PRE-EXISTING TABLE'
         GO TO 990
         END IF
C                                       Sort SY table to time-antenna
C                                       Need col. pointers, sort order.
      CALL SYINI ('READ', BUFFO, INDISK, INCNO, SYIVER, CATBLK, LUNI,
     *   ISYRNO, SYKOLS, SYNUMV, NUMAN, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Get column pointers
      NKEY = 2
      CALL FNDCOL (NKEY, COLHED, 24, .TRUE., BUFFO, KOLS, IRET)
      IF ((IRET.GE.1) .AND. (IRET.LE.10)) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING COLUMNS IN SY TABLE'
         GO TO 990
         END IF
      IRET = 0
      TYTIM = KOLS(1)
      TYANT = KOLS(2)
      TIMKOL = SYKOLS(1)
      SOUKOL = SYKOLS(4)
      ANTKOL = SYKOLS(5)
      SUBKOL = SYKOLS(6)
      FRQKOL = SYKOLS(7)
      TS1KOL = SYKOLS(8)
      PS1KOL = SYKOLS(9)
      PG1KOL = SYKOLS(10)
      IF (NUMPOL.GT.1) THEN
         PD2KOL = SYKOLS(11)
         PS2KOL = SYKOLS(12)
         PG2KOL = SYKOLS(13)
      ELSE
         PD2KOL = -1000
         PS2KOL = -1000
         PG2KOL = -1000
         END IF
C                                       Close table
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IERR)
      IF ((IERR.NE.0) .OR. (IRET.NE.0)) GO TO 999
      KEY(1,1) = TYTIM
      KEY(1,2) = TYANT
      KEY(2,1) = 0
      KEY(2,2) = 0
C                                       Sort to time-antenna order.
      IF (((BUFFO(43).NE.TYTIM) .OR. (BUFFO(44).NE.TYANT))) THEN
         CALL TABSRT (INDISK, INCNO, 'SY', SYIVER, SYIVER, KEY, KEYSUB,
     *      FKEY, BUFFO, CATBLK, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SORTING INPUT SY TABLE'
            GO TO 990
            END IF
         END IF
C                                       sort FG table?
      WRITE (MSGTXT,1010) LFGVER
      CALL MSGWRT (3)
      CALL FGREFM (INDISK, INCNO, LFGVER, CATBLK, LUNI, IERR)
      CALL FLGINI ('READ', FGBUFF, INDISK, INCNO, LFGVER, CATBLK, FGLUN,
     *   IFGRNO, FGKOLS, FGNUMV, IERR)
      IF (IERR.NE.0) THEN
         IRET = 2
         WRITE (MSGTXT,1000) IERR, 'OPENING FLAG TABLE'
         GO TO 990
         END IF
      KEY(1,1) = 5
      KEY(1,2) = 1
      IF (((FGBUFF(43).NE.5) .OR. (FGBUFF(44).NE.1))) THEN
         CALL TABIO ('CLOS', 0, IFGRNO, FGBUFF, FGBUFF, IERR)
         CALL TABSRT (INDISK, INCNO, 'FG', LFGVER, LFGVER, KEY, KEYSUB,
     *      FKEY, BUFFO, CATBLK, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SORTING FLAG TABLE'
            GO TO 990
            END IF
         CALL FLGINI ('READ', FGBUFF, INDISK, INCNO, LFGVER, CATBLK,
     *      FGLUN, IFGRNO, FGKOLS, FGNUMV, IERR)
         IF (IERR.NE.0) THEN
            IRET = 2
            WRITE (MSGTXT,1000) IERR, 'OPENING FLAG TABLE'
            GO TO 990
            END IF
         END IF
      NFGREC = FGBUFF(5)
      NUMFLG = 0
      TMFLST = -1.E6
C                                       Open files
      CALL SYINI ('READ', BUFFI, INDISK, INCNO, SYIVER, CATBLK, LUNI,
     *   ISYRNI, SYKOLS, SYNUMV, NUMAN, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING INPUT SY TABLE'
         GO TO 990
         END IF
      CALL SYINI ('WRIT', BUFFO, INDISK, INCNO, SYOVER, CATBLK, LUNO,
     *   ISYRNO, SYKOLS, SYNUMV, NUMAN, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING OUTPUT SY TABLE'
         GO TO 990
         END IF
      NUMREC = BUFFI(5)
      PARTFL = 0
      FULLFL = 0
      DO 90 ISYRNI = 1,NUMREC
         CALL TABIO ('READ', IRCODE, ISYRNI, RECORD, BUFFI, IRET)
         IF (IRET.LT.0) THEN
            IRET = 0
            GO TO 90
            END IF
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'READING INPUT SY TABLE'
            GO TO 990
            END IF
         TIME = RECD(TIMKOL)
C                                       new time: NXTFLG clone
         IF (TMFLST.LT.TIME) THEN
            TMFLST = TIME
C                                       any to drop from list?
 10         NDROP = 0
            IF ((NUMFLG.GT.0) .AND. (TIMORD)) THEN
               DO 20 I = 1,NUMFLG
                  IF (FLGTND(I).LT.TIME) NDROP = I
 20               CONTINUE
               END IF
C                                       Compress, dropping flag.
            IF (NDROP.GT.0) THEN
               IF (NDROP.LT.NUMFLG) THEN
                  LIMIT = NDROP + 1
                  DO 30 I = LIMIT,NUMFLG
                     IT = I - 1
                     FLGTST(IT) = FLGTST(I)
                     FLGTND(IT) = FLGTND(I)
                     FLGSOU(IT) = FLGSOU(I)
                     FLGANT(IT) = FLGANT(I)
                     FLGFQD(IT) = FLGFQD(I)
                     FLGSUB(IT) = FLGSUB(I)
                     FLGBIF(IT) = FLGBIF(I)
                     FLGEIF(IT) = FLGEIF(I)
                     FLGPOL(1,IT) = FLGPOL(1,I)
                     FLGPOL(2,IT) = FLGPOL(2,I)
                     FLGPOL(3,IT) = FLGPOL(3,I)
                     FLGPOL(4,IT) = FLGPOL(4,I)
 30                  CONTINUE
                  END IF
               NUMFLG = NUMFLG - 1
               GO TO 10
               END IF
C                                       read FG table
 40         LIMIT = IFGRNO
            DO 50 I = LIMIT,NFGREC
               IFGRNO = I
               CALL TABFLG ('READ', FGBUFF, IFGRNO, FGKOLS, FGNUMV,
     *            FSOUR, FSUBA, FFREQI, FANTS, FTIMER, FIFS, FCHANS,
     *            PFLAGS, REASON, IERR)
               IF (IERR.GT.0) GO TO 900
               IF (IERR.EQ.0) THEN
                  IF (TIME.LT.FTIMER(1)) GO TO 55
                  IF (TIME.GT.FTIMER(2)) GO TO 50
                  IF ((FFREQI.GT.0) .AND. (FREQID.GT.0) .AND.
     *               (FFREQI.NE.FREQID)) GO TO 50
                  IF ((FIFS(1).GT.0) .AND. (FIFS(1).GT.LEIF)) GO TO 50
                  IF ((FIFS(2).GT.0) .AND. (FIFS(2).LT.LBIF)) GO TO 50
                  IF ((FSUBA.GT.0) .AND. (SUBARR.GT.0) .AND.
     *               (FSUBA.NE.SUBARR)) GO TO 50
                  IF ((.NOT.PFLAGS(1)) .AND. (.NOT.PFLAGS(2))) GO TO 50
                  IF ((FANTS(1).GT.0) .AND. (FANTS(2).GT.0)) GO TO 50
C                                       ignore channel dependent
                  IF (FCHANS(1).LE.0) FCHANS(1) = 1
                  IF (FCHANS(2).LE.0) FCHANS(2) = CATBLK(KINAX+JLOCF)
                  IF ((FCHANS(1).GT.1) .OR.
     *               (FCHANS(2).LT.CATBLK(KINAX+JLOCF))) GO TO 50
                  IF (NUMFLG.EQ.MAXFLG) THEN
                     MSGTXT = 'NUMBER OF FLAGS AT 1 TIME EXCEEDS LIMIT'
                     CALL MSGWRT (7)
                     MSGTXT = 'NOT ALL TABLE ROWS PROPERLY FLAGGED'
                     CALL MSGWRT (7)
                     GO TO 60
                     END IF
                  NUMFLG = NUMFLG + 1
C                                       Fill in tables
                  FLGTST(NUMFLG) = FTIMER(1)
                  FLGTND(NUMFLG) = FTIMER(2)
                  FLGSOU(NUMFLG) = FSOUR
                  FLGFQD(NUMFLG) = FFREQI
                  FLGANT(NUMFLG) = MAX (FANTS(1), FANTS(2))
                  FLGSUB(NUMFLG) = FSUBA
                  FLGBIF(NUMFLG) = FIFS(1)
                  FLGEIF(NUMFLG) = FIFS(2)
                  IF (FLGBIF(NUMFLG).LE.0) FLGBIF(NUMFLG) = 1
                  IF (FLGEIF(NUMFLG).LE.0) THEN
                     IF (JLOCIF.GT.0) FLGEIF(NUMFLG) =
     *                  CATBLK(KINAX+JLOCIF)
                     IF (JLOCIF.LE.0) FLGEIF(NUMFLG) = 1
                     END IF
C
                  CALL LCOPY (4, PFLAGS, FLGPOL(1,NUMFLG))
                  GO TO 40
                  END IF
 50            CONTINUE
 55         IFGRNO = IFGRNO - 1
            END IF
C                                       end get new flags
C                                       check flags to see if apply
 60      WAS1 = .FALSE.
         DO 70 IFLAG = 1,NUMFLG
            IF ((TIME.LT.FLGTST(IFLAG)) .OR. (TIME.GT.FLGTND(IFLAG)))
     *         GO TO 70
            I = RECORD(SOUKOL)
            IF ((FLGSOU(IFLAG).GT.0) .AND. (I.NE.FLGSOU(IFLAG)) .AND.
     *         (I.GT.0)) GO TO 70
            I = RECORD(ANTKOL)
            IF ((FLGANT(IFLAG).NE.I) .AND. (FLGANT(IFLAG).GT.0) .AND.
     *         (I.GT.0)) GO TO 70
            I = RECORD(SUBKOL)
            IF ((FLGSUB(IFLAG).NE.I) .AND. (FLGSUB(IFLAG).GT.0) .AND.
     *         (I.GT.0)) GO TO 70
            I = RECORD(FRQKOL)
            IF ((FLGFQD(IFLAG).NE.I) .AND. (FLGFQD(IFLAG).GT.0) .AND.
     *         (I.GT.0)) GO TO 70
            CALL LCOPY (4, FLGPOL(1,IFLAG), PFLAGS)
C                                       something to be flagged w this
            DO 65 I = FLGBIF(IFLAG),FLGEIF(IFLAG)
               IF (PFLAGS(1)) THEN
                  RECR(TS1KOL+I-1) = FBLANK
                  RECR(PS1KOL+I-1) = FBLANK
                  IF (PG1KOL.GT.0) RECR(PG1KOL+I-1) = FBLANK
                  END IF
               IF ((NUMPOL.GT.1) .AND. (PFLAGS(2))) THEN
                  RECR(PD2KOL+I-1) = FBLANK
                  RECR(PS2KOL+I-1) = FBLANK
                  IF (PG2KOL.GT.0) RECR(PG2KOL+I-1) = FBLANK
                  END IF
 65            CONTINUE
            WAS1 = .TRUE.
 70         CONTINUE
C                                       all bad?
         IF (WAS1) THEN
            PARTFL = PARTFL + 1
            DO 75 I = LBIF,LEIF
               IF (RECR(TS1KOL+I-1).NE.FBLANK) GO TO 80
               IF (RECR(PS1KOL+I-1).NE.FBLANK) GO TO 80
               IF (PG1KOL.GT.0) THEN
                  IF (RECR(PG1KOL+I-1).NE.FBLANK) GO TO 80
                  END IF
               IF (PG2KOL.GT.0) THEN
                  IF (RECR(PG2KOL+I-1).NE.FBLANK) GO TO 80
                  END IF
               IF (NUMPOL.GT.1) THEN
                  IF (RECR(PD2KOL+I-1).NE.FBLANK) GO TO 80
                  IF (RECR(PS2KOL+I-1).NE.FBLANK) GO TO 80
                  END IF
 75            CONTINUE
            FULLFL = FULLFL + 1
            GO TO 90
            END IF
 80      CALL TABIO ('WRIT', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
         IF (IRET.GT.0) THEN
            WRITE (MSGTXT,1000) IRET, 'WRITING OUTPUT SY TABLE'
            GO TO 990
            END IF
         ISYRNO = ISYRNO + 1
 90      CONTINUE
      PARTFL = PARTFL - FULLFL
      WRITE (MSGTXT,1090) ISYRNO, SYIVER, SYOVER
      CALL MSGWRT (3)
      WRITE (MSGTXT,1091) PARTFL
      IF (PARTFL.GT.0) CALL MSGWRT (3)
      WRITE (MSGTXT,1092) FULLFL
      IF (FULLFL.GT.0) CALL MSGWRT (3)
C
 900  CALL TABIO ('CLOS', 0, NUMREC, BUFFI, BUFFI, IERR)
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IERR)
      CALL TABIO ('CLOS', 0, IFGRNO, FGBUFF, FGBUFF, IERR)
      GO TO 999
C
 990  IF (IRET.GT.0) CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYFLAG: ERROR',I5,' ON ',A)
 1010 FORMAT ('SYFLAG applying flag table version',I3)
 1090 FORMAT ('SYFLAG: wrote',I9,' records from table',I3,' to table',
     *   I3)
 1091 FORMAT ('SYFLAG:      ',I9,' records were partly flagged')
 1092 FORMAT ('SYFLAG:      ',I9,' records were omitted since',
     *   ' fully flagged')
      END
      SUBROUTINE SYHISC (NB, SYHIST, IRET)
C-----------------------------------------------------------------------
C   Clips selected portions of SY tables.
C   Leaves the output table sorted in antenna-time order.
C   Inputs
C      NB       I      First dimension of SYHIST
C      SYHIST   R(*)   Histograms
C   Output:
C      IRET     I      Return code, 0=>OK, otherwise failed.
C-----------------------------------------------------------------------
      INTEGER   NB, IRET
      REAL      SYHIST(NB,*)
C
      INCLUDE 'SYHIS.INC'
      CHARACTER  COLHED(2)*24
      INTEGER   KEY(2,2), ICLUN, SYANT, SYTIM,  NKEY, I, KOLS(2),
     *   NUMPOL, NUMIF, SUB, TYPKOL, NUMSUB, TIMKOL, SOUKOL, ANTKOL,
     *   SUBKOL, FRQKOL, PS1KOL, PD1KOL, PG1KOL, PS2KOL, PD2KOL, PG2KOL,
     *   NUMANT, KEYSUB(2,2), LANT, LD, LP, LIF, LL, IR
      LOGICAL   T, DOPDIF, DOPSUM, DOPRAT
      REAL      FKEY(2,2), STTDIF(3), STTSUM(3), X, Y, STTRAT(3)
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'CLDATA.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA FKEY /1.0,0.0, 1.0,0.0/
      DATA KEYSUB /4*1/
      DATA COLHED /'TIME ', 'ANTENNA NO. '/
      DATA T /.TRUE./
      DATA ICLUN /30/
C-----------------------------------------------------------------------
      IRET = 0
C                                       Sort SY table to antenna-time.
C                                       Need col. pointers, sort order.
      CALL SYINI ('READ', BUFFO, INDISK, INCNO, SYOVER, CATBLK, ICLUN,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING NEW SY TABLE'
         GO TO 990
         END IF
C                                       Get column pointers
      NKEY = 2
      CALL FNDCOL (NKEY, COLHED, 24, T, BUFFO, KOLS, IRET)
      IF ((IRET.GE.1) .AND. (IRET.LE.10)) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING SY TABLE COLUMNS'
         GO TO 990
         END IF
      IRET = 0
      SYTIM = KOLS(1)
      SYANT = KOLS(2)
      TIMKOL = SYKOLS(1)
      TYPKOL = SYKOLS(3)
      SOUKOL = SYKOLS(4)
      ANTKOL = SYKOLS(5)
      SUBKOL = SYKOLS(6)
      FRQKOL = SYKOLS(7)
      PD1KOL = SYKOLS(8)
      PS1KOL = SYKOLS(9)
      IF (NUMPOL.GT.1) THEN
         PD2KOL = SYKOLS(11)
         PS2KOL = SYKOLS(12)
      ELSE
         PD2KOL = -1000
         PS2KOL = -1000
         END IF
C                                       Close table
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSING SY TABLE BEFORE SORT'
         GO TO 990
         END IF
      KEY(1,1) = SYANT
      KEY(1,2) = SYTIM
      KEY(2,1) = 0
      KEY(2,2) = 0
C                                       Sort to antenna time order.
      IF (((BUFFO(43).NE.SYANT) .OR. (BUFFO(44).NE.SYTIM))) THEN
         CALL TABSRT (INDISK, INCNO, 'SY', SYOVER, SYOVER, KEY, KEYSUB,
     *      FKEY, BUFFO, CATBLK, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SORTING NEW SY TABLE'
            GO TO 990
            END IF
         END IF
C                                       Reopen write
      CALL SYINI ('WRIT', BUFFO, INDISK, INCNO, SYOVER, CATBLK, ICLUN,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'REOPEN SY TABLE AS WRITE'
         GO TO 990
      END IF
C                                       set clip limits
      I = 2 * MAXIF * MAXANT * 3
      CALL DFILL (I, -1.D10, DDSUM)
      CALL DFILL (I, 1.D10, DDSUMS)
      IR = 0
      DO 50 LANT = 1,DDNANT
         DO 40 LIF = LBIF,LEIF
            DO 30 LP = POL1,POL2
               DO 20 LD = 1,3
                  LL = DDCNT(LP,LD,LIF,LANT) + 0.1
                  IF (LL.GT.0) THEN
                     IR = IR + 1
                     IF (SYHIST(6,IR).LE.0.0) THEN
                        DDSUM(LP,LD,LIF,LANT) = SYHIST(3,IR) -
     *                     SYHIST(4,IR)*APARM(LD)
                        DDSUMS(LP,LD,LIF,LANT) = SYHIST(3,IR) +
     *                     SYHIST(4,IR)*APARM(LD)
                     ELSE
                        X = SQRT (SYHIST(3,IR)*SYHIST(5,IR))
                        Y = SQRT (SYHIST(4,IR)*SYHIST(6,IR))
                        DDSUM(LP,LD,LIF,LANT) = X - Y * APARM(LD)
                        DDSUMS(LP,LD,LIF,LANT) = X + Y * APARM(LD)
                        END IF
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
C                                       Find number of subarrays.
      CALL FNDEXT ('AN', CATBLK, NUMSUB)
      NUMSUB = MAX (NUMSUB, 1)
C                                       Determine smoothing parameters.
      STTDIF(1) = APARM(7) / 1440.0
      STTSUM(1) = APARM(8) / 1440.0
      STTRAT(1) = APARM(9) / 1440.0
      DOPDIF = (APARM(4).GT.0.0) .AND. (APARM(4).LT.25.0)
      DOPSUM = (APARM(5).GT.0.0) .AND. (APARM(5).LT.25.0)
      DOPRAT = (APARM(6).GT.0.0) .AND. (APARM(6).LT.25.0)
      DOPDIF = DOPDIF .OR. ((APARM(1).GT.0.0) .AND. (APARM(1).LT.25.0))
      DOPSUM = DOPSUM .OR. ((APARM(2).GT.0.0) .AND. (APARM(2).LT.25.0))
      DOPRAT = DOPRAT .OR. ((APARM(3).GT.0.0) .AND. (APARM(3).LT.25.0))
C                                       Inform user of smoothing:
      IF ((DOPDIF) .OR. (DOPSUM) .OR. (DOPRAT)) THEN
         MSGTXT ='SYHISC: Clip and MW SY table'
         IF (DOIT(3)) MSGTXT ='SYHISC: Clip and MW SY table' //
     *      ' and save results'
         CALL MSGWRT (4)
C                                       Clip TY/SY
         DO 100 I = LBIF,LEIF
            CALL CLPSYS (STTDIF, STTSUM, STTRAT, DOPDIF, DOPSUM, DOPRAT,
     *         SUB, NUMANT, TYPKOL, TIMKOL, SUBKOL, ANTKOL, SOUKOL,
     *         FRQKOL, PD1KOL+I-1, PS1KOL+I-1, PG1KOL+I-1, PD2KOL+I-1,
     *         PS2KOL+I-1, PG2KOL+I-1, I, NB, SYHIST, IRET)
            IF (IRET.NE.0) GO TO 999
 100        CONTINUE
         END IF
C                                       Close table
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IRET)
      IF (IRET.EQ.0) GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISC: ERROR',I4,' ON ',A)
      END
      SUBROUTINE CLPSYS (STTDIF, STTSUM, STTRAT, DOPDIF, DOPSUM, DOPRAT,
     *   SUB, NUMA, TYPKOL, TIMKOL, SUBKOL, ANTKOL, SOUKOL, FRQKOL,
     *   PD1KOL, PS1KOL, PG1KOL, PD2KOL, PS2KOL, PG2KOL, BEGIF, NB,
     *   SYHIST, IRET)
C-----------------------------------------------------------------------
C   Routine to clip Pdif, Psum, Psys by comparison with a median window
C   filter.  All poln present and the range of IF specified by IFBEG
C   and IFEND are clipped.  The values in a single polarization are
C   averaged.
C   Inputs:
C      STTDIF   R       Pdif smoothing time (days)
C      STTSUM   R       Psum smoothing time (days)
C      STTRAT   R       Psys smoothing time (days)
C      DOPDIF   L       Smooth Pdif
C      DOPSUM   L       Smooth Psum
C      DOPRAT   L       Smooth Psys
C      SUB      I       Desired subarray
C      NUMA   I       Number of antennas
C      TIMKOL   I       Time column pointer.
C      SUBKOL   I       Subarray column pointer
C      ANTKOL   I       Antenna column pointer
C      FRQKOL   I       FQ id column pointer
C      SOUKOL   I       Source ID column pointer
C      PD1KOL   I       Pdif pol 1  column pointer
C      PS1KOL   I       Psum 1  column pointer
C      PD2KOL   I       Pdif pol 2 pointer <1 => not present
C      PS2KOL   I       Psum 2  column pointer <1 => not present
C      BEGIF    I       IF for display purposes only
C   Inputs from common:
C      I/O buffer etc.
C      Other data selection criteria.
C   Output:
C      IRET     I  Error code, 0=OK else failed.
C-----------------------------------------------------------------------
      INTEGER   SUB, NUMA, TYPKOL, TIMKOL, SUBKOL, ANTKOL, SOUKOL,
     *   FRQKOL, PD1KOL, PS1KOL, PG1KOL, PD2KOL, PS2KOL, PG2KOL, BEGIF,
     *   IRET, NB
      REAL      STTDIF(*), STTSUM(*), STTRAT(*), SYHIST(NB,*)
      LOGICAL   DOPDIF, DOPSUM, DOPRAT
C
      INTEGER   LOOPR, LOOPA, IRCODE, NUMTIM, ANT, NUMREC, FSTREC, I,
     *   NLEFT, SAVE, NRECS, NSYVAL, ITC, WHICH, JRNO, SOURID, FREQID,
     *   SUBA, NPDIF(2), NPSUM(2), NPRAT(2), ITIME
      LOGICAL   SLCTD, WANT, BAD
      REAL      RTIME, X
      DOUBLE PRECISION TIMOFF
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'CLDATA.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      DATA IRCODE /0/
C-----------------------------------------------------------------------
C                                       Get number of records in table
      NUMREC = BUFFO(5)
      IF (NUMREC.LE.0) GO TO 999
      IF ((.NOT.DOPDIF) .AND. (.NOT.DOPSUM) .AND. (.NOT.DOPRAT))
     *   GO TO 999
      I = 2 * MAXIF * MAXANT * 3
      CALL DFILL (I, -1.D10, DDAVG)
      CALL DFILL (I, 1.D10, DDRMS)
      FSTREC = 0
      NRECS = 0
      NSYVAL = 0
      CALL FILL (2, 0, NPDIF)
      CALL FILL (2, 0, NPSUM)
      CALL FILL (2, 0, NPRAT)
C                                       Loop over antenna
      DO 600 LOOPA = 1,NUMA
         ANT = LOOPA
C                                       Want this antenna?
         IF (.NOT.SLCTD (ANT, ANTENS, NANTSL, DOAWNT)) GO TO 600
C                                       Set pointers, counters
         NUMTIM = 0
         NLEFT = NUMREC - FSTREC
C                                       Loop in time, reading
         DO 100 LOOPR = 1,NLEFT
            ISYRNO = FSTREC + LOOPR
            CALL TABIO ('READ', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
            IF (IRET.LT.0) THEN
               IRET = 0
               GO TO 100
               END IF
            IF (IRET.NE.0) GO TO 900
C                                       Finished antenna?
            IF (RECORD(ANTKOL).GT.ANT) GO TO 110
            IF (RECORD(ANTKOL).LT.ANT) GO TO 100
            RTIME = RECD(TIMKOL)
            SOURID = RECORD(SOUKOL)
            FREQID = RECORD(FRQKOL)
            SUBA = RECORD(SUBKOL)
            WANT = .TRUE.
            IF ((RTIME.LT.BTIME) .OR. (RTIME.GT.ETIME)) WANT = .FALSE.
            IF ((SOURID.GT.0) .AND. (NSOUWD.GT.0)) THEN
               WANT = .NOT.DOSWNT
               DO 15 I = 1,NSOUWD
                  IF (SOUWAN(I).EQ.SOURID) WANT = DOSWNT
 15               CONTINUE
               END IF
            IF ((SUBA.GT.0) .AND. (SUBARR.GT.0) .AND. (SUBA.NE.SUBARR))
     *         WANT = .FALSE.
            IF ((FREQID.GT.0) .AND. (FRQSEL.GT.0) .AND.
     *         (FRQSEL.NE.FREQID)) WANT = .FALSE.
            IF (WANT) THEN
               IF (NUMTIM.EQ.MXTIME) THEN
                  MSGTXT = 'NUMBER OF TIMES EXCESSIVE, OPERATION' //
     *               ' TRUNCATED'
                  CALL MSGWRT (8)
                  END IF
               IF (NUMTIM.LT.MXTIME) THEN
                  NUMTIM = NUMTIM + 1
                  IF (NUMTIM.EQ.1) TIMOFF = RTIME
                  WRKTIM(NUMTIM) = RTIME - TIMOFF
                  WRKREC(NUMTIM) = ISYRNO
                  IF (TYPKOL.GT.0) THEN
                     WRKTYP(NUMTIM) = RECORD(TYPKOL)
                  ELSE
                     WRKTYP(NUMTIM) = 0
                     END IF
                  if (isyrno.eq.119) then
                     msgtxt = 'we are here'
                     end if
C                                       basic clipping included
                  WORK2(NUMTIM) = RECR(PD1KOL)
                  IF ((WORK2(NUMTIM).NE.FBLANK) .AND.
     *               ((WORK2(NUMTIM).LE.DDSUM(1,1,BEGIF,ANT)) .OR.
     *               (WORK2(NUMTIM).GE.DDSUMS(1,1,BEGIF,ANT)))) THEN
                     WORK2(NUMTIM) = FBLANK
                     NPDIF(1) = NPDIF(1) + 1
                     END IF
                  WORK4(NUMTIM) = RECR(PS1KOL)
                  IF ((WORK4(NUMTIM).NE.FBLANK) .AND.
     *               ((WORK4(NUMTIM).LE.DDSUM(1,2,BEGIF,ANT)) .OR.
     *               (WORK4(NUMTIM).GE.DDSUMS(1,2,BEGIF,ANT)))) THEN
                     WORK4(NUMTIM) = FBLANK
                     NPSUM(1) = NPSUM(1) + 1
                     END IF
C                                       Psys 1
                  WORK6(NUMTIM) = FBLANK
                  IF (DOPRAT) THEN
                     IF (WRKTYP(NUMTIM).EQ.1) THEN
                        ITC = 3
                     ELSE
                        ITC = 1
                        END IF
                     IF ((WORK2(NUMTIM).LE.0.0) .OR.
     *                  (WORK4(NUMTIM).EQ.FBLANK) .OR.
     *                  (WORK2(NUMTIM).EQ.FBLANK) .OR.
     *                  (TCAL(ITC,BEGIF,ANT).EQ.FBLANK)) THEN
                        WORK2(NUMTIM) = FBLANK
                        WORK4(NUMTIM) = FBLANK
                     ELSE
                        WORK6(NUMTIM) = WORK4(NUMTIM)/WORK2(NUMTIM) /
     *                    2. * TCAL(ITC,BEGIF,ANT)
                        IF ((WORK6(NUMTIM).LE.DDSUM(1,3,BEGIF,ANT)) .OR.
     *                     (WORK6(NUMTIM).GE.DDSUMS(1,3,BEGIF,ANT)))
     *                     THEN
                           WORK2(NUMTIM) = FBLANK
                           WORK4(NUMTIM) = FBLANK
                           WORK6(NUMTIM) = FBLANK
                           NPRAT(1) = NPRAT(1) + 1
                           END IF
                        END IF
                     END IF
                  IF (PD2KOL.GT.0) THEN
                     WORK3(NUMTIM) = RECR(PD2KOL)
                     IF ((WORK3(NUMTIM).NE.FBLANK) .AND.
     *                  ((WORK3(NUMTIM).LE.DDSUM(2,1,BEGIF,ANT)) .OR.
     *                  (WORK3(NUMTIM).GE.DDSUMS(2,1,BEGIF,ANT)))) THEN
                        WORK3(NUMTIM) =FBLANK
                        NPDIF(1) = NPDIF(1) + 1
                        END IF
                     WORK5(NUMTIM) = RECR(PS2KOL)
                     IF ((WORK5(NUMTIM).NE.FBLANK) .AND.
     *                  ((WORK5(NUMTIM).LE.DDSUM(2,2,BEGIF,ANT)) .OR.
     *                  (WORK5(NUMTIM).GE.DDSUMS(2,2,BEGIF,ANT)))) THEN
                        WORK5(NUMTIM) = FBLANK
                        NPSUM(1) = NPSUM(1) + 1
                        END IF
                     WORK7(NUMTIM) = FBLANK
                     IF (DOPRAT) THEN
                        IF (WRKTYP(NUMTIM).EQ.1) THEN
                           ITC = 4
                        ELSE
                           ITC = 2
                           END IF
C                                       Psys 2
                        IF ((WORK3(NUMTIM).LE.0.0) .OR.
     *                     (WORK5(NUMTIM).EQ.FBLANK) .OR.
     *                     (WORK3(NUMTIM).EQ.FBLANK) .OR.
     *                     (TCAL(ITC,BEGIF,ANT).EQ.FBLANK)) THEN
                           WORK3(NUMTIM) = FBLANK
                           WORK5(NUMTIM) = FBLANK
                        ELSE
                           WORK7(NUMTIM) = WORK5(NUMTIM) / WORK3(NUMTIM)
     *                        * TCAL(ITC,BEGIF,ANT) / 2.0
                           IF ((WORK7(NUMTIM).LE.DDSUM(2,3,BEGIF,ANT))
     *                        .OR.
     *                        (WORK7(NUMTIM).GE.DDSUMS(2,3,BEGIF,ANT)))
     *                        THEN
                              WORK3(NUMTIM) = FBLANK
                              WORK5(NUMTIM) = FBLANK
                              WORK7(NUMTIM) = FBLANK
                              NPRAT(1) = NPRAT(1) + 1
                              END IF
                           END IF
                        END IF
                  ELSE
                     WORK3(NUMTIM) = FBLANK
                     WORK5(NUMTIM) = FBLANK
                     WORK7(NUMTIM) = FBLANK
                     END IF
                  WRKSRC(NUMTIM) = RECORD(SOUKOL) + 0.5
                  END IF
               END IF
 100        CONTINUE
 110     SAVE = ISYRNO - 1
         IF (NUMTIM.LE.0) GO TO 590
C                                       Pdif smooth as requested
         IF (DOPDIF) THEN
            CALL MWFBSM (STTDIF, WRKTIM, WORK2, WRKSRC, FBLANK, NUMTIM,
     *         WORK1)
            JRNO = WHICH (1, BEGIF, 1, ANT)
            IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK2, WORK1, JRNO, NB,
     *         SYHIST, NPDIF(2))
C                                       Second Poln?
            IF (PD2KOL.GT.0) THEN
               CALL MWFBSM (STTDIF, WRKTIM, WORK3, WRKSRC, FBLANK,
     *            NUMTIM, WORK2)
               JRNO = WHICH (2, BEGIF, 1, ANT)
               IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK3, WORK2, JRNO,
     *            NB, SYHIST, NPDIF(2))
               END IF
         ELSE
            CALL RCOPY (NUMTIM, WORK2, WORK1)
            CALL RCOPY (NUMTIM, WORK3, WORK2)
            END IF
C                                       Psum
         IF (DOPSUM) THEN
            CALL MWFBSM (STTSUM, WRKTIM, WORK4, WRKSRC, FBLANK, NUMTIM,
     *         WORK3)
            JRNO = WHICH (1, BEGIF, 2, ANT)
            IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK4, WORK3, JRNO, NB,
     *         SYHIST, NPSUM(2))
C                                       Second Poln?
            IF (PD2KOL.GT.0) THEN
               CALL MWFBSM (STTSUM, WRKTIM, WORK5, WRKSRC, FBLANK,
     *            NUMTIM, WORK4)
               JRNO = WHICH (2, BEGIF, 2, ANT)
               IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK5, WORK4, JRNO,
     *            NB, SYHIST, NPSUM(2))
               END IF
         ELSE
            CALL RCOPY (NUMTIM, WORK4, WORK3)
            CALL RCOPY (NUMTIM, WORK5, WORK4)
            END IF
C                                       Ratio Psum/Pdif
         IF (DOPRAT) THEN
            CALL MWFBSM (STTRAT, WRKTIM, WORK6, WRKSRC, FBLANK, NUMTIM,
     *         WORK5)
            JRNO = WHICH (1, BEGIF, 3, ANT)
            IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK6, WORK5, JRNO, nb,
     *         SYHIST, NPRAT(2))
C                                       Second Poln?
            IF (PD2KOL.GT.0) THEN
               CALL MWFBSM (STTRAT, WRKTIM, WORK7, WRKSRC, FBLANK,
     *            NUMTIM, WORK6)
               JRNO = WHICH (2, BEGIF, 3, ANT)
               IF (JRNO.GT.0) CALL SYMWFH (NUMTIM, WORK7, WORK6, JRNO,
     *            NB, SYHIST, NPRAT(2))
               END IF
         ELSE
            CALL RCOPY (NUMTIM, WORK6, WORK5)
            CALL RCOPY (NUMTIM, WORK7, WORK6)
            END IF
C                                       Clip
         DO 200 ITIME = 1,NUMTIM
            ISYRNO = WRKREC(ITIME)
            CALL TABIO ('READ', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
            IF (IRET.GT.0) GO TO 900
            IF (IRET.LT.0) THEN
               IRET = 0
               GO TO 200
               END IF
            BAD = .FALSE.
C                                       test SY again
C                                       Psum > Pdif: 1
            IF ((RECR(PS1KOL).NE.FBLANK) .AND.
     *         (RECR(PD1KOL).NE.FBLANK) .AND.
     *         (RECR(PS1KOL).LE.RECR(PD1KOL))) THEN
               RECR(PD1KOL) = FBLANK
               RECR(PS1KOL) = FBLANK
               BAD = .TRUE.
               NSYVAL = NSYVAL + 1
               END IF
C                                       blank on Psum/Pdif: 1
            IF ((DOPRAT) .AND. (RECR(PD1KOL).NE.FBLANK) .AND.
     *         (RECR(PD1KOL).NE.0.0) .AND.
     *         (RECR(PS1KOL).NE.FBLANK)) THEN
               IF (WRKTYP(ITIME).EQ.1) THEN
                  ITC = 3
               ELSE
                  ITC = 1
                  END IF
               X = RECR(PS1KOL)/RECR(PD1KOL) / 2. *
     *            TCAL(ITC,BEGIF,ANT)
               IF ((X.LE.DDSUM(1,3,BEGIF,ANT)) .OR.
     *            (X.GT.DDSUMS(1,3,BEGIF,ANT))) THEN
                  RECR(PS1KOL) = FBLANK
                  RECR(PD1KOL) = FBLANK
                  BAD = .TRUE.
               ELSE IF (WORK5(ITIME).EQ.FBLANK) THEN
                  RECR(PS1KOL) = FBLANK
                  RECR(PD1KOL) = FBLANK
                  BAD = .TRUE.
                  END IF
               END IF
C                                       IF 2 Psum > Pdif
            IF (PD2KOL.GT.0) THEN
               IF ((RECR(PD2KOL).NE.FBLANK) .AND.
     *            (RECR(PS2KOL).NE.FBLANK) .AND.
     *            (RECR(PS2KOL).LE.RECR(PD2KOL))) THEN
                  RECR(PD2KOL) = FBLANK
                  RECR(PS2KOL) = FBLANK
                  BAD = .TRUE.
                  NSYVAL = NSYVAL + 1
                  END IF
C                                       blank on Psum/Pdif: 2
               IF ((DOPRAT) .AND. (RECR(PD2KOL).NE.FBLANK) .AND.
     *            (RECR(PD2KOL).NE.0.0) .AND.
     *            (RECR(PS2KOL).NE.FBLANK)) THEN
                  IF (WRKTYP(ITIME).EQ.1) THEN
                     ITC = 4
                  ELSE
                     ITC = 2
                     END IF
                  X = RECR(PS2KOL)/RECR(PD2KOL) / 2. *
     *               TCAL(ITC,BEGIF,ANT)
                  IF ((X.LE.DDSUM(2,3,BEGIF,ANT)) .OR.
     *               (X.GT.DDSUMS(2,3,BEGIF,ANT))) THEN
                     RECR(PS2KOL) = FBLANK
                     RECR(PD2KOL) = FBLANK
                     BAD = .TRUE.
                  ELSE IF (WORK6(ITIME).EQ.FBLANK) THEN
                     RECR(PS2KOL) = FBLANK
                     RECR(PD2KOL) = FBLANK
                     BAD = .TRUE.
                     END IF
                  END IF
               END IF
C                                       Pdif or Tsys
            IF (DOPDIF) THEN
               IF (RECR(PD1KOL).NE.FBLANK) THEN
                  X = RECR(PD1KOL)
                  IF ((X.LE.DDSUM(1,1,BEGIF,ANT)) .OR.
     *               (X.GT.DDSUMS(1,1,BEGIF,ANT))) THEN
                     RECR(PD1KOL) = FBLANK
                     BAD = .TRUE.
                  ELSE IF (WORK1(ITIME).EQ.FBLANK) THEN
                     RECR(PD1KOL) = FBLANK
                     BAD = .TRUE.
                     END IF
                  END IF
               END IF
C                                       Psum or Tant
            IF (DOPSUM) THEN
               IF (RECR(PS1KOL).NE.FBLANK) THEN
                  X = RECR(PS1KOL)
                  IF ((X.LE.DDSUM(1,2,BEGIF,ANT)) .OR.
     *               (X.GT.DDSUMS(1,2,BEGIF,ANT))) THEN
                     RECR(PS1KOL) = FBLANK
                     BAD = .TRUE.
                  ELSE IF (WORK3(ITIME).EQ.FBLANK) THEN
                     RECR(PS1KOL) = FBLANK
                     BAD = .TRUE.
                     END IF
                  END IF
               END IF
C                                       Second polarization?
            IF ((DOPDIF) .AND. (PD2KOL.GT.0)) THEN
C                                       Pdif or Tsys
               IF (RECR(PD2KOL).NE.FBLANK) THEN
                  X = RECR(PD2KOL)
                  IF ((X.LE.DDSUM(2,1,BEGIF,ANT)) .OR.
     *               (X.GT.DDSUMS(2,1,BEGIF,ANT))) THEN
                     RECR(PD2KOL) = FBLANK
                     BAD = .TRUE.
                  ELSE IF (WORK2(ITIME).EQ.FBLANK) THEN
                     RECR(PD2KOL) = FBLANK
                     BAD = .TRUE.
                     END IF
                  END IF
               END IF
C                                       Psum or Tant
            IF ((DOPSUM) .AND. (PS2KOL.GT.0)) THEN
               IF (RECR(PS2KOL).NE.FBLANK) THEN
                  X = RECR(PS2KOL)
                  IF ((X.LE.DDSUM(2,2,BEGIF,ANT)) .OR.
     *               (X.GT.DDSUMS(2,2,BEGIF,ANT))) THEN
                     RECR(PS2KOL) = FBLANK
                     BAD = .TRUE.
                  ELSE IF (WORK4(ITIME).EQ.FBLANK) THEN
                     RECR(PS2KOL) = FBLANK
                     BAD = .TRUE.
                     END IF
                  END IF
               END IF
C                                       Rewrite record
            IF (BAD) THEN
               CALL TABIO ('WRIT', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
               IF (IRET.NE.0) GO TO 900
               NRECS = NRECS + 1
               END IF
 200        CONTINUE
C
 590     FSTREC = SAVE
C                                       End of antenna loop
 600     CONTINUE
      IF (NRECS.GT.0) THEN
         WRITE (MSGTXT,1605)
         IF (BEGIF.EQ.LBIF) CALL MSGWRT (4)
         WRITE (MSGTXT,1601) BEGIF, NSYVAL
         CALL MSGWRT (4)
         WRITE (MSGTXT,1600) BEGIF, NPDIF, 'Pdif'
         IF (DOPDIF) CALL MSGWRT (4)
         WRITE (MSGTXT,1600) BEGIF, NPSUM, 'Psum'
         IF (DOPSUM) CALL MSGWRT (4)
         WRITE (MSGTXT,1600) BEGIF, NPRAT, 'Tcal*Psum/Pdif/2'
         IF (DOPRAT) CALL MSGWRT (4)
         WRITE (MSGTXT,1602) BEGIF, NRECS
         CALL MSGWRT (4)
      END IF
      GO TO 999
C                                       TABIO error
 900  WRITE (MSGTXT,1900) IRET
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1600 FORMAT ('IF',I3,' clipped',2I10,3X,A)
 1601 FORMAT ('IF',I3,' blanked',I10,' improper SY values Psum<=Pdif')
 1602 FORMAT ('IF',I3,' changed',I10,' table records due to clipping')
 1605 FORMAT (14X,'clip APARM',' MWF CPARM','   flagged')
 1900 FORMAT ('CLIPTY: TABIO ERROR',I3)
      END
      SUBROUTINE SYMWFH (NUMTIM, WORKI, WORKS, JRNO, NB, SYHIST, NPCNT)
C-----------------------------------------------------------------------
C   SYMWFH does basic statistics on the difference between WORKI and
C   WORKS (smoothed data).  It then does a histogram in SYHIST(*,JRNO)
C   and sets the MW clip levels
C   Inputs
C      NUMTIM   I      Number data points in WORKI, WORKS
C      WORKI    R(*)   Data array before smoothing
C      WORKS    R(*)   Smoothed data array
C      JRNO     I      location in SYHIST for results
C      NB       I      Number of values in each histogram (8+NHIST)
C   In/Output:
C      NPCNT    I      count of flagged times
C   Output:
C      SYHIST   R(*)   Histogram plus pixrange, means, rmses, overflows
C-----------------------------------------------------------------------
      INTEGER   NUMTIM, JRNO, NB, NPCNT
      REAL      WORKI(*), WORKS(*), SYHIST(NB,*)
C
      INTEGER   M
      PARAMETER (M=1024)
C
      INCLUDE 'SYHIS.INC'
      INTEGER   I, N, MP, LDFJAC, LWA, IPVT(3), INFO, IB, LP, LD, LIF,
     *   LANT
      DOUBLE PRECISION S, SS, SN, D, DMAX, FVEC(M), FJAC(3,3), WA(2*M),
     *   TOL, RINT, PARMS(3)
      EXTERNAL  XGFUNC
      REAL      X, Y
      INCLUDE 'SYHISUE.INC'
      INCLUDE 'GDATA.INC'
      INCLUDE 'INCS:DDCH.INC'
      DATA LWA /2048/
C-----------------------------------------------------------------------
      CALL RWHICH (JRNO, LP, LIF, LD, LANT)
      S = 0.0D0
      SS = 0.0D0
      SN = 0.0D0
      DO 20 I = 1,NUMTIM
         IF ((WORKI(I).NE.FBLANK) .AND. (WORKS(I).NE.FBLANK)) THEN
            D = WORKI(I) - WORKS(I)
            S = S + D
            SS = SS + D * D
            SN = SN + 1.0D0
            END IF
 20      CONTINUE
      CALL RFILL (NB, 0.0, SYHIST(1,JRNO))
      IF (SN.GE.2.0D0) THEN
         S = S / SN
         SS = SS / SN - S * S
         SS = SQRT (MAX (0.0D0, SS))
         SYHIST(3,JRNO) = S
         SYHIST(4,JRNO) = SS
         SYHIST(1,JRNO) = S - RPARM(LD) * SS
         SYHIST(2,JRNO) = S + RPARM(LD) * SS
         DO 30 I = 1,NUMTIM
            IF ((WORKI(I).NE.FBLANK) .AND. (WORKS(I).NE.FBLANK)) THEN
               D = WORKI(I) - WORKS(I)
               IB = (D - SYHIST(1,JRNO)) * (NB-8) /
     *            (SYHIST(2,JRNO)-SYHIST(1,JRNO)) + 8.9999
               IF (IB.LT.8) IB = 7
               IF (IB.GT.NB) IB = 8
               SYHIST(IB,JRNO) = SYHIST(IB,JRNO) + 1.0
               END IF
 30         CONTINUE
         DMAX = -1.E6
         MP = 0
         DO 40 I = 9,NB
            GDATA(I-8) = SYHIST(I,JRNO)
            IF (DMAX.LT.GDATA(I-8)) THEN
               MP = I - 8
               DMAX = GDATA(I-8)
               END IF
 40         CONTINUE
         RINT = (SYHIST(2,JRNO)-SYHIST(1,JRNO)) / (NB - 8)
         PARMS(1) = DMAX
         PARMS(2) = MP
         PARMS(3) = SYHIST(4,JRNO) / RINT
         N = 3
         MP = NB - 8
         LDFJAC = 3
         TOL = 1.D-5
         NITTER = 100
         ITTER = 0
         CALL LMSTR1 (XGFUNC, MP, N, PARMS, FVEC, FJAC, LDFJAC, TOL,
     *      INFO, IPVT, WA, LWA)
         IF ((INFO.GT.0) .AND. (INFO.LE.3)) THEN
            SYHIST(5,JRNO) = (PARMS(2)-1.D0)*RINT + SYHIST(1,JRNO)
            SYHIST(6,JRNO) = PARMS(3) * RINT
            END IF
         IF (SYHIST(6,JRNO).LE.0.0) THEN
            DDAVG(LP,LD,LIF,LANT) = SYHIST(3,JRNO) -
     *         SYHIST(4,JRNO)*APARM(3+LD)
            DDRMS(LP,LD,LIF,LANT) = SYHIST(3,JRNO) +
     *         SYHIST(4,JRNO)*APARM(3+LD)
         ELSE
            X = SQRT (SYHIST(3,JRNO)*SYHIST(5,JRNO))
            Y = SQRT (SYHIST(4,JRNO)*SYHIST(6,JRNO))
            DDAVG(LP,LD,LIF,LANT) = X - Y * APARM(3+LD)
            DDRMS(LP,LD,LIF,LANT) = X + Y * APARM(3+LD)
            END IF
         IF (APARM(3+LD).LE.25.0) THEN
            DO 50 I = 1,NUMTIM
               IF ((WORKI(I).NE.FBLANK) .AND. (WORKS(I).NE.FBLANK)) THEN
                  D = WORKI(I) - WORKS(I)
                  IF ((D.GT.DDRMS(LP,LD,LIF,LANT)) .OR.
     *               (D.LT.DDAVG(LP,LD,LIF,LANT))) THEN
                     WORKS(I) = FBLANK
                     NPCNT = NPCNT + 1
                     END IF
               ELSE
                  WORKS(I) = FBLANK
                  END IF
 50            CONTINUE
            END IF
         END IF
C
 999  RETURN
      END
      SUBROUTINE RWHICH (KRNO, IP, IIF, ID, IANT)
C-----------------------------------------------------------------------
      INTEGER   KRNO, IP, IIF, ID, IANT
C
      INTEGER   LP, LIF, LANT, IR, LL, LD
      INCLUDE 'SYHIS.INC'
      INCLUDE 'SYHISUE.INC'
C-----------------------------------------------------------------------
      IR = 0
      DO 50 LANT = 1,DDNANT
         DO 40 LIF = LBIF,LEIF
            DO 30 LP = POL1,POL2
               DO 20 LD = 1,3
                  LL = DDCNT(LP,LD,LIF,LANT) + 0.1
                  IF (LL.GT.0) THEN
                     IR = IR + 1
                     IF (IR.EQ.KRNO) THEN
                        IP = LP
                        IIF = LIF
                        ID = LD
                        IANT = LANT
                        GO TO 999
                        END IF
                     END IF
 20               CONTINUE
 30            CONTINUE
 40         CONTINUE
 50      CONTINUE
C
 999  RETURN
      END
      SUBROUTINE SYHISS (IRET)
C-----------------------------------------------------------------------
C   Smooths the SY table
C   Output
C      IRET   I   Error code
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INCLUDE 'INCS:PUVD.INC'
      CHARACTER COLHED(2)*24
      INTEGER   KEY(2,2), ICLUN, NKEY, I, KOLS(2), NUMPOL, NUMIF,
     *   TIMKOL, SOUKOL, ANTKOL, SUBKOL, FRQKOL, TS1KOL, TA1KOL, TS2KOL,
     *   TA2KOL, NUMANT, KEYSUB(2,2), TYPKOL, NUMSUB
      LOGICAL   T, DOPDIF, DOPSUM
      REAL      FKEY(2,2), STPDIF(3), STPSUM(3)
      INCLUDE 'SYHIS.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DUVH.INC'
      INCLUDE 'INCS:DCAT.INC'
      DATA FKEY /1.0,0.0, 1.0,0.0/
      DATA KEYSUB /4*1/
      DATA COLHED /'TIME ', 'ANTENNA NO. '/
      DATA T /.TRUE./
      DATA ICLUN /30/
C-----------------------------------------------------------------------
C                                       Sort SY table to antenna-time.
C                                       Need col. pointers, sort order.
      CALL SYINI ('READ', BUFFO, INDISK, INCNO, SYOVER, CATBLK, ICLUN,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPEN OUTPUT SY TABLE'
         GO TO 990
         END IF
C                                       Get column pointers
      NKEY = 2
      CALL FNDCOL (NKEY, COLHED, 24, T, BUFFO, KOLS, IRET)
      IF ((IRET.GE.1) .AND. (IRET.LE.10)) THEN
         WRITE (MSGTXT,1000) IRET, 'FINDING SORT COLUMNS'
         GO TO 990
         END IF
      TIMKOL = SYKOLS(1)
      TYPKOL = SYKOLS(3)
      SOUKOL = SYKOLS(4)
      ANTKOL = SYKOLS(5)
      SUBKOL = SYKOLS(6)
      FRQKOL = SYKOLS(7)
      TS1KOL = SYKOLS(8)
      TA1KOL = SYKOLS(9)
      IF (NUMPOL.GT.1) THEN
         TS2KOL = SYKOLS(11)
         TA2KOL = SYKOLS(12)
      ELSE
         TS2KOL = -1000
         TA2KOL = -1000
         END IF
C                                       Close table
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CLOSING OUTPUT SY TABLE'
         GO TO 990
         END IF
C                                       Sort to antenna time order.
      KEY(1,1) = KOLS(2)
      KEY(1,2) = KOLS(1)
      IF (((BUFFO(43).NE.KOLS(2)) .OR. (BUFFO(44).NE.KOLS(1)))) THEN
         CALL TABSRT (INDISK, INCNO, 'SY', SYOVER, SYOVER, KEY, KEYSUB,
     *      FKEY, BUFFO, CATBLK, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'SORTING SY TABLE'
            GO TO 990
            END IF
         END IF
C                                       Reopen write
      CALL SYINI ('WRIT', BUFFO, INDISK, INCNO, SYOVER, CATBLK, ICLUN,
     *   ISYRNO, SYKOLS, SYNUMV, NUMANT, NUMPOL, NUMIF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'REOPENING OUTPUT SY TABLE WRITE'
         GO TO 990
         END IF
C                                       Find number of subarrays.
      CALL FNDEXT ('AN', CATBLK, NUMSUB)
      NUMSUB = MAX (NUMSUB, 1)
C                                       Determine smoothing parameters.
      STPDIF(1) = BPARM(1) / 1440.0
      STPSUM(1) = BPARM(2) / 1440.0
      STPDIF(2) = BPARM(6) / 1440.0
      STPSUM(2) = BPARM(7) / 1440.0
      STPDIF(3) = CUTOFF
      STPSUM(3) = CUTOFF
      DOPDIF =  STPDIF(1) .GE. 1.0E-10
      DOPSUM =  STPSUM(1) .GE. 1.0E-10
C                                       Inform user of smoothing:
      MSGTXT ='TYSMTH: Smoothing SY table'
      CALL MSGWRT (4)
C                                       Loop over IF
      DO 100 I = LBIF,LEIF
         CALL SMOSY (STPDIF, STPSUM, DOPDIF, DOPSUM, 1, NUMANT, TYPKOL,
     *      TIMKOL, SUBKOL, ANTKOL, SOUKOL, FRQKOL, TS1KOL+I-1,
     *      TA1KOL+I-1, TS2KOL+I-1, TA2KOL+I-1, IRET)
         IF (IRET.NE.0) GO TO 999
 100     CONTINUE
C                                       Close table
      CALL TABIO ('CLOS', 0, ISYRNO, BUFFO, BUFFO, IRET)
      GO TO 999
C
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('SYHISS ERROR',I4,' ON ',A)
      END
      SUBROUTINE SMOSY (STPDIF, STPSUM, DOPDIF, DOPSUM, SUB, NUMA,
     *   TYPKOL, TIMKOL, SUBKOL, ANTKOL, SOUKOL, FRQKOL, TS1KOL, TA1KOL,
     *   TS2KOL, TA2KOL, IRET)
C-----------------------------------------------------------------------
C   Routine to smooth TYs in an open table in antenna-time order.
C   Inputs:
C      STPDIF   R    Tsys smoothing time (days)
C      STPSUM   R    Tant smoothing time (days)
C      DOPDIF   L    Smooth Tsys?
C      DOPSUM   L    Smooth Tant?
C      SUB      I    Desired subarray
C      NUMA     I    Number of antennas
C      TIMKOL   I    Time column pointer.
C      SUBKOL   I    Subarray column pointer
C      ANTKOL   I    Antenna column pointer
C      FRQKOL   I    FQ id column pointer
C      SOUKOL   I    Source ID column pointer
C      TS1KOL   I    Tsys 1 column pointer
C      TA1KOL   I    Tant 1 column pointer
C      TS2KOL   I    Tsys 2 column pointer <1 => not present
C      TA2KOL   I    Tant 2 pointer <1 => not present
C   Inputs from common:
C      I/O buffer etc.
C      Other data selection criteria.
C   Output:
C      IRET     I  Error code, 0=OK else failed.
C-----------------------------------------------------------------------
      REAL      STPDIF(*), STPSUM(*)
      LOGICAL   DOPDIF, DOPSUM
      INTEGER   SUB, NUMA, TYPKOL, TIMKOL, SUBKOL, ANTKOL, SOUKOL,
     *   FRQKOL, TS1KOL, TA1KOL, TS2KOL, TA2KOL, IRET
C
      INTEGER   LOOPR, LOOPA, IRCODE, NUMTIM, ANT, NUMREC, FSTREC,
     *   NLEFT, SAVE, ITIME
      LOGICAL   SLCTD, TYWANT, WANT
      DOUBLE PRECISION TIMOFF
      REAL      RTIME
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'SYHIS.INC'
      INCLUDE 'CLDATA.INC'
      INCLUDE 'REPSYTAB.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
      INCLUDE 'INCS:DMSG.INC'
      DATA IRCODE /0/
C-----------------------------------------------------------------------
C                                       Get number of records in table
      NUMREC = BUFFO(5)
      IF (NUMREC.LE.0) GO TO 999
      IF ((.NOT.DOPDIF) .AND. (.NOT.DOPSUM)) GO TO 999
      FSTREC = 0
C                                       Loop over antenna
      DO 600 LOOPA = 1,NUMA
         ANT = LOOPA
C                                       Want this antenna?
         IF (.NOT.SLCTD (ANT, ANTENS, NANTSL, DOAWNT)) GO TO 600
C                                       Set pointers, counters
         NUMTIM = 0
         NLEFT = NUMREC - FSTREC
C                                       Loop in time, reading
         DO 100 LOOPR = 1,NLEFT
            ISYRNO = FSTREC + LOOPR
            CALL TABIO ('READ', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
            IF (IRET.LT.0) THEN
               IRET = 0
               GO TO 100
               END IF
            IF (IRET.NE.0) GO TO 900
C                                       Finished antenna?
            IF (RECORD(ANTKOL).GT.ANT) GO TO 110
            IF (RECORD(ANTKOL).LT.ANT) GO TO 100
            RTIME = RECD(TIMKOL)
            IF (RECORD(SOUKOL).NE.1) THEN
               MSGTXT = 'WE ARE HERE'
               END IF
C                                       See if wanted.
            WANT = TYWANT (RECORD(SOUKOL), RECORD(FRQKOL),
     *         RECORD(ANTKOL), RECORD(SUBKOL), RTIME)
C                                       Check subarray
            WANT = WANT .AND. (RECORD(SUBKOL).EQ.SUB)
C                                       Not all antennas wanted
            WANT = WANT .AND. (RECORD(ANTKOL).EQ.ANT)
            IF ((WANT) .AND. (NUMTIM.EQ.MXTIME)) THEN
               MSGTXT = 'NUMBER OF TIMES EXCESSIVE, OPERATION' //
     *            ' TRUNCATED'
               CALL MSGWRT (8)
               END IF
            IF ((WANT) .AND. (NUMTIM.LT.MXTIME)) THEN
               NUMTIM = NUMTIM + 1
               IF (NUMTIM.EQ.1) TIMOFF = RTIME
               WRKTIM(NUMTIM) = RTIME - TIMOFF
               WRKREC(NUMTIM) = ISYRNO
               WORK2(NUMTIM) = RECR(TS1KOL)
               WORK3(NUMTIM) = RECR(TA1KOL)
               IF (TS2KOL.GT.0) THEN
                  WORK4(NUMTIM) = RECR(TS2KOL)
                  WORK5(NUMTIM) = RECR(TA2KOL)
                  END IF
               WRKSRC(NUMTIM) = RECORD(SOUKOL) + 0.5
               IF (TYPKOL.GT.0) THEN
                  WRKTYP(NUMTIM) = RECORD(TYPKOL)
               ELSE
                  WRKTYP(NUMTIM) = 0
                  END IF
               END IF
 100        CONTINUE
 110     SAVE = ISYRNO - 1
         IF (NUMTIM.LE.0) GO TO 590
C                                       Smooth as requested
         IF (DOPDIF) CALL SYSMSM (INTPRM, STPDIF, WRKTIM, WORK2, FBLANK,
     *      NUMTIM, WRKSRC, WORK1)
         IF (DOPSUM) CALL SYSMSM (INTPRM, STPSUM, WRKTIM, WORK3, FBLANK,
     *      NUMTIM, WRKSRC, WORK2)
C                                       Second Poln?
         IF (TS2KOL.GT.0) THEN
            IF (DOPDIF) CALL SYSMSM (INTPRM, STPDIF, WRKTIM, WORK4,
     *         FBLANK, NUMTIM, WRKSRC, WORK3)
C                                       Second Poln?
            IF (DOPSUM) CALL SYSMSM (INTPRM, STPSUM, WRKTIM, WORK5,
     *         FBLANK, NUMTIM, WRKSRC, WORK4)
            END IF
C                                       Replace with smoothed values
         DO 200 ITIME = 1,NUMTIM
            ISYRNO = WRKREC(ITIME)
            CALL TABIO ('READ', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
            IF (IRET.NE.0) GO TO 900
            IF (IRET.LT.0) THEN
               IRET = 0
               GO TO 200
               END IF
C                                       Update if desired
            IF (DOPDIF) THEN
               IF (RECR(TS1KOL).EQ.FBLANK) THEN
                  IF (XDOBLK.GE.0.0) RECR(TS1KOL) = WORK1(ITIME)
               ELSE
                  IF (XDOBLK.LE.0.0) RECR(TS1KOL) = WORK1(ITIME)
                  END IF
C                                       Second polarization?
               IF (TS2KOL.GT.0) THEN
                  IF (RECR(TS2KOL).EQ.FBLANK) THEN
                     IF (XDOBLK.GE.0.0) RECR(TS2KOL) = WORK3(ITIME)
                  ELSE
                     IF (XDOBLK.LE.0.0) RECR(TS2KOL) = WORK3(ITIME)
                     END IF
                  END IF
               END IF
            IF (DOPSUM) THEN
               IF (RECR(TA1KOL).EQ.FBLANK) THEN
                  IF (XDOBLK.GE.0.0) RECR(TA1KOL) = WORK2(ITIME)
               ELSE
                  IF (XDOBLK.LE.0.0) RECR(TA1KOL) = WORK2(ITIME)
                  END IF
C                                       Second polarization?
               IF (TA2KOL.GT.0) THEN
                  IF (RECR(TA2KOL).EQ.FBLANK) THEN
                     IF (XDOBLK.GE.0.0) RECR(TA2KOL) = WORK4(ITIME)
                  ELSE
                     IF (XDOBLK.LE.0.0) RECR(TA2KOL) = WORK4(ITIME)
                     END IF
                  END IF
               END IF
C                                       Rewrite record
            CALL TABIO ('WRIT', IRCODE, ISYRNO, RECORD, BUFFO, IRET)
            IF (IRET.NE.0) GO TO 900
 200        CONTINUE
 590     FSTREC = SAVE
C                                       End of antenna loop
 600     CONTINUE
      GO TO 999
C                                       TABIO error
 900  WRITE (MSGTXT,1900) IRET
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1900 FORMAT ('SMOSY: TABIO ERROR',I3,' SMOOTHING SY TABLE')
      END
      SUBROUTINE SYSMSM (SMMETH, SMOTIM, TIME, IN, BLANK, NUMTIM, S,
     *   OUT)
C-----------------------------------------------------------------------
C   Routine to call appropriate smoothing routine.  Magic value blanking
C   is supported.
C   Inputs:
C      SMMETH   C*4    Method 'BOX','MWF', unknown = 'BOX'
C      SMOTIM   R(*)   Smoothing time (days)
C      TIME     R(*)   Times (days)
C      IN       R(*)   Input values.
C      BLANK    R      Magic blank value.
C      NUMTIM   I      Number of time/values
C      S        I(*)   Source number list
C   Output:
C      OUT      R(*)   Output array
C-----------------------------------------------------------------------
      CHARACTER SMMETH*4
      REAL      SMOTIM(*), TIME(*), IN(*), BLANK, OUT(*)
      INTEGER   NUMTIM, S(*)
C-----------------------------------------------------------------------
C                                       Any work to do?
      IF (NUMTIM.LE.0) GO TO 999
C                                       Median window filter
      IF (SMMETH.EQ.'MWF') THEN
         CALL MWFBSM (SMOTIM, TIME, IN, S, BLANK, NUMTIM, OUT)
C                                       function types
      ELSE IF (SMMETH.EQ.'GAUS') THEN
         CALL FUNBSM (SMMETH, SMOTIM(3), SMOTIM, TIME, IN, S, BLANK,
     *      NUMTIM, OUT)
      ELSE IF (SMMETH.EQ.'EXP ') THEN
         CALL FUNBSM (SMMETH, SMOTIM(3), SMOTIM, TIME, IN, S, BLANK,
     *      NUMTIM, OUT)
      ELSE IF (SMMETH.EQ.'LINE') THEN
         CALL FUNBSM (SMMETH, SMOTIM(3), SMOTIM, TIME, IN, S, BLANK,
     *      NUMTIM, OUT)
C                                       2-point
      ELSE IF (SMMETH.EQ.'2PT ') THEN
         CALL TPTBSM (SMOTIM, TIME, IN, S, BLANK, NUMTIM, .FALSE., OUT)
C                                       2-point - hanning
      ELSE IF (SMMETH.EQ.'2PTH') THEN
         CALL TPTBSM (SMOTIM, TIME, IN, S, BLANK, NUMTIM, .TRUE., OUT)
C                                       Default = Boxcar
      ELSE
         CALL BOXBSM (SMOTIM, TIME, IN, S, BLANK, NUMTIM, OUT)
         END IF
C
 999  RETURN
      END
      LOGICAL FUNCTION TYWANT (SOUR, FQID, ANT, SUB, TIME)
C-----------------------------------------------------------------------
C   Function to determine if a source, FQid, antenna, subarray and time
C   have been selected.  Returns .TRUE. if task selection criteria are
C   met else .FALSE.
C   Inputs
C      SOUR     I    Source Id
C      FQID     I    FQ id
C      ANT      I    Antenna number
C      SUB      I    Subarray number
C      TIME     R    Time
C   Inputs from common:
C      SOUWAN   I(*)  List of selected source IDs.
C      NSOUWD   I     Number of values in SOUWAN, 0=any source
C      DOSWNT   L     If .TRUE. values in SOUWAN are selected else
C                     deselected.
C      FREQID   I     Selected FQ id, .le. 0 => any
C      SUBA     I     Selected subarray, .le. 0 => any
C      ANTENS   I(*)  List of selected antennas
C      NANTSL   I     Number of values in ANTENS, 0=any antenna
C      DOAWNT   L     If .TRUE. values in ANTENS are selected else
C                     deselected.
C      TSTART   D     Start time
C      TEND     D     End time
C-----------------------------------------------------------------------
      INTEGER   SOUR, FQID, ANT, SUB
      REAL      TIME
C
      LOGICAL WANT, SLCTD
      INCLUDE 'INCS:PUVD.INC'
      INCLUDE 'SYHIS.INC'
      INCLUDE 'INCS:DSEL.INC'
C-----------------------------------------------------------------------
C                                       Want this source?
      WANT = SLCTD (SOUR, SOUWAN, NSOUWD, DOSWNT)
C                                       Want this FQ id?
      WANT = WANT .AND.
     *   ((FQID.EQ.FRQSEL) .OR. (FRQSEL.LE.0) .OR. (FQID.LE.0))
C                                       Check subarray
      WANT = WANT .AND.
     *   ((SUB.EQ.SUBARR) .OR. (SUBARR.LE.0) .OR. (SUB.LE.0))
C                                       Want this antenna?
      WANT = WANT .AND.
     *   SLCTD (ANT, ANTENS, NANTSL, DOAWNT)
C                                       Check time
      WANT = WANT .AND.
     *   ((TIME.GE.TSTART) .AND. (TIME.LE.TEND))
      TYWANT = WANT
C
 999  RETURN
      END
      SUBROUTINE SYHISH
C-----------------------------------------------------------------------
C     SYHISH adds to the history file
C-----------------------------------------------------------------------
C
      INCLUDE 'SYHIS.INC'
      INCLUDE 'INCS:DHIS.INC'
      INTEGER   LUN, IERR, DATE(3), TIME(3), I, J, JTRIM, I1, I2, J1,
     *   J2, LIMIT, LIMIT2
      CHARACTER ATIME*8, ADATE*12, HILINE*72
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DSEL.INC'
C-----------------------------------------------------------------------
C                                       Write History.
      CALL HIINIT (3)
C                                       open
      LUN = 26
      CALL HIOPEN (LUN, INDISK, INCNO, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
C                                       Task message
      CALL ZDATE (DATE)
      CALL ZTIME (TIME)
      CALL TIMDAT (TIME, DATE, ATIME, ADATE)
      WRITE (HILINE,1000) TSKNAM, RLSNAM, ADATE, ATIME
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
C                                       BP versions
      WRITE (HILINE,1010) TSKNAM, SYIVER
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1011) TSKNAM, SYOVER
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
C                                       sources
      IF (NSOUWD.LE.0) THEN
         WRITE (HILINE,1020) TSKNAM
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
      ELSE
C                                       Included or excluded?
         WRITE (HILINE,1021) TSKNAM, NSOUWD
         IF (DOSWNT) WRITE (HILINE,1022) TSKNAM, NSOUWD
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
C                                       1st 2 and label.
         I1 = 1
         IF (SOURCS(1)(1:1).EQ.'-') I1 = 2
         I2 = 1
         IF (SOURCS(2)(1:1).EQ.'-') I2 = 2
         WRITE (HILINE,1023) TSKNAM, SOURCS(1)(I1:), SOURCS(2)(I2:)
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
C                                       Rest of sources
         DO 20 I = 3,MIN(NSOUWD,30),2
            IF ((SOURCS(I).NE.' ') .OR. (SOURCS(I+1).NE.' ')) THEN
               I1 = 1
               IF (SOURCS(I)(1:1).EQ.'-') I1 = 2
               J1 = JTRIM (SOURCS(I))
               I2 = 1
               IF (SOURCS(I+1)(1:1).EQ.'-') I2 = 2
               J2 = JTRIM (SOURCS(I+1))
               WRITE (HILINE,1024) TSKNAM, SOURCS(I)(I1:J1),
     *            SOURCS(I+1)(I2:J2)
               CALL HIADD (LUN, HILINE, BUFFI, IERR)
               IF (IERR.NE.0) GO TO 190
               END IF
 20         CONTINUE
         END IF
C                                       Antennas
      IF (NANTSL.LE.0) THEN
         WRITE (HILINE,1031) TSKNAM
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
C                                       Included or excluded?
      ELSE
         WRITE (HILINE,1032) TSKNAM
         IF (DOAWNT) WRITE (HILINE,1033) TSKNAM
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
C                                       1st 12 and label.
         LIMIT = MIN (12, NANTSL)
         WRITE (HILINE,1034) TSKNAM, (ANTENS(J),J=1,LIMIT)
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
C                                       Rest of antennas
         IF (NANTSL.GT.12) THEN
            DO 50 I = 13,NANTSL,12
               LIMIT = I
               LIMIT2 = I + 11
               LIMIT2 = MIN (NANTSL, LIMIT2)
               WRITE (HILINE,1035) TSKNAM, (ANTENS(J),J=LIMIT,LIMIT2)
               CALL HIADD (LUN, HILINE, BUFFI, IERR)
               IF (IERR.NE.0) GO TO 190
 50            CONTINUE
            END IF
         END IF
C                                       data selection
      WRITE (HILINE,1040) TSKNAM, STOKES
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1041) TSKNAM, FRQSEL
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1042) TSKNAM, SUBARR
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1043) TSKNAM, BIF
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1044) TSKNAM, EIF
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      IF (LFGVER.GT.0) THEN
         WRITE (HILINE,1045) TSKNAM, LFGVER
      ELSE
         WRITE (HILINE,1046) TSKNAM, LFGVER
         END IF
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
C                                       TIMERANG
      CALL HITIME (TSTART, TEND, LUN, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
C                                       clipping and MW
      WRITE (HILINE,1050) TSKNAM, (APARM(I), I = 1,3)
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1051) TSKNAM, (APARM(I), I = 4,6)
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190
      WRITE (HILINE,1052) TSKNAM, (APARM(I), I = 7,9)
      CALL HIADD (LUN, HILINE, BUFFI, IERR)
      IF (IERR.NE.0) GO TO 190

      IF ((BPARM(1).LE.0.0) .AND. (BPARM(2).LE.0.0)) THEN
         WRITE (HILINE,1060) TSKNAM
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
      ELSE
         WRITE (HILINE,1061) TSKNAM, INTPRM
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
         WRITE (HILINE,1062) TSKNAM, BPARM(1), BPARM(2)
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
         WRITE (HILINE,1063) TSKNAM, BPARM(6), BPARM(7)
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
         WRITE (HILINE,1064) TSKNAM, CUTOFF
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
         IF (XDOBLK.GT.0.0) THEN
            WRITE (HILINE,1065) TSKNAM, XDOBLK
         ELSE IF (XDOBLK.EQ.0.0) THEN
            WRITE (HILINE,1066) TSKNAM, XDOBLK
         ELSE
            WRITE (HILINE,1067) TSKNAM, XDOBLK
            END IF
         CALL HIADD (LUN, HILINE, BUFFI, IERR)
         IF (IERR.NE.0) GO TO 190
         END IF
      CALL HICLOS (LUN, .TRUE., BUFFI, IERR)
      GO TO 999
C
 190  WRITE (MSGTXT,1190) IERR
      CALL MSGWRT(7)
      CALL HICLOS (LUN, .TRUE., BUFFI, IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT (A6,'Release =''',A7,' ''  /********* Start ',
     *   A12,2X,A8)
 1010 FORMAT (A6,'INVERS = ',I5,'   /input SY file version no.')
 1011 FORMAT (A6,'OUTVERS =',I5,'   /output SY file version no.')
 1020 FORMAT (A6,'SOURCES = '' ''   / All sources selected')
 1021 FORMAT (A6,'N_SOURCES=',I5,' / Following Sources excluded:')
 1022 FORMAT (A6,'N_SOURCES=',I5,' / Following Sources included:')
 1023 FORMAT (A6,'SOURCES  = ''',A,''',''',A,'''')
 1024 FORMAT (A6,'          ,''',A,''',''',A,'''')
 1031 FORMAT (A6,'ANTENNAS = 0     / All antennas selected')
 1032 FORMAT (A6,' / Antennas excluded:')
 1033 FORMAT (A6,' / Antennas included:')
 1034 FORMAT (A6,'ANTENNAS = ',12(I3,' '))
 1035 FORMAT (A6,'           ',12(I3,' '))
 1040 FORMAT (A6,'STOKES  = ''',A,'''   / Selected polarization')
 1041 FORMAT (A6,'FREQID  = ',I5,'   / Selected frequency ID')
 1042 FORMAT (A6,'SUBARRAY= ',I5,'   / Selected subarray')
 1043 FORMAT (A6,'BIF     = ',I5,'   / First spectral window')
 1044 FORMAT (A6,'EIF     = ',I5,'   / Last spectral window')
 1045 FORMAT (A6,'FLAGVER = ',I5,'   / Flag table applied')
 1046 FORMAT (A6,'FLAGVER = ',I5,'   / No flag table applied')
 1050 FORMAT (A6,'APARM(1-3)=',3F6.1,'   / Clip factors')
 1051 FORMAT (A6,'APARM(4-6)=',3F6.1,'   / MW Clip factors')
 1052 FORMAT (A6,'APARM(7-9)=',3F6.1,'   / MW smooth times')
 1060 FORMAT (A6,'/   No final smoothing applied, ',
     *   'clipped points blanked')
 1061 FORMAT (A6,'SAMPTYPE = ''',A4,''' / Final smoothing function')
 1062 FORMAT (A6,'BPARM(1-2) =',2F8.3,' / smooth support')
 1063 FORMAT (A6,'BPARM(6-7) =',2F8.3,' / smooth FWHM')
 1064 FORMAT (A6,'CUTOFF = ',F10.6,' / smooth weight cutoff')
 1065 FORMAT (A6,'DOBLANK =',F4.1,'   / blanked/clipped values',
     *   'replaced with smoothed')
 1066 FORMAT (A6,'DOBLANK =',F4.1,'   / all values replaced',
     *   ' with smoothed')
 1067 FORMAT (A6,'DOBLANK =',F4.1,'   / blanked/clipped values',
     *   'left, good replaced with smoothed')
 1190 FORMAT ('SYHISH: ERROR',I4,' WRITING HISTORY FILE')
      END
