LOCAL INCLUDE 'PRPLT.INC'
      INCLUDE 'INCS:PMAD.INC'
      INCLUDE 'INCS:PTVC.INC'
      CHARACTER NAMIN*12, CLSIN*6, IGFILE*48
      HOLLERITH XNAMIN(3), XCLSIN(2)
      REAL      SEQIN, DSKIN, BLC(7), TRC(7), XPROF, RANGE(2), XYRATO,
     *   TLABEL, XDOTV, XGRCH
      LOGICAL   DOTV, IDOPRF(3)
      REAL      XXPROF(32768,3), IBUFF(MABFSS), XXMIN(3), XXMAX(3),
     *   CATOR(256), CATSR(256,3)
      DOUBLE PRECISION CATSD(128,3), CATOD(128), XPOS(4), YPOS(4),
     *   ZPOS(4)
      INTEGER   IMLUN, IMFIND, IGLUN, IGFIND, IVOL, CNO, ILABEL, INPRMS,
     *   GRCHN, ISEQ, NNPROF(32768,3), SCRTCH(256), JBUFSZ, IVER,
     *   CATOLD(256), CATSI(256,3)
      EQUIVALENCE (CATSI, CATSR, CATSD)
      EQUIVALENCE (CATOLD, CATOR, CATOD)
      COMMON /INPARM/ XNAMIN, XCLSIN, SEQIN, DSKIN, BLC, TRC, XPROF,
     *   RANGE, XYRATO, TLABEL, XDOTV, XGRCH
      COMMON /CHARPM/ NAMIN, CLSIN, IGFILE
      COMMON /PRPLTD/ CATOLD, CATSD, XPOS, YPOS, ZPOS, IMLUN, IMFIND,
     *   IGLUN, IGFIND, IVOL, CNO, ILABEL, INPRMS, GRCHN, ISEQ, XXPROF,
     *   NNPROF, IBUFF, SCRTCH, JBUFSZ, DOTV, IDOPRF, XXMIN, XXMAX, IVER
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
LOCAL END
      PROGRAM PRPLT
C-----------------------------------------------------------------------
C! Plots profiles summing on other axes
C# Graphics Map-util Plot-appl EXT-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PRPLT will write commands to a plot file for the execution
C   of up to 3 profile plots summin over the other 2 axes.
C   INPUTS:   (from AIPS)
C      INNAME   R(3)   name of grey scale image.
C      INCLASS  R(2)   class of grey scale image.
C      INSEQ    R      sequence number of grey scale image.
C      INDISK   R      disk volume number. 0 means try all.
C      BLC      R(7)   the coordinate in the input file to become the
C                      left hand coordinate (1,1) of the contour plot.
C                      BLC(1) is the X coordinate and BLC(2) is the Y
C                      coordinate.  The first coordinate in the input
C                      image is (1,1).
C      TRC      R(7)   the coordinate in the input file to become the
C                      top right hand corner of the plot.
C      DOPROFIL R      Selects which profiles will be plotted
C      PIXRANGE R(2)   the maximum and minimum values allowed for the
C                      map.  All other values will be clipped.  If
C                      IRANGE(1) .GE. IRANGE(2) then the map max and
C                      min will be used.
C      XYRATIO  R      the ratio between the scale factor to use for the
C                      X axis and the scale factor to use for the Y axis
C      LTYPE    R      the type of axis labeling to use for this plot
C                          1 = none
C                          2 = leave out ticks and tick labels
C                          3 = RA - DEC coordinates & labels
C                          4 = Center relative
C                          5 = Subimage center-relative
C                          6 = pixel count
C      DOTV     R      > 0 => TV, else plot file
C      GRCHAN   R      graphics channel to use
C-----------------------------------------------------------------------
      INTEGER   IRET, PLBUF(256), IERR
      INCLUDE 'PRPLT.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DLOC.INC'
C-----------------------------------------------------------------------
      JBUFSZ = 2 * (MABFSS + 2048)
      JBUFSZ = 2 * MABFSS
      INPRMS = 28
      CALL PRPLTI (IRET)
      IF (IRET.NE.0) GO TO 999
C                                       Open files, set parms
      CALL PRPLTR (IRET)
      IF (IRET.NE.0) GO TO 995
      CALL PRPLTP (PLBUF, IRET)
      IF (IRET.NE.0) GO TO 950
C                                       Finish up plot file
      CALL GFINIS (PLBUF, IRET)
C                                       Write sucessful finish message.
      IF (IRET.EQ.0) THEN
         IF (.NOT.DOTV) CALL HIPLOT (IVOL, CNO, IVER, SCRTCH, IERR)
         IRET = 0
         WRITE (MSGTXT,1080) IVER
         CALL MSGWRT (2)
         GO TO 995
         END IF
C-----------------------------------------------------------------------
C                                       Graph writing error.
 950  WRITE (MSGTXT,1950)
      CALL MSGWRT (8)
C                                       Try to do finish.
      CALL GFINIS (PLBUF, IERR)
      IF (IERR.EQ.0) THEN
         IF (.NOT.DOTV) CALL HIPLOT (IVOL, CNO, IVER, SCRTCH, IERR)
         IRET = 0
         GO TO 995
         END IF
C                                       Finish not sucessful. Destroy.
      IF (.NOT.DOTV) THEN
         CALL ZCLOSE (IGLUN, IGFIND, IERR)
         CALL ZDESTR (IVOL, IGFILE, IERR)
         IF (IVER.GT.0) CALL DELEXT ('PL', IVOL, CNO, 'READ', CATBLK,
     *      SCRTCH, IVER, IERR)
         END IF
C                                       Close map file.
 995  CALL DIE (IRET, SCRTCH)
C
 999  STOP
C-----------------------------------------------------------------------
 1080 FORMAT ('Successful plot file version',I5,'  created.')
 1950 FORMAT ('Error during graphing will try to finish partial graph')
      END
      SUBROUTINE PRPLTI (IRET)
C-----------------------------------------------------------------------
C   Routine to get parameters for PRPLT
C   Outputs
C      IRET    I        Return code 0=> OK, else just go to STOP
C   Task parameters are returned in common /INPARM/
C-----------------------------------------------------------------------
      INTEGER   IRET
C
      INTEGER   IERR, IROUND
      CHARACTER PRGNAM*6
      INCLUDE 'PRPLT.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DFIL.INC'
      DATA PRGNAM /'PRPLT '/
C-----------------------------------------------------------------------
      CALL ZDCHIN (.TRUE.)
      CALL VHDRIN
      JBUFSZ = MABFSS * 2
      NCFILE = 0
      NSCR = 0
C                                       Get input values from AIPS.
      CALL GTPARM (PRGNAM, INPRMS, RQUICK, XNAMIN, SCRTCH, IRET)
      IF (IRET.NE.0) RQUICK = .TRUE.
      IF (IRET.EQ.1) GO TO 999
      IF (RQUICK) CALL RELPOP (IRET, SCRTCH, IERR)
      IF (IRET.NE.0) GO TO 999
C                                       AIPS Holleriths ->
C                                       characters
      CALL H2CHR (12, 1, XNAMIN, NAMIN)
      CALL H2CHR (6, 1, XCLSIN, CLSIN)
      ISEQ = IROUND (SEQIN)
      IVOL = IROUND (DSKIN)
C
 999  RETURN
      END
      SUBROUTINE PRPLTR (IRET)
C-----------------------------------------------------------------------
C   PRPLTR performs the initialization of parameters and computes the
C   profiles.
C   Output:
C      IRET     I        0 => proceed, 1 => quit
C-----------------------------------------------------------------------
      INTEGER    IRET
C
      CHARACTER TYPE*2, OPCODE*4
      REAL      V, RT(2), DBG1(256), DBG2(256), DBG3(256)
      DOUBLE PRECISION D
      INTEGER   IROUND, IUSER, I, LTYPE, TVCORN(2), IDEPTH(5), NX, NY,
     (   NZ, IX, IY, IZ, RO, IWIN(4), IBIND, J, K
      LOGICAL   T
      INCLUDE 'PRPLT.INC'
      INCLUDE 'INCS:DGPH.INC'
      INCLUDE 'INCS:DFIL.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DTVC.INC'
      EQUIVALENCE (DBG1,XXPROF(1,1))
      EQUIVALENCE (DBG2,XXPROF(1,2))
      EQUIVALENCE (DBG3,XXPROF(1,3))
      DATA T /.TRUE./
      DATA TVCORN /2*0/
C-----------------------------------------------------------------------
      I = 3 * 32768
      CALL RFILL (I, 0.0, XXPROF)
      CALL FILL (I, 0, NNPROF)
      IMLUN = 16
      IGLUN = 26
      ILABEL = IROUND (TLABEL)
      IF (ILABEL.EQ.6) ILABEL = 106
      IF (ILABEL.EQ.10) ILABEL = 110
      LTYPE = MOD (ABS(ILABEL), 100)
      IF (LTYPE.LE.0) LTYPE = 3
      LTYPE = MOD (LTYPE-1,10) + 1
      IF (ILABEL.GT.0) THEN
         ILABEL = (ILABEL/100)*100 + LTYPE
      ELSE
         ILABEL = (ILABEL/100)*100 - LTYPE
         END IF
      TLABEL = ILABEL
      IUSER = NLUSER
      DOTV = XDOTV.GT.0.0
      GRCHN = XGRCH + 0.01
C                                       Open grey scale map file
      TYPE = 'MA'
      OPCODE = 'HDWR'
      IF (DOTV) OPCODE = 'READ'
      IVER = 0
      CALL MAPOPN (OPCODE, IVOL, NAMIN, CLSIN, ISEQ, TYPE, IUSER,
     *   IMLUN, IMFIND, CNO, CATBLK, SCRTCH, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'OPENING INPUT IMAGE'
         GO TO 990
         END IF
      NCFILE = NCFILE + 1
      FVOL(NCFILE) = IVOL
      FCNO(NCFILE) = CNO
      FRW(NCFILE) = 0
      CALL COPY (256, CATBLK, CATOLD)
C                                       window
      CALL WINDOW (CATOLD(KIDIM), CATOLD(KINAX), BLC, TRC, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'SETTING WINDOW INTO IMAGE'
         GO TO 990
         END IF
C                                       return adverbs
      SEQIN = ISEQ
      DSKIN = IVOL
      CALL CHR2H (12, NAMIN, 1, XNAMIN)
      CALL CHR2H (6, CLSIN, 1, XCLSIN)
      I = IROUND (XPROF)
      IDOPRF(1) = (MOD(I,2).EQ.1)
      I = I/2
      IDOPRF(2) = (MOD(I,2).EQ.1)
      I = I/2
      IDOPRF(3) = (MOD(I,2).EQ.1)
C                                       Build file name.
      CALL ZPHFIL ('PL', IVOL, CNO, IVER, IGFILE, IRET)
C                                       Default XYRATO: ratio of
C                                       incr if related.
      DO 60 I = 1,5
         IDEPTH(I) = IROUND (BLC(I+2))
 60      CONTINUE
      NX = TRC(1) - BLC(1) + 1.1
      NY = TRC(2) - BLC(2) + 1.1
      NZ = TRC(3) - BLC(3) + 1.1
      IWIN(1) = BLC(1) + 0.1
      IWIN(3) = TRC(1) + 0.1
      IWIN(2) = BLC(2) + 0.1
      IWIN(4) = TRC(2) + 0.1
      IF (NX.EQ.1) IDOPRF(1) = .FALSE.
      IF (NY.EQ.1) IDOPRF(2) = .FALSE.
      IF (NZ.EQ.1) IDOPRF(3) = .FALSE.
      DO 100 IZ = 1,NZ
         IDEPTH(1) = IZ + BLC(3) - 1
         CALL COMOFF (CATOLD(KIDIM), CATOLD(KINAX), IDEPTH, RO, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'FINDING I/O OFFSET'
            GO TO 990
            END IF
         RO = RO + 1
         CALL MINIT ('READ', IMLUN, IMFIND, CATOLD(KINAX),
     *      CATOLD(KINAX+1), IWIN, IBUFF, JBUFSZ, RO, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT I/O READ'
            GO TO 990
            END IF
         DO 90 IY = 1,NY
            CALL MDISK ('READ', IMLUN, IMFIND, IBUFF, IBIND, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ IMAGE FILE'
               GO TO 990
               END IF
            IF (IBIND.GT.MABFSS) THEN
               MSGTXT = 'BAD I/O'
               CALL MSGWRT (9)
               END IF
            DO 80 IX = 1,NX
               V = IBUFF(IBIND+IX-1)
               IF (V.NE.FBLANK) THEN
                  XXPROF(IX,1) = XXPROF(IX,1) + V
                  XXPROF(IY,2) = XXPROF(IY,2) + V
                  XXPROF(IZ,3) = XXPROF(IZ,3) + V
                  NNPROF(IX,1) = NNPROF(IX,1) + 1
                  NNPROF(IY,2) = NNPROF(IY,2) + 1
                  NNPROF(IZ,3) = NNPROF(IZ,3) + 1
               END IF
 80         CONTINUE
 90      CONTINUE
 100  CONTINUE
      CALL ZCLOSE (IMLUN, IMFIND, IRET)
      IRET = 12
      CALL RFILL (3, 1.E10, XXMIN)
      CALL RFILL (3, -1.E10, XXMAX)
      DO 110 IX = 1,NX
         IF (NNPROF(IX,1).GT.0) IRET = 0
         XXPROF(IX,1) = XXPROF(IX,1) / MAX (1,NNPROF(IX,1))
         XXMAX(1) = MAX (XXMAX(1), XXPROF(IX,1))
         XXMIN(1) = MIN (XXMIN(1), XXPROF(IX,1))
 110     CONTINUE
      DO 120 IY = 1,NY
         IF (NNPROF(IY,2).GT.0) IRET = 0
         XXPROF(IY,2) = XXPROF(IY,2) / MAX (1,NNPROF(IY,2))
         XXMAX(2) = MAX (XXMAX(2), XXPROF(IY,2))
         XXMIN(2) = MIN (XXMIN(2), XXPROF(IY,2))
 120     CONTINUE
      DO 130 IZ = 1,NZ
         IF (NNPROF(IZ,3).GT.0) IRET = 0
         XXPROF(IZ,3) = XXPROF(IZ,3) / MAX (1,NNPROF(IZ,3))
         XXMAX(3) = MAX (XXMAX(3), XXPROF(IZ,3))
         XXMIN(3) = MIN (XXMIN(3), XXPROF(IZ,3))
 130     CONTINUE
      IF (IRET.NE.0) THEN
         MSGTXT = 'NO VALID DATA FOUND'
         GO TO 990
      END IF
C                                       set up headers for all 3
      CALL COPY (256, CATOLD, CATBLK)
      CATBLK(KINAX) = NX
      CATBLK(KINAX+1) = NY
      CATBLK(KINAX+2) = NZ
      CATR(KRCRP) = CATR(KRCRP) - BLC(1) + 1.0
      CATR(KRCRP+1) = CATR(KRCRP+1) - BLC(2) + 1.0
      CATR(KRCRP+2) = CATR(KRCRP+2) - BLC(3) + 1.0
      CALL COPY (256, CATBLK, CATSI(1,1))
      CALL COPY (256, CATBLK, CATSI(1,2))
      CALL COPY (256, CATBLK, CATSI(1,3))
C                                       swap axis info
      DO 150 K = 2,3
         IF (IDOPRF(K)) THEN
            J = K - 1
            I = CATBLK(KINAX+J)
            CATSI(KINAX+J,K) = CATBLK(KINAX)
            CATSI(KINAX,K) = I
            V = CATR(KRCRP+J)
            CATSR(KRCRP+J,K) = CATR(KRCRP)
            CATSR(KRCRP,K) = V
            V = CATR(KRCIC+J)
            CATSR(KRCIC+J,K) = CATR(KRCIC)
            CATSR(KRCIC,K) = V
            D = CATD(KDCRV+J)
            CATSD(KDCRV+J,K) = CATD(KDCRV)
            CATSD(KDCRV,K) = D
            CALL RCOPY (2, CATR(KHCTP+2*J), RT)
            CALL RCOPY (2, CATR(KHCTP), CATSR(KHCTP+2*J,K))
            CALL RCOPY (2, RT, CATSR(KHCTP,K))
            END IF
 150     CONTINUE
      GO TO 999
C
 990  CALL MSGWRT (8)
      IF (IVER.GT.0) CALL DELEXT ('PL', IVOL, CNO, 'READ', CATOLD,
     *   SCRTCH, IVER, I)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRPLTR ERROR',I4,' ON ',A)
      END
      SUBROUTINE PRPLTP (PLBUF, IRET)
C-----------------------------------------------------------------------
C   does the plots
C   In/out
C      PLBUF   I(256)   Plot buffer
C   Output
C      IRET    I        error code
C-----------------------------------------------------------------------
      INTEGER   PLBUF(*), IRET
C
      INCLUDE 'PRPLT.INC'
      INTEGER   IP, NP, JP, TVCHN, TVCORN(2), IDEPTH(5), IGSIZE, IGTYPE,
     *   INP, LTYPE, I, NTEXT, ID(3), IT(3), INCHAR
      REAL      VS, PLTYIN, PLTYOF, XBLC(2), XTRC(2), XMIN, XMAX, XT,
     *   FBLC(2), FTRC(2), CHOUT(4), X, Y, YS, YMULT, CH(4), YGAP, DX,
     *   DY
      CHARACTER PHNAME*48, YPREF*5, SPTEXT(2)*80, ATIME*8, ADATE*12,
     *   INTEXT(3)*8
      LOGICAL   OKAY, DOPIX
      DOUBLE PRECISION DLAT
      INCLUDE 'INCS:DLOC.INC'
      DATA TVCHN, TVCORN, IDEPTH /3*0, 5*1/
      DATA FBLC, FTRC /2*0.0, 2*1000.0/
      DATA INTEXT / 'X  <YZ>','Y  <XZ>','Z  <XY>'/
C-----------------------------------------------------------------------
      NP = 0
      XMIN = 1.E10
      XMAX = -XMIN
      DO 10 IP = 1,3
         IF (IDOPRF(IP)) THEN
            NP = NP + 1
            IF (RANGE(1).LT.RANGE(2)) THEN
               XXMIN(IP) = RANGE(1)
               XXMAX(IP) = RANGE(2)
               END IF
            XMIN = MIN (XMIN, XXMIN(IP))
            XMAX = MAX (XMAX, XXMAX(IP))
            END IF
 10      CONTINUE
      XT = (XMAX - XMIN) * 0.035
      XMAX = XMAX + XT
      XMIN = XMIN - XT
      XT = MAX (ABS(XMAX), ABS(XMIN))
      YS = XT
      CALL METSCA (YS, YPREF, OKAY)
      YMULT = YS / XT
      VS = 1000.0 / NP
      PLTYIN = 1000.0 / (NP - 0.1)
      PLTYOF = NP * PLTYIN - 1000.0
C                                       Add extension file to header.
      IF (.NOT.DOTV) THEN
         CALL MADDEX ('PL', IVOL, CNO, CATOLD, SCRTCH, .TRUE., 'READ',
     *      IVER, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'ADDING PLOT FILE TO HEADER'
            GO TO 990
            END IF
         END IF
C                                       Make physical filename
      CALL ZPHFIL ('PL', IVOL, CNO, IVER, PHNAME, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'MAKING PLOT FILE NAME'
         GO TO 990
         END IF
C                                       Open plot file
      IGSIZE = 0
      IGTYPE = 82
      TVCHN = 0
      CALL GINIT (IVOL, CNO, PHNAME, IGSIZE, IGTYPE, INPRMS, XNAMIN,
     *   DOTV, TVCHN, GRCHN, TVCORN, CATBLK, PLBUF, IGLUN, IGFIND,
     *   IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'CREATING PLOT FILE'
         GO TO 990
         END IF
      XBLC(1) = 0.0
      XTRC(1) = 1000.0
C                                       tick data
      CALL COPY (256, CATSI(1,1), CATBLK)
      LOCNUM = 1
      CALL SETLOC (IDEPTH, .FALSE.)
      ROT(LOCNUM) = 0.0
      CORTYP(LOCNUM) = 0
      LABTYP(LOCNUM) = 0
      AXTYP(LOCNUM) = 0
      AXFUNC(1,LOCNUM) = 0
      AXFUNC(2,LOCNUM) = 0
      CPREF(1,LOCNUM) = ' '
      CPREF(2,LOCNUM) = YPREF
      CALL RFILL (4, 0.5, CHOUT)
      LTYPE = MOD (ABS (ILABEL), 100)
      DOPIX = (LTYPE.EQ.6) .OR. (LTYPE.EQ.10)
      IF (LTYPE.EQ.2) CHOUT(1) = 2.5
      IF (LTYPE.GT.2) THEN
         CALL CHNTIC (FBLC, FTRC, INP)
         CHOUT(1) = INP + 4.5
         END IF
      IF (LTYPE.GT.1) CHOUT(2) = 2.0
      IF (LTYPE.GT.2) CHOUT(2) = CHOUT(2) + 1.333
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CHOUT(4) = 2.5
         IF (ILABEL.GT.0) CHOUT(4) = 3.833
         END IF
C                                        Init. for line drawing
      CALL GINITL (FBLC, FTRC, XYRATO, CHOUT, IDEPTH, PLBUF, IRET)
      IF (IRET.NE.0) THEN
         WRITE (MSGTXT,1000) IRET, 'INIOT PLOT FOR LINE DRAWING'
         GO TO 990
      END IF
      XBLC(2) = 0.0 + (NP-1) * PLTYIN
      XTRC(2) = XBLC(2) + PLTYIN -1.0 - PLTYOF
      DY = CHOUT(4) - 1.5
      DX = 0.0
      IF ((ILABEL.GT.0) .AND. (LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CALL GPOS (XBLC(1), XTRC(2), PLBUF, IRET)
         IF (IRET.NE.0) GO TO 980
         CALL ZDATE (ID)
         CALL ZTIME (IT)
         CALL TIMDAT (IT, ID, ATIME, ADATE)
         WRITE (SPTEXT(1),1050) IVER, ADATE, ATIME
         CALL REFRMT (SPTEXT(1), '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, SPTEXT(1), PLBUF, IRET)
         IF (IRET.NE.0) GO TO 980
         DY = DY - 1.333
         END IF
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) THEN
         CALL GPOS (XBLC(1), XTRC(2), PLBUF, IRET)
         IF (IRET.NE.0) GO TO 980
         CALL H2CHR (8, 1, CATH(KHOBJ), SPTEXT(1))
         CALL CHTRIM (SPTEXT(1), 80, SPTEXT(1), INCHAR)
         INCHAR = INCHAR + 1
         IF (INCHAR.GT.1) THEN
            SPTEXT(INCHAR:) = '___'
            INCHAR = INCHAR + 3
            END IF
         CALL H2CHR (18, 1, CATH(KHIMN), SPTEXT(2))
         CALL NAMEST (SPTEXT(2), CATBLK(KIIMS), SPTEXT(1)(INCHAR:),
     *      INCHAR)
         CALL REFRMT (SPTEXT(1), '_', INCHAR)
         CALL GCHAR (INCHAR, 0, DX, DY, SPTEXT(1), PLBUF, IRET)
         IF (IRET.NE.0) GO TO 980
         END IF
      JP = 0
      DO 100 IP = 1,3
         IF (IDOPRF(IP)) THEN
            JP = JP + 1
            XBLC(2) = 0.0 + (JP-1) * PLTYIN
            XTRC(2) = XBLC(2) + PLTYIN -1.0 - PLTYOF
            XT = (XXMAX(IP) - XXMIN(IP)) * 0.035
            XXMAX(IP) = XXMAX(IP) + XT
            XXMIN(IP) = XXMIN(IP) - XT
            CALL COPY (256, CATSI(1,IP), CATBLK)
            LOCNUM = 1
            CALL LABINI (XBLC, XTRC, IDEPTH, CH, ILABEL, .FALSE., YGAP,
     *         SPTEXT, NTEXT)
            AXINC(1,LOCNUM) = AXINC(1,LOCNUM) * (CATBLK(KINAX)-1) /
     *         (XTRC(1)-XBLC(1))
            RPLOC(1,LOCNUM) = RPLOC(1,LOCNUM) * (XTRC(1)-XBLC(1)) /
     *         (CATBLK(KINAX)-1.)
            LABTYP(LOCNUM) = MOD (LABTYP(LOCNUM), 10)
            IF ((KLOCL(LOCNUM).EQ.0) .AND. (KLOCM(LOCNUM).GT.0) .AND.
     *         (.NOT.DOPIX)) THEN
               DLAT = CATD(KDCRV+KLOCM(LOCNUM))
               DLAT = COS (DLAT)
               AXINC(1,LOCNUM) = AXINC(1,LOCNUM) / DLAT
               END IF
            IF (DOPIX) CPREF(1,LOCNUM) = 'Pixl'
            AXFUNC(2,LOCNUM) = 0
            CORTYP(LOCNUM) = 0
            CALL H2CHR (8, 1, CATH(KHCTP), CTYP(1,LOCNUM))
            RPVAL(2,LOCNUM) = XXMIN(IP) * YMULT
            RPLOC(2,LOCNUM) = XBLC(2)
            AXINC(2,LOCNUM) = (XXMAX(IP)-XXMIN(IP)) / (XTRC(2)-XBLC(2))
     *         * YMULT
            CPREF(2,LOCNUM) = YPREF
            CALL H2CHR (8, 1, CATH(KHBUN), CTYP(2,LOCNUM))
C                                       Draw borders.
            CALL GLTYPE (1, PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL GPOS (XBLC(1), XBLC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL GVEC (XTRC(1), XBLC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL GVEC (XTRC(1), XTRC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL GVEC (XBLC(1), XTRC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL GVEC (XBLC(1), XBLC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            CALL CLAB1 (xBLC, xTRC, CHOUT, ILABEL, XYRATO, .FALSE.,
     *         PLBUF, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'LABELING PLOT'
               GO TO 990
               END IF
            CALL GPOS (XTRC(1), XTRC(2), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            DX = -11
            DY = -4
            CALL GCHAR (7, 0, DX, DY, INTEXT(IP), PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            XT = 998.0 / CATBLK(KINAX)
            YS = (XTRC(2)-XBLC(2)) / (XXMAX(IP)-XXMIN(IP))
            X = 0.0
            CALL GLTYPE (2, PLBUF, IRET)
            IF (IRET.NE.0) GO TO 980
            DO 20 I = 1,CATBLK(KINAX)
               X = X + XT
               XXPROF(I,IP) = MIN (XXMAX(IP), MAX (XXMIN(IP),
     *            XXPROF(I,IP)))
               Y = (XXPROF(I,IP) - XXMIN(IP)) * YS + XBLC(2)
               IF (I.EQ.1) THEN
                  CALL GPOS (X, Y, PLBUF, IRET)
               ELSE
                  CALL GVEC (X, Y, PLBUF, IRET)
                  END IF
               IF (IRET.NE.0) GO TO 980
 20            CONTINUE
            END IF
 100     CONTINUE
      GO TO 999
C
 980  WRITE (MSGTXT,1000) IRET, 'DRAWING PLOT'
 990  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PRPLTP ERROR',I4,' ON ',A)
 1050 FORMAT ('Plot file version',I4,'__created ',A12,A8)
      END
