      SUBROUTINE COLOR2 (NLEVS, ICOLR, NBRK, GAMMA, APARM, BUFFER, IERR)
C-----------------------------------------------------------------------
C! 2-colors: wedge from high to 0, 2nd wedge from there to high
C# TV-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2020-2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   COLORL creates a continuous coloring from blue thru green to red.
C   Inputs:
C      NLEVS   I      # of intensities (usually 256 or 1024)
C      ICOLR   I      initial color R,G,B = 1,2,3
C                     < 0 => go RBG order instead
C      NBRK    I      break point between low color and high
C      GAMMA   R      gamma correction power
C      APARM   R(10)  Fiddle parameters: (1) fractional overlap of 2
C                       (2,3) peak, fractional overlap middle color
C   Output:
C      BUFFER  R(*)   scratch buffer
C      IERR    I      error code of ZM70XF: 0 - ok
C-----------------------------------------------------------------------
      INTEGER   NLEVS, ICOLR, NBRK, IERR
      REAL      GAMMA, APARM(10), BUFFER(*)
C
      INTEGER   NMX, NBR, KOLOR, NEND(2), ICI, INC, JERR
      REAL      GAMINV, SLOPE(2), OFFSET(2), FO, FP, TF
      LOGICAL   WASYNC
      INCLUDE 'INCS:DTVC.INC'
C-----------------------------------------------------------------------
      GAMINV = GAMMA
      IF (GAMINV.LE.0.0) GAMINV = 1.0
      GAMINV = 1.0 / GAMINV
      IF (NLEVS.GT.OFMINP+1) NLEVS = OFMINP + 1
      NMX = MAX (3, NLEVS)
      NBR = MAX (2, MIN (NMX-1, NBRK))
      TF = REAL (NBR) / REAL(NLEVS)
      NEND(1) = NMX
      NEND(2) = NMX
      ICI = ABS (ICOLR)
      INC = -1
      IF (ICOLR.LT.0) INC = 1
      IF ((ICI.LT.1) .OR. (ICI.GT.3)) ICI = 3
      WASYNC = ISYNCH.EQ.0
      IF (WASYNC) CALL YHOLD ('ONNN', JERR)
C                                        first color (blue ICI=3)
      KOLOR = 2 ** (3-ICI)
      SLOPE(1) = 1.0 / (1.0-NBR-APARM(1)*(NMX-NBR))
      OFFSET(1) = 1.0
      CALL ILNCLR (KOLOR, 1, NEND, SLOPE, OFFSET, GAMINV, BUFFER, IERR)
      IF (IERR.NE.0) GO TO 990
C                                        second color (green ICI->2)
      ICI = ICI + INC
      IF (ICI.EQ.4) ICI = 1
      IF (ICI.EQ.0) ICI = 3
      KOLOR = 2 ** (3-ICI)
C                                       off
      IF ((APARM(2).LE.0.0) .OR. (APARM(3).LE.0.0)) THEN
         SLOPE(1) = 0.0
         OFFSET(1) = 0.0
         CALL ILNCLR (KOLOR, 1, NEND, SLOPE, OFFSET, GAMINV, BUFFER,
     *      IERR)
C                                       enabled
      ELSE
         NEND(1) = NBR
         TF = NBR - (NBR-1)*APARM(3)
         SLOPE(1) = APARM(2) / (NBR-TF)
         OFFSET(1) = -SLOPE(1) * (TF - 1.0)
         TF = NBR + (NMX-NBR)*APARM(3)
         SLOPE(2) = -APARM(2) / (TF - NBR)
         OFFSET(2) = -SLOPE(2) * (TF-1.0)
         CALL ILNCLR (KOLOR, 2, NEND, SLOPE, OFFSET, GAMINV, BUFFER,
     *      IERR)
         NEND(1) = NMX
         END IF
      IF (IERR.NE.0) GO TO 990
C                                        third color (red ICI->1)
      ICI = ICI + INC
      IF (ICI.EQ.4) ICI = 1
      IF (ICI.EQ.0) ICI = 3
      KOLOR = 2 ** (3-ICI)
      TF = APARM(1) * (NBR - 1)
      SLOPE(1) = 1.0 / (NMX-NBR-TF)
      OFFSET(1) = -(NBR-TF-1.0) * SLOPE(1)
      CALL ILNCLR (KOLOR, 1, NEND, SLOPE, OFFSET, GAMINV, BUFFER, IERR)
C
 990  IF (WASYNC) CALL YHOLD ('OFFF', JERR)
C
 999  RETURN
      END
