      SUBROUTINE COLR2S (NLEVS, TYPE, X0, SATUR, HUE, GAMMA, IERR)
C-----------------------------------------------------------------------
C! writes OFM with 2-color
C# TV-util
C-----------------------------------------------------------------------
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   COLOR2S uses an STC algorithm to produce 2-color intensity wedges
C   in the lightness-hue-saturation space.
C   Inputs:
C      NLEVS   I      number of intensities
C      TYPE    I      -1 down from X0, 0 level, +1 up from X0
C      X0      R      break point between the colors
C      SATUR   R(2)   saturation at X0, saturation at ends
C      HUE     R(2)   hue at left, hue at right (0 - 360)
C      GAMMA   R      gamma correction power (2.7 or 1.8 ok?)
C   Output:
C      IERR    I          error code of ZM70XF
C-----------------------------------------------------------------------
      INTEGER    NLEVS, TYPE, IERR
      REAL       X0, SATUR(2), HUE(2), GAMMA
C
      INCLUDE 'INCS:PTVC.INC'
      INTEGER    KOLR, IT, LEVS, NW, IX0, I
      REAL       ALPHA, BETA, GAMINV, H, DTOR, Z, X, S, A, B, L, Y3, Y,
     *   COLR, COLX(3), COLY(3), COLZ(3),LBUF(TVMOFM,3), V
      LOGICAL     VRTRTC
      INCLUDE 'INCS:DTVC.INC'
      DATA  COLX /  0.125, -1.090,  2.580/,
     *      COLY / -0.295,  2.040, -1.150/,
     *      COLZ /  1.170,  0.058, -0.422/
      DATA VRTRTC, DTOR /.TRUE., 0.017452393/
C-----------------------------------------------------------------------
C                                        check input some
      IERR = 2
      IF (GAMMA.LE.0.0) GO TO 999
      NW = TVMOFM
      LEVS = MIN (OFMINP+1, NLEVS)
      IF (LEVS.LT.32) LEVS = LUTOUT + 1
      IF (LEVS.GT.OFMINP+1) LEVS = OFMINP + 1
      IX0 = X0 * LEVS + 0.05
      ALPHA = 0.0
      BETA = (SATUR(2) - SATUR(1))
      GAMINV = 1.0 / GAMMA
      IT = OFMINP + 1
      CALL RFILL (IT, 0.0, LBUF(1,1))
      CALL RFILL (IT, 0.0, LBUF(1,2))
      CALL RFILL (IT, 0.0, LBUF(1,3))
C                                       constant
      S = 100.0
      H = HUE(1) * DTOR
      V  = 1.0
      DO 20 I = 1,LEVS
         IF (I.LE.IX0) THEN
            L = 20.
            S = FLOAT (IX0-I) / FLOAT (IX0) * BETA + SATUR(1)
            A = S * COS(H)
            B = S * SIN(H)
            IF (TYPE.LT.0) THEN
               V = FLOAT (I-1) / FLOAT (IX0-1)
            ELSE IF (TYPE.EQ.0.0) THEN
               V = 1.0
            ELSE
               V = FLOAT (IX0-I) / FLOAT (IX0-1)
               END IF
            V = V ** 1.5
C                                       LAB colors to RGB colors
            Y3 = (L + 16.0) / 116.0
            Y = Y3 ** 3
            X = (A/500.0 + Y3) ** 3
            Z = (Y3 - B/200.0) ** 3
            DO 10 KOLR = 1,3
               COLR = X * COLX(KOLR) + Y * COLY(KOLR) + Z * COLZ(KOLR)
               COLR = MAX (0.0, MIN (1.0, COLR))
               COLR = COLR ** GAMINV
               COLR = COLR * V
               COLR = MAX (0.0, MIN (1.0, COLR))
               LBUF(I,KOLR) = COLR
 10            CONTINUE
            IF (I.EQ.IX0) THEN
               H = HUE(2) * DTOR
               A = S * COS(H)
               B = S * SIN(H)
            END IF
         ELSE
            L = 65.
            S = FLOAT (IX0-I) / FLOAT (IX0) * BETA + SATUR(1)
            A = S * COS(H)
            B = S * SIN(H)
            IF (TYPE.LT.0) THEN
               V = FLOAT (LEVS-I) / FLOAT (LEVS-IX0-1)
            ELSE IF (TYPE.EQ.0.0) THEN
               V = 1.0
            ELSE
               V = FLOAT (I-IX0-1) / FLOAT (LEVS-IX0-1)
               END IF
            V = V ** 1.5
C                                       LAB colors to RGB colors
            Y3 = (L + 16.0) / 116.0
            Y = Y3 ** 3
            X = (A/500.0 + Y3) ** 3
            Z = (Y3 - B/200.0) ** 3
            DO 15 KOLR = 1,3
               COLR = X * COLX(KOLR) + Y * COLY(KOLR) + Z *
     *            COLZ(KOLR)
               COLR = MAX (0.0, MIN (1.0, COLR))
               COLR = COLR ** GAMINV
               COLR = COLR * V
               COLR = MAX (0.0, MIN (1.0, COLR))
               LBUF(I,KOLR) = COLR
 15            CONTINUE
            END IF
 20      CONTINUE
C                                        loop over colors r g b
      LBUF(1,1) = 0.
      LBUF(1,2) = 0.
      LBUF(1,3) = 0.
      CALL OFMIO ('WRIT', NW, LEVS, VRTRTC, LBUF, IERR)
      IF (IERR.NE.0) GO TO 999
C
 999  RETURN
      END
