      SUBROUTINE FXLEVS (LUN, FIND, CATBLK, BLC, TRC, ZMIN, ZMAX, ZINC,
     *   XMULT, LEVS, RMIN, RMAX, BUFFER, JBUFSZ, IRET)
C-----------------------------------------------------------------------
C! Finds the actual LEVS that will be used - note does image I/O
C# Graphics Map-util Plot-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2021, 2024
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Finds max, min in a data cube and then checks the contour levels
C   returning only those that will be used.
C   Inputs:
C      LUN      I       LUN of open file
C      FIND     I       pointer to open file
C      CATBLK   I(256)  Contour image header
C      BLC      R(7)    Bottom left corner
C      TRC      R(7)    Top right corner
C      ZMIN     I       First plane to use
C      ZMAX     I       Last plane to use
C      ZINC     I       Increment in planes
C      XMULT    R       Factor in front of LEVS
C      JBUFSZ   I       Size of buffer in AIPS bytes
C   In/Out
C      LEVS     R(30)   Contour levels = LEVS(i)*XMULT
C   Outputs
C      RMIN     R       Minimum brightness in the contouring images
C      RMAX     R       Maximum brightness in the contouring images
C      BUFFER   R(*)    I/O work buffer
C      IRET     I       Error code
C-----------------------------------------------------------------------
      INTEGER   LUN, FIND, CATBLK(256), ZMIN, ZMAX, ZINC, JBUFSZ, IRET
      REAL      BLC(7), TRC(7), XMULT, LEVS(30), RMIN, RMAX, BUFFER(*)
C
      INTEGER   IX1, IX2, IY1, IY2, IX, IY, IZ, IDEPTH(5), IWIN(4), IZ1,
     *   IZ2, IZ3, NX, NY, IOF, NLEVS, IPOS
      REAL      V, ALEVS(30)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DDCH.INC'
      INCLUDE 'INCS:DHDR.INC'
C-----------------------------------------------------------------------
      NX = CATBLK(KINAX)
      NY = CATBLK(KINAX+1)
      IX1 = BLC(1) + 0.01
      IX2 = TRC(1) + 0.01
      IY1 = BLC(2) + 0.01
      IY2 = TRC(2) + 0.01
      IWIN(1) = IX1
      IWIN(2) = IY1
      IWIN(3) = IX2
      IWIN(4) = IY2
      RMIN = 1.E10
      RMAX = -1.E10
      IF ((ZMAX.GE.ZMIN) .AND. (ZMIN.GE.1)) THEN
         IZ1 = ZMIN
         IZ2 = ZMAX
         IZ3 = MAX (1, ABS(ZINC))
      ELSE IF ((ZMAX.LE.ZMIN) .AND. (ZMAX.GE.1)) THEN
         IZ1 = ZMAX
         IZ2 = ZMIN
         IZ3 = MAX (1, ABS(ZINC))
      ELSE
         IZ1 = BLC(3) + 0.01
         IZ2 = IZ1
         IZ3 = 1
         END IF
      IDEPTH(2) = BLC(4) + 0.01
      IDEPTH(3) = BLC(5) + 0.01
      IDEPTH(4) = BLC(6) + 0.01
      IDEPTH(5) = BLC(7) + 0.01
C                                       do the I/O
      DO 40 IZ = IZ1,IZ2,IZ3
         IDEPTH(1) = IZ
         CALL COMOFF (CATBLK(KIDIM), CATBLK(KINAX), IDEPTH, IOF, IRET)
         IF (IRET.NE.0) GO TO 999
         IOF = IOF + 1
C                                       Init for double buff read.
         CALL MINIT ('READ', LUN, FIND, NX, NY, IWIN, BUFFER, JBUFSZ,
     *      IOF, IRET)
         IF (IRET.NE.0) THEN
            WRITE (MSGTXT,1000) IRET, 'INIT THE I/O'
            GO TO 980
            END IF
         DO 30 IY = IY1,IY2
            CALL MDISK ('READ', LUN, FIND, BUFFER, IPOS, IRET)
            IF (IRET.NE.0) THEN
               WRITE (MSGTXT,1000) IRET, 'READ IMAGE ROW'
               GO TO 980
               END IF
            DO 20 IX = IX1,IX2
               V = BUFFER(IPOS+IX-IX1)
               IF (V.NE.FBLANK) THEN
                  RMIN = MIN (RMIN, V)
                  RMAX = MAX (RMAX, V)
                  END IF
 20            CONTINUE
 30         CONTINUE
 40      CONTINUE
C                                       now the levs
      CALL RFILL (30, 0.0, ALEVS)
      ALEVS(1) = XMULT * LEVS(1)
      DO 50 IX = 2,30
         IF (LEVS(IX).GT.LEVS(IX-1)) THEN
            ALEVS(IX) = XMULT * LEVS(IX)
         ELSE
            NLEVS = IX - 1
            GO TO 60
            END IF
 50      CONTINUE
      NLEVS = 30
C                                       now check them out
 60   CALL RFILL (30, 0.0, LEVS)
      IY = 0
      DO 70 IX = 1,NLEVS
         IF ((ALEVS(IX).GE.RMIN) .AND. (ALEVS(IX).LE.RMAX)) THEN
            IY = IY + 1
            LEVS(IY) = ALEVS(IX) / XMULT
            END IF
 70      CONTINUE
      IF (IY.LE.0) THEN
         IRET = 10
         MSGTXT = 'FXLEVS: NO VALID LEVS FOUND'
         GO TO 980
         END IF
      GO TO 999
C
 980  CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('FXLEVS: ERROR',I4,' ON ',A)
      END

