      SUBROUTINE IAXIS1 (IBUFF, ILAB, IGR, DOZERO, DOGRID, IERR)
C-----------------------------------------------------------------------
C! draws axis labels and tick marks (via ITICS) on TV
C# TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 1995-1996, 1998, 2001, 2006-2008, 2011, 2014, 2019,
C;  Copyright (C) 2021
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   IAXIS1 is an axis drawing and labelling routine for Drawing
C   directly onto the IIS.
C   Inputs:
C      IBUFF    I(*)   The output buffer used in writing to the TV:
C                      size >= max x dimension
C      ILAB     I      the type of labeling to use: 1 none, 2 notick
C                         3 = Ra/Dec, 4 = center-rel, 5 = subim centerd
C                         7 = like 3, but leave off top, bot lines
C      IGR      I      Use graphics plane IGR
C      DOZERO   I      1 => zero full graphics plane (UNIQUE true)
C                      -1 => zero only needed piece of graphics plane
C                      0 => do NOT zero the graphics plane
C      DOGRID   L      T => plot full coordinate grid, else ticks
C   Output:
C      IBUFF    I(*)   the updated TV output buffer.
C      IERR     I      error indicator: 0 no error; 10 = Image too small
C   Common:
C      /MAPHDR/ CATBLK   I(256)   the image catalog header.
C   MRC 89/May/15: Provide for UT axes to be labelled in time format.
C-----------------------------------------------------------------------
      INTEGER   IBUFF(*), ILAB, IGR, DOZERO, IERR
      LOGICAL   DOGRID
C
      CHARACTER  SCRTXT*80, PLABEL(9)*16, BJUNK*8, NAME*18, ITYPE*2,
     *   XTRTXT(2)*80, ELABEL(2)*8, WETYP*4, NOTICK*8
      REAL   CH(4), XINC, YINC, BLC(2), TRC(2), BLC2(2), TRC2(2), YGAP,
     *   RX0, RY0, SAVINC(2)
      INTEGER   NTEXT, ILL, IDUM(4), IXCORN, IYCORN, IXBLC, IYBLC,
     *   IXTRC, IYTRC, IG1, IG2, IBLKX0, IBLKXT,IBLKY0, IBLKYT, INLAB,
     *   IXCRN(5), IYCRN(5), NXST, IX, IY, IANGL, INCHAR, I, IERR2,
     *   IXTCRN, ITRIM, IYTCRN, ITG1, ITG2, IROUND, IE, IEPO, LLAB,
     *   LTYPE
      LOGICAL   NOTLAB, XINSID, YINSID, SLICE, WASYNC
      DOUBLE PRECISION SAVCRV(2)
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DCAT.INC'
      EQUIVALENCE (XTRTXT, SCRTXT)
      DATA PLABEL /'ECLIPTIC LONG.  ', 'ECLIPTIC LAT.   ',
     *   'GALACTIC LONG.  ', 'GALACTIC LAT.   ', 'RIGHT ASCENSION ',
     *   'DECLINATION     ', 'TIME (HOURS)    ', 'HA (HOURS)     ',
     *   'LST (HOURS)     '/
      DATA ILL /0/
      DATA SLICE /.FALSE./
      DATA ELABEL /' (B1950)', ' (J2000)'/
      DATA NOTICK /'NO TICKS'/
C-----------------------------------------------------------------------
      CALL CHECKL ('IAXIS1')
      IERR = 0
      IF (NGRAPH.LE.0) GO TO 999
      WASYNC = ISYNCH.EQ.0
      LTYPE = MOD (ABS(ILAB), 100)
      LLAB = - ABS (ILAB)
C                                       Initial values.
      IG1 = IGR
      IF ((IG1.LE.0) .OR. (IG1.GT.NGRAPH-1)) IG1 = MIN (2, NGRAPH-1)
      IG2 = 0
      IF (NGRAPH.GE.4) IG2 = NGRAPH
      IXCORN = CATBLK(IICOR)
      IYCORN = CATBLK(IICOR+1)
      IXTCRN = CATBLK(IICOR+2)
      IYTCRN = CATBLK(IICOR+3)
      IXBLC = CATBLK(IIWIN)
      IYBLC = CATBLK(IIWIN+1)
      IXTRC = CATBLK(IIWIN+2)
      IYTRC = CATBLK(IIWIN+3)
      IF ((IXTCRN-IXCORN.GT.2) .AND. (IYTCRN-IYCORN.GT.2) .AND.
     *   (IYTRC-IYBLC.GT.2) .AND. (IXTRC-IXBLC.GT.2)) GO TO 10
         IERR = 10
         WRITE (MSGTXT,1000)
         CALL MSGWRT (6)
         GO TO 999
 10   XINC = REAL(IXTRC-IXBLC) / REAL(IXTCRN-IXCORN)
      YINC = REAL(IYTRC-IYBLC) / REAL(IYTCRN-IYCORN)
      IEPO = IROUND (CATR(KREPO))
      IF (IEPO.EQ.1950) THEN
         IE = 1
      ELSE IF (IEPO.EQ.2000) THEN
         IE = 2
      ELSE
         IE = 0
         END IF
C                                       Turn on graphics channels.
      IF (WASYNC) CALL YHOLD ('ONNN', IERR)
      ITG1 = NGRAY + IG1
      ITG2 = NGRAY + IG2
      CALL YSLECT ('ONNN', ITG1, 0, IBUFF, IERR)
      IF (IERR.NE.0) GO TO 980
      IF (IG2.GT.0) CALL YSLECT ('ONNN', ITG2, 0, IBUFF, IERR)
      IF (IERR.NE.0) GO TO 980
C                                       update image catalog
      IDUM(1) = 1
      IDUM(2) = 1
      IDUM(3) = MAXXTV(1)
      IDUM(4) = MAXXTV(2)
      CALL YCWRIT (ITG1, IDUM, CATBLK, IBUFF, IERR)
      IF (IG2.GT.0) CALL YCWRIT (ITG2, IDUM, CATBLK, IBUFF, IERR)
      CALL H2CHR (2, KHPTYO, CATH(KHPTY), ITYPE)
      IF (ITYPE.EQ.'WE') THEN
         I = 2 * (KICTPN - 1)
         CALL H2CHR (4, 1, CATH(KHCTP+I), WETYP)
         ITYPE(2:2) = WETYP(3:3)
         END IF
C                                       Write borders one pixel off
C                                       image if possible.
      IXCRN(1) = MAX (1, IXCORN-1)
      IXCRN(2) = MIN (MAXXTV(1), IXTCRN+1)
      IXCRN(3) = IXCRN(2)
      IXCRN(4) = IXCRN(1)
      IXCRN(5) = IXCRN(1)
      IYCRN(1) = MAX (1, IYCORN-1)
      IYCRN(2) = IYCRN(1)
      IYCRN(3) = MIN (MAXXTV(2), IYTCRN+1)
      IYCRN(4) = IYCRN(3)
      IYCRN(5) = IYCRN(1)
      RX0 = IXCORN * XINC - IXBLC
      RY0 = IYCORN * YINC - IYBLC
      BLC(1) = IXBLC - XINC * (IXCORN - IXCRN(1))
      BLC(2) = IYBLC - YINC * (IYCORN - IYCRN(1))
      TRC(1) = IXTRC + XINC * (IXCRN(3) - IXTCRN)
      TRC(2) = IYTRC + YINC * (IYCRN(3) - IYTCRN)
C                                       Init position info
      CALL RFILL (4, 0.0, CH)
      IF ((LTYPE.GT.1) .AND. (LTYPE.LT.7)) CH(2) = 2.666
      INLAB = LABTYP(LOCNUM)
      SAVCRV(1) = RPVAL(1,LOCNUM)
      SAVCRV(2) = RPVAL(2,LOCNUM)
      SAVINC(1) = AXINC(1,LOCNUM)
      SAVINC(2) = AXINC(2,LOCNUM)
      CALL LABINI (BLC, TRC, CATBLK(IIDEP), CH, LLAB, SLICE, YGAP,
     *   XTRTXT, NTEXT)
      IF (ITYPE.EQ.'WR') THEN
         CH(3) = CH(3) + CH(1) - 0.5
         CH(1) = 0.5
      ELSE IF (ITYPE.EQ.'WT') THEN
         CH(4)= CH(4) + CH(2) - 0.5
         CH(2) = 0.5
         END IF
      NOTLAB = .FALSE.
      XINSID = .FALSE.
      YINSID = .FALSE.
C                                       check for time axes
      IF ((LABTYP(LOCNUM).EQ.0) .AND. (INLAB.NE.0)) THEN
         LABTYP(LOCNUM) = INLAB
         IF (MOD(INLAB,10).NE.0) THEN
            RPVAL(1,LOCNUM) = SAVCRV(1)
            AXINC(1,LOCNUM) = SAVINC(1)
            END IF
         IF (INLAB/10.NE.0) THEN
            RPVAL(2,LOCNUM) = SAVCRV(2)
            AXINC(2,LOCNUM) = SAVINC(2)
            END IF
         END IF
C                                       Zero full graphics planes
      IF (DOZERO.GT.0) THEN
         CALL YZERO (ITG1, IERR)
         IF (IERR.NE.0) GO TO 980
         IF (IG2.GT.0) CALL YZERO (ITG2, IERR)
         IF (IERR.NE.0) GO TO 980
C                                       Zero (blank) needed part of
C                                       image planes 2 and NGRAPH.
      ELSE IF (DOZERO.LT.0) THEN
         IBLKX0 = IXCORN - CH(1) * CSIZTV(1) - 2.5
         IF (IBLKX0.LT.1) IBLKX0 = 1
         IBLKXT = IXTCRN + CH(3) * CSIZTV(1) + 2.5
         IF (IBLKXT.GT.MAXXTV(1)) IBLKXT = MAXXTV(1)
         IBLKY0 = IYCORN - CH(2) * CSIZTV(2) - 2.5
         IF (IBLKY0.LT.1) IBLKY0 = 1
         IBLKYT = IYTCRN + CH(4) * CSIZTV(2) + 2.5
         IF (IBLKYT.GT.MAXXTV(2)) IBLKYT = MAXXTV(2)
C                                       Clear part of sceen.
         CALL YFILL (ITG1, IBLKX0, IBLKY0, IBLKXT, IBLKYT, 0, IBUFF,
     *      IERR)
         IF (IERR.NE.0) GO TO 980
         IF (IG2.GT.0) CALL YFILL (ITG2, IBLKX0, IBLKY0, IBLKXT, IBLKYT,
     *      0, IBUFF, IERR)
         IF (IERR.NE.0) GO TO 980
         END IF
C                                       Draw borders.
      CALL IMVECT ('ONNN', ITG1, 5, IXCRN, IYCRN, IBUFF, IERR)
      IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
      IF (LTYPE.EQ.1) GO TO 990
C                                       Extra text
      IF ((NTEXT.GT.0) .AND. (LTYPE.LE.6)) THEN
         IANGL = 0
         IX = IXCORN
         DO 85 I = 1,NTEXT
            IY = IYCORN - YGAP * CSIZTV(2) - 1.5
            CALL CHTRIM (XTRTXT(I), 80, XTRTXT(I), INCHAR)
            IF ((IY.GE.1) .AND. (IX+INCHAR*CSIZTV(1)-1.LE.MAXXTV(1)))
     *         GO TO 80
               MSGTXT = XTRTXT(I)
               CALL MSGWRT (2)
               NOTLAB = .TRUE.
               GO TO 85
 80         CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL,
     *         XTRTXT(I)(:INCHAR), IBUFF, IERR)
            IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
            YGAP = YGAP + 1.333
 85         CONTINUE
         END IF
C                                       source name, freq, stokes
      IF (LTYPE.LT.7) THEN
         IX = IXCORN
         IY = IYTCRN + 0.5 * CSIZTV(2) + 1.5
         IF (IY+CSIZTV(2)-1.GT.MAXXTV(2)) THEN
            NOTLAB = .TRUE.
            GO TO 130
            END IF
         IANGL = 0
         CALL H2CHR (8, 1, CATH(KHOBJ), SCRTXT)
         IF (SCRTXT.NE.' ') THEN
            INCHAR = 12
            SCRTXT(11:11) = '_'
         ELSE
            INCHAR = 1
            END IF
         IF (NCHLAB(1,LOCNUM).GT.0) THEN
            SCRTXT(INCHAR:) = SAXLAB(1,LOCNUM)(:NCHLAB(1,LOCNUM))
            END IF
         CALL REFRMT (SCRTXT, '_', INCHAR)
         NXST = INCHAR
         IF (NCHLAB(2,LOCNUM).GT.0) THEN
            INCHAR = INCHAR + 3
            SCRTXT(INCHAR-1:INCHAR-1) = '_'
            SCRTXT(INCHAR:) = SAXLAB(2,LOCNUM)(:NCHLAB(2,LOCNUM))
            INCHAR = INCHAR + 3 + NCHLAB(2,LOCNUM)
            END IF
         CALL REFRMT (SCRTXT, '_', INCHAR)
C                                       fit in x direction?
         I = (MAXXTV(1)-IX+1) / CSIZTV(1)
         IF (I.GT.INCHAR) GO TO 115
            NOTLAB = .TRUE.
            IF (I.LT.8) GO TO 130
            INCHAR = NXST
            IF (I.LT.NXST) INCHAR = 8
 115     CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL, SCRTXT(:INCHAR),
     *      IBUFF, IERR)
         IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
         END IF
C
C                                       vertical axis
 130  I = LABTYP(LOCNUM) / 10
      IF (I.GT.0) THEN
         INCHAR = ITRIM (PLABEL(I))
         SCRTXT = PLABEL(I)
         IF ((IE.GT.0) .AND. ((I.EQ.5) .OR. (I.EQ.6))) THEN
            SCRTXT(INCHAR+1:) = ELABEL(IE)
            INCHAR = INCHAR + 8
            END IF
      ELSE
C                                       Use time format for UT.
         IF (CTYP(2,LOCNUM).EQ.'UT') THEN
            LABTYP(LOCNUM) = LABTYP(LOCNUM) + 50
            RPVAL(2,LOCNUM) = RPVAL(2,LOCNUM)/240.0
            AXINC(2,LOCNUM) = AXINC(2,LOCNUM)/240.0
            END IF
         SCRTXT = CPREF(2,LOCNUM) // CTYP(2,LOCNUM)
         CALL CHTRIM (SCRTXT, 25, SCRTXT, INCHAR)
         IF (CTYP(2,LOCNUM).EQ.NOTICK) INCHAR = 0
         END IF
      IF (INCHAR.GT.0) THEN
         IY = (IYCORN + IYTCRN)/2.0 + ((INCHAR-2.0)/2.0)*CSIZTV(2) + 0.5
         IF (ITYPE.EQ.'WR') THEN
            IX = IXTCRN + (CH(3)-1.5)*CSIZTV(1)
            IF (IX-1.5*CSIZTV(1).GT.MAXXTV(1)) THEN
               YINSID = .TRUE.
               IX = IXTCRN + 1.5*CSIZTV(1) + 0.5
               END IF
            IF ((IX.GT.MAXXTV(1)) .OR. (IY+CSIZTV(2)-1.GT.MAXXTV(2)))
     *         THEN
               NOTLAB = .TRUE.
               GO TO 140
               END IF
         ELSE
            IX = IXCORN - (CH(1)-0.5)*CSIZTV(1)
            IF (IX+1.5*CSIZTV(1).LT.1) THEN
               YINSID = .TRUE.
               IX = IXCORN - 1.5*CSIZTV(1) + 0.5
               END IF
            IF ((IX.LT.1) .OR. (IY+CSIZTV(2)-1.GT.MAXXTV(2))) THEN
               NOTLAB = .TRUE.
               GO TO 140
               END IF
            END IF
         IANGL = 3
         CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL, SCRTXT(:INCHAR),
     *      IBUFF, IERR)
         IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
         END IF
C
C                                       horizontal axis
 140  I = MOD (LABTYP(LOCNUM), 10)
      IF (I.GT.0) THEN
         INCHAR = ITRIM (PLABEL(I))
         SCRTXT = PLABEL(I)
         IF ((IE.GT.0) .AND. ((I.EQ.5) .OR. (I.EQ.6))) THEN
            SCRTXT(INCHAR+1:) = ELABEL(IE)
            INCHAR = INCHAR + 8
            END IF
      ELSE
C                                       Use time format for UT.
         IF (CTYP(1,LOCNUM).EQ.'UT') THEN
            LABTYP(LOCNUM) = LABTYP(LOCNUM) + 5
            RPVAL(1,LOCNUM) = RPVAL(1,LOCNUM)/240.0
            AXINC(1,LOCNUM) = AXINC(1,LOCNUM)/240.0
            END IF
         SCRTXT = CPREF(1,LOCNUM) // CTYP(1,LOCNUM)
         CALL CHTRIM (SCRTXT, 25, SCRTXT, INCHAR)
         IF (CTYP(1,LOCNUM).EQ.NOTICK) INCHAR = 0
         END IF
      IF (INCHAR.GT.0) THEN
         IX = (IXCORN + IXTCRN)/2.0 - (INCHAR/2.0)*CSIZTV(1) + 0.5
         IF (ITYPE.EQ.'WT') THEN
            IY = IYTCRN + 1.833 * CSIZTV(2)
            IF (MOD(ILAB,100).EQ.2) IY = IYTCRN + 0.5 * CSIZTV(2)
            IF (IY.GT.MAXXTV(2)-CSIZTV(2)) THEN
               IY = IYTCRN + 0.5*CSIZTV(2)
               XINSID = .TRUE.
               END IF
            IF ((IX.LT.1) .OR. (IY.GT.MAXXTV(2)-CSIZTV(2))) THEN
               NOTLAB = .TRUE.
               GO TO 150
               END IF
         ELSE
            IY = IYCORN - 2.833 * CSIZTV(2)
            IF (MOD(ILAB,100).EQ.2) IY = IYCORN - 1.5 * CSIZTV(2)
            IF (IY.LT.1) THEN
               IY = IYCORN - 1.5*CSIZTV(2)
               XINSID = .TRUE.
               END IF
            IF ((IX.LT.1) .OR. (IY.LT.1)) THEN
               NOTLAB = .TRUE.
               GO TO 150
               END IF
            END IF
         IANGL = 0
         CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL, SCRTXT(:INCHAR),
     *      IBUFF, IERR)
         IF ((IERR.NE.0).AND.(IERR.NE.2)) GO TO 980
         END IF
C                                       peak flux
 150  IF (LTYPE.LT.7) THEN
         IX = IXCORN
         IY = IYCORN - YGAP*CSIZTV(2)
         INCHAR = 27
         IF ((IY.GE.1) .AND. (IX+INCHAR*CSIZTV(1)-1.LE.MAXXTV(1)))
     *      GO TO 155
            NOTLAB = .TRUE.
            GO TO 160
 155     CALL H2CHR (8, 1, CATH(KHBUN), BJUNK)
         WRITE (SCRTXT,1155) CATR(KRDMX), BJUNK
         CALL REFRMT (SCRTXT, '_', INCHAR)
         IANGL = 0
         CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL, SCRTXT(:INCHAR),
     *      IBUFF, IERR)
         IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
C                                       image name
 160     IX = IXCORN
         IY = IY - 1.333*CSIZTV(2)
         SCRTXT = 'IMNAME= '
         CALL H2CHR (18, 1, CATH(KHIMN), NAME)
         CALL NAMEST (NAME, CATBLK(KIIMS), SCRTXT(INCHAR:), INCHAR)
         CALL REFRMT (SCRTXT, '_', INCHAR)
         IF ((IY.GE.1) .AND. (IX+INCHAR*CSIZTV(1)-1.LE.MAXXTV(1)))
     *      GO TO 165
            NOTLAB = .TRUE.
            GO TO 200
 165     IANGL = 0
         CALL IMANOT ('WRIT', IG1, IX, IY, IANGL, ILL, SCRTXT(:INCHAR),
     *      IBUFF, IERR)
         IF ((IERR.NE.0) .AND. (IERR.NE.2)) GO TO 980
         END IF
C                                       Figure out where tic marks go.
 200  IF (LTYPE.NE.2) THEN
         IX = IXCORN - (MAX (3.,CH(1))-2.5)*CSIZTV(1) + 0.5
         IY = IYCORN - 2.833*CSIZTV(2) + .5
         BLC2(1) = BLC(1)
         BLC2(2) = BLC(2)
         TRC2(1) = TRC(1)
         TRC2(2) = TRC(2)
         IF ((AXINC(2,LOCNUM).NE.0.0) .AND. (CTYP(2,LOCNUM).NE.NOTICK))
     *      THEN
            IF ((ITYPE.NE.'WB') .AND. (ITYPE.NE.'WT').AND.
     *         (ITYPE.NE.'WR')) THEN
               YINSID = YINSID .OR. (IX.LT.1)
C               IF (YINSID) BLC2(2) = BLC2(2) + 2.5*CSIZTV(2)*YINC
               CALL ITICS (2, IG1, YINSID, RX0, RY0, XINC, YINC, BLC2,
     *            TRC2, DOGRID, IBUFF, IERR2)
            ELSE IF (ITYPE.EQ.'WR') THEN
               YINSID = YINSID .OR. (IX.GT.MAXXTV(1))
C               IF (YINSID) TRC2(2) = TRC2(2) - 2.5*CSIZTV(2)*YINC
               CALL ITICS (6, IG1, YINSID, RX0, RY0, XINC, YINC, BLC2,
     *            TRC2, DOGRID, IBUFF, IERR2)
               END IF
            END IF
         IF ((AXINC(1,LOCNUM).NE.0.0) .AND. (CTYP(1,LOCNUM).NE.NOTICK))
     *      THEN
            IF ((ITYPE.NE.'WR') .AND. (ITYPE.NE.'WL').AND.
     *         (ITYPE.NE.'WT')) THEN
               TRC2(2) = TRC(2)
               BLC2(2) = BLC(2)
               XINSID = XINSID .OR. (IY.LT.1)
               CALL ITICS (1, IG1, XINSID, RX0, RY0, XINC, YINC, BLC2,
     *            TRC2, DOGRID, IBUFF, IERR2)
            ELSE IF (ITYPE.EQ.'WT') THEN
               TRC2(2) = TRC(2)
               BLC2(2) = BLC(2)
               XINSID = XINSID .OR. (IY.GT.MAXXTV(2))
               CALL ITICS (5, IG1, XINSID, RX0, RY0, XINC, YINC, BLC2,
     *            TRC2, DOGRID, IBUFF, IERR2)
               END IF
            END IF
         END IF
      GO TO 990
C                                       Graph drawing error.
 980  WRITE (MSGTXT,1980) IERR
      CALL MSGWRT (7)
 990  IF (NOTLAB) THEN
         WRITE (MSGTXT,1990)
         CALL MSGWRT (6)
         END IF
      IF (WASYNC) CALL YHOLD ('OFFF', IERR)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('IMAGE TOO SMALL TO LABEL')
 1155 FORMAT ('Peak brightness =',1PE12.4,1X,A8)
 1980 FORMAT ('GRAPH LABEL WRITING ERROR. IERR =',I5)
 1990 FORMAT ('SOME PARTS OF LABEL DID NOT FIT ON THE SCREEN')
      END
