      SUBROUTINE OFMCOL (NLEVS, OFM, IOFM, IERR)
C-----------------------------------------------------------------------
C! various standard OFMs with a stretch interaction
C# TV-appl
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   Inputs:
C      NLEVS    I      color levels
C   Output:
C      BUFFER   I(*)   scratch * >= TVMOFM
C      IERR     I      error code
C-----------------------------------------------------------------------
      INCLUDE 'INCS:PTVC.INC'
      INTEGER   NLEVS, IERR
      REAL      OFM(TVMOFM,3), IOFM(TVMOFM,3)
C
      INTEGER   IBUT, QUAD, ITW(3), ICOL, IMLEVS, CCOL(3), MX, MY,
     *   LX, LY, J0, I, J
      REAL      RPOS(2), PPOS(2), FK, X
      LOGICAL   F, DOIT
      CHARACTER ANAMES(10)*8, BNAMES(10)*8, CNAMES(10)*8, NAMES(10,3)*8,
     *   FILNAM*48
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DMSG.INC'
      EQUIVALENCE (ANAMES, NAMES(1,1))
      EQUIVALENCE (BNAMES, NAMES(1,2))
      EQUIVALENCE (CNAMES, NAMES(1,3))
      DATA F /.FALSE./
      DATA ANAMES /'AMBER','CERRADO','FLAMINGO','FLARE','INFERNO',
     *   'LAJOLLA','MAGMA','OXY','ROCKET','TURBID'/
      DATA BNAMES /'ALGAE','CETCBL4','PARULA','PLASMA','RAIN',
     *   'TROPICAL','TURBO','ECTD1','TWILIGHT','VLAG'/
      DATA CNAMES /'ARAUCARI','CIVIDIS','CREST','ECLIPSE','FREEZE',
     *   'MAKO','PANTANAL','VIRIDIS','ICEFIRE','RAINBOW'/
C-----------------------------------------------------------------------
C                                        general parameters
      QUAD = -1
      RPOS(1) = 0.0
      RPOS(2) = 0.0
      IMLEVS = MAX (LUTOUT+1, NLEVS)
      IF (IMLEVS.GT.OFMINP+1) IMLEVS = OFMINP + 1
      CALL ZTIME (ITW)
C                                        TVCOLORS
C                                        Button A: red ofms
C                                        Button B: green ofms
C                                        Button C: blue ofms
      MSGTXT = 'Hit button A for reddish OFMs'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button A for greenish & 2-color OFMs'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button A for blueish OFMs'
      CALL MSGWRT (1)
      MSGTXT = 'Hit button D to exit'
      CALL MSGWRT (1)
      PPOS(1) = 0.0
      PPOS(2) = 0.0
      ICOL = 0
      MX = WINDTV(3) - WINDTV(1) + 1
      MY = WINDTV(4) - WINDTV(2) + 1
      CALL FILL (3, 0, CCOL)
      IBUT = 1
      GO TO 30
C                                        init vals, on cursor
 10   RPOS(1) = (WINDTV(1) + WINDTV(3)) / 2
      RPOS(2) = (WINDTV(2) + WINDTV(4)) / 2
      CALL RCOPY (2, RPOS, PPOS)
      MX = RPOS(1)
      MY = RPOS(2)
      CALL YCURSE ('ONNN', F, F, RPOS, QUAD, IBUT, IERR)
      IF (IERR.NE.0) GO TO 900
C                                        read until moves
 20   CALL YCURSE ('READ', F, F, RPOS, QUAD, IBUT, IERR)
         IF (IERR.NE.0) GO TO 900
         IF (IBUT.GT.7) GO TO 900
         IF (IBUT.EQ.0) GO TO 35
C                                       new OFM
 30         CALL YWINDO ('READ', WINDTV, IERR)
            IF (IERR.NE.0) GO TO 900
            MX = (WINDTV(1) + WINDTV(3)) / 2
            MY = (WINDTV(2) + WINDTV(4)) / 2
            LX = WINDTV(3) - WINDTV(1) + 1
            LY = WINDTV(4) - WINDTV(2) + 1
            ICOL = MIN (3, IBUT)
            CCOL(ICOL) = CCOL(ICOL) + 1
            IF (CCOL(ICOL).GT.10) CCOL(ICOL) = 1
            FILNAM = NAMES(CCOL(ICOL),ICOL)
            CALL OFMDIR ('QGET', FILNAM, TVMOFM, IOFM, IERR)
            IF (IERR.NE.0) GO TO 900
            CALL OFMIO ('WRIT', TVMOFM, IMLEVS, F, IOFM, IERR)
            IF (IERR.NE.0) GO TO 900
            MSGTXT = 'Doing ' // FILNAM
            CALL MSGWRT (2)
            GO TO 10
C                                       stretch current OFM
 35      CALL DLINTR (RPOS, IBUT, PPOS, ITW, DOIT)
C                                        new color
         IF ((DOIT) .AND. (ICOL.GT.0)) THEN
            J0 = (IMLEVS * (RPOS(1)-WINDTV(1))) / LX
            FK = IMLEVS / (2.0 * J0)
            DO 40 I = 2,J0
               X = IMLEVS/2 + FK * (I-J0)
               J = X
               OFM(I,3) = (IOFM(J+1,3)-IOFM(J,3))*(X-J) + IOFM(J,3)
               OFM(I,2) = (IOFM(J+1,2)-IOFM(J,2))*(X-J) + IOFM(J,2)
               OFM(I,1) = (IOFM(J+1,1)-IOFM(J,1))*(X-J) + IOFM(J,1)
 40            CONTINUE
            FK = IMLEVS / (2.0 * (IMLEVS-J0))
            DO 50 I = J0+1,IMLEVS
               X = IMLEVS/2 + FK * (I-J0)
               J = X
               J = MIN (IMLEVS-1, J)
               OFM(I,3) = (IOFM(J+1,3)-IOFM(J,3))*(X-J) + IOFM(J,3)
               OFM(I,2) = (IOFM(J+1,2)-IOFM(J,2))*(X-J) + IOFM(J,2)
               OFM(I,1) = (IOFM(J+1,1)-IOFM(J,1))*(X-J) + IOFM(J,1)
 50            CONTINUE
C                                       Send to TV
            CALL OFMIO ('WRIT', TVMOFM, IMLEVS, F, OFM, IERR)
            IF (IERR.NE.0) GO TO 900
            END IF
         GO TO 20
C                                        messages on error
 900  IF (IERR.NE.0) THEN
         WRITE (MSGTXT,1910) IERR
         CALL MSGWRT (7)
         END IF
C
 999  RETURN
C-----------------------------------------------------------------------
 1910 FORMAT ('OFMCOL: TV ACTION ERROR CODE',I7)
      END
