      SUBROUTINE PLTVEC (VPCORN, VBLC, VTRC, VASEC, LABEL, IWBUFF, IERR)
C-----------------------------------------------------------------------
C! Draw polarization vector in a box
C# Map Plot
C-----------------------------------------------------------------------
C;  Copyright (C) 2019, 2022
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   PLTVEC  plots the polarization vector
C   Inputs:
C      VPCORN   I        Code indicating where to put the plot
C                           0 or 5: in the middle of the pane
C                                   10    darker
C                           1: lower left-hand corner  6 darker
C                           2: lower right-hand corner 7 darker
C                           3: upper left-hand corner  8 darker
C                           4: upper right-hand corner 9 darker
C      VBLC     I(2)     BLC of pol box
C      VTRC     I(2)     TRC of pol box
C      VASEC    R        Length of vector in ASEC
C      LABEL    C*(*)    Label
C   In/out:
C      IWBUFF   I(256)   I/O block for graph file.
C   Output:
C      IERR     I        Error code. 0: success, > 0 from plot routines
C                            -1: HPBW not defined
C                            -2: plot too big
C-----------------------------------------------------------------------
      INTEGER   VPCORN, VBLC(2), VTRC(2), IERR, IWBUFF(256)
      REAL      VASEC
      CHARACTER LABEL*(*)
C
      INTEGER   INTYPE, J, JTRIM
      REAL      X, Y, DX, DY
      CHARACTER TXTMSG*80
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
      INCLUDE 'INCS:DLOC.INC'
      INCLUDE 'INCS:DGPH.INC'
C-----------------------------------------------------------------------
      IERR = 0
      INTYPE = GPHLTY
      IF (AXTYP(LOCNUM).NE.1) GO TO 999
      IF ((LABTYP(LOCNUM).NE.56) .AND. (LABTYP(LOCNUM).NE.65)) GO TO 999
      IF ((VBLC(1).GE.VTRC(1)) .OR. (VBLC(2).GE.VTRC(2))) GO TO 999
C                                       state our intentions
      TXTMSG = 'Draw polarization vector inside box'
      CALL GCOMNT (-1, TXTMSG, IWBUFF, IERR)
      IF (IERR.NE.0) GO TO 999
C                                       Draw a box around the beam
      IF (VPCORN.NE.0) THEN
         IF (GPHLTY.NE.1) THEN
            CALL GLTYPE (1, IWBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            END IF
         X = VBLC(1)
         Y = VBLC(2)
         CALL GPOS (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         X = VTRC(1)
         CALL GVEC (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         Y = VTRC(2)
         CALL GVEC (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         X = VBLC(1)
         CALL GVEC (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         Y = VBLC(2)
         CALL GVEC (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
C                                       pol vec
         X = VBLC(1) + 0.25 * (VTRC(1) - VBLC(1))
         Y = (VBLC(2) + VTRC(2)) / 2.0
         CALL GPOS (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         X = X + (VTRC(1) - VBLC(1)) / 2.0
         CALL GVEC (X, Y, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
C                                       characters
         J = JTRIM (LABEL)
         IF (J.GT.0) THEN
            CALL REFRMT (LABEL, ' ', J)
            X = (VTRC(1) + VBLC(1)) / 2.0
            DX = -J / 2.0
            DY = 0.5
            IF (GPHDOT) DY = 1.0
            CALL GPOS (X, Y, IWBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            CALL GCHAR (J, 0, DX, DY, LABEL(:J), IWBUFF, IERR)
            IF (IERR.NE.0) GO TO 999
            END IF
         END IF
      IF (GPHLTY.NE.INTYPE) THEN
         CALL GLTYPE (INTYPE, IWBUFF, IERR)
         IF (IERR.NE.0) GO TO 999
         END IF
      WRITE (MSGTXT,1000) VASEC
      CALL MSGWRT (3)
C
 999  RETURN
C-----------------------------------------------------------------------
 1000 FORMAT ('PLTVEC drawing boxed pol. vector of length',F8.3,' asec')
      END
