      SUBROUTINE XGVECT (OP, CHAN, COUNT, XDATA, YDATA, SCRTCH, IERR)
C-----------------------------------------------------------------------
C! Writes connected line segments to the TV for pixel-replicated images
C# Map Spectral
C-----------------------------------------------------------------------
C;  Copyright (C) 2025
C;  Associated Universities, Inc. Washington DC, USA.
C;
C;  This program is free software; you can redistribute it and/or
C;  modify it under the terms of the GNU General Public License as
C;  published by the Free Software Foundation; either version 2 of
C;  the License, or (at your option) any later version.
C;
C;  This program is distributed in the hope that it will be useful,
C;  but WITHOUT ANY WARRANTY; without even the implied warranty of
C;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C;  GNU General Public License for more details.
C;
C;  You should have received a copy of the GNU General Public
C;  License along with this program; if not, write to the Free
C;  Software Foundation, Inc., 675 Massachusetts Ave, Cambridge,
C;  MA 02139, USA.
C;
C;  Correspondence concerning AIPS should be addressed as follows:
C;         Internet email: aipsmail@nrao.edu.
C;         Postal address: AIPS Project Office
C;                         National Radio Astronomy Observatory
C;                         520 Edgemont Road
C;                         Charlottesville, VA 22903-2475 USA
C-----------------------------------------------------------------------
C   XGVECT writes a connected sequence of line segments on a TV channel
C   for pixel-replicated image pixels
C   Inputs:
C      OP      C*4     'ONNN' line of ones (max intensity)
C                      'OFFF' line of zeros (min intensity)
C      CHAN    I       channel number (1 to NGRAY+NGRAPH)
C      COUNT   I       number of X,Y pairs ( > 1)
C      XDATA   I(COUNT)      X coordinates X1,X2,...
C      YDATA   I(COUNT)      Y coordinates Y1,Y2,...
C   Output:
C      SCRTCH  I(*)    scratch buffer (size MAXXTV)
C      IERR    I       error code of ZM70XF - 0 => ok;  2 => input error
C-----------------------------------------------------------------------
      CHARACTER OP*4
      INTEGER   CHAN, COUNT, XDATA(*), YDATA(*), SCRTCH(*), IERR
C
      INTEGER   INT, IC, IMGWIN(4), TVWIN(4), MINC, LENG, LPY, LPX,
     *   IPX, IPY, I, K
      REAL      RPOS(2), LX(100), LY(100), DX, DY
      INCLUDE 'INCS:DTVC.INC'
      INCLUDE 'INCS:DCAT.INC'
      INCLUDE 'INCS:DHDR.INC'
      INCLUDE 'INCS:DMSG.INC'
C-----------------------------------------------------------------------
C                                       check inputs
      IERR = 2
      INT = -99
      IF ((OP.EQ.'ONNN') .AND. (CHAN.LE.NGRAY)) INT = MAXINT
      IF ((OP.EQ.'ONNN') .AND. (CHAN.GT.NGRAY)) INT = 2**NGRAPH - 1
      IF (OP.EQ.'OFFF') INT = 0
C                                       how big is a pixel
      CALL COPY (4, CATBLK(IIWIN), IMGWIN)
      CALL COPY (4, CATBLK(IICOR), TVWIN)
      MINC = (TVWIN(3) - TVWIN(1) + 1.0) / (IMGWIN(3) - IMGWIN(1) + 1.0)
     *   + 0.1
      CALL FILL (MINC, INT, SCRTCH)
      DO 10 IC = 1,COUNT
         LX(IC) = (XDATA(IC) - TVWIN(1)) / MINC
         LX(IC) = LX(IC) + IMGWIN(1)
         LY(IC) = (YDATA(IC) - TVWIN(2)) / MINC
         LY(IC) = IMGWIN(2) + LY(IC)
 10      CONTINUE
C                                       loop over line segments
      DO 100 IC = 1,COUNT-1
         DX = LX(IC+1) - LX(IC)
         DY = LY(IC+1) - LY(IC)
         LENG = MAX (ABS(DX), ABS(DY)) * 10.0 + 0.1
         LENG = MAX (LENG, 1)
         DX = DX / LENG
         DY = DY / LENG
         RPOS(1) = LX(IC) - DX
         RPOS(2) = LY(IC) - DY
         LPY = -1
         LPX = -1
         DO 90 K = 1,LENG
            RPOS(1) = RPOS(1) + DX
            RPOS(2) = RPOS(2) + DY
            IPX = RPOS(1) + 0.5
            IPY = RPOS(2) + 0.5
C                                       fill in pixel
            IF ((IPX.NE.LPX) .OR. (IPY.NE.LPY)) THEN
               LPX = IPX
               LPY = IPY
               IPX = TVWIN(1) + (LPX - IMGWIN(1)) * MINC
               IPY = TVWIN(2) + (LPY - IMGWIN(2)) * MINC - 1
               DO 20 I = 1,MINC
                  IPY = IPY + 1
                  CALL YIMGIO ('WRIT', CHAN, IPX, IPY, 0, MINC, SCRTCH,
     *               IERR)
                  IF (IERR.NE.0) GO TO 990
 20               CONTINUE
               END IF
 90         CONTINUE
 100     CONTINUE
      GO TO 999
C
 990  WRITE (MSGTXT,1990) IERR, IPX, IPY
      CALL MSGWRT (8)
C
 999  RETURN
C-----------------------------------------------------------------------
 1990 FORMAT ('XGVECT YIMGIO ERROR',I4,'AT TV X,Y',2I6)
      END
